/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDCheckBox;
import com.kingdee.bos.ctrl.swing.LanguageInfo;
import com.kingdee.bos.ctrl.swing.MultiLangItem;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.cache.CacheServiceFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.bos.workflow.exception.AlreadyBindProcessInstanceException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.BussAnalysisThemeFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportCollection;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportFactory;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeTreeInfo;
import com.kingdee.eas.sem.mp.IBussAnalysisThemeReport;
import com.kingdee.eas.sem.mp.client.AbstractBussAnalysisTreeEditUI;
import com.kingdee.eas.sem.mp.client.BussAnalysisF7PromptDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.apache.log4j.Logger;

public class BussAnalysisTreeEditUI
extends AbstractBussAnalysisTreeEditUI {
    private static final Logger logger = CoreUIObject.getLogger(BussAnalysisTreeEditUI.class);
    private static final String RES = "com.kingdee.eas.sem.mp.BussAnalysisResource";
    private BussAnalysisThemeReportInfo bussReportInfo = null;
    private BussAnalysisThemeInfo parent;

    public void loadFields() {
        super.loadFields();
        if ("EDIT".equals(this.getOprtState()) || "VIEW".equals(this.getOprtState())) {
            this.initBussReportInfo();
        } else if ("ADDNEW".equals(this.getOprtState())) {
            this.bussReportInfo = new BussAnalysisThemeReportInfo();
        }
    }

    protected void initBussReportInfo() {
        if (this.editData != null && this.editData.getId() != null) {
            try {
                this.bussReportInfo = this.getBussReportInfoByThemeID(this.editData.getId());
                this.bussReport.setDefaultLangItemData(this.bussReportInfo == null ? null : this.bussReportInfo.getSubjectCaption());
            }
            catch (Exception e) {
                MsgBox.showInfo((Component)((Object)this), (String)"dataError!");
                e.printStackTrace();
            }
        }
    }

    private BussAnalysisThemeReportInfo getBussReportInfoByThemeID(BOSUuid themeID) throws BOSException, EASBizException {
        IBussAnalysisThemeReport iBussReport = BussAnalysisThemeReportFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("theme.id", (Object)themeID.toString()));
        filter.setMaskString(" #0 ");
        ev.setFilter(filter);
        BussAnalysisThemeReportInfo tempReportInfo = null;
        BussAnalysisThemeReportCollection cols = iBussReport.getBussAnalysisThemeReportCollection(ev);
        if (cols != null && cols.size() > 0) {
            tempReportInfo = cols.get(0);
        }
        return tempReportInfo;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        BussAnalysisF7PromptDialog f7 = new BussAnalysisF7PromptDialog((IUIObject)this);
        this.txtNumber.setRequired(true);
        this.kDBizMultiLangBox1.setRequired(true);
        this.initWorkButtons();
        this.addListeners();
        this.btnSelectBussReport.setIcon(EASResource.getIcon((String)"imgTbtn_find"));
        this.bussReport.setEditable(false);
        if (this.chkIsBusiLeaf.isSelected()) {
            this.btnSelectBussReport.setEnabled(true);
        } else {
            this.btnSelectBussReport.setEnabled(false);
        }
        Object obj = this.getUIContext().get("ParentNode");
        if (obj != null && obj instanceof BussAnalysisThemeInfo) {
            this.parent = (BussAnalysisThemeInfo)obj;
        }
        this.setComponentState();
    }

    private void setComponentState() {
        if (!"ADDNEW".equals(this.getOprtState()) && "VIEW".equals(this.getOprtState())) {
            this.chkIsBusiLeaf.setEnabled(false);
            this.btnSelectBussReport.setEnabled(false);
        }
    }

    private void initWorkButtons() {
        this.menuBiz.setVisible(false);
        this.rMenuItemSubmitAndPrint.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnSave.setVisible(false);
        this.btnCopy.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnCopy.setVisible(false);
    }

    private void addListeners() {
        this.chkIsBusiLeaf.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent arg0) {
                BussAnalysisTreeEditUI.this.bussLeafStateChange(arg0);
            }
        });
    }

    private void bussLeafStateChange(ChangeEvent event) {
        if (((KDCheckBox)event.getSource()).getSelected() == 32) {
            this.btnSelectBussReport.setEnabled(true);
        } else {
            this.btnSelectBussReport.setEnabled(false);
            this.bussReport.setDefaultLangItemData(null);
            this.bussReportInfo = null;
        }
    }

    protected IObjectValue createNewData() {
        BussAnalysisThemeInfo newInfo = new BussAnalysisThemeInfo();
        newInfo.setIsBusiLeaf(false);
        return newInfo;
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        String nameData;
        LanguageInfo langInfo;
        MultiLangItem name;
        super.beforeStoreFields(e);
        String txtNumber = this.txtNumber.getText();
        if (txtNumber == null || txtNumber.trim().length() < 1) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussNumberNotNull"));
            SysUtil.abort();
            this.txtNumber.requestFocus();
        }
        if (txtNumber.trim().length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"number_too_long"));
            SysUtil.abort();
            this.txtNumber.requestFocus();
        }
        if ((name = this.kDBizMultiLangBox1.getItemBy(langInfo = new LanguageInfo(this.getLocale()))) == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussNameNotNull"));
            this.kDBizMultiLangBox1.requestFocus();
            this.abort();
        }
        if ((nameData = (String)name.getData()) == null || nameData.trim().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"bussNameNotNull"));
            this.kDBizMultiLangBox1.requestFocus();
            this.abort();
        }
        if (nameData.length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"name_length_too_long"));
            this.kDBizMultiLangBox1.requestFocus();
            this.abort();
        }
        if (this.chkIsBusiLeaf.getSelectState() == 32 && this.bussReportInfo == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"please_select_buss"));
            this.btnSelectBussReport.requestFocus();
            this.abort();
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    public void actionSelectReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionSelectReport_actionPerformed(e);
        BussAnalysisF7PromptDialog f7 = new BussAnalysisF7PromptDialog((IUIObject)this);
        f7.show();
        Object obj = f7.getDatas();
        if (obj != null && obj instanceof BussAnalysisThemeTreeInfo) {
            this.createNewDetailData((BussAnalysisThemeTreeInfo)obj);
            this.bussReport.setDefaultLangItemData((Object)this.bussReportInfo.getSubjectCaption());
        }
    }

    protected BussAnalysisThemeReportInfo createNewDetailData(BussAnalysisThemeTreeInfo bizInfo) {
        if (this.bussReportInfo == null) {
            this.bussReportInfo = new BussAnalysisThemeReportInfo();
        }
        this.bussReportInfo.setSubjectCaption(bizInfo.getName());
        this.bussReportInfo.setSubjectName(bizInfo.getSubName());
        this.bussReportInfo.setSubjectPath(bizInfo.getSubPath());
        this.bussReportInfo.setWidth(1);
        this.bussReportInfo.setHeight(1);
        return this.bussReportInfo;
    }

    public IObjectPK runSubmit() throws Exception {
        IObjectPK tempPK = super.runSubmit();
        return tempPK;
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.editData.setParent(this.parent);
        if (this.getActionFromActionEvent(e) == null && !this.checkClickTime()) {
            return;
        }
        this.verify(e);
        IObjectPK pk = null;
        IObjectPK bussReportPk = null;
        try {
            Object objectNumber;
            pk = this.runSubmit();
            IObjectValue subMitValue = null;
            subMitValue = this.getValue(pk);
            if (subMitValue != null && ((BussAnalysisThemeInfo)subMitValue).isIsBusiLeaf()) {
                this.bussReportInfo.setTheme((BussAnalysisThemeInfo)subMitValue);
                IBussAnalysisThemeReport iBussReport = BussAnalysisThemeReportFactory.getRemoteInstance();
                bussReportPk = iBussReport.submit((CoreBaseInfo)this.bussReportInfo);
                this.bussReportInfo = iBussReport.getBussAnalysisThemeReportInfo(bussReportPk);
            }
            if (!(OprtState.ADDNEW.equals(this.getOprtState()) && this.chkMenuItemSubmitAndAddNew.isSelected() || (objectNumber = subMitValue.get("number")) == null)) {
                this.editData.setString("number", objectNumber.toString());
            }
            this.getUIContext().put("ID", pk.toString());
            this.getUIContext().put("InitDataObject", subMitValue);
        }
        catch (AlreadyBindProcessInstanceException wfExceptoin) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_BindWfInstance"));
            return;
        }
        CacheServiceFactory.getInstance().discardType(this.editData.getBOSType());
        this.showMessageForStatus();
        this.showSubmitSuccess();
        if (OprtState.ADDNEW.equals(this.getOprtState())) {
            int size = this.idList.size();
            this.idList.add(size, pk.toString());
        }
        if (this.wfContext.isBindWorkFlow()) {
            this.wfContext.addToDataMap((Object)pk.toString(), (Object)pk.toString());
        }
        this.actionCopy.setEnabled(true);
        this.setSave(true);
        this.setSaved(true);
        this.afterSubmitPerform(pk);
    }

    private void afterSubmitPerform(IObjectPK pk) {
        if ("ADDNEW".equals(this.getOprtState()) && this.chkMenuItemSubmitAndAddNew.isSelected()) {
            if (this.chkMenuItemSubmitAndPrint.isSelected()) {
                this.afterSubmitPrint();
            }
            this.afterSubmitAddNew();
            return;
        }
        if (this.chkMenuItemSubmitAndPrint.isSelected()) {
            this.afterSubmitPrint();
            return;
        }
        if (this.chkMenuItemSubmitAndPrint.isSelected() && this.chkMenuItemSubmitAndAddNew.isSelected()) {
            this.afterSubmitPrint();
            this.afterSubmitAddNew();
            return;
        }
        this.afterSubmitEdit(pk);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return BussAnalysisThemeFactory.getRemoteInstance();
    }

    private void afterSelfSubmit() {
    }

    protected void unLockUI() {
        super.unLockUI();
        this.chkIsBusiLeaf.setEnabled(true);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }
}

