/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.swing.KDMultiLangBox;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.ctrl.swing.event.DataChangeListener;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.util.UIHelper;
import com.kingdee.eas.basedata.common.BasedataSysException;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.client.AbstractCSFEditUI;
import com.kingdee.eas.sem.mp.client.MpCoreTreeListUI;
import com.kingdee.eas.sem.mp.util.MCUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import org.apache.log4j.Logger;

public class CSFEditUI
extends AbstractCSFEditUI {
    private static final Logger logger = CoreUIObject.getLogger(MpCoreTreeListUI.class);
    private static String kpiResouce = "com.kingdee.eas.sem.mp.client.KPIResource";
    private CompanyOrgUnitInfo currentOrg;

    public CSFEditUI() throws Exception {
        this.bizPromptCompany.setEnabled(false);
    }

    protected void initListener() {
        super.initListener();
        this.bizPromptCompany.addDataChangeListener(new DataChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void dataChanged(DataChangeEvent e) {
                try {
                    CSFEditUI.this.bizPromptCompany_dataChanged(e);
                }
                catch (Exception exc) {
                    CSFEditUI.this.handUIException(exc);
                }
            }
        });
    }

    protected void bizPromptCompany_dataChanged(DataChangeEvent e) {
        Object newValue = e.getNewValue();
        if (!CompanyOrgUnitInfo.class.isInstance(newValue)) {
            return;
        }
        CompanyOrgUnitInfo company = (CompanyOrgUnitInfo)e.getNewValue();
        EntityViewInfo csfEvi = new EntityViewInfo();
        FilterInfo bscFilter = new FilterInfo();
        bscFilter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)company.getId().toString()));
        bscFilter.getFilterItems().add(new FilterItemInfo("isRef", (Object)new Boolean(false), CompareType.EQUALS));
        csfEvi.setFilter(bscFilter);
        this.bizPromptBSC.setEntityViewInfo(csfEvi);
    }

    public void onLoad() throws Exception {
        this.initCurrentOrg();
        super.onLoad();
        this.txtNumber.setMaxLength(80);
        this.mltName.setMaxLength(255);
        this.mltDescription.setMaxLength(255);
        this.btnCopy.setVisible(false);
        EntityViewInfo csfEvi = new EntityViewInfo();
        FilterInfo bscFilter = new FilterInfo();
        bscFilter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)this.currentOrg.getId().toString()));
        bscFilter.getFilterItems().add(new FilterItemInfo("isRef", (Object)new Boolean(false), CompareType.EQUALS));
        csfEvi.setFilter(bscFilter);
        this.bizPromptBSC.setEntityViewInfo(csfEvi);
    }

    public void loadFields() {
        this.bizPromptCompany.setEnabled(false);
        super.loadFields();
        this.txtNumber.requestFocus();
        this.setControlEditableStateByCurrentData();
    }

    public void storeFields() {
        super.storeFields();
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("partfi.*"));
        sic.add(new SelectorItemInfo("BSC.*"));
        sic.add(new SelectorItemInfo("parent.isModifiable"));
        sic.add(new SelectorItemInfo("description"));
        sic.add(new SelectorItemInfo("isModifiable"));
        return sic;
    }

    private boolean checkCanModify() {
        return this.editData.getParent() == null || this.editData.getParent().isIsModifiable();
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        if (!this.checkCanModify()) {
            MsgBox.showInfo((Component)((Object)this), (String)MCUtil.getString("refNotModify"));
            this.abort();
        }
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        super.verifyInput(e);
        if (StringUtils.isEmpty((String)this.txtNumber.getText())) {
            this.txtNumber.setRequestFocusEnabled(true);
            this.txtNumber.requestFocusInWindow();
            throw new BasedataSysException(BasedataSysException.NUMBER_IS_EMPTY);
        }
        UIHelper.storeMultiLangFields((KDMultiLangBox)this.mltName, (IObjectValue)this.editData, (String)"name");
        if (StringUtils.isEmpty((String)this.editData.getName())) {
            this.mltName.setRequestFocusEnabled(true);
            this.mltName.requestFocusInWindow();
            throw new BasedataSysException(BasedataSysException.NAME_IS_EMPTY);
        }
        if (this.bizPromptCompany.getData() == null || StringUtils.isEmpty((String)this.bizPromptCompany.getData().toString())) {
            this.bizPromptCompany.setRequestFocusEnabled(true);
            this.bizPromptCompany.requestFocusInWindow();
            throw new MPException(MPException.COMPANYBLANKEXCEPTION);
        }
        if (this.bizPromptBSC.getData() == null || StringUtils.isEmpty((String)this.bizPromptBSC.getData().toString())) {
            this.bizPromptBSC.setRequestFocusEnabled(true);
            this.bizPromptBSC.requestFocusInWindow();
            throw new MPException(MPException.BSCBLANKEXCEPTION);
        }
    }

    protected void txtName_actionPerformed(ActionEvent e) throws Exception {
    }

    public void actionAddNew_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddNew_actionPerformed(e);
        this.initOldData((IObjectValue)this.editData);
    }

    protected IObjectValue createNewData() {
        CSFInfo csf = new CSFInfo();
        csf.setPartFi(this.currentOrg);
        csf.setIsModifiable(true);
        return csf;
    }

    private void initCurrentOrg() throws Exception {
        if (this.currentOrg != null) {
            return;
        }
        String orgId = (String)this.getUIContext().get("company");
        if (orgId != null && orgId.length() > 0) {
            ICompanyOrgUnit org = CompanyOrgUnitFactory.getRemoteInstance();
            this.currentOrg = org.getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)kpiResouce, (String)"select_companyOrgUnit"));
            super.abort();
        }
    }

    private void setControlEditableStateByCurrentData() {
        try {
            if (this.editData == null) {
                return;
            }
            if (this.editData.getId() != null && this.editData.getId() != null) {
                if (!this.checkCanModify()) {
                    this.actionSubmit.setEnabled(false);
                    this.txtNumber.setEditable(false);
                    this.mltName.setEnabled(false);
                    this.mltDescription.setEditable(false);
                    this.bizPromptBSC.setEnabled(false);
                    this.bizPromptCompany.setEnabled(false);
                    this.boxIsModify.setEnabled(false);
                    this.btnEdit.setEnabled(false);
                } else if ("EDIT".equalsIgnoreCase(this.oprtState)) {
                    this.actionSubmit.setEnabled(true);
                    this.mltName.setEnabled(true);
                    if (this.editData.getParent() != null && !this.editData.getParent().isIsModifiable()) {
                        this.mltName.setEnabled(false);
                    }
                    this.txtNumber.setEditable(false);
                    this.mltDescription.setEditable(true);
                    this.bizPromptBSC.setEnabled(true);
                    this.bizPromptCompany.setEnabled(false);
                    this.boxIsModify.setEnabled(true);
                }
            } else if (OprtState.ADDNEW.equals(this.oprtState)) {
                this.actionSubmit.setEnabled(true);
                this.txtNumber.setEditable(true);
                this.mltName.setEditable(true);
                this.bizPromptBSC.setEnabled(true);
                this.bizPromptCompany.setEnabled(false);
                this.boxIsModify.setEnabled(true);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        this.bizPromptCompany.setEditable(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        this.setControlEditableStateByCurrentData();
        this.bizPromptCompany.setEnabled(false);
    }

    protected ICoreBase getBizInterface() throws Exception {
        return CSFFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }
}

