/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataLoaderFactory;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.function.FunctionObjectInfo;
import com.kingdee.bos.metadata.function.OperationCollection;
import com.kingdee.bos.metadata.function.OperationInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.base.uiframe.client.UIConfig;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.fi.rpt.client.ProgressManager;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.framework.client.workflow.EASWfServiceClient;
import com.kingdee.eas.sem.mp.AnalysisItemFactory;
import com.kingdee.eas.sem.mp.AnalysisItemInfo;
import com.kingdee.eas.sem.mp.DWCalculateSchemaCollection;
import com.kingdee.eas.sem.mp.DWCalculateSchemaFactory;
import com.kingdee.eas.sem.mp.DWCalculateSchemaInfo;
import com.kingdee.eas.sem.mp.DWCalculateSchemaItemCollection;
import com.kingdee.eas.sem.mp.DWCalculateSchemaItemInfo;
import com.kingdee.eas.sem.mp.DWCalculateSchemaOrgCollection;
import com.kingdee.eas.sem.mp.DWCalculateSchemaOrgInfo;
import com.kingdee.eas.sem.mp.DWKPIFacadeFactory;
import com.kingdee.eas.sem.mp.IDWCalculateSchema;
import com.kingdee.eas.sem.mp.client.AbstractCalculateSchemaUI;
import com.kingdee.eas.sem.mp.client.AnalysisItemSelectUI;
import com.kingdee.eas.sem.mp.client.CalculateSchemaAddUI;
import com.kingdee.eas.sem.mp.client.KPISpecialCompanyTreeHandler;
import com.kingdee.eas.sem.mp.client.LongTimeDialog;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class CalculateSchemaUI
extends AbstractCalculateSchemaUI {
    private static final Logger logger = CoreUIObject.getLogger(CalculateSchemaUI.class);
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    private DWCalculateSchemaInfo schemaInfo = null;
    private boolean isUpdateSolutionAddUIEdit = false;
    private static final String IsChange = "IsChange";
    private static final String IsNew = "IsNew";
    private IDWCalculateSchema iSchema = DWCalculateSchemaFactory.getRemoteInstance();
    private EASWfServiceClient workflowClient = null;
    boolean hasListSelectChange = false;
    private ProgressManager procManager = null;

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnCalExecute.setEnabled(true);
        this.actionAddCompany.setEnabled(true);
        this.actionAddItem.setEnabled(true);
        this.actionDelCompany.setEnabled(true);
        this.actionDelItem.setEnabled(true);
        this.addSchema.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.addSchema.setToolTipText(EASResource.getString((String)"add"));
        this.saveSchema.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.saveSchema.setToolTipText(EASResource.getString((String)"save"));
        this.addCompany.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.addCompany.setToolTipText(EASResource.getString((String)"add"));
        this.addItem.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.addItem.setToolTipText(EASResource.getString((String)"add"));
        this.delSchema.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delSchema.setToolTipText(EASResource.getString((String)"delete"));
        this.delCompany.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delCompany.setToolTipText(EASResource.getString((String)"delete"));
        this.delItem.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delItem.setToolTipText(EASResource.getString((String)"delete"));
        this.actionAddSchema.setEnabled(true);
        this.actionSaveSchema.setEnabled(true);
        this.actionDelSchema.setEnabled(true);
        this.kDContainer1.addButton((JButton)this.addSchema);
        this.kDContainer1.addButton((JButton)this.saveSchema);
        this.kDContainer1.addButton((JButton)this.delSchema);
        this.kDContainer1.setTitleStyle(1);
    }

    public void storeFields() {
        super.storeFields();
    }

    private void initSelfListener() {
        this.schemaList.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    CalculateSchemaUI.this.schemaListChange();
                }
            }
        });
        this.schemaList.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 127) {
                    try {
                        CalculateSchemaUI.this.actionDelSchema_actionPerformed(null);
                    }
                    catch (Exception e) {
                        CalculateSchemaUI.this.handUIException(e);
                    }
                }
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
        this.schemaList.addListSelectionListener(new ListSelectionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void valueChanged(ListSelectionEvent e) {
                try {
                    CalculateSchemaUI.this.lstSchema_valueChanged(e);
                }
                catch (Exception exc) {
                    CalculateSchemaUI.this.handUIException(exc);
                }
            }
        });
    }

    public void initUIContentLayout() {
        super.initUIContentLayout();
        this.itemTable.checkParsed();
        this.companyTable.checkParsed();
    }

    private void lstSchema_valueChanged(ListSelectionEvent e) {
        this.hasListSelectChange = true;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSelfListener();
        this.loadFields();
        this.refreshUpdateSchemaView();
        this.schemaList.setVisible(true);
        this.itemTable.getStyleAttributes().setLocked(true);
        this.companyTable.getStyleAttributes().setLocked(true);
        KDTSortManager itemSM = new KDTSortManager(this.itemTable);
        itemSM.setSortAuto(true);
        this.itemTable.getColumn("number").setSortable(true);
        this.itemTable.getColumn("name").setSortable(true);
        KDTSortManager companySM = new KDTSortManager(this.companyTable);
        companySM.setSortAuto(true);
        this.companyTable.getColumn("number").setSortable(true);
        this.companyTable.getColumn("name").setSortable(true);
    }

    public void loadFields() {
        super.loadFields();
        DWCalculateSchemaCollection schemaCollection = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("company.id"));
            sic.add(new SelectorItemInfo("company.company.id"));
            sic.add(new SelectorItemInfo("company.company.name"));
            sic.add(new SelectorItemInfo("company.company.number"));
            sic.add(new SelectorItemInfo("item.id"));
            sic.add(new SelectorItemInfo("item.item.id"));
            sic.add(new SelectorItemInfo("item.item.name"));
            sic.add(new SelectorItemInfo("item.item.number"));
            sic.add(new SelectorItemInfo("isPreMonth"));
            sic.add(new SelectorItemInfo("isCurMonth"));
            sic.add(new SelectorItemInfo("beginTime"));
            sic.add(new SelectorItemInfo("endTime"));
            sic.add(new SelectorItemInfo("isAutoSchema"));
            sic.add(new SelectorItemInfo("intervalSetted"));
            sic.add(new SelectorItemInfo("jobProcessDef"));
            CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit().getCU();
            FilterInfo filter = new FilterInfo();
            view.setFilter(filter);
            filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString()));
            schemaCollection = this.iSchema.getDWCalculateSchemaCollection(view);
            if (schemaCollection == null || schemaCollection.size() == 0) {
                return;
            }
            int size = schemaCollection.size();
            for (int i = 0; i < size; ++i) {
                this.schemaList.addElement((Object)schemaCollection.get(i));
                if (i != size - 1) continue;
                this.schemaList.setSelectedIndex(i);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void schemaListChange() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        try {
            ComponentUtil.setWindowsCursorOfWair((Window)window);
            this.refreshUpdateSchemaView();
        }
        catch (Exception ie) {
            this.handUIException(ie);
        }
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    protected void beginTime_dataChanged(DataChangeEvent e) throws Exception {
        Date eDate;
        Date bDate;
        Object beginObj = this.beginTime.getValue();
        Object endObj = this.endTime.getValue();
        if (beginObj != null && endObj != null && this.dateCompare(bDate = (Date)beginObj, eDate = (Date)endObj) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4!");
            this.beginTime.setValue(null);
            return;
        }
        this.setChange();
    }

    protected void endTime_dataChanged(DataChangeEvent e) throws Exception {
        Date eDate;
        Date bDate;
        Object beginObj = this.beginTime.getValue();
        Object endObj = this.endTime.getValue();
        if (beginObj != null && endObj != null && this.dateCompare(bDate = (Date)beginObj, eDate = (Date)endObj) > 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u5f00\u59cb\u65f6\u95f4\u5fc5\u987b\u5c0f\u4e8e\u7ed3\u675f\u65f6\u95f4!");
            return;
        }
        this.setChange();
    }

    public void actionAddItem_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ArrayList itemList = new ArrayList();
        HashMap confirmMap = new HashMap();
        DWCalculateSchemaInfo schemaInfo = this.getCalculateSchemaInfo();
        DWCalculateSchemaItemCollection itemCols = schemaInfo.getItem();
        DWCalculateSchemaItemInfo schemaItemInfo = null;
        uiContext.put((Object)"itemList", itemList);
        uiContext.put((Object)"confirmMap", confirmMap);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(AnalysisItemSelectUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
        uiWindow.show();
        if (null != confirmMap.get("confirm") && ((Boolean)confirmMap.get("confirm")).booleanValue() && itemList.size() > 0) {
            IRow row = null;
            String clsID = null;
            AnalysisItemInfo itemInfo = null;
            for (int i = 0; i < itemList.size(); ++i) {
                clsID = ((AnalysisItemInfo)itemList.get(i)).getId().toString();
                if (this.checkIsExist(this.itemTable, clsID)) continue;
                schemaItemInfo = new DWCalculateSchemaItemInfo();
                row = this.itemTable.addRow();
                itemInfo = (AnalysisItemInfo)itemList.get(i);
                row.getCell("id").setValue((Object)itemInfo.getId());
                row.getCell("name").setValue((Object)itemInfo.getName());
                row.getCell("number").setValue((Object)itemInfo.getNumber());
                row.setUserObject((Object)itemInfo);
                schemaItemInfo.setItem(itemInfo);
                schemaItemInfo.setParent(schemaInfo);
                itemCols.add(schemaItemInfo);
                this.setChange();
            }
        }
    }

    private boolean checkIsExist(KDTable table, String clsId) {
        boolean flag = false;
        int rowCount = table.getRowCount();
        IRow row = null;
        String curID = null;
        for (int i = 0; i < rowCount; ++i) {
            row = table.getRow(i);
            if (null == row || !(curID = row.getCell("id").getValue().toString()).equals(clsId)) continue;
            flag = true;
            break;
        }
        return flag;
    }

    public void actionDelItem_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.itemTable.getSelectManager();
        if (null == this.itemTable.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"no_select"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.itemTable);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.itemTable.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.itemTable.removeRow(selectRows[i]);
                this.deleteItemFromSchema(row.getCell("id").getValue().toString());
            }
        }
    }

    private void setChange() {
        this.getCalculateSchemaInfo().put(IsChange, IsChange);
    }

    private void deleteItemFromSchema(String ItemID) {
        if (ItemID != null) {
            Iterator it = this.getCalculateSchemaInfo().getItem().iterator();
            while (it.hasNext()) {
                DWCalculateSchemaItemInfo itemInfo = (DWCalculateSchemaItemInfo)it.next();
                if (!itemInfo.getItem().getId().toString().equals(ItemID)) continue;
                it.remove();
                this.setChange();
                break;
            }
        }
    }

    private void deleteCompanyFromSchema(String companyID) {
        if (companyID != null) {
            Iterator it = this.getCalculateSchemaInfo().getCompany().iterator();
            while (it.hasNext()) {
                DWCalculateSchemaOrgInfo orgInfo = (DWCalculateSchemaOrgInfo)it.next();
                if (!orgInfo.getCompany().getId().toString().equals(companyID)) continue;
                it.remove();
                this.setChange();
                break;
            }
        }
    }

    public void actionAddCompany_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo[] tempOrgInfo;
        String orgId = null == SysContext.getSysContext().getCurrentAdminUnit() ? null : SysContext.getSysContext().getCurrentAdminUnit().getId().toString();
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(true);
        af7.setRootUnitID(orgId);
        af7.disablePerm(this.getMap(), true);
        OrgTreeInfo oti = new OrgTreeInfo();
        oti.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000034F2827FD"));
        TreeModel model = af7.getTreeModel(OrgViewType.ADMIN, oti);
        HashMap newMap = KPISpecialCompanyTreeHandler.getTreeCols(model);
        CompanyF7 newAF7 = new CompanyF7();
        newAF7.setMultiSelect(true);
        newAF7.setRootUnitID(orgId);
        newAF7.disablePerm(newMap, true);
        newAF7.show();
        if (newAF7.isCanceled()) {
            return;
        }
        Object obj = newAF7.getData();
        if (obj instanceof OrgUnitInfo[] && (tempOrgInfo = (OrgUnitInfo[])obj) != null && tempOrgInfo.length > 0) {
            DWCalculateSchemaInfo schemaInfo = this.getCalculateSchemaInfo();
            DWCalculateSchemaOrgCollection orgCols = schemaInfo.getCompany();
            DWCalculateSchemaOrgInfo schemaOrgInfo = null;
            if (tempOrgInfo != null && tempOrgInfo.length > 0) {
                for (int i = 0; i < tempOrgInfo.length; ++i) {
                    OrgUnitInfo tempOuInfo = tempOrgInfo[i];
                    String ouId = tempOuInfo.getId().toString();
                    if (this.checkIsExist(this.companyTable, ouId)) continue;
                    schemaOrgInfo = new DWCalculateSchemaOrgInfo();
                    IRow tempRow = this.companyTable.addRow();
                    tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                    tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                    tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                    tempRow.setUserObject((Object)tempOrgInfo[i]);
                    schemaOrgInfo.setCompany((CompanyOrgUnitInfo)tempOrgInfo[i]);
                    schemaOrgInfo.setParent(schemaInfo);
                    orgCols.add(schemaOrgInfo);
                    this.setChange();
                }
            }
        }
    }

    private HashMap getMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            CompanyOrgUnitCollection coms = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("select id");
            map = new HashMap();
            int n = coms.size();
            for (int i = 0; i < n; ++i) {
                map.put(coms.get(i).getId().toString(), new Boolean(false));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public void actionDelCompany_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.companyTable.getSelectManager();
        if (null == this.companyTable.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"no_select"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.companyTable);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.companyTable.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.companyTable.removeRow(selectRows[i]);
                this.deleteCompanyFromSchema(row.getCell("id").getValue().toString());
            }
        }
    }

    public void actionCalExecute_actionPerformed(ActionEvent e) throws Exception {
        DWCalculateSchemaInfo dwschema = this.getCalculateSchemaInfo();
        if (dwschema.get(IsChange) != null || dwschema.get(IsNew) != null) {
            MsgBox.showInfo((String)"\u65b9\u6848\u672a\u4fdd\u5b58,\u8bf7\u5148\u4fdd\u5b58\u65b9\u6848");
            return;
        }
        if (this.beginTime.getValue() == null || this.endTime.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u586b\u5199\u4e00\u4e2a\u65f6\u95f4\u6bb5\uff01");
            return;
        }
        if (this.itemTable.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u6dfb\u52a0BI\u6307\u6807");
            return;
        }
        if (this.companyTable.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u6dfb\u52a0\u7ec4\u7ec7");
            return;
        }
        this.actionCalExecute.setEnabled(false);
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog(new JFrame()));
        ltd.setTitle("\u6570\u636e\u66f4\u65b0\u4e2d...");
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    if (null != CalculateSchemaUI.this.getCalculateSchemaInfo()) {
                        DWKPIFacadeFactory.getRemoteInstance().manualCalculateFactKpi(CalculateSchemaUI.this.getCalculateSchemaInfo());
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
        this.actionCalExecute.setEnabled(true);
    }

    public void actionAddSchema_actionPerformed(ActionEvent e) throws Exception {
        this.itemTable.removeRows();
        this.companyTable.removeRows();
        this.isUpdateSolutionAddUIEdit = false;
        this.schemaInfo = null;
        String name = this.createSchemaName();
        if (name == null) {
            return;
        }
        this.selfClearUI();
        DWCalculateSchemaInfo calSchemaInfo = new DWCalculateSchemaInfo();
        this.setInfoName(calSchemaInfo, name);
        calSchemaInfo.put(IsNew, IsNew);
        this.schemaList.addElement((Object)calSchemaInfo);
        this.schemaList.setSelectedIndex(this.schemaList.getElementCount() - 1);
        this.schemaList.repaint();
        this.refreshUpdateSchemaView();
        this.preMonth.setSelected(false);
        this.curMonth.setSelected(true);
    }

    public void refreshUpdateSchemaView() {
        DWCalculateSchemaInfo updateInfo = this.getCalculateSchemaInfo();
        if (updateInfo == null) {
            this.selfClearUI();
            return;
        }
        this.selfClearUI();
        this.beginTime.setValue((Object)updateInfo.getBeginTime());
        this.endTime.setValue((Object)updateInfo.getEndTime());
        this.preMonth.setSelected(updateInfo.isIsPreMonth());
        this.curMonth.setSelected(updateInfo.isIsCurMonth());
        this.intervalSet.setText(updateInfo.getIntervalSetted());
        try {
            if (updateInfo.isIsAutoSchema()) {
                this.autoUpdate_actionPerformed(null);
            } else {
                this.manualUpdate_actionPerformed(null);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
        DWCalculateSchemaItemCollection itemCols = this.getCalculateSchemaInfo().getItem();
        Iterator it = itemCols.iterator();
        while (it.hasNext()) {
            AnalysisItemInfo itemInfo = ((DWCalculateSchemaItemInfo)it.next()).getItem();
            if (itemInfo == null) continue;
            this.addItemTable(itemInfo);
        }
        DWCalculateSchemaOrgCollection companyCols = this.getCalculateSchemaInfo().getCompany();
        it = companyCols.iterator();
        while (it.hasNext()) {
            CompanyOrgUnitInfo companyInfo = ((DWCalculateSchemaOrgInfo)it.next()).getCompany();
            if (companyInfo == null) continue;
            this.addCompanyTable(companyInfo);
        }
        this.hasListSelectChange = false;
        this.getCalculateSchemaInfo().remove(IsChange);
    }

    private void addItemTable(AnalysisItemInfo itemInfo) {
        try {
            boolean flag = AnalysisItemFactory.getRemoteInstance().exists((IObjectPK)new ObjectUuidPK(itemInfo.getId()));
            if (flag) {
                IRow row = this.itemTable.addRow();
                row.getCell(0).setValue((Object)itemInfo.getName());
                row.getCell(1).setValue((Object)itemInfo.getNumber());
                row.getCell(2).setValue((Object)itemInfo.getId());
                row.setUserObject((Object)itemInfo);
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void addCompanyTable(CompanyOrgUnitInfo companyInfo) {
        try {
            IRow row = this.companyTable.addRow();
            row.getCell(0).setValue((Object)companyInfo.getName());
            row.getCell(1).setValue((Object)companyInfo.getNumber());
            row.getCell(2).setValue((Object)companyInfo.getId());
            row.setUserObject((Object)companyInfo);
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setInfoName(DWCalculateSchemaInfo info, String name) {
        if (info != null) {
            info.setName(name, new Locale("l1"));
            info.setName(name, new Locale("l2"));
            info.setName(name, new Locale("l3"));
        }
    }

    protected void selfClearUI() {
        this.itemTable.removeRows();
        this.companyTable.removeRows();
        this.beginTime.setValue(null);
        this.endTime.setValue(null);
        this.preMonth.setSelected(false);
        this.curMonth.setSelected(false);
    }

    private String createSchemaName() throws EASBizException, BOSException {
        boolean isExist = true;
        while (isExist) {
            String strName = this.inputName();
            if (strName == null) {
                return null;
            }
            DWCalculateSchemaInfo info = new DWCalculateSchemaInfo();
            this.setInfoName(info, strName);
            isExist = this.checkNameExits(info);
            if (isExist) {
                MsgBox.showInfo((Component)((Object)this), (String)"\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u7684\u65b9\u6848");
                continue;
            }
            return strName.trim();
        }
        return null;
    }

    private boolean checkNameExits(DWCalculateSchemaInfo info) throws EASBizException, BOSException {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName().trim()));
        boolean isExist = this.iSchema.exists(filter);
        if (!isExist) {
            int size = this.schemaList.getElementCount();
            for (int i = 0; i < size; ++i) {
                DWCalculateSchemaInfo ui = (DWCalculateSchemaInfo)this.schemaList.getElement(i);
                if (ui == info || ui.getName() == null || !ui.getName().trim().equals(info.getName().trim())) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    private String inputName() throws UIException {
        String sUIName = CalculateSchemaAddUI.class.getName();
        UIContext uiContext = new UIContext((Object)this);
        Hashtable<String, String> option = new Hashtable<String, String>();
        if (this.isUpdateSolutionAddUIEdit) {
            option.put("name", this.getCalculateSchemaInfo().getName());
        }
        uiContext.put((Object)"option", option);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(sUIName, (Map)uiContext);
        uiWindow.show();
        String action = (String)option.get("action");
        if (action != null && action.equals("CANCEL")) {
            return null;
        }
        String strName = (String)option.get("name");
        if (strName == null || strName.length() == 0) {
            return null;
        }
        return strName.trim();
    }

    public DWCalculateSchemaInfo getCalculateSchemaInfo() {
        if (this.schemaList.getElementCount() == 0 && this.schemaInfo == null) {
            this.schemaInfo = new DWCalculateSchemaInfo();
            this.schemaInfo.put(IsNew, IsNew);
        }
        if (this.schemaInfo != null) {
            return this.schemaInfo;
        }
        int selectIndex = this.schemaList.getSelectedIndex();
        if (selectIndex >= 0) {
            return (DWCalculateSchemaInfo)this.schemaList.getElement(selectIndex);
        }
        if (this.schemaList.getElementCount() > 0) {
            return (DWCalculateSchemaInfo)this.schemaList.getElement(0);
        }
        return null;
    }

    public void actionSaveSchema_actionPerformed(ActionEvent e) throws Exception {
        if (this.autoUpdate.isSelected()) {
            this.autoSchemaSave();
        } else {
            this.manualSchemaSave();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void autoSchemaSave() throws Exception {
        DWCalculateSchemaInfo schemaInfo = this.getCalculateSchemaInfo();
        if (null == this.intervalSet.getText() || this.intervalSet.getText().trim().equals("")) {
            MsgBox.showInfo((String)"\u8bf7\u8bbe\u7f6e\u540e\u53f0\u81ea\u52a8\u66f4\u65b0\u65f6\u95f4\u65b9\u6848");
            return;
        }
        schemaInfo.setIntervalSetted(this.intervalSet.getText());
        if (this.itemTable.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u6dfb\u52a0BI\u6307\u6807");
            return;
        }
        if (this.companyTable.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u6dfb\u52a0\u7ec4\u7ec7");
            return;
        }
        schemaInfo.setIsCurMonth(this.curMonth.isSelected());
        schemaInfo.setIsPreMonth(this.preMonth.isSelected());
        schemaInfo.setIsAutoSchema(true);
        schemaInfo.setBeginTime(null);
        schemaInfo.setEndTime(null);
        if (this.schemaInfo != null) {
            if (schemaInfo.getName() == null) {
                String name = this.createSchemaName();
                if (name == null) {
                    return;
                }
                this.setInfoName(schemaInfo, name);
            }
            if (!this.doautoSchemaSave(schemaInfo)) return;
            this.schemaList.addElement((Object)schemaInfo);
            schemaInfo = null;
            this.schemaList.setSelectedIndex(this.schemaList.getElementCount() - 1);
            this.schemaList.repaint();
            return;
        } else {
            schemaInfo = (DWCalculateSchemaInfo)this.schemaList.getSelectedValue();
            if (!this.doautoSchemaSave(schemaInfo)) return;
            this.showMessageBar(EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.UpdateSchemaSaveSucess"));
        }
    }

    private FunctionObjectInfo getFunction() {
        MetaDataPK functionPK = new MetaDataPK("com.kingdee.eas.sem.mp.app.DWKPIFunction");
        FunctionObjectInfo function = MetaDataLoaderFactory.getRemoteMetaDataLoader().getFunction((IMetaDataPK)functionPK);
        return function;
    }

    private EASWfServiceClient getWorkflowClient() throws Exception {
        if (this.workflowClient == null) {
            this.workflowClient = new EASWfServiceClient();
            this.workflowClient.init(UIConfig.getUrl(), SysContext.getSysContext().getSessionID());
        }
        return this.workflowClient;
    }

    private boolean doautoSchemaSave(DWCalculateSchemaInfo schemaInfo) {
        try {
            FunctionObjectInfo function = this.getFunction();
            OperationCollection operCols = function.getOperation();
            OperationInfo operation = null;
            operation = operCols.get(0);
            HashMap<String, String> jobContext = new HashMap<String, String>();
            if (schemaInfo.get(IsNew) != null) {
                BOSUuid uuid = BOSUuid.create((BOSObjectType)this.iSchema.getType());
                ObjectUuidPK pk = new ObjectUuidPK(uuid);
                jobContext.put("schemaID", pk.toString());
                String jobProcessDefID = this.getWorkflowClient().createJobProcessDef("BI\u6307\u6807\u62bd\u53d6", function, operation, jobContext, schemaInfo.getIntervalSetted(), SysContext.getSysContext().getLocale());
                schemaInfo.setJobProcessDef(jobProcessDefID);
                schemaInfo.setId(uuid);
                this.iSchema.submit((IObjectPK)pk, (CoreBaseInfo)schemaInfo);
            } else if (schemaInfo.get(IsChange) != null) {
                ObjectUuidPK schemePk = new ObjectUuidPK(schemaInfo.getId());
                jobContext.put("schemaID", schemePk.toString());
                if (null == schemaInfo.getJobProcessDef()) {
                    String jobProcessDefID = this.getWorkflowClient().createJobProcessDef("BI\u6307\u6807\u62bd\u53d6", function, operation, jobContext, schemaInfo.getIntervalSetted(), SysContext.getSysContext().getLocale());
                    schemaInfo.setJobProcessDef(jobProcessDefID);
                } else {
                    this.getWorkflowClient().updateProcessSchedule(schemaInfo.getJobProcessDef(), schemaInfo.getIntervalSetted());
                }
                this.iSchema.submit((IObjectPK)schemePk, (CoreBaseInfo)schemaInfo);
            }
            schemaInfo.put(IsNew, null);
            schemaInfo.put(IsChange, null);
        }
        catch (Exception e) {
            this.handUIException(e);
            String strSavefailed = EASResource.getString((String)(schemaInfo.getName() + " :  saveFailed"));
            this.getProgressManager().popMessage(strSavefailed);
            return false;
        }
        return true;
    }

    private void manualSchemaSave() throws Exception {
        DWCalculateSchemaInfo schemaInfo = this.getCalculateSchemaInfo();
        schemaInfo.setBeginTime(this.beginTime.getSqlDate());
        schemaInfo.setEndTime(this.endTime.getSqlDate());
        schemaInfo.setIsAutoSchema(false);
        schemaInfo.setIsPreMonth(this.preMonth.isSelected());
        schemaInfo.setIsCurMonth(this.curMonth.isSelected());
        if (this.beginTime.getValue() == null || this.endTime.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u586b\u5199\u4e00\u4e2a\u65f6\u95f4\u6bb5\uff01");
            return;
        }
        if (this.itemTable.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u6dfb\u52a0BI\u6307\u6807");
            return;
        }
        if (this.companyTable.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8bf7\u6dfb\u52a0\u7ec4\u7ec7");
            return;
        }
        if (this.schemaInfo != null) {
            if (schemaInfo.getName() == null) {
                String name = this.createSchemaName();
                if (name == null) {
                    return;
                }
                this.setInfoName(schemaInfo, name);
            }
            if (this.saveSchema(schemaInfo)) {
                this.schemaList.addElement((Object)schemaInfo);
                schemaInfo = null;
                this.schemaList.setSelectedIndex(this.schemaList.getElementCount() - 1);
                this.schemaList.repaint();
            } else {
                return;
            }
        }
        if (this.saveSchemas()) {
            this.showMessageBar("\u65b9\u6848\u4fdd\u5b58\u6210\u529f");
        }
    }

    private void showMessageBar(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    private boolean saveSchemas() {
        int count = this.schemaList.getElementCount();
        DWCalculateSchemaInfo schema = null;
        for (int i = 0; i < count; ++i) {
            schema = (DWCalculateSchemaInfo)this.schemaList.getElement(i);
            if (this.saveSchema(schema)) continue;
            this.schemaList.setSelectedIndex(i);
            this.refreshUpdateSchemaView();
            return false;
        }
        String strSave = EASResource.getString((String)"saveSuccessed");
        this.getProgressManager().popMessage(strSave);
        return true;
    }

    private boolean saveSchema(DWCalculateSchemaInfo info) {
        try {
            if (info.get(IsNew) != null) {
                BOSUuid uuid = BOSUuid.create((BOSObjectType)this.iSchema.getType());
                ObjectUuidPK pk = new ObjectUuidPK(uuid);
                info.setId(uuid);
                this.iSchema.submit((IObjectPK)pk, (CoreBaseInfo)info);
            } else if (info.get(IsChange) != null) {
                ObjectUuidPK schemePk = new ObjectUuidPK(info.getId());
                this.iSchema.submit((IObjectPK)schemePk, (CoreBaseInfo)info);
            }
            info.put(IsNew, null);
            info.put(IsChange, null);
        }
        catch (Exception e) {
            this.handUIException(e);
            String strSavefailed = EASResource.getString((String)(info.getName() + " :  saveFailed"));
            this.getProgressManager().popMessage(strSavefailed);
            return false;
        }
        return true;
    }

    public ProgressManager getProgressManager() {
        if (this.procManager == null) {
            this.procManager = new ProgressManager((CoreUI)this);
            this.procManager.setMainStatusBar(this.getMainStatusBar());
            this.procManager.setProgressBar(ProgressManager.getProgressBar((CoreUI)this));
            this.procManager.setEstimateTime(5000);
        }
        return this.procManager;
    }

    public void actionDelSchema_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.schemaList.getSelectedValue();
        if (obj == null) {
            return;
        }
        String strSave = EASResource.getString((String)RES, (String)"confirmDelete");
        int answer = MsgBox.showConfirm2((Component)((Object)this), (String)strSave);
        if (answer == 0) {
            Object[] os = this.schemaList.getSelectedValues();
            if (os != null) {
                for (int j = 0; j < os.length; ++j) {
                    DWCalculateSchemaInfo schemaInfo = (DWCalculateSchemaInfo)os[j];
                    if (schemaInfo.getId() != null && schemaInfo.getId().toString().trim().length() > 0) {
                        ObjectUuidPK pk = new ObjectUuidPK(schemaInfo.getId());
                        this.iSchema.delete((IObjectPK)pk);
                        if (schemaInfo.isIsAutoSchema()) {
                            this.getWorkflowClient().setProcessDefEnable(schemaInfo.getJobProcessDef(), false);
                        }
                    }
                    this.schemaList.removeElement((Object)schemaInfo);
                }
            }
            this.selfClearUI();
            if (this.schemaList.getElementCount() != 0) {
                this.schemaList.setSelectedIndex(0);
                this.refreshUpdateSchemaView();
            }
        }
    }

    private int dateCompare(Date bDate, Date eDate) {
        int eDay;
        int eMonth;
        Calendar bCalendar = Calendar.getInstance();
        bCalendar.setTime(bDate);
        Calendar eCalendar = Calendar.getInstance();
        eCalendar.setTime(eDate);
        int bYear = bCalendar.get(1);
        int eYear = eCalendar.get(1);
        if (bYear < eYear) {
            return -1;
        }
        if (bYear > eYear) {
            return 1;
        }
        int bMonth = bCalendar.get(2);
        if (bMonth < (eMonth = eCalendar.get(2))) {
            return -1;
        }
        if (bMonth > eMonth) {
            return 1;
        }
        int bDay = bCalendar.get(5);
        if (bDay < (eDay = eCalendar.get(5))) {
            return -1;
        }
        if (bDay > eDay) {
            return 1;
        }
        return 0;
    }

    protected void autoUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.autoUpdate.setSelected(true);
        this.manualUpdate.setSelected(false);
        this.autoConfig.setEnabled(true);
        this.beginTime.setEnabled(false);
        this.endTime.setEnabled(false);
        this.beginTime.setValue(null);
        this.endTime.setValue(null);
        this.btnCalExecute.setEnabled(false);
        this.setChange();
    }

    protected void manualUpdate_actionPerformed(ActionEvent e) throws Exception {
        this.autoUpdate.setSelected(false);
        this.manualUpdate.setSelected(true);
        this.autoConfig.setEnabled(false);
        this.beginTime.setEnabled(true);
        this.endTime.setEnabled(true);
        this.btnCalExecute.setEnabled(true);
        this.setChange();
    }

    protected void preMonth_actionPerformed(ActionEvent e) throws Exception {
        this.setChange();
    }

    protected void curMonth_actionPerformed(ActionEvent e) throws Exception {
        this.setChange();
    }

    public void actionAutoConfig_actionPerformed(ActionEvent e) throws Exception {
        String tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)this.getCalculateSchemaInfo().getIntervalSetted());
        if (tempSchedule != null) {
            this.getCalculateSchemaInfo().setIntervalSetted(tempSchedule);
            this.setChange();
            this.intervalSet.setText(this.getCalculateSchemaInfo().getIntervalSetted());
        }
    }
}

