/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDComboBox;
import com.kingdee.bos.ctrl.swing.KDDial;
import com.kingdee.bos.ctrl.swing.KDLayout;
import com.kingdee.bos.ctrl.swing.KDPopupMenu;
import com.kingdee.bos.ctrl.swing.dial.KpiDial;
import com.kingdee.bos.ctrl.swing.dial.KpiScale;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.sql.ParserException;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.client.AbstractDashboardUI;
import com.kingdee.eas.sem.mp.client.KpiDialInfo;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class DashboardUI
extends AbstractDashboardUI {
    private KDDial currentDial;
    private KDPopupMenu dialMenu;
    private final int dialHeight = 129;
    private final int dialWidth = 226;
    private final int gapHeight = 3;
    private final int gapWidth = 3;
    private final int boxListHeight = 34;
    private int dashboardColumn = 2;
    private int currentCellY = 0;
    private LinkedHashMap comBoxList = new LinkedHashMap();
    private LinkedHashMap kpiDial = new LinkedHashMap();
    private NumberFormat ft = null;
    private DecimalFormat percentFt = null;
    private static int imgHeight = 34;
    private int currentCellX = 0;
    private WarnGroupCollection wgs = null;

    public void onLoad() throws Exception {
        this.pnlDashBoard.setAutoscrolls(true);
        super.onLoad();
        this.initDialMemu();
        String kpiName = (String)this.getUIContext().get("kpiName");
        String kpiId = (String)this.getUIContext().get("kpi");
        this.initDial(kpiId);
        this.setUITitle(kpiName);
    }

    private void initDialMemu() {
        this.dialMenu = new KDPopupMenu();
        this.dialMenu.add((Action)new AbstractAction(EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPIDRILL")){

            public void actionPerformed(ActionEvent e) {
                DashboardUI.this.drillDashboard(e);
            }
        });
    }

    private IObjectCollection getDrillChildKpi(String kpiId) throws BOSException, EASBizException {
        IKPI kpi = KPIFactory.getRemoteInstance();
        IObjectCollection childKpis = kpi.drillChildKpi((IObjectPK)new ObjectUuidPK(kpiId));
        return childKpis;
    }

    private void initDial(String kpiId) throws EASBizException, BOSException {
        IObjectCollection childKpis = this.getDrillChildKpi(kpiId);
        if (childKpis == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.ORGHASNOCHILD"));
            super.abort();
        } else if (childKpis != null) {
            int dashRows;
            int planeHight;
            int count = childKpis.size();
            if (count == 0) {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPIHASNOCHILD"));
                super.abort();
            }
            if ((planeHight = (dashRows = count % 2 == 0 ? count / 2 : count / 2 + 1) * 129 + 20 + dashRows * 34) > 336) {
                this.pnlDashBoard.setPreferredSize(new Dimension(536, planeHight));
            }
            for (int i = 0; i < count; ++i) {
                KPIInfo childInfo = (KPIInfo)childKpis.getObject(i);
                if (childInfo == null || null == childInfo.getKpiValue() || childInfo.getKpiValue().size() <= 0) continue;
                this.addKpiToDial(childInfo);
            }
        }
    }

    protected void triggerKDDialMenu(MouseEvent event) {
        this.currentDial = (KDDial)event.getSource();
        this.dialMenu.show((Component)event.getSource(), event.getX(), event.getY());
    }

    protected void drillDashboard(ActionEvent e) {
        if (this.currentDial == null) {
            return;
        }
        Object obj = this.currentDial.getUserObject();
        if (obj instanceof KPIInfo) {
            Object tempObj = this.comBoxList.get(((KPIInfo)obj).getId().toString());
            if (tempObj != null && tempObj instanceof KDComboBox) {
                KDComboBox selectedBox = (KDComboBox)tempObj;
                tempObj = selectedBox.getSelectedItem();
                this.displayChildKpiInDashboard((KPIInfo)obj, (KPIValueInfo)tempObj);
            } else {
                MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPIHASNOCHILD"));
                super.abort();
            }
        } else {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPIHASNOCHILD"));
            super.abort();
        }
    }

    private void displayChildKpiInDashboard(KPIInfo info, KPIValueInfo valueInfo) {
        try {
            UIContext ctx = new UIContext(null);
            ctx.put((Object)"Owner", (Object)this.getUIWindow());
            ctx.put((Object)"kpi", (Object)info.getId().toString());
            ctx.put((Object)"kpiValue", (Object)valueInfo.getId().toString());
            ctx.put((Object)"kpiName", (Object)info.getName());
            ctx.put((Object)"kpiValueName", (Object)valueInfo.getName());
            IUIWindow ui = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create("com.kingdee.eas.sem.mp.client.DashboardUI", (Map)ctx);
            ui.show();
        }
        catch (UIException e) {
            super.handUIException((Throwable)e);
        }
    }

    private void addKpiToDial(KPIInfo childInfo) {
        try {
            String kpiValue = (String)this.getUIContext().get("kpiValueName");
            KpiDialInfo dialInfo = new KpiDialInfo(childInfo, childInfo.getKpiValue(), this.getCurrentTimeKpiValueInKpi(childInfo.getKpiValue(), kpiValue), false);
            this.createDial_new(dialInfo);
        }
        catch (EASBizException e) {
            this.handleException((Exception)((Object)e));
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
    }

    private boolean createDial_new(KpiDialInfo dialInfo) {
        boolean isSuccess = false;
        String showKpiName = "";
        KPIInfo kpiInfo = dialInfo.getKpiInfo();
        BigDecimal currentValue = dialInfo.getCurKpiValueInfo().getKpiValue();
        if (kpiInfo.isIsPercent()) {
            currentValue = currentValue.multiply(new BigDecimal("100"));
        }
        showKpiName = kpiInfo.getPartFI().getName() + ":" + kpiInfo.getName();
        String numberUnit = kpiInfo.getNumberUnit();
        if (numberUnit == null) {
            numberUnit = "";
        }
        numberUnit = EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPINUMBERUNIT") + numberUnit;
        KDDial dial = new KDDial(dialInfo.getTotal(), dialInfo.getNormal(), dialInfo.getWarning(), dialInfo.getCritical(), showKpiName);
        dial.setValue((Object)currentValue);
        dial.setUnitTitle(numberUnit);
        KpiScale scale = dial.getScale();
        this.setScoleOfPain(scale);
        this.setTickLabelFormat(scale, kpiInfo.isIsPercent());
        if (dialInfo.isDoubleEdge()) {
            scale.setTickLabelVisible(false);
        }
        dial.setUserObject((Object)kpiInfo);
        dial.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent event) {
                if (event.getButton() == 3) {
                    DashboardUI.this.triggerKDDialMenu(event);
                }
            }
        });
        this.kpiDial.put(kpiInfo.getId().toString(), dial);
        this.addDialColumnList((KpiDial)dial, kpiInfo, dialInfo.getValueCols());
        isSuccess = true;
        return isSuccess;
    }

    private void setScoleOfPain(KpiScale scale) {
        if (this.wgs == null) {
            try {
                IWarnGroup warnGroup = WarnGroupFactory.getRemoteInstance();
                EntityViewInfo wgEvi = null;
                wgEvi = new EntityViewInfo("order by periority desc");
                this.wgs = warnGroup.getWarnGroupCollection(wgEvi);
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
            catch (ParserException e) {
                e.printStackTrace();
            }
        }
        if (this.wgs == null || this.wgs.size() < 3) {
            return;
        }
        scale.setCriticalPaint((Paint)StringConverter.convertToColor((String)this.wgs.get(2).getColor()));
        scale.setWarningPaint((Paint)StringConverter.convertToColor((String)this.wgs.get(1).getColor()));
        scale.setNormalPaint((Paint)StringConverter.convertToColor((String)this.wgs.get(0).getColor()));
    }

    private void setTickLabelFormat(KpiScale scale, boolean isPercent) {
        if (!isPercent) {
            if (this.ft == null) {
                this.ft = NumberFormat.getInstance();
                ((DecimalFormat)this.ft).setDecimalSeparatorAlwaysShown(true);
                ((DecimalFormat)this.ft).setGroupingSize(3);
                this.ft.setMaximumFractionDigits(2);
                this.ft.setMinimumFractionDigits(2);
                this.ft.setMinimumIntegerDigits(1);
            }
            scale.setTickLabelFormat((Format)this.ft);
        } else {
            if (this.percentFt == null) {
                this.percentFt = new DecimalFormat("###.##'%'");
                this.percentFt.setMaximumFractionDigits(2);
                this.percentFt.setMinimumFractionDigits(2);
            }
            scale.setTickLabelFormat((Format)this.percentFt);
        }
    }

    private void addDialColumnList(KpiDial dial, KPIInfo kpiInfo, KPIValueCollection valueCols) {
        int averWidth;
        int pnlWidth;
        if (this.currentCellY == this.dashboardColumn) {
            this.currentCellY = 0;
            ++this.currentCellX;
        }
        if ((pnlWidth = this.pnlDashBoard.getWidth()) == 0) {
            pnlWidth = 229 * this.dashboardColumn;
        }
        if ((averWidth = pnlWidth / this.dashboardColumn - 226) < 3) {
            averWidth = 3;
        }
        int y = imgHeight * this.currentCellX + this.currentCellX * 12 + this.currentCellX * 129;
        KDComboBox cbBox = new KDComboBox();
        cbBox.setUserObject((Object)kpiInfo);
        if (valueCols == null || valueCols.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)"\u8be5KPI\u6ca1\u6709\u5386\u53f2\u8bb0\u5f55\uff0c\u6570\u636e\u5f02\u5e38\uff01");
            return;
        }
        cbBox.addItems(valueCols.toArray());
        cbBox.setSelectedIndex(this.getIndexOfCurrentTimeInKpi(valueCols, (String)this.getUIContext().get("kpiValue")));
        cbBox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                DashboardUI.this.refreshSingleDial(e);
            }
        });
        this.comBoxList.put(kpiInfo.getId().toString(), cbBox);
        if (this.currentCellY == 0) {
            int x = averWidth / 2;
            this.pnlDashBoard.add((Component)dial, (Object)new KDLayout.Constraints(x + 5, y, this.dialWidth, this.dialHeight, 5));
            dial.getUnitTitle().setRect(new Rectangle(this.dialWidth, this.dialHeight));
            this.pnlDashBoard.add((Component)cbBox, (Object)new KDLayout.Constraints(x + 40, y + this.dialHeight, this.dialWidth - 60, 19, 0));
        } else if (this.currentCellY == 1) {
            int x = pnlWidth / (this.currentCellY + 1);
            this.pnlDashBoard.add((Component)dial, (Object)new KDLayout.Constraints(x, y, this.dialWidth, this.dialHeight, 5));
            dial.getUnitTitle().setRect(new Rectangle(this.dialWidth, this.dialHeight));
            cbBox.setBounds(new Rectangle(x + 70, y + 70, 170, 20));
            this.pnlDashBoard.add((Component)cbBox, (Object)new KDLayout.Constraints(x + 40, y + this.dialHeight, this.dialWidth - 60, 19, 0));
        }
        this.pnlDashBoard.revalidate();
        this.pnlDashBoard.doLayout();
        ++this.currentCellY;
    }

    private int getIndexOfCurrentTimeInKpi(KPIValueCollection valueCols, String kpiValueID) {
        KPIValueInfo tempValueInfo;
        KPIValueInfo kpiValueInfo = null;
        int i = 0;
        try {
            kpiValueInfo = KPIValueFactory.getRemoteInstance().getKPIValueInfo((IObjectPK)new ObjectUuidPK(kpiValueID));
        }
        catch (Exception e) {
            this.handleException(e);
        }
        Iterator ite = valueCols.iterator();
        while (ite.hasNext() && (null == (tempValueInfo = (KPIValueInfo)ite.next()).getName() || null == kpiValueInfo || !tempValueInfo.getName().equals(kpiValueInfo.getName()))) {
            ++i;
        }
        if (i == valueCols.size()) {
            i = 0;
        }
        return i;
    }

    private KPIValueInfo getCurrentTimeKpiValueInKpi(KPIValueCollection valueCols, String kpiValueName) {
        KPIValueInfo kpiValueInfo = null;
        Iterator ite = valueCols.iterator();
        while (ite.hasNext()) {
            KPIValueInfo tempValueInfo = (KPIValueInfo)ite.next();
            if (null == tempValueInfo.getName() || !tempValueInfo.getName().equals(kpiValueName)) continue;
            kpiValueInfo = tempValueInfo;
            break;
        }
        return kpiValueInfo;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    private void refreshSingleDial(ItemEvent e) {
        KPIValueInfo tempInfo;
        Object obj1;
        Object obj = e.getItem();
        if (obj instanceof KPIValueInfo && (obj1 = this.kpiDial.get((tempInfo = (KPIValueInfo)obj).getKpi().getId().toString())) != null && obj1 instanceof KDDial) {
            this.currentDial = (KDDial)obj1;
            this.refreshKpiToDial((KPIInfo)this.currentDial.getUserObject(), tempInfo, false);
        }
    }

    private void refreshKpiToDial(KPIInfo obj, KPIValueInfo kpiValueInfo, boolean refreshBox) {
        if (obj == null) {
            return;
        }
        KpiDialInfo dialInfo = null;
        if (!refreshBox) {
            try {
                dialInfo = new KpiDialInfo(obj, null, kpiValueInfo, true);
            }
            catch (EASBizException e) {
                e.printStackTrace();
            }
            catch (BOSException e) {
                e.printStackTrace();
            }
        }
        KPIInfo kpiInfo = dialInfo.getKpiInfo();
        KPIValueInfo valueInfo = dialInfo.getCurKpiValueInfo();
        BigDecimal currentValue = valueInfo.getKpiValue();
        if (kpiInfo.isIsPercent()) {
            currentValue = currentValue.multiply(new BigDecimal("100"));
        }
        this.currentDial.setValue((Object)currentValue);
        String numberUnit = kpiInfo.getNumberUnit();
        if (numberUnit == null) {
            numberUnit = "";
        }
        this.currentDial.setUnitTitle(EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.KPINUMBERUNIT") + numberUnit);
        KpiScale scale = this.currentDial.getScale();
        scale.setTotalRange(dialInfo.getTotal());
        scale.setNormalRange(dialInfo.getNormal());
        scale.setCriticalRange(dialInfo.getCritical());
        scale.setWarningRange(dialInfo.getWarning());
        this.setScoleOfPain(scale);
        this.setTickLabelFormat(scale, kpiInfo.isIsPercent());
        if (dialInfo.isDoubleEdge()) {
            scale.setTickLabelVisible(false);
        } else {
            scale.setTickLabelVisible(true);
        }
        this.currentDial.setUserObject((Object)kpiInfo);
    }
}

