/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIRefValueInfo;
import com.kingdee.eas.sem.mp.client.AbstractEdgeParamFormulaEditUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class EdgeParamFormulaEditUI
extends AbstractEdgeParamFormulaEditUI {
    private boolean isCanceled = false;
    private StringBuffer formula;
    private ArrayList lastFormulaChanged;
    private ArrayList lastTxtFormulaChanged;
    private HashMap idToName = new HashMap();
    private HashMap nameToId = new HashMap();

    public EdgeParamFormulaEditUI() throws Exception {
        this.formula = new StringBuffer();
        this.lastFormulaChanged = new ArrayList();
        this.lastTxtFormulaChanged = new ArrayList();
        this.kdtRefValue.getSelectManager().setSelectMode(2);
        this.btnAddToFormula.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMulti.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivision.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnLeftBracket.setIcon(EASResource.getIcon((String)"imgTbtn_rightbracketsign"));
        this.btnRightBracket.setIcon(EASResource.getIcon((String)"imgTbtn_leftbracketsign"));
    }

    public void onLoad() throws Exception {
        Object refValues = null;
        this.txtFormula.setText("");
        Object obj = this.getUIContext().get("kpi");
        if (obj != null && obj instanceof String) {
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("refValues.refGroup.deletedStatus");
            selector.add("refValues.refGroup.id");
            selector.add("refValues.refGroup.number");
            selector.add("refValues.refGroup.name");
            selector.add("refValues.refValue");
            IKPI kpi = KPIFactory.getRemoteInstance();
            this.editData = kpi.getKPIInfo((IObjectPK)new ObjectUuidPK((String)obj), selector);
        }
        super.onLoad();
        this.kdtRefValue.checkParsed();
        this.initValue();
    }

    private void initRefStandardValue(OrgUnitInfo company) {
    }

    private void initValue() {
        String paramTitle = (String)this.getUIContext().get("paramTitle");
        this.lblEdgeParamName.setText(paramTitle);
        String initFormula = (String)this.getUIContext().get("initFormula");
        this.changeFormula(true, "", initFormula);
    }

    private StringBuffer convertIdToName(String initFormula) {
        StringTokenizer st = new StringTokenizer(" " + initFormula, "$");
        StringBuffer formulaBuffer = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formulaBuffer.append(st.nextToken());
            } else {
                formulaBuffer.append("$");
                formulaBuffer.append(this.idToName.get(st.nextToken()));
                formulaBuffer.append("$");
            }
            flag = !flag;
        }
        formulaBuffer = formulaBuffer.deleteCharAt(0);
        return formulaBuffer;
    }

    protected void bindDataToTable(KDTable table, IObjectCollection collection) {
        int i;
        if (collection == null) {
            return;
        }
        table.setUserObject((Object)collection);
        table.removeRows();
        int j = 0;
        int n = collection.size();
        for (i = 0; i < n; ++i) {
            KPIRefValueInfo obj = (KPIRefValueInfo)collection.getObject(i);
            if (obj.getRefGroup().getDeletedStatus().getValue() == 2) {
                ++j;
                continue;
            }
            IRow row = table.addRow(i - j);
            this.dataBinder.loadLineFields(table, row, (IObjectValue)obj);
            this.idToName.put(obj.getRefGroup().getId().toString(), obj.getRefGroup().getName());
            this.nameToId.put(obj.getRefGroup().getName(), obj.getRefGroup().getId().toString());
        }
        int count = this.kdtRefValue.getRowCount();
        for (i = 0; i < count - 1; ++i) {
            int min = i;
            String minNumber = (String)this.kdtRefValue.getRow(min).getCell("number").getValue();
            minNumber = minNumber.toLowerCase();
            for (int k = i + 1; k < count; ++k) {
                String refNumber = (String)this.kdtRefValue.getRow(k).getCell("number").getValue();
                if ((refNumber = refNumber.toLowerCase()).compareTo(minNumber) >= 0) continue;
                min = k;
                minNumber = refNumber;
            }
            System.out.print(" " + minNumber);
            if (min == i) continue;
            IRow src = this.kdtRefValue.getRow(i);
            IRow dest = this.kdtRefValue.getRow(min);
            this.kdtRefValue.removeRow(i);
            this.kdtRefValue.addRow(i, dest);
            this.kdtRefValue.removeRow(min);
            this.kdtRefValue.addRow(min, src);
        }
    }

    public void loadFields() {
        this.dataBinder.loadHeader();
    }

    public void storeFields() {
        super.storeFields();
    }

    public boolean getIsCanceled() {
        return this.isCanceled;
    }

    public void setIsCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    protected void btnPlus_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "+", "+");
    }

    protected void btnMinus_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "-", "-");
    }

    protected void btnMulti_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "*", "*");
    }

    protected void btnDivision_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "/", "/");
    }

    protected void btnLeftBracket_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "(", "(");
    }

    protected void btnRightBracket_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, ")", ")");
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setIsCanceled(false);
        this.getUIWindow().close();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setIsCanceled(true);
        this.getUIWindow().close();
    }

    protected void btnAddToFormula_actionPerformed(ActionEvent e) throws Exception {
        int row = this.kdtRefValue.getSelectManager().getActiveRowIndex();
        if (row < 0) {
            return;
        }
        IRow rowInfo = this.kdtRefValue.getRow(row);
        String id = rowInfo.getCell("id").getValue().toString();
        String name = (String)rowInfo.getCell("name").getValue();
        StringBuffer txtFormu = new StringBuffer();
        txtFormu.append("$");
        txtFormu.append(name);
        txtFormu.append("$");
        this.changeFormula(true, "$" + id + "$", txtFormu.toString());
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(false, null, null);
    }

    protected void changeFormula(boolean isAppending, String formu, String txtFormu) {
        if (isAppending) {
            this.txtFormula.setText(this.txtFormula.getText() + txtFormu);
        } else {
            this.txtFormula.setText("");
        }
        this.txtFormula.requestFocus();
    }

    public String getFormula() {
        String formulaReturned = this.txtFormula.getText();
        return formulaReturned;
    }

    private StringBuffer convertNameToId(String nameFormula) {
        StringBuffer formulaReturned = new StringBuffer();
        String formulaManual = " " + nameFormula;
        StringTokenizer st = new StringTokenizer(formulaManual, "$");
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formulaReturned.append(st.nextToken());
            } else {
                formulaReturned.append("$");
                formulaReturned.append(this.nameToId.get(st.nextToken()));
                formulaReturned.append("$");
            }
            flag = !flag;
        }
        formulaReturned = formulaReturned.deleteCharAt(0);
        return formulaReturned;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    public class EdgeParamFormulaData {
        private String idFormula;
        private String numberFormula;

        public String getIdFormula() {
            return this.idFormula;
        }

        public void setIdFormula(String idFormula) {
            this.idFormula = idFormula;
        }

        public String getNumberFormula() {
            return this.numberFormula;
        }

        public void setNumberFormula(String numberFormula) {
            this.numberFormula = numberFormula;
        }

        public EdgeParamFormulaData(String numberFormula, String idFormula) {
            this.idFormula = idFormula;
            this.numberFormula = numberFormula;
        }

        public String toString() {
            return this.idFormula;
        }
    }
}

