/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.TempStandardValueInfo;
import com.kingdee.eas.sem.mp.client.AbstractEdgeParamFormulaNewEditUI;
import com.kingdee.eas.sem.mp.util.KPIFormatHandle;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class EdgeParamFormulaNewEditUI
extends AbstractEdgeParamFormulaNewEditUI {
    private static final long serialVersionUID = 7094600536802805077L;
    private boolean isCanceled = false;
    private StringBuffer formula;
    private Map kpiValueRefStValueMap = new HashMap();
    private KPIRefStandardValueNewCollection cols = null;
    private int displayPrecision = 2;
    private boolean isPercent = false;

    public EdgeParamFormulaNewEditUI() throws Exception {
        this.formula = new StringBuffer();
        this.refValue.getSelectManager().setSelectMode(2);
        this.btnAddToFormula.setIcon(EASResource.getIcon((String)"imgTbtn_move_right"));
        this.btnPlus.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnMinus.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMulti.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivision.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnDelete.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnLeftBracket.setIcon(EASResource.getIcon((String)"imgTbtn_rightbracketsign"));
        this.btnRightBracket.setIcon(EASResource.getIcon((String)"imgTbtn_leftbracketsign"));
    }

    public void onLoad() throws Exception {
        this.txtFormula.setText("");
        Object obj = this.getUIContext().get("kpiValue");
        obj = this.getUIContext().get("company");
        if (obj == null || !(obj instanceof OrgUnitInfo)) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.sem.mp.client.KPIResource.Company_Null"));
            this.abort();
        }
        OrgUnitInfo company = (OrgUnitInfo)obj;
        obj = this.getUIContext().get("stValueMap");
        if (obj != null && obj instanceof KPIRefStandardValueNewCollection) {
            this.cols = (KPIRefStandardValueNewCollection)((Object)obj);
        }
        this.displayPrecision = (Integer)this.getUIContext().get("displayPrecision");
        this.isPercent = (Boolean)this.getUIContext().get("isPercent");
        super.onLoad();
        this.refValue.checkParsed();
        this.initValue();
        this.initKPIStandardTable();
    }

    private void initKPIStandardTable() {
        Iterator it = this.cols.iterator();
        IRow iRow = null;
        BigDecimal percentSource = new BigDecimal(100);
        DecimalFormat dec = new DecimalFormat();
        dec = KPIFormatHandle.initKpiFormter(this.isPercent, this.displayPrecision, dec);
        this.refValue.getColumn("value").getStyleAttributes().setNumberFormat("");
        while (it.hasNext()) {
            KPIRefStandardValueNewInfo kpiRefValue = (KPIRefStandardValueNewInfo)it.next();
            iRow = this.refValue.addRow();
            iRow.getCell("id").setValue((Object)kpiRefValue.getRefGroup().getId());
            iRow.getCell("number").setValue((Object)kpiRefValue.getRefGroup().getNumber());
            iRow.getCell("name").setValue((Object)kpiRefValue.getRefGroup().getName());
            try {
                BigDecimal tempValue = new BigDecimal(kpiRefValue.getRefValue());
                if (this.isPercent) {
                    tempValue = tempValue.multiply(percentSource);
                }
                iRow.getCell("value").setValue((Object)dec.format(tempValue));
            }
            catch (Exception e) {
                iRow.getCell("value").setValue((Object)kpiRefValue.getRefValue());
            }
            if (kpiRefValue.getCurrentValue() == null || kpiRefValue.getCurrentValue().equals(new BigDecimal(0))) {
                iRow.getCell("currentValue").setValue((Object)"");
                continue;
            }
            if (this.isPercent) {
                iRow.getCell("currentValue").setValue((Object)dec.format(percentSource.multiply(kpiRefValue.getCurrentValue())));
                continue;
            }
            iRow.getCell("currentValue").setValue((Object)dec.format(kpiRefValue.getCurrentValue()));
        }
    }

    private TempStandardValueInfo getTSValueById(KPIValueInfo kpiValueInfo, String tempId) {
        Map sMap;
        Object obj1;
        Object obj = this.kpiValueRefStValueMap.get(kpiValueInfo.getId().toString());
        if (obj != null && obj instanceof Map && (obj1 = (sMap = (Map)obj).get(tempId)) != null && obj1 instanceof TempStandardValueInfo) {
            return (TempStandardValueInfo)obj1;
        }
        return null;
    }

    private void initValue() {
        String paramTitle = (String)this.getUIContext().get("paramTitle");
        this.lblEdgeParamName.setText(paramTitle);
        String initFormula = (String)this.getUIContext().get("initFormula");
        this.changeFormula(true, "", initFormula);
    }

    public boolean getIsCanceled() {
        return this.isCanceled;
    }

    public void setIsCanceled(boolean isCanceled) {
        this.isCanceled = isCanceled;
    }

    protected void btnPlus_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "+", "+");
    }

    protected void btnMinus_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "-", "-");
    }

    protected void btnMulti_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "*", "*");
    }

    protected void btnDivision_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "/", "/");
    }

    protected void btnLeftBracket_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, "(", "(");
    }

    protected void btnRightBracket_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(true, ")", ")");
    }

    protected void btnConfirm_actionPerformed(ActionEvent e) throws Exception {
        this.setIsCanceled(false);
        this.getUIWindow().close();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.setIsCanceled(true);
        this.getUIWindow().close();
    }

    protected void btnAddToFormula_actionPerformed(ActionEvent e) throws Exception {
        int row = this.refValue.getSelectManager().getActiveRowIndex();
        if (row < 0) {
            return;
        }
        IRow rowInfo = this.refValue.getRow(row);
        String id = rowInfo.getCell("id").getValue().toString();
        String name = (String)rowInfo.getCell("name").getValue();
        StringBuffer txtFormu = new StringBuffer();
        txtFormu.append("$");
        txtFormu.append(name);
        txtFormu.append("$");
        this.changeFormula(true, "$" + id + "$", txtFormu.toString());
    }

    protected void btnDelete_actionPerformed(ActionEvent e) throws Exception {
        this.changeFormula(false, null, null);
    }

    protected void changeFormula(boolean isAppending, String formu, String txtFormu) {
        if (isAppending) {
            this.txtFormula.setText(this.txtFormula.getText() + txtFormu);
        } else {
            this.txtFormula.setText("");
        }
        this.txtFormula.requestFocus();
    }

    public String getFormula() {
        String formulaReturned = this.txtFormula.getText();
        return formulaReturned;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    public class EdgeParamFormulaData {
        private String idFormula;
        private String numberFormula;

        public String getIdFormula() {
            return this.idFormula;
        }

        public void setIdFormula(String idFormula) {
            this.idFormula = idFormula;
        }

        public String getNumberFormula() {
            return this.numberFormula;
        }

        public void setNumberFormula(String numberFormula) {
            this.numberFormula = numberFormula;
        }

        public EdgeParamFormulaData(String numberFormula, String idFormula) {
            this.idFormula = idFormula;
            this.numberFormula = numberFormula;
        }

        public String toString() {
            return this.idFormula;
        }
    }
}

