/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.swing.KDDialog;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.uiframe.client.HelpUtils;
import com.kingdee.eas.base.uiframe.client.UIModelDialog;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.fi.rpt.RptContextManager;
import com.kingdee.eas.fi.rpt.api.IRptContextManager;
import com.kingdee.eas.fi.rpt.client.FormulaFilter;
import com.kingdee.eas.fi.rpt.client.FormulaWizardUI;
import com.kingdee.eas.fi.rpt.client.IFormulaWizardListener;
import com.kingdee.eas.fi.rpt.client.RptFormula;
import com.kingdee.eas.fi.rpt.client.RptFormulaCategory;
import com.kingdee.eas.fi.rpt.client.RptFormulaComp;
import com.kingdee.eas.fi.rpt.client.RptOperObject;
import com.kingdee.eas.fi.rpt.util.RptUtil;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.UnAtomFormula;
import com.kingdee.eas.sem.mp.client.AbstractFormulaPickerUI;
import com.kingdee.eas.sem.mp.client.IFormulaPickerListener;
import com.kingdee.eas.sem.mp.util.MCUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Action;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FormulaPickerUI
extends AbstractFormulaPickerUI
implements IFormulaWizardListener {
    private boolean isAdvMode;
    private boolean canBeAdvance;
    private HashSet listeners;
    private String formulaLine;
    private Point basePos;
    private Point wizardPos;
    protected boolean isUnAtomFormula;
    protected RptContextManager context;
    protected RptFormulaCategory unAtomcategory;
    private String formulaName;
    private FormulaFilter fmFilter = null;
    private boolean showAdvance;

    public static FormulaPickerUI creatFormulaPicker(CoreUIObject parentUI) throws Exception {
        IUIFactory fy = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow wnd = fy.create(FormulaPickerUI.class.getName(), (Map)new UIContext((Object)parentUI));
        return wnd != null ? (FormulaPickerUI)wnd.getUIObject() : null;
    }

    public void open(String filter, boolean showAdvance) throws Exception {
        this.open(filter, false, false);
    }

    public void open(String filter, boolean showAdvance, boolean isUnAtomFormula) throws Exception {
        this.isUnAtomFormula = isUnAtomFormula;
        this.LoadFormulaComp(filter);
        IUIWindow w = this.getUIWindow();
        if (w instanceof KDDialog) {
            KDDialog d = (KDDialog)w;
            d.addWindowListener((WindowListener)new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    FormulaPickerUI.this.endPicker(false);
                }

                public void windowActivated(WindowEvent e) {
                    if (FormulaPickerUI.this.isAdvMode) {
                        // empty if block
                    }
                }
            });
            this.showAdvance = showAdvance;
        }
        w.show();
    }

    public void open(String filter) throws Exception {
        this.open(filter, false);
    }

    public void open() throws Exception {
        this.open(null);
    }

    public synchronized void addFormulaPickerListener(IFormulaPickerListener listener) {
        if (listener != null) {
            this.listeners.add(listener);
        }
    }

    private void fireListenersReturnee(boolean isOk, boolean isAdvMode) {
        for (IFormulaPickerListener l : this.listeners) {
            if (l == null) continue;
            l.pickerReturnee(this, this.formulaName, this.formulaLine, isOk, isAdvMode);
        }
    }

    private void fireListenersSetout() {
        for (IFormulaPickerListener l : this.listeners) {
            if (l == null) continue;
            l.pickerSetout(this);
        }
    }

    public void setExtendable(boolean canExtend) {
        this.canBeAdvance = canExtend;
        this.btnAdvance.setEnabled(this.canBeAdvance);
    }

    public boolean isAdvMode() {
        return this.isAdvMode;
    }

    public void setLocation(Point p) {
        if (p != null) {
            this.basePos.x = p.x;
            this.basePos.y = p.y;
        }
    }

    public FormulaPickerUI() throws Exception {
        this.btnPlus.setIcon(MCUtil.getIcon("imgTbtn_plussign"));
        this.btnMinus.setIcon(MCUtil.getIcon("imgTbtn_minussign"));
        this.btnMultiply.setIcon(MCUtil.getIcon("imgTbtn_multiplysign"));
        this.btnDivision.setIcon(MCUtil.getIcon("imgTbtn_dividesign"));
        this.btnBracket.setIcon(MCUtil.getIcon("imgTbtn_unequaltosign"));
        this.btnInsert.setIcon(MCUtil.getIcon("imgTbtn_showformula"));
        this.btnClear.setIcon(MCUtil.getIcon("imgTbtn_delete"));
        this.btnSearch.setIcon(MCUtil.getIcon("imgTbtn_find"));
        this.btnPlus.setText(null);
        this.btnMinus.setText(null);
        this.btnMultiply.setText(null);
        this.btnDivision.setText(null);
        this.btnBracket.setText(null);
        this.btnInsert.setText(null);
        this.btnClear.setText(null);
        this.btnSearch.setText(null);
        this.isAdvMode = false;
        this.canBeAdvance = true;
        this.listeners = new HashSet(1, 0.75f);
        this.basePos = new Point(100, 100);
        this.wizardPos = new Point(100, 100);
        this.txtSearch.setEnabledPopup(false);
        this.lstFormula.setFixedCellHeight(18);
        this.lstFormula.setModel(new DefaultListModel());
        this.lstFormula.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                RptOperObject fm;
                FormulaPickerUI.this.lstFormula.ensureIndexIsVisible(FormulaPickerUI.this.lstFormula.getSelectedIndex());
                if (e.getValueIsAdjusting()) {
                    return;
                }
                int cnt = FormulaPickerUI.this.lstFormula.getElementCount();
                RptOperObject rptOperObject = fm = cnt < 1 || FormulaPickerUI.this.lstFormula.getSelectedIndex() >= cnt ? null : (RptOperObject)FormulaPickerUI.this.lstFormula.getSelectedValue();
                if (fm instanceof UnAtomFormula) {
                    FormulaPickerUI.this.txtDescription.setText(fm == null ? null : fm.getDescription());
                } else {
                    FormulaPickerUI.this.txtDescription.setText(fm == null ? null : fm.getDescription());
                }
            }
        });
        this.lstFormula.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    try {
                        FormulaPickerUI.this.callWizard();
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
        this.cbxGroup.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    RptFormulaCategory cat = (RptFormulaCategory)e.getItem();
                    RptFormulaComp.getInstance().setCurCategory(cat);
                    FormulaPickerUI.this.showFormulas(cat.getName(), cat);
                }
            }
        });
        this.btnInsert.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    FormulaPickerUI.this.callWizard();
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        });
        SearchAction sa = new SearchAction();
        this.txtSearch.addActionListener((ActionListener)sa);
        this.btnSearch.addActionListener((ActionListener)sa);
    }

    protected void searchFormula() {
        String text = this.txtSearch.getText();
        if (text != null && text.length() > 0) {
            text = text.trim().toLowerCase();
            DefaultListModel listModel = (DefaultListModel)this.lstFormula.getModel();
            int curPos = this.lstFormula.getSelectedIndex();
            boolean isFound = false;
            int size = listModel.size();
            for (int i = 0; i < size; ++i) {
                String item;
                if (listModel.elementAt(curPos = this.getNextPos(curPos, 0, size - 1)) == null || (item = listModel.elementAt(curPos).toString().toLowerCase()).indexOf(text) == -1) continue;
                isFound = true;
                break;
            }
            if (isFound) {
                this.lstFormula.setSelectedIndex(curPos);
                this.lstFormula.ensureIndexIsVisible(curPos);
                this.lstFormula.requestFocus();
                return;
            }
        }
        this.txtSearch.requestFocus();
    }

    private int getNextPos(int curPos, int minPos, int maxPos) {
        if (curPos < minPos || curPos >= maxPos) {
            curPos = minPos - 1;
        }
        return curPos + 1;
    }

    public void LoadFormulaComp(String filter) throws Exception {
        ItemListener[] its;
        RptFormulaComp comp;
        if (this.fmFilter == null) {
            this.fmFilter = new FormulaFilter();
        }
        if (filter != null) {
            this.fmFilter.setFilter(filter);
        }
        if (!(comp = RptFormulaComp.getInstance()).isLoaded()) {
            comp.load();
        }
        if ((its = this.cbxGroup.getItemListeners()) != null && its.length > 0) {
            this.cbxGroup.removeItemListener(its[0]);
        }
        for (RptFormulaCategory ct : comp.getFormulaCategory()) {
            if (this.fmFilter.filtrateCate(ct.getName())) continue;
            this.cbxGroup.addItem((Object)ct);
        }
        RptFormulaCategory cn = comp.getCurCategory();
        if (cn != null) {
            this.cbxGroup.removeItem((Object)cn);
            this.cbxGroup.insertItemAt((Object)cn, 0);
        }
        if (this.cbxGroup.getItemCount() > 0) {
            this.cbxGroup.setSelectedIndex(0);
        }
        if (its != null && its.length > 0) {
            this.cbxGroup.addItemListener(its[0]);
        }
        this.fireListenersSetout();
        this.showFormulas(cn == null ? null : cn.getName(), cn);
    }

    public void setFilter(String filter) {
        if (this.fmFilter == null) {
            this.fmFilter = new FormulaFilter();
        }
        this.fmFilter.setFilter(filter);
    }

    public Dimension getPreferredSize() {
        IUIWindow w;
        if (!this.isPreferredSizeSet() && (w = this.getUIWindow()) != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            d.setResizable(false);
            d.setModal(true);
            Dimension stoneSize = this.preferredSize();
            stoneSize.width -= this.pnlAdvance.getSize().width;
            this.setPreferredSize(stoneSize);
        }
        return super.getPreferredSize();
    }

    protected void btnAdvance_actionPerformed(ActionEvent e) throws Exception {
        IUIWindow w = this.getUIWindow();
        if (w != null && w instanceof UIModelDialog) {
            UIModelDialog d = (UIModelDialog)w;
            Dimension AdvSize = d.getSize();
            if (this.isAdvMode) {
                AdvSize.width -= this.pnlAdvance.getSize().width;
                this.btnOk.setText(this.resHelper.getString("btnOk.text"));
            } else {
                AdvSize.width += this.pnlAdvance.getSize().width;
                this.btnOk.setText(this.resHelper.getString("btnFinish.text"));
                this.txtExpression.setSelectAllOnFocus(false);
                this.txtExpression.requestFocus();
                if (this.formulaLine != null && this.formulaLine.length() > 1 && this.formulaLine.charAt(0) == '=') {
                    this.txtExpression.setText(this.formulaLine.substring(1));
                }
            }
            this.isAdvMode = !this.isAdvMode;
            d.setSize(AdvSize);
        }
        super.btnAdvance_actionPerformed(e);
    }

    private void showFormulas(String cateName, RptFormulaCategory cat) {
        if ("all formulas".equalsIgnoreCase(cateName)) {
            cateName = null;
        }
        RptFormulaComp comp = RptFormulaComp.getInstance();
        Iterator fms = comp.getFormulasByCategory(cateName).iterator();
        DefaultListModel listModel = (DefaultListModel)this.lstFormula.getModel();
        listModel.removeAllElements();
        if (this.unAtomcategory != null && (this.unAtomcategory.equals((Object)cat) || cateName == null)) {
            for (IFormulaPickerListener l : this.listeners) {
                if (l == null) continue;
                l.loadFormulas(this);
            }
        }
        int index = -1;
        int pos = 0;
        while (fms.hasNext()) {
            RptFormula fm = (RptFormula)fms.next();
            if (this.fmFilter.filtrateFormula(fm)) continue;
            if (index == -1 && fm.equals((Object)comp.getCurFormula())) {
                index = pos;
            }
            ++pos;
            listModel.addElement(fm);
        }
        if (index >= 0) {
            this.lstFormula.setSelectedIndex(index);
            this.lstFormula.ensureIndexIsVisible(index);
        }
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        this.endPicker(false);
    }

    protected void btnOk_actionPerformed(ActionEvent e) throws Exception {
        super.btnOk_actionPerformed(e);
        if (this.isAdvMode) {
            this.endPicker(true);
        } else {
            this.callWizard();
        }
    }

    private void endPicker(boolean isOk) {
        if (isOk) {
            if (this.isAdvMode) {
                this.formulaLine = this.txtExpression.getText().trim();
            }
        } else {
            this.formulaLine = null;
            this.formulaName = null;
        }
        this.disposeUIWindow();
        this.fireListenersReturnee(isOk, this.isAdvMode);
    }

    private void callWizard() throws Exception {
        if (this.lstFormula.getModel().getSize() < 1) {
            return;
        }
        RptOperObject fm1 = (RptOperObject)this.lstFormula.getSelectedValue();
        if (fm1 == null) {
            return;
        }
        if (fm1 instanceof UnAtomFormula) {
            this.wizardReturnee(null, ((UnAtomFormula)fm1).getFormula(), true);
            return;
        }
        RptFormula fm = (RptFormula)fm1;
        RptFormulaComp.getInstance().setCurFormula(fm);
        this.formulaName = fm.getName();
        FormulaWizardUI wizard = FormulaWizardUI.creatFormulaWizard((String)fm.getWizard(), (Object)((Object)this));
        wizard.addFormulaWizardListener((IFormulaWizardListener)this);
        wizard.setRptContext((IRptContextManager)this.context);
        wizard.open(fm.getName());
    }

    public void wizardSetout(FormulaWizardUI wizard) {
    }

    public void wizardReturnee(FormulaWizardUI wizard, String formulaLine, boolean isOk) {
        if (!this.isAdvMode) {
            this.formulaLine = formulaLine;
            this.endPicker(isOk);
        } else if (isOk) {
            this.txtExpression.insert(formulaLine, this.txtExpression.getCaretPosition());
        }
    }

    private boolean canInsert(char ch, int insertPos) {
        String line = this.txtExpression.getText();
        char preChar = '\u0000';
        if (line == null || line.length() == 0) {
            insertPos = -1;
        } else if (insertPos > 0) {
            preChar = line.charAt(insertPos - 1);
        }
        boolean res = false;
        switch (ch) {
            case '+': {
                res = true;
                break;
            }
            case '-': {
                res = true;
                break;
            }
            case '*': {
                res = insertPos > 0;
                break;
            }
            case '/': {
                res = insertPos > 0;
                break;
            }
            case '(': {
                res = true;
            }
        }
        return res;
    }

    private void insertOperator(char ch) {
        int pos = this.txtExpression.getCaretPosition();
        if (this.canInsert(ch, pos)) {
            if (ch != '(') {
                this.txtExpression.insert(Character.toString(ch), pos);
            } else {
                this.txtExpression.insert("()", pos);
                this.txtExpression.setCaretPosition(pos + 1);
            }
        }
    }

    public void insertOperatorAction_actionPerformed(ActionEvent e) throws Exception {
        super.insertOperatorAction_actionPerformed(e);
        int ch = 0;
        Object src = e.getSource();
        if (src == this.btnPlus) {
            ch = 43;
        } else if (src == this.btnMinus) {
            ch = 45;
        } else if (src == this.btnMultiply) {
            ch = 42;
        } else if (src == this.btnDivision) {
            ch = 47;
        } else if (src == this.btnBracket) {
            ch = 40;
        }
        this.insertOperator((char)ch);
        this.txtExpression.requestFocus();
    }

    public void setRptContext(RptContextManager rptContext) {
        this.context = rptContext;
    }

    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtExpression.setText("");
        this.txtExpression.requestFocus();
    }

    protected JButton getDefaultButton() {
        return this.btnOk;
    }

    public void onShow() throws Exception {
        super.onShow();
        if (this.showAdvance) {
            try {
                this.btnAdvance_actionPerformed(null);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MCUtil.setEscAction((CoreUIObject)this, new Action(){

            public boolean isEnabled() {
                return true;
            }

            public void setEnabled(boolean b) {
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
            }

            public Object getValue(String key) {
                return null;
            }

            public void putValue(String key, Object value) {
            }

            public void actionPerformed(ActionEvent e) {
                FormulaPickerUI.this.endPicker(false);
            }
        });
    }

    public void actionHelp_actionPerformed(ActionEvent e) throws Exception {
        super.actionHelp_actionPerformed(e);
        JButton btn = (JButton)e.getSource();
        try {
            HelpUtils.ActionHelp h = new HelpUtils.ActionHelp("fatempClassCriterion", (Component)btn, "fatempClassCriterion", 30);
            h.actionPerformed(e);
        }
        catch (Exception ex) {
            MsgBox.showError((String)RptUtil.getReportResource((String)"HELP_NOT_EXISTS"));
        }
    }

    public void setAdvMode(boolean isAdvMode) {
        this.isAdvMode = isAdvMode;
    }

    public String getFormulaLine() {
        return this.formulaLine;
    }

    public void setFormulaLine(String formulaLine) {
        this.formulaLine = formulaLine;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    private class SearchAction
    implements ActionListener {
        private SearchAction() {
        }

        public void actionPerformed(ActionEvent e) {
            FormulaPickerUI.this.searchFormula();
        }
    }
}

