/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.event.KDTMouseEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.client.AbstractImportKPIUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.KDTableUtil;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class ImportKPIUI
extends AbstractImportKPIUI {
    private static final Logger logger = CoreUIObject.getLogger(ImportKPIUI.class);
    public static String[] selectKpiIDs = null;
    public static boolean isSelectedAll = false;
    public static boolean isCanceled = false;
    private String resource = "com.kingdee.eas.sem.mp.MPResource";
    EntityViewInfo queryEntity = null;
    List kpiList = new ArrayList();

    public void onLoad() throws Exception {
        super.onLoad();
        this.createQueryEntity();
        this.queryImportKPIQuery = this.queryEntity;
        this.kdtQueryImportKPIQuery.checkParsed();
        this.kdtQueryImportKPIQuery.getSelectManager().setSelectMode(10);
        this.kdtQueryImportKPIQuery.getColumn("number").setMergeable(true);
        this.kdtQueryImportKPIQuery.getColumn("name").setMergeable(true);
        this.kdtQueryImportKPIQuery.getColumn("company.name").setMergeable(true);
        this.kdtQueryImportKPIQuery.getColumn("BSC.name").setMergeable(true);
        this.kdtQueryImportKPIQuery.getColumn("CSF.name").setMergeable(true);
        this.kdtQueryImportKPIQuery.getStyleAttributes().setLocked(true);
    }

    protected void createQueryEntity() throws Exception {
        this.queryEntity = new EntityViewInfo();
        AdminOrgUnitInfo currentAdminOrg = (AdminOrgUnitInfo)this.getUIContext().get("currentAdminOrg");
        AdminOrgUnitInfo parentAdminOrg = (AdminOrgUnitInfo)this.getUIContext().get("parentAdminOrg");
        String currentOrgID = currentAdminOrg.getId().toString();
        String parentOrgID = parentAdminOrg.getId().toString();
        IKPI iKPI = KPIFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)currentOrgID));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", null, CompareType.NOTEQUALS));
        evi.setFilter(filter);
        KPICollection currentCollection = iKPI.getKPICollection(evi);
        KPICollection parentCollection = null;
        EntityViewInfo parentEvi = new EntityViewInfo();
        FilterInfo parentFilter = new FilterInfo();
        parentFilter.getFilterItems().add(new FilterItemInfo("company.id", (Object)parentOrgID));
        parentEvi.setFilter(parentFilter);
        parentCollection = iKPI.getKPICollection(parentEvi);
        List tempList = this.compareKPICollection(parentCollection, currentCollection);
        int size = currentCollection.size();
        KPIInfo parentInfo = null;
        Object currentInfo = null;
        KPIValueCollection currentKpiValueCol = null;
        KPIValueCollection parentKpiValueCol = null;
        KPIValueInfo curKpiValue = null;
        KPIValueInfo parKpiValue = null;
        KPIInfo kpiInfo = null;
        Object valueInfo = null;
        KPICollection kpiCols = new KPICollection();
        boolean hasImport = false;
        for (int i = 0; i < size; ++i) {
            parentInfo = currentCollection.get(i).getParent();
            currentKpiValueCol = currentCollection.get(i).getKpiValue();
            if (parentInfo == null) continue;
            parentInfo = iKPI.getKPIInfo((IObjectPK)new ObjectUuidPK(parentInfo.getId()));
            parentKpiValueCol = parentInfo.getKpiValue();
            kpiInfo = (KPIInfo)parentInfo.clone();
            kpiInfo.getKpiValue().clear();
            int n = parentKpiValueCol.size();
            for (int j = 0; j < n; ++j) {
                parKpiValue = parentKpiValueCol.get(j);
                hasImport = false;
                int m = currentKpiValueCol.size();
                for (int k = 0; k < m; ++k) {
                    curKpiValue = currentKpiValueCol.get(k);
                    if (curKpiValue.getParentId() == null || !curKpiValue.getParentId().equals(parKpiValue.getId().toString())) continue;
                    hasImport = true;
                    break;
                }
                if (hasImport) continue;
                kpiInfo.getKpiValue().add(parKpiValue);
            }
            if (kpiInfo.getKpiValue().size() <= 0) continue;
            kpiCols.add(kpiInfo);
        }
        StringBuffer kpiIDString = new StringBuffer();
        StringBuffer kpiValueIDString = new StringBuffer();
        KPIInfo tempInfo = null;
        KPIValueCollection valueCols = null;
        int valueCount = 0;
        int count = kpiCols.size();
        for (int k = 0; k < count; ++k) {
            tempInfo = kpiCols.get(k);
            kpiIDString.append(tempInfo.getId().toString());
            kpiIDString.append(",");
            valueCols = tempInfo.getKpiValue();
            valueCount = valueCols.size();
            for (int p = 0; p < valueCount; ++p) {
                kpiValueIDString.append(valueCols.get(p).getId().toString());
                kpiValueIDString.append(",");
            }
        }
        if (kpiIDString.lastIndexOf(",") > 0) {
            kpiIDString.substring(0, kpiIDString.lastIndexOf(","));
        }
        if (kpiValueIDString.lastIndexOf(",") > 0) {
            kpiValueIDString.substring(0, kpiValueIDString.lastIndexOf(","));
        }
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("company.id", (Object)parentOrgID));
        StringBuffer tempId = new StringBuffer();
        Iterator ite = tempList.iterator();
        while (ite.hasNext()) {
            tempId.append(ite.next().toString());
            tempId.append(",");
        }
        String notImportIds = tempId.toString();
        if (tempId.lastIndexOf(",") > 0) {
            notImportIds = notImportIds.substring(0, tempId.lastIndexOf(","));
        }
        filter1.getFilterItems().add(new FilterItemInfo("id", (Object)notImportIds.toString(), CompareType.INCLUDE));
        if (kpiIDString.length() > 0) {
            filter1.getFilterItems().add(new FilterItemInfo("id", (Object)kpiIDString.toString(), CompareType.INCLUDE));
            filter1.getFilterItems().add(new FilterItemInfo("kpiValue.id", (Object)kpiValueIDString.toString(), CompareType.INCLUDE));
            filter1.setMaskString(" (#0 and ( #1 or ( #2 and #3 )))");
        } else {
            filter1.setMaskString(" (#0 and #1) ");
        }
        this.queryEntity.setFilter(filter1);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        block5: {
            super.btnOK_actionPerformed(e);
            isCanceled = false;
            isSelectedAll = this.chkSelectedAll.isSelected();
            if (!isSelectedAll) {
                int[] rowID = KDTableUtil.getSelectedRows((KDTable)this.kdtQueryImportKPIQuery);
                if (rowID != null && rowID.length > 0) {
                    selectKpiIDs = new String[rowID.length];
                    for (int i = 0; i < rowID.length; ++i) {
                        String kpiId = this.kdtQueryImportKPIQuery.getRow(rowID[i]).getCell(0).getValue().toString();
                        String kpiValueId = this.kdtQueryImportKPIQuery.getRow(rowID[i]).getCell("kpiValue.id").getValue().toString();
                        ImportKPIUI.selectKpiIDs[i] = kpiId + "!" + kpiValueId;
                    }
                    break block5;
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)this.resource, (String)"selectImportRecord"));
                    return;
                }
            }
            selectKpiIDs = new String[this.kdtQueryImportKPIQuery.getRowCount()];
            for (int i = 0; i < this.kdtQueryImportKPIQuery.getRowCount(); ++i) {
                String kpiId = this.kdtQueryImportKPIQuery.getRow(i).getCell(0).getValue().toString();
                String kpiValueId = this.kdtQueryImportKPIQuery.getRow(i).getCell("kpiValue.id").getValue().toString();
                ImportKPIUI.selectKpiIDs[i] = kpiId + "!" + kpiValueId;
            }
        }
        this.getUIWindow().close();
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        super.btnCancel_actionPerformed(e);
        isCanceled = true;
        this.getUIWindow().close();
    }

    protected void tblMain_tableClicked(KDTMouseEvent e) throws Exception {
        if (e.getClickCount() != 1 && e.getClickCount() == 2) {
            this.btnOK_actionPerformed(null);
        }
    }

    private List compareKPICollection(KPICollection sourceCols, KPICollection targetCols) {
        ArrayList<String> ids = new ArrayList<String>();
        if (sourceCols == null) {
            return ids;
        }
        if (targetCols == null) {
            Iterator ite = sourceCols.iterator();
            while (ite.hasNext()) {
                ids.add(((KPIInfo)ite.next()).getId().toString());
            }
        } else {
            Iterator ite = sourceCols.iterator();
            while (ite.hasNext()) {
                KPIInfo kpiInfo = (KPIInfo)ite.next();
                if (this.isExist(kpiInfo.getId().toString(), targetCols)) continue;
                ids.add(kpiInfo.getId().toString());
            }
        }
        return ids;
    }

    private boolean isExist(String id, KPICollection cols) {
        if (id == null) {
            return false;
        }
        if (cols == null) {
            return false;
        }
        Iterator ite = cols.iterator();
        while (ite.hasNext()) {
            KPIInfo kpiInfo = (KPIInfo)ite.next();
            if (!id.equals(kpiInfo.getParent().getId().toString())) continue;
            return true;
        }
        return false;
    }
}

