/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgStructureInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfCompanyInfo;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfKPICollection;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfKPIInfo;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetFactory;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetInfo;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.client.AbstractKPIAnalysisReportEditUI;
import com.kingdee.eas.sem.mp.client.KPISelectUI;
import com.kingdee.eas.sem.mp.util.SortHandle;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class KPIAnalysisReportEditUI
extends AbstractKPIAnalysisReportEditUI {
    private static final Logger logger = CoreUIObject.getLogger(KPIAnalysisReportEditUI.class);
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    private boolean selectCompanyOK;
    private boolean selectKPIOK;
    private Set currentCompanySet = new HashSet();

    public void onLoad() throws Exception {
        this.kdtOfKPI.checkParsed();
        this.kdtOfCompany.checkParsed();
        super.onLoad();
        this.kdtOfKPI.getSelectManager().setSelectMode(10);
        this.kdtOfCompany.getSelectManager().setSelectMode(10);
        this.btnSelCompany.setEnabled(true);
        this.btnDelCompany.setEnabled(true);
        this.btnSelKpi.setEnabled(true);
        this.btnDelKpi.setEnabled(true);
        this.btnSave.setVisible(false);
        this.btnPrint.setVisible(false);
        this.btnPrintPreview.setVisible(false);
        this.btnCancel.setVisible(false);
        this.btnCancelCancel.setVisible(false);
        this.btnFirst.setVisible(false);
        this.btnNext.setVisible(false);
        this.btnLast.setVisible(false);
        this.btnPre.setVisible(false);
        this.btnCopy.setVisible(false);
        this.txtName.setRequired(true);
        this.txtNumber.setRequired(true);
        this.prmtCreator.setEnabled(false);
        this.contCreator.setVisible(false);
        this.kdtOfKPI.getStyleAttributes().setLocked(true);
        this.kdtOfCompany.getStyleAttributes().setLocked(true);
        this.editData.isIsDisplayCompanySimpleName();
        this.kpiUp.setEnabled(true);
        this.kpiDown.setEnabled(true);
        KDTSortManager sSm = new KDTSortManager(this.kdtOfKPI);
        sSm.setSortAuto(true);
        this.kdtOfKPI.getColumn("index").setSortable(true);
        sSm.sort(this.kdtOfKPI.getColumnIndex("index"), 0);
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void addSelfListens() {
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("isDisplayCompanySimpleName"));
        return sic;
    }

    public void setDataObject(IObjectValue dataObject) {
        this.orderHandle(dataObject);
        super.setDataObject(dataObject);
    }

    protected void beforeStoreFields(ActionEvent e) throws Exception {
        int kpiCount;
        String name;
        String number = this.txtNumber.getText();
        if (number == null || number.trim().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"number_null"));
            this.txtNumber.requestFocus();
            this.abort();
        } else if (number.length() > 80) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"number_too_long"));
            this.txtNumber.requestFocus();
            this.abort();
        }
        String string = name = this.txtName.getSelectedItemData() == null ? null : this.txtName.getSelectedItemData().toString();
        if (name == null || name.trim().length() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"name_null"));
            this.txtName.requestFocus();
            this.abort();
        } else if (name.length() > 255) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"name_too_long"));
            this.txtName.requestFocus();
            this.abort();
        }
        int companyCount = this.kdtOfCompany.getRowCount();
        if (companyCount <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_company"));
            this.abort();
        }
        if ((kpiCount = this.kdtOfKPI.getRowCount()) <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_kpi"));
            this.abort();
        }
    }

    protected IObjectValue createNewData() {
        KPIAnalysisReportSetInfo newInfo = new KPIAnalysisReportSetInfo();
        newInfo.setIsDisplayCompanySimpleName(true);
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        if (user != null) {
            try {
                user = UserFactory.getRemoteInstance().getUserInfo((IObjectPK)new ObjectUuidPK(user.getId()));
            }
            catch (Exception e) {
                logger.info((Object)"createNewData() error,init user error!");
            }
        }
        newInfo.setCreator(user);
        return newInfo;
    }

    public void actionSelectCompany_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo[] tempOrgInfo;
        String orgId = null == SysContext.getSysContext().getCurrentFIUnit() ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(true);
        af7.setRootUnitID(orgId);
        af7.setCheckedOrgIDs(this.currentCompanySet);
        af7.show();
        if (af7.isCanceled()) {
            return;
        }
        Object obj = af7.getData();
        if (obj instanceof OrgUnitInfo[] && (tempOrgInfo = (OrgUnitInfo[])obj) != null && tempOrgInfo.length > 0) {
            boolean isAdd = false;
            for (int i = 0; i < tempOrgInfo.length; ++i) {
                IRow tempRow;
                KPIAnalysisReportOfCompanyInfo companyInfo;
                isAdd = false;
                OrgUnitInfo tempOuInfo = tempOrgInfo[i];
                String ouId = tempOuInfo.getId().toString();
                int rowCount = this.kdtOfCompany.getRowCount();
                this.currentCompanySet.add(ouId);
                if (rowCount > 0) {
                    for (int j = 0; j < rowCount; ++j) {
                        String addOuId = this.kdtOfCompany.getRow(j).getCell("companyId").getValue().toString();
                        if (!ouId.equals(addOuId)) continue;
                        isAdd = true;
                        break;
                    }
                    if (isAdd) continue;
                    companyInfo = this.createCompanyInfo();
                    companyInfo.setPartFI((CompanyOrgUnitInfo)tempOrgInfo[i]);
                    tempRow = this.kdtOfCompany.addRow();
                    tempRow.setUserObject((Object)companyInfo);
                    this.dataBinder.loadLineFields(this.kdtOfCompany, tempRow, (IObjectValue)companyInfo);
                    continue;
                }
                companyInfo = this.createCompanyInfo();
                companyInfo.setPartFI((CompanyOrgUnitInfo)tempOrgInfo[i]);
                tempRow = this.kdtOfCompany.addRow();
                tempRow.setUserObject((Object)companyInfo);
                this.dataBinder.loadLineFields(this.kdtOfCompany, tempRow, (IObjectValue)companyInfo);
            }
        }
    }

    public void actionSelectKPI_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ArrayList list = new ArrayList();
        uiContext.put((Object)"Data", list);
        uiContext.put((Object)"KPIAnalysisReportEditUI", (Object)this);
        uiContext.put((Object)"DefaultFilter", (Object)this.getInitFilterForSelectUI());
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow window = uiFactory.create(KPISelectUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        if (this.isSelectKPIOK()) {
            if (list != null) {
                Iterator ite = list.iterator();
                boolean isAdd = false;
                while (ite.hasNext()) {
                    KPIAnalysisReportOfKPIInfo reportOfKPIInfo;
                    IRow tempRow;
                    isAdd = false;
                    KPIInfo tempKpiInfo = (KPIInfo)ite.next();
                    String tempId = tempKpiInfo.getId().toString();
                    int rows = this.kdtOfKPI.getRowCount();
                    if (rows > 0) {
                        for (int i = 0; i < rows; ++i) {
                            String cellId = this.kdtOfKPI.getRow(i).getCell("kpiID").getValue().toString();
                            if (!tempId.equals(cellId)) continue;
                            isAdd = true;
                            break;
                        }
                        if (isAdd) continue;
                        tempRow = this.kdtOfKPI.addRow();
                        reportOfKPIInfo = this.createReportOfKPIInfo();
                        reportOfKPIInfo.setKpi(tempKpiInfo);
                        this.dataBinder.loadLineFields(this.kdtOfKPI, tempRow, (IObjectValue)reportOfKPIInfo);
                        continue;
                    }
                    tempRow = this.kdtOfKPI.addRow();
                    reportOfKPIInfo = this.createReportOfKPIInfo();
                    reportOfKPIInfo.setKpi(tempKpiInfo);
                    this.dataBinder.loadLineFields(this.kdtOfKPI, tempRow, (IObjectValue)reportOfKPIInfo);
                }
            }
            this.refreshRowIndex(this.kdtOfKPI);
        }
    }

    private KPIAnalysisReportOfKPIInfo createReportOfKPIInfo() {
        KPIAnalysisReportOfKPIInfo kpiInfo = new KPIAnalysisReportOfKPIInfo();
        kpiInfo.setAnalysisSet(this.editData);
        return kpiInfo;
    }

    private KPIAnalysisReportOfCompanyInfo createCompanyInfo() {
        KPIAnalysisReportOfCompanyInfo companyInfo = new KPIAnalysisReportOfCompanyInfo();
        return companyInfo;
    }

    private HashMap getMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            CompanyOrgUnitCollection coms = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("select id");
            map = new HashMap();
            int n = coms.size();
            for (int i = 0; i < n; ++i) {
                map.put(coms.get(i).getId().toString(), new Boolean(false));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    public void actionDelKpi_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtOfKPI);
        this.refreshRowIndex(this.kdtOfKPI);
    }

    public void actionDelCompany_actionPerformed(ActionEvent e) throws Exception {
        this.removeLine(this.kdtOfCompany);
    }

    public void actionKpiDown_actionPerformed(ActionEvent e) throws Exception {
        this.downRow(this.kdtOfKPI);
    }

    public void actionUpKpi_actionPerformed(ActionEvent e) throws Exception {
        this.upRow(this.kdtOfKPI);
    }

    private void upRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > 0) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw - 1, selectRow);
            table.getSelectManager().select(selectRpw - 1, 0);
            this.refreshRowIndex(table);
        }
    }

    private void downRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw >= 0 && selectRpw < table.getRowCount() - 1) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw + 1, selectRow);
            table.getSelectManager().select(selectRpw + 1, 0);
            this.refreshRowIndex(table);
        }
    }

    private void delSelectLine(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            table.removeRow(selectRpw);
        }
    }

    private void refreshRowIndex(KDTable table) {
        if (table == null) {
            return;
        }
        int rowCount = table.getRowCount();
        if (rowCount <= 1) {
            return;
        }
        for (int i = 0; i < rowCount; ++i) {
            IRow row = table.getRow(i);
            row.getCell("index").setValue((Object)new Integer(i));
        }
    }

    protected ICoreBase getBizInterface() throws Exception {
        return KPIAnalysisReportSetFactory.getRemoteInstance();
    }

    public boolean isSelectCompanyOK() {
        return this.selectCompanyOK;
    }

    public void setSelectCompanyOK(boolean selectCompanyOK) {
        this.selectCompanyOK = selectCompanyOK;
    }

    public boolean isSelectKPIOK() {
        return this.selectKPIOK;
    }

    public void setSelectKPIOK(boolean selectKPIOK) {
        this.selectKPIOK = selectKPIOK;
    }

    protected void removeLine(KDTable table) {
        if (table == null) {
            return;
        }
        if (table.getSelectManager().size() == 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        if (this.confirmRemove()) {
            KDTSelectManager selectManager = table.getSelectManager();
            int size = selectManager.size();
            KDTSelectBlock selectBlock = null;
            HashSet<Integer> indexSet = new HashSet<Integer>();
            for (int blockIndex = 0; blockIndex < size; ++blockIndex) {
                selectBlock = selectManager.get(blockIndex);
                int top = selectBlock.getBeginRow();
                int bottom = selectBlock.getEndRow();
                if (table.getRow(top) == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
                    return;
                }
                for (int i = top; i <= bottom; ++i) {
                    indexSet.add(new Integer(i));
                }
            }
            Object[] indexArr = new Integer[indexSet.size()];
            Object[] indexObj = indexSet.toArray();
            System.arraycopy(indexObj, 0, indexArr, 0, indexArr.length);
            Arrays.sort(indexArr);
            if (indexArr == null) {
                return;
            }
            for (int i = indexArr.length - 1; i >= 0; --i) {
                int index;
                int rowIndex = Integer.parseInt(String.valueOf(indexArr[i]));
                IObjectValue detailData = (IObjectValue)table.getRow(rowIndex).getUserObject();
                table.removeRow(rowIndex);
                IObjectCollection collection = (IObjectCollection)table.getUserObject();
                if (collection == null) {
                    logger.error((Object)"collection not be binded to table");
                } else if (detailData != null && (index = this.getCollectionIndex(collection, detailData)) >= 0 && collection.size() > index) {
                    collection.removeObject(index);
                }
                this.afterRemoveLine(table, detailData);
            }
            if (table.getRow(0) != null) {
                table.getSelectManager().select(0, 0);
            }
        }
    }

    protected void afterRemoveLine(KDTable table, IObjectValue lineData) {
    }

    private int getCollectionIndex(IObjectCollection collection, IObjectValue obj) {
        int index = -1;
        if (collection == null) {
            return index;
        }
        for (int i = collection.size() - 1; i >= 0; --i) {
            if (obj != collection.getObject(i)) continue;
            index = i;
            return index;
        }
        return index;
    }

    protected FilterInfo getInitFilterForSelectUI() {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)SysContext.getSysContext().getCurrentCtrlUnit().getId().toString(), CompareType.EQUALS));
        return filter;
    }

    private HashMap getTreeCols(TreeModel model) {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        if (model == null) {
            return map;
        }
        Object obj = model.getRoot();
        if (obj != null && obj instanceof DefaultKingdeeTreeNode) {
            OrgStructureInfo tempInfo = (OrgStructureInfo)((DefaultKingdeeTreeNode)obj).getUserObject();
            map.put(tempInfo.getUnit().getId().toString(), new Boolean(false));
            this.initTreeMap(model, (DefaultKingdeeTreeNode)obj, map);
        }
        return map;
    }

    private void initTreeMap(TreeModel model, DefaultKingdeeTreeNode parent, Map map) {
        int childCount = model.getChildCount(parent);
        for (int i = 0; i < childCount; ++i) {
            Object obj = model.getChild(parent, i);
            OrgStructureInfo tempInfo = (OrgStructureInfo)((DefaultKingdeeTreeNode)obj).getUserObject();
            map.put(tempInfo.getUnit().getId().toString(), new Boolean(false));
            this.initTreeMap(model, (DefaultKingdeeTreeNode)obj, map);
        }
    }

    private void orderHandle(IObjectValue dataObject) {
        int size;
        if (dataObject == null || !(dataObject instanceof KPIAnalysisReportSetInfo)) {
            return;
        }
        KPIAnalysisReportSetInfo setInfo = (KPIAnalysisReportSetInfo)dataObject;
        KPIAnalysisReportOfKPICollection reportOfKpi = setInfo.getOfKPI();
        if (reportOfKpi != null && (size = reportOfKpi.size()) > 0) {
            int i;
            KPIAnalysisReportOfKPIInfo[] tempArray = new KPIAnalysisReportOfKPIInfo[reportOfKpi.size()];
            for (i = 0; i < size; ++i) {
                tempArray[i] = reportOfKpi.get(i);
                System.out.println("index" + i + ":" + tempArray[i].getIndex());
            }
            SortHandle.sort(tempArray, 0, size);
            reportOfKpi.clear();
            for (i = 0; i < size; ++i) {
                System.out.println("index" + i + ":" + tempArray[i].getIndex());
                reportOfKpi.add(tempArray[i]);
            }
        }
    }
}

