/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.common.variant.Variant;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.sem.mp.EdgeGroupInfo;
import com.kingdee.eas.sem.mp.IKPIFacade;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamNewCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamNewInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.client.AbstractKPICalculateConditionUI;
import com.kingdee.eas.sem.mp.client.LongTimeDialog;
import com.kingdee.eas.util.AbortException;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.util.ScriptUtil;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class KPICalculateConditionUI
extends AbstractKPICalculateConditionUI {
    private static final Logger logger = CoreUIObject.getLogger(KPICalculateConditionUI.class);
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    private static BigDecimal MAXVALUE = new BigDecimal("1000000000000");
    KPIInfo kpiInfo = (KPIInfo)this.getUIContext().get("kpiInfo");
    KPIInfo newKpiInfo = null;
    KPIRefStandardValueNewCollection cols = null;
    List resultList = null;
    private IKPIFacade kpiFacade = null;
    private boolean verifyResult = true;
    Date date = null;
    String state = "";

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionAbout.setVisible(false);
        this.actionCalculator.setVisible(false);
        this.actionExitCurrent.setVisible(false);
        this.actionExport.setVisible(false);
        this.actionHelp.setVisible(false);
        this.actionPageSetup.setVisible(false);
        this.actionPersonalSite.setVisible(false);
        this.actionRegProduct.setVisible(false);
        this.menuBar.setVisible(false);
        this.toolBar.setVisible(false);
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void isCancel_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
    }

    private void verifyKPI() {
        if (null != this.resultList && this.kpiInfo.getRefValue().size() == this.resultList.size() - 1) {
            this.newKpiInfo = this.setStandardValue(this.kpiInfo, this.resultList);
            this.veriryWarnParamData(this.newKpiInfo);
        }
    }

    private void veriryWarnParamData(KPIInfo newKpiInfo) {
        if (newKpiInfo.isIsWarnable()) {
            this.calculateWarnParamCurrentValue(newKpiInfo);
            this.state = this.getKpiValueCurrentWarn(newKpiInfo, this.resultList.get(0));
            this.verifyWarnParamValue(newKpiInfo);
        }
    }

    private void doCalculate() {
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog(new JFrame()));
        ltd.getText().setText(EASResource.getString((String)RES, (String)"informal_calculate_processbar_content"));
        ltd.setTitle(EASResource.getString((String)RES, (String)"informal_calculate_process_title"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    KPICalculateConditionUI.this.resultList = KPICalculateConditionUI.this.calculateFormula(KPICalculateConditionUI.this.date);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
    }

    private List calculateFormula(Date date) {
        this.kpiInfo = (KPIInfo)this.getUIContext().get("kpiInfo");
        this.cols = this.kpiInfo.getRefValue();
        List reList = new ArrayList();
        ArrayList<Object> standardValueList = new ArrayList<Object>();
        Iterator iter = this.cols.iterator();
        int i = 0;
        String[] formulaArr = new String[this.cols.size() + 1];
        formulaArr[0] = this.kpiInfo.getFormula();
        while (iter.hasNext()) {
            KPIRefStandardValueNewInfo info = (KPIRefStandardValueNewInfo)iter.next();
            formulaArr[++i] = info.getRefValue();
        }
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("bizDate", date);
        params.put("timeType", (Object)this.kpiInfo.getTimeType());
        params.put("company", (OrgUnitInfo)this.getUIContext().get("company"));
        params.put("IncludePosted", this.kpiInfo.isIsUnpassedVoucherIncluded());
        params.put("IncludeLeaf", this.kpiInfo.isIsDetailItemBalanceInclude());
        params.put("IncludeSub", this.kpiInfo.isIsSubItemBalanceInclude());
        try {
            reList = this.getKPIFacade().calcFormulas(formulaArr, params);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        if (reList.get(0) instanceof Variant[]) {
            Variant[] var = (Variant[])reList.get(0);
            for (int p = 0; p < var.length; ++p) {
                if (null != var[p].getValue()) {
                    if (!(var[p].getValue() instanceof BigDecimal) && !(var[p].getValue() instanceof Integer)) {
                        Object tips = var[p].getValue();
                        if (tips.toString().indexOf(EASResource.getString((String)RES, (String)"permission")) > -1) {
                            if (p == 0) {
                                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"kpi_formula_no_permission_error") + formulaArr[p]));
                            } else {
                                MsgBox.showInfo((Component)((Object)this), (String)(EASResource.getString((String)RES, (String)"kpi_standardvalue_formula_no_permission_error") + formulaArr[p]));
                            }
                            SysUtil.abort();
                            continue;
                        }
                        if (tips.equals("=")) {
                            standardValueList.add("");
                            continue;
                        }
                        if (p == 0) {
                            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"kpi_formula_error"));
                            SysUtil.abort();
                            continue;
                        }
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"kpi_standardvalue_error"));
                        SysUtil.abort();
                        continue;
                    }
                    standardValueList.add(var[p].getValue());
                    continue;
                }
                standardValueList.add("");
            }
        }
        return standardValueList;
    }

    private IKPIFacade getKPIFacade() throws BOSException {
        if (this.kpiFacade == null) {
            this.kpiFacade = KPIFacadeFactory.getRemoteInstance();
        }
        return this.kpiFacade;
    }

    private String getKpiValueCurrentWarn(KPIInfo kpiInfo, Object kpiValue) {
        if (!kpiInfo.isIsWarnable()) {
            return "";
        }
        KPIWarnParamNewCollection params = null;
        params = kpiInfo.getWarnParam();
        if (params != null) {
            HashMap<String, BigDecimal> paramsMap = new HashMap<String, BigDecimal>();
            int paramCount = params.size();
            for (int i = 0; i < paramCount; ++i) {
                KPIWarnParamNewInfo paramInfo = params.get(i);
                paramsMap.put(paramInfo.getEdgeParam().getId().toString() + paramInfo.getWarnGroup().getId().toString(), paramInfo.getCurrentValue());
            }
            String egFormula = " " + kpiInfo.getCurrentWarnStatus().getFormula();
            try {
                IWarnGroup warnGroup = WarnGroupFactory.getRemoteInstance();
                EntityViewInfo wgevi = new EntityViewInfo();
                SorterItemInfo sort = new SorterItemInfo("periority");
                sort.setSortType(SortType.ASCEND);
                wgevi.getSorter().add(sort);
                WarnGroupCollection wgs = warnGroup.getWarnGroupCollection(wgevi);
                if (wgs != null) {
                    int i;
                    int wgCount = wgs.size();
                    for (i = 0; i < wgCount - 1; ++i) {
                        WarnGroupInfo wgInfo = wgs.get(i);
                        StringTokenizer st = new StringTokenizer(egFormula, "$");
                        StringBuffer scriptFormula = new StringBuffer();
                        boolean flag = true;
                        while (st.hasMoreTokens()) {
                            if (flag) {
                                scriptFormula.append(st.nextToken());
                            } else {
                                String token = st.nextToken();
                                if (token.equalsIgnoreCase("CURRENTVALUE")) {
                                    if (kpiValue.equals("")) {
                                        scriptFormula.append(0);
                                    } else {
                                        scriptFormula.append(kpiValue);
                                    }
                                } else {
                                    token = token + wgInfo.getId().toString();
                                    BigDecimal paramValue = (BigDecimal)paramsMap.get(token);
                                    scriptFormula.append(paramValue);
                                }
                            }
                            flag = !flag;
                        }
                        boolean result = (Boolean)ScriptUtil.evalExpr((String)scriptFormula.toString(), null);
                        if (result) break;
                    }
                    if (i < wgCount) {
                        return wgs.get(i).getName();
                    }
                }
            }
            catch (Exception e) {
                this.handUIException(e);
            }
        }
        return null;
    }

    private KPIInfo setStandardValue(KPIInfo kpiInfo, List resultList) {
        KPIInfo newKpiInfo = (KPIInfo)kpiInfo.clone();
        Object obj = null;
        KPIRefStandardValueNewCollection refCols = newKpiInfo.getRefValue();
        if (refCols.size() == resultList.size() - 1) {
            for (int i = 0; i < resultList.size() - 1; ++i) {
                obj = resultList.get(i + 1);
                if (obj instanceof BigDecimal) {
                    refCols.get(i).setCurrentValue(obj);
                    continue;
                }
                if (obj instanceof Integer) {
                    refCols.get(i).setCurrentValue(new BigDecimal((Integer)obj));
                    continue;
                }
                refCols.get(i).setCurrentValue(new BigDecimal(0));
            }
        }
        return newKpiInfo;
    }

    private void calculateWarnParamCurrentValue(KPIInfo newKpiInfo) {
        KPIWarnParamNewCollection warnParamCols = null;
        warnParamCols = newKpiInfo.getWarnParam();
        if (warnParamCols != null) {
            int count = warnParamCols.size();
            String errorDiscript = null;
            for (int i = 0; i < count; ++i) {
                KPIWarnParamNewInfo warnParamInfo;
                KPIWarnParamNewInfo tempWarnParamInfo = warnParamInfo = warnParamCols.get(i);
                String tempParamValue = warnParamInfo.getParamValue();
                if (tempParamValue == null || "".equals(tempParamValue.trim())) {
                    if (newKpiInfo.isIsWarnable()) {
                        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"warnparamSetError"));
                        SysUtil.abort();
                        continue;
                    }
                    tempWarnParamInfo.setParamValue(" ");
                    tempWarnParamInfo.setCurrentValue(null);
                    continue;
                }
                errorDiscript = EASResource.getString((String)RES, (String)"warnparamSetError");
                BigDecimal value = this.execParamValue(newKpiInfo, tempParamValue, errorDiscript);
                tempWarnParamInfo.setParamValue(warnParamInfo.getParamValue());
                tempWarnParamInfo.setCurrentValue(value);
            }
        }
    }

    private BigDecimal execParamValue(KPIInfo newKpiInfo, String paramValue, String errorDiscript) {
        String tempParamValue = paramValue;
        String paramFormulaValue = " " + tempParamValue;
        StringTokenizer st = new StringTokenizer(paramFormulaValue, "$");
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        BigDecimal value = null;
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                KPIRefStandardValueNewCollection cols = newKpiInfo.getRefValue();
                Iterator it = cols.iterator();
                while (it.hasNext()) {
                    KPIRefStandardValueNewInfo refValue = (KPIRefStandardValueNewInfo)it.next();
                    if (!refValue.getRefGroup().getId().toString().equalsIgnoreCase(refGroupId)) continue;
                    value = refValue.getCurrentValue();
                }
                if (value != null) {
                    formula.append(value);
                } else {
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"warnparamSetError"));
                    SysUtil.abort();
                }
            }
            flag = !flag;
        }
        BigDecimal currentValue = null;
        try {
            currentValue = new BigDecimal(ScriptUtil.evalExpr((String)formula.toString(), null).toString());
        }
        catch (Exception e) {
            MsgBox.showInfo((Component)((Object)this), (String)errorDiscript);
            SysUtil.abort();
        }
        return currentValue;
    }

    private void verifyWarnParamValue(KPIInfo newKpiInfo) {
        KPIWarnParamNewCollection warnParamCols = null;
        ArrayList<BigDecimal> paramCurrentValue = new ArrayList<BigDecimal>();
        paramCurrentValue.clear();
        warnParamCols = newKpiInfo.getWarnParam();
        if (warnParamCols == null || warnParamCols.size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"warnparamSetError"));
            SysUtil.abort();
        } else {
            int n = warnParamCols.size();
            for (int i = 0; i < n; ++i) {
                KPIWarnParamNewInfo tempWarnParamInfo = warnParamCols.get(i);
                BigDecimal tempWarnValue = tempWarnParamInfo.getCurrentValue();
                if (tempWarnValue == null) {
                    MsgBox.showInfo((Component)((Object)this), (String)(tempWarnParamInfo.getEdgeParam().getName() + "," + tempWarnParamInfo.getWarnGroup().getName() + EASResource.getString((String)RES, (String)"warnparamSetError")));
                    SysUtil.abort();
                }
                if (tempWarnValue.compareTo(MAXVALUE) >= 0) {
                    MsgBox.showInfo((Component)((Object)this), (String)(tempWarnParamInfo.getEdgeParam().getName() + "," + tempWarnParamInfo.getWarnGroup().getName() + EASResource.getString((String)RES, (String)"warnparamSetError")));
                    SysUtil.abort();
                }
                paramCurrentValue.add(tempWarnParamInfo.getCurrentValue());
            }
            if (!this.checkEdgeParam(newKpiInfo.getCurrentWarnStatus(), paramCurrentValue)) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"warnparamSetError"));
                SysUtil.abort();
            }
        }
    }

    private boolean checkEdgeParam(EdgeGroupInfo edgeInfo, List paramCurrentValue) {
        BigDecimal errorLow;
        BigDecimal warnLow;
        int left = edgeInfo.getFormula().indexOf(">");
        int right = edgeInfo.getFormula().indexOf("<");
        if (left > -1 && right > -1) {
            BigDecimal warnHigh = (BigDecimal)paramCurrentValue.get(0);
            BigDecimal errorHigh = (BigDecimal)paramCurrentValue.get(1);
            BigDecimal warnLow2 = (BigDecimal)paramCurrentValue.get(2);
            BigDecimal errorLow2 = (BigDecimal)paramCurrentValue.get(3);
            if (errorHigh.compareTo(warnHigh) <= 0 || warnHigh.compareTo(warnLow2) <= 0 || warnLow2.compareTo(errorLow2) <= 0) {
                return false;
            }
        } else if (left > -1 && right == -1) {
            BigDecimal warnHigh = (BigDecimal)paramCurrentValue.get(0);
            BigDecimal errorHigh = (BigDecimal)paramCurrentValue.get(1);
            if (errorHigh.compareTo(warnHigh) <= 0) {
                return false;
            }
        } else if (left == -1 && right > -1 && (warnLow = (BigDecimal)paramCurrentValue.get(0)).compareTo(errorLow = (BigDecimal)paramCurrentValue.get(1)) <= 0) {
            return false;
        }
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareactionOK() {
        return true;
    }

    public boolean isPrepareDestroyWindow() {
        return true;
    }

    public RequestContext prepareactionOK(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareactionOK(itemAction);
        request.put("date", (Object)((Date)this.datePoint.getValue()));
        request.put("kpiInfo", this.getUIContext().get("kpiInfo"));
        request.put("company", this.getUIContext().get("company"));
        return request;
    }

    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        super.disposeUIWindow();
        this.date = (Date)this.datePoint.getValue();
        this.doCalculate();
        try {
            this.verifyKPI();
        }
        catch (AbortException e1) {
            this.verifyResult = false;
        }
        Object obj = this.getUIContext().get("timeMap");
        if (null != obj && obj instanceof Map) {
            ((Map)obj).put("selectedTime", this.date);
            ((Map)obj).put("resultList", this.resultList);
            ((Map)obj).put("state", this.state);
            ((Map)obj).put("verifyResult", this.verifyResult);
        }
    }
}

