/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.util.style.Styles;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.sem.mp.KPIFacadeFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewCollection;
import com.kingdee.eas.sem.mp.KPIRefStandardValueNewInfo;
import com.kingdee.eas.sem.mp.KPITimeTypeEnum;
import com.kingdee.eas.sem.mp.client.AbstractKPICalculateResultUI;
import com.kingdee.eas.sem.mp.client.KPICalculateConditionUI;
import com.kingdee.eas.sem.mp.formulaservice.timeservice.KPITimeHandle;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class KPICalculateResultUI
extends AbstractKPICalculateResultUI {
    private static final Logger logger = CoreUIObject.getLogger(KPICalculateResultUI.class);
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    KPIInfo kpiInfo = null;
    KPIInfo newKpiInfo = null;
    KPIRefStandardValueNewCollection cols = null;
    List resultList = null;
    Date date = null;
    String state = "";

    public void onLoad() throws Exception {
        super.onLoad();
        this.loadData();
        this.initTable();
    }

    private void initTable() {
        this.tblResult.checkParsed();
        this.tblResult.removeRows();
        this.tblResult.removeColumns();
        this.addTableColumns();
        this.bindFields();
        this.singleCreateKpi(this.kpiInfo, this.date);
        this.setDisplay();
    }

    private void addTableColumns() {
        this.tblResult.addHeadRow();
        this.tblResult.addColumns(3);
        IRow iRow = null;
        iRow = this.tblResult.getHeadRow(0);
        iRow.getCell(0).setValue((Object)EASResource.getString((String)RES, (String)"year"));
        iRow.getCell(1).setValue((Object)EASResource.getString((String)RES, (String)"real_value"));
        iRow.getCell(2).setValue((Object)EASResource.getString((String)RES, (String)"current_state"));
        if (null != this.cols) {
            Iterator iter = this.cols.iterator();
            while (iter.hasNext()) {
                KPIRefStandardValueNewInfo refInfo = (KPIRefStandardValueNewInfo)iter.next();
                this.tblResult.addColumn();
                iRow.getCell(this.tblResult.getColumnCount() - 1).setValue((Object)refInfo.getRefGroup().getName());
            }
        }
        int cols = this.tblResult.getColumnCount();
        for (int i = 0; i < cols; ++i) {
            this.tblResult.getColumn(i).getStyleAttributes().setLocked(true);
            this.tblResult.getColumn(i).getStyleAttributes().setHorizontalAlign(Styles.HorizontalAlignment.RIGHT);
        }
        this.tblResult.reLayoutAndPaint();
    }

    public void storeFields() {
        super.storeFields();
    }

    private void loadData() {
        this.resultList = (List)this.getUIContext().get("resultList");
        this.state = (String)this.getUIContext().get("state");
        this.date = (Date)this.getUIContext().get("date");
        this.kpiInfo = (KPIInfo)this.getUIContext().get("kpiInfo");
        this.cols = this.kpiInfo.getRefValue();
    }

    private void bindFields() {
        IRow iRow = null;
        if (null != this.kpiInfo) {
            this.lbCode.setText(this.kpiInfo.getNumber());
            this.lbName.setText(this.kpiInfo.getName());
            this.lbUnit.setText(this.kpiInfo.getNumberUnit());
            this.lbFrequency.setText(this.kpiInfo.getTimeType().toString());
            this.lbCalculateTime.setText(this.dateFormat(this.date));
        }
        iRow = this.tblResult.addRow();
        iRow.getCell(0).setValue((Object)this.getTimeText(this.date, this.kpiInfo.getTimeType()));
        if (null != this.resultList && this.resultList.size() > 0) {
            iRow.getCell(1).setValue((Object)KPICalculateResultUI.cutString(this.resultList.get(0), new Integer(this.kpiInfo.getDisplayPrecision())));
            for (int i = 1; i < this.resultList.size(); ++i) {
                iRow.getCell(this.tblResult.getColumnCount() - this.cols.size() + i - 1).setValue((Object)KPICalculateResultUI.cutString(this.resultList.get(i), new Integer(this.kpiInfo.getDisplayPrecision())));
            }
        }
        iRow.getCell(2).setValue((Object)this.state);
    }

    private void setDisplay() {
        StringBuffer formatStr = new StringBuffer();
        int dp = this.kpiInfo.getDisplayPrecision();
        if (dp < 2) {
            dp = 2;
        }
        formatStr.append("0.");
        for (int i = 0; i < dp; ++i) {
            formatStr.append("0");
        }
        for (int j = 1; j < this.tblResult.getColumnCount(); ++j) {
            if (j == 2) continue;
            this.tblResult.getColumn(j).getStyleAttributes().setNumberFormat("%r-{###,###,##" + formatStr.toString() + "}15.2f");
        }
    }

    private String dateFormat(Date date) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        if (date != null) {
            return format.format(date);
        }
        return null;
    }

    private String getTimeText(Date currentDate, KPITimeTypeEnum timeType) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(currentDate);
        return KPITimeHandle.getTimeText(timeType, calendar);
    }

    protected void isOk_actionPerformed(ActionEvent e) throws Exception {
        super.getUIWindow().close();
    }

    protected void isCancel_actionPerformed(ActionEvent e) throws Exception {
        super.getUIWindow().close();
    }

    private static String cutString(Object refValue, Object obj) {
        if (null != refValue && null != refValue) {
            String value = refValue.toString();
            try {
                int length = 0;
                if (null != obj) {
                    length = (Integer)obj;
                }
                if (length == 0) {
                    length = 2;
                }
                if (value.indexOf(".") > -1 && length > 0) {
                    String[] arr = value.split("\\.");
                    if (length <= arr[1].length()) {
                        return arr[0] + "." + arr[1].substring(0, length);
                    }
                    return value;
                }
                return value;
            }
            catch (Exception e) {
                logger.fatal((Object)"error in cutString");
            }
        }
        return null;
    }

    protected void informalCalcualte_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        HashMap timeMap = new HashMap();
        uiContext.put((Object)"timeMap", timeMap);
        uiContext.put((Object)"company", (Object)((OrgUnitInfo)this.getUIContext().get("company")));
        uiContext.put((Object)"kpiInfo", (Object)this.kpiInfo);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(KPICalculateConditionUI.class.getName(), (Map)uiContext, null, OprtState.VIEW);
        uiWindow.show();
        this.date = (Date)timeMap.get("selectedTime");
        if (null != this.date) {
            this.resultList = (List)timeMap.get("resultList");
            this.state = (String)timeMap.get("state");
            this.initTable();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.informalCalcualte.setIcon(EASResource.getIcon((String)"imgTbtn_compute"));
    }

    private boolean singleCreateKpi(KPIInfo kpiInfo, Date date) {
        try {
            KPIFacadeFactory.getRemoteInstance().singleCreateKPI(kpiInfo, date);
        }
        catch (Exception e) {
            this.handUIException(e);
        }
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }
}

