/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.sem.mp.KPICommentCollection;
import com.kingdee.eas.sem.mp.KPICommentFactory;
import com.kingdee.eas.sem.mp.client.AbstractKPICommentListUI;
import com.kingdee.eas.sem.mp.client.KPICommentEditUI;
import java.awt.event.ActionEvent;
import java.util.Map;
import org.apache.log4j.Logger;

public class KPICommentListUI
extends AbstractKPICommentListUI {
    private static final long serialVersionUID = -1738562032883516759L;
    private static final Logger logger = CoreUIObject.getLogger(KPICommentListUI.class);
    private String kpiValueId;
    private KPICommentCollection comments;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.addNew.setEnabled(true);
        Map context = this.getUIContext();
        Object obj = context.get("KPIValueID");
        if (obj != null) {
            String tempValueId;
            this.kpiValueId = tempValueId = obj.toString();
            this.initCommentList(tempValueId);
            this.conctructCommentList(this.comments);
        }
        this.kDEditorPane1.setBackground(this.getBackground());
    }

    public void addNewAction_actionPerformed(ActionEvent e) throws Exception {
        super.addNewAction_actionPerformed(e);
        KPICommentEditUI commentEditUI = this.showEditUI(null);
        if (commentEditUI != null && !commentEditUI.isCanceled()) {
            this.refreshCommentList();
        }
    }

    private void refreshCommentList() {
        this.initCommentList(this.kpiValueId);
        this.conctructCommentList(this.comments);
    }

    private KPICommentEditUI showEditUI(IUIWindow dsUI) {
        UIContext uiContext = new UIContext((Object)this.ui);
        uiContext.put((Object)"Owner", (Object)this.getUIWindow());
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"actionType", (Object)"edit");
        uiContext.put((Object)"KPIValueId", (Object)this.kpiValueId);
        IUIFactory uiFactory = null;
        KPICommentEditUI dsEditUI = null;
        try {
            uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
            dsUI = uiFactory.create("com.kingdee.eas.sem.mp.client.KPICommentEditUI", (Map)uiContext);
            dsUI.show();
            dsEditUI = (KPICommentEditUI)dsUI.getUIObject();
        }
        catch (BOSException ex) {
            this.handleException((Exception)((Object)ex));
        }
        return dsEditUI;
    }

    private void initCommentList(String kpiValueId) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpiValue.id", (Object)kpiValueId));
        ev.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sortInfo);
        try {
            this.comments = KPICommentFactory.getRemoteInstance().getKPICommentCollection(ev);
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
    }

    private void conctructCommentList(KPICommentCollection comments) {
        if (comments != null && comments.size() > 0) {
            StringBuffer initialText = new StringBuffer();
            initialText.append("<table width='100%' height='100%'>");
            boolean mark = true;
            int n = comments.size();
            for (int i = 0; i < n; ++i) {
                if (mark) {
                    initialText.append("<tr bgcolor=\u2018#DFE2C6\u2019><td>").append(i + 1).append("</td><td>&nbsp;&nbsp;&nbsp;&nbsp;<font size=3>").append(comments.get(i).getComment()).append("</font></td></tr>");
                    mark = false;
                    continue;
                }
                initialText.append("<tr><td>").append(i + 1).append("</td><td>&nbsp;&nbsp;&nbsp;&nbsp;<font size=3>").append(comments.get(i).getComment()).append("</font></td></tr>");
                mark = true;
            }
            initialText.append("</table>");
            this.kDEditorPane1.setText(initialText.toString());
        }
    }
}

