/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.AbstractUpdateSchemaInfo;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IUpdateSchema;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPISchemaTypeEnum;
import com.kingdee.eas.sem.mp.UpdateSchemaCompanyRelaCollection;
import com.kingdee.eas.sem.mp.UpdateSchemaCompanyRelaInfo;
import com.kingdee.eas.sem.mp.UpdateSchemaFactory;
import com.kingdee.eas.sem.mp.UpdateSchemaInfo;
import com.kingdee.eas.sem.mp.UpdateSchemaKPIRelaCollection;
import com.kingdee.eas.sem.mp.UpdateSchemaKPIRelaInfo;
import com.kingdee.eas.sem.mp.client.AbstractKPIQueryPanelUI;
import com.kingdee.eas.sem.mp.client.KPIQueryResultUI;
import com.kingdee.eas.sem.mp.client.KPISelectUI;
import com.kingdee.eas.sem.mp.client.LongTimeDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.JFrame;
import org.apache.log4j.Logger;

public class KPIQueryPanelUI
extends AbstractKPIQueryPanelUI {
    private static final Logger logger = CoreUIObject.getLogger(KPIQueryPanelUI.class);
    private static String MenuCreateKpi = "MenuCreateKpi";
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    private boolean selectKPIOK;
    private UpdateSchemaInfo defaultUpdateSchemaInfo = null;
    private boolean isUpdateSolutionAddUIEdit = false;
    private IUpdateSchema iUpdateSchema = UpdateSchemaFactory.getRemoteInstance();
    boolean hasListSelectChange = false;
    private AdminOrgUnitInfo currentAdminOrg = SysContext.getSysContext().getCurrentAdminUnit();
    private String orgID = this.getCurrentOrgId();
    KDWorkButton btnSechDel = new KDWorkButton();
    KDWorkButton btnSechAdd = new KDWorkButton();
    KDWorkButton btnSechSave = new KDWorkButton();
    KDWorkButton btnSechEdit = new KDWorkButton();
    String strSave = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.CaclSolutonUI_Save_cue");
    private Set currentCompanySet = new HashSet();
    private CompanyOrgUnitInfo currentCompanyOrg = SysContext.getSysContext().getCurrentFIUnit();
    private static final String IsChange = "IsChange";
    private static final String IsNew = "IsNew";

    public KPIQueryPanelUI() throws Exception {
        if (this.currentCompanyOrg == null) {
            throw new KPIException(KPIException.NOT_COMPNAYORTUNIT);
        }
    }

    public void initUIContentLayout() {
        this.kpiList.checkParsed();
        this.companyList.checkParsed();
        this.initCtrl();
        super.initUIContentLayout();
        this.kpiList.getColumn(0).getStyleAttributes().setHided(true);
        this.kpiList.getSelectManager().setSelectMode(10);
        this.kpiList.getColumn(1).getStyleAttributes().setLocked(true);
        this.kpiList.getColumn(2).getStyleAttributes().setLocked(true);
        this.companyList.getColumn(1).getStyleAttributes().setLocked(true);
        this.companyList.getColumn(2).getStyleAttributes().setLocked(true);
        this.companyList.getSelectManager().setSelectMode(10);
    }

    public void initCtrl() {
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAdd.setToolTipText(EASResource.getString((String)"add"));
        this.btnAdd.setEnabled(true);
        this.btnDel.setText(null);
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDel.setToolTipText(EASResource.getString((String)"delete"));
        this.btnDel.setEnabled(true);
        this.btnUp.setText(null);
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnUp.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.up"));
        this.btnUp.setEnabled(true);
        this.btnDown.setText(null);
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnDown.setEnabled(true);
        this.btnDown.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.down"));
        this.btnUpCompany.setText(null);
        this.btnUpCompany.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnUpCompany.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.up"));
        this.btnUpCompany.setEnabled(true);
        this.btnDownCompany.setText(null);
        this.btnDownCompany.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnDownCompany.setEnabled(true);
        this.btnDownCompany.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.down"));
        this.btnAddCompany.setEnabled(true);
        this.btnAddCompany.setText(null);
        this.btnAddCompany.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAddCompany.setToolTipText(EASResource.getString((String)RES, (String)"addCompany"));
        this.btnDelCompany.setEnabled(true);
        this.btnDelCompany.setText(null);
        this.btnDelCompany.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDelCompany.setToolTipText(EASResource.getString((String)RES, (String)"delCompany"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listSechChange() {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        try {
            ComponentUtil.setWindowsCursorOfWair((Window)window);
            this.refreshUpdateSchemaView();
        }
        catch (Exception ie) {
            this.handUIException(ie);
        }
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    private String getCurrentOrgId() {
        String orgId = null;
        CompanyOrgUnitInfo adminOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (adminOrg != null) {
            orgId = adminOrg.getId().toString();
        }
        return orgId;
    }

    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        super.actionAdd_actionPerformed(e);
        UIContext uiContext = new UIContext((Object)this);
        ArrayList list = new ArrayList();
        uiContext.put((Object)"Data", list);
        uiContext.put((Object)"KPIAnalysisReportEditUI", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow window = uiFactory.create(KPISelectUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        if (this.isSelectKPIOK() && list != null) {
            UpdateSchemaInfo ui = this.getUpdateSchemaInfo();
            UpdateSchemaKPIRelaCollection uc = ui.getSolutionRela();
            ArrayList<String> oldReportIDs = new ArrayList<String>();
            Iterator it = uc.iterator();
            while (it.hasNext()) {
                UpdateSchemaKPIRelaInfo relaInfo = (UpdateSchemaKPIRelaInfo)it.next();
                if (relaInfo.getKPI().getId() == null || relaInfo.getKPI().getId().toString().length() <= 0) continue;
                oldReportIDs.add(relaInfo.getKPI().getId().toString());
            }
            ArrayList reportDatas = this.filterData(list.toArray(), oldReportIDs);
            if (reportDatas != null && reportDatas.size() > 0) {
                for (int j = 0; j < reportDatas.size(); ++j) {
                    this.addKPITable((KPIInfo)reportDatas.get(j));
                    UpdateSchemaKPIRelaInfo ukr = new UpdateSchemaKPIRelaInfo();
                    ukr.setKPI((KPIInfo)reportDatas.get(j));
                    ukr.setSchema(ui);
                    uc.add(ukr);
                    this.setChange();
                }
            }
        }
    }

    public void actionAddCompany_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo[] tempOrgInfo;
        String orgId = null == SysContext.getSysContext().getCurrentFIUnit() ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(true);
        af7.setRootUnitID(orgId);
        af7.setCheckedOrgIDs(this.currentCompanySet);
        af7.show();
        Object obj = af7.getData();
        if (obj instanceof OrgUnitInfo[] && (tempOrgInfo = (OrgUnitInfo[])obj) != null && tempOrgInfo.length > 0) {
            boolean isAdd = false;
            UpdateSchemaInfo schemaInfo = this.getUpdateSchemaInfo();
            UpdateSchemaCompanyRelaCollection companyRelaCols = schemaInfo.getCompanyRela();
            for (int i = 0; i < tempOrgInfo.length; ++i) {
                IRow tempRow;
                UpdateSchemaCompanyRelaInfo companyInfo;
                isAdd = false;
                OrgUnitInfo tempOuInfo = tempOrgInfo[i];
                String ouId = tempOuInfo.getId().toString();
                int rowCount = this.companyList.getRowCount();
                this.currentCompanySet.add(ouId);
                if (rowCount > 0) {
                    for (int j = 0; j < rowCount; ++j) {
                        String addOuId = this.companyList.getRow(j).getCell("id").getValue().toString();
                        if (!ouId.equals(addOuId)) continue;
                        isAdd = true;
                        break;
                    }
                    if (isAdd) continue;
                    companyInfo = new UpdateSchemaCompanyRelaInfo();
                    companyInfo.setPartFI((CompanyOrgUnitInfo)tempOrgInfo[i]);
                    companyInfo.setSchema(schemaInfo);
                    companyRelaCols.add(companyInfo);
                    tempRow = this.companyList.addRow();
                    tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                    tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                    tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                    tempRow.setUserObject((Object)companyInfo);
                    continue;
                }
                companyInfo = new UpdateSchemaCompanyRelaInfo();
                companyInfo.setPartFI((CompanyOrgUnitInfo)tempOrgInfo[i]);
                companyInfo.setSchema(schemaInfo);
                companyRelaCols.add(companyInfo);
                tempRow = this.companyList.addRow();
                tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                tempRow.setUserObject((Object)companyInfo);
            }
        }
    }

    private void addKPITable(KPIInfo kpiInfo) {
        try {
            IKPI iKPI = KPIFactory.getRemoteInstance();
            SelectorItemCollection sci = new SelectorItemCollection();
            sci.add(new SelectorItemInfo("*"));
            kpiInfo = iKPI.getKPIInfo((IObjectPK)new ObjectUuidPK(kpiInfo.getId()), sci);
            IRow row = this.kpiList.addRow();
            row.getCell(0).setValue((Object)kpiInfo);
            row.getCell(1).setValue((Object)kpiInfo.getNumber());
            row.getCell(2).setValue((Object)kpiInfo.getName());
            row.getCell(3).setValue((Object)kpiInfo.getTimeType());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void addCompanyTable(CompanyOrgUnitInfo companyInfo) {
        try {
            IRow row = this.companyList.addRow();
            row.getCell(0).setValue((Object)companyInfo.getId());
            row.getCell(1).setValue((Object)companyInfo.getNumber());
            row.getCell(2).setValue((Object)companyInfo.getName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private ArrayList filterData(Object[] newReports, ArrayList oldReports) {
        if (newReports == null || newReports.length == 0) {
            return null;
        }
        ArrayList<Object> returnDatas = new ArrayList<Object>();
        int oldReportDatasSize = newReports.length;
        for (int i = 0; i < oldReportDatasSize; ++i) {
            String id;
            if (newReports[i] == null || ((KPIInfo)newReports[i]).getId() == null || oldReports.contains(id = ((KPIInfo)newReports[i]).getId().toString())) continue;
            returnDatas.add(newReports[i]);
        }
        return returnDatas;
    }

    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.kpiList.getSelectManager();
        if (null == this.kpiList.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.plsSelectKPI"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kpiList);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.kpiList.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.kpiList.removeRow(selectRows[i]);
                KPIInfo kpi = (KPIInfo)row.getCell(0).getValue();
                this.deleteKPIFromUpdateSchema(kpi);
            }
        }
    }

    public void actionDelCompany_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.companyList.getSelectManager();
        if (null == this.companyList.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"no_select"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.companyList);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.companyList.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.companyList.removeRow(selectRows[i]);
                String companyId = row.getCell(0).getValue().toString();
                this.deleteCompanyFromUpdateSchema(companyId);
            }
        }
    }

    private void deleteKPIFromUpdateSchema(KPIInfo kpi) {
        if (kpi != null) {
            Iterator it = this.getUpdateSchemaInfo().getSolutionRela().iterator();
            while (it.hasNext()) {
                UpdateSchemaKPIRelaInfo ukpiR = (UpdateSchemaKPIRelaInfo)it.next();
                if (!ukpiR.getKPI().getId().toString().equals(kpi.getId().toString())) continue;
                it.remove();
                this.setChange();
                break;
            }
        }
    }

    private void deleteCompanyFromUpdateSchema(String companyId) {
        if (companyId != null) {
            Iterator it = this.getUpdateSchemaInfo().getCompanyRela().iterator();
            while (it.hasNext()) {
                UpdateSchemaCompanyRelaInfo ukpiR = (UpdateSchemaCompanyRelaInfo)it.next();
                if (!ukpiR.getPartFI().getId().toString().equals(companyId)) continue;
                it.remove();
                this.setChange();
                break;
            }
        }
    }

    private void setChange() {
        this.getUpdateSchemaInfo().put(IsChange, IsChange);
    }

    protected void delSelectLine(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            table.removeRow(selectRpw);
        }
    }

    public void actionDownCompany_actionPerformed(ActionEvent e) throws Exception {
        this.downRow(this.companyList);
    }

    public void actionUpCompany_actionPerformed(ActionEvent e) throws Exception {
        this.upRow(this.companyList);
    }

    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        this.upRow(this.kpiList);
    }

    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        this.downRow(this.kpiList);
    }

    private void upRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > 0) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw - 1, selectRow);
            table.getSelectManager().select(selectRpw - 1, 0);
        }
    }

    private void downRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw >= 0 && selectRpw < table.getRowCount() - 1) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw + 1, selectRow);
            table.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    private void setInfoName(UpdateSchemaInfo info, String name) {
        if (info != null) {
            info.setName(name, new Locale("l1"));
            info.setName(name, new Locale("l2"));
            info.setName(name, new Locale("l3"));
        }
    }

    protected void selfClearUI() {
        this.kpiList.removeRows();
    }

    public UpdateSchemaInfo getUpdateSchemaInfo() {
        return null;
    }

    private String inputName() throws UIException {
        String sUIName = "com.kingdee.eas.sem.mp.client.UpdateSolutionAddUI";
        UIContext uiContext = new UIContext((Object)this);
        Hashtable<String, String> option = new Hashtable<String, String>();
        if (this.isUpdateSolutionAddUIEdit) {
            option.put("name", this.getUpdateSchemaInfo().getName());
        }
        uiContext.put((Object)"option", option);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(sUIName, (Map)uiContext);
        uiWindow.show();
        String action = (String)option.get("action");
        if (action != null && action.equals("CANCEL")) {
            return null;
        }
        String strName = (String)option.get("name");
        if (strName == null || strName.length() == 0) {
            return null;
        }
        return strName.trim();
    }

    public void refreshUpdateSchemaView() {
        UpdateSchemaInfo updateInfo = this.getUpdateSchemaInfo();
        if (updateInfo == null) {
            this.selfClearUI();
            return;
        }
        this.kpiList.removeRows();
        this.companyList.removeRows();
        this.beginPeriod.setValue((Object)updateInfo.getBeginPeriod());
        this.endPeriod.setValue((Object)updateInfo.getEndPeriod());
        if (null != updateInfo.getSchemaType() && updateInfo.getSchemaType().equals((Object)KPISchemaTypeEnum.KPI_CALCULATE)) {
            this.kpiCalculate.setSelected(true);
        } else {
            this.kpiSearch.setSelected(true);
        }
        UpdateSchemaKPIRelaCollection c = updateInfo.getSolutionRela();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            KPIInfo ki = ((UpdateSchemaKPIRelaInfo)it.next()).getKPI();
            if (ki == null) continue;
            this.addKPITable(ki);
        }
        UpdateSchemaCompanyRelaCollection companyCols = updateInfo.getCompanyRela();
        it = companyCols.iterator();
        this.currentCompanySet.clear();
        while (it.hasNext()) {
            CompanyOrgUnitInfo companyInfo = ((UpdateSchemaCompanyRelaInfo)it.next()).getPartFI();
            if (companyInfo != null) {
                this.addCompanyTable(companyInfo);
            }
            this.currentCompanySet.add(companyInfo.getId().toString());
        }
        this.hasListSelectChange = false;
    }

    public AdminOrgUnitInfo getAdminOrgUnitInfo() {
        return this.currentAdminOrg;
    }

    public void setAdminOrgUnitInfo(AdminOrgUnitInfo adminOrgUnitInfo) {
        this.currentAdminOrg = adminOrgUnitInfo;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    public boolean isSelectKPIOK() {
        return this.selectKPIOK;
    }

    public void setSelectKPIOK(boolean selectKPIOK) {
        this.selectKPIOK = selectKPIOK;
    }

    private HashMap getMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            CompanyOrgUnitCollection coms = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("select id");
            map = new HashMap();
            int n = coms.size();
            for (int i = 0; i < n; ++i) {
                map.put(coms.get(i).getId().toString(), new Boolean(false));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }

    protected void beginPeriod_dataChanged(DataChangeEvent e) throws Exception {
        UpdateSchemaInfo updateInfo;
        if (this.hasListSelectChange) {
            return;
        }
        Object beginObj = this.beginPeriod.getValue();
        Object endObj = this.endPeriod.getValue();
        if (beginObj != null && endObj != null) {
            Date bDate = (Date)beginObj;
            Date eDate = (Date)endObj;
            if (this.dateCompare(bDate, eDate) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateBeforeEndDate"));
                this.beginPeriod.setValue(null);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)beginObj);
            int beginYear = calendar.get(1);
            calendar.setTime((Date)endObj);
            int endYear = calendar.get(1);
            if (beginYear != endYear) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"theSameYear"));
                this.beginPeriod.setValue(null);
                return;
            }
        }
        if ((updateInfo = this.getUpdateSchemaInfo()) != null && this.beginPeriod.getValue() != null) {
            updateInfo.setBeginPeriod((Date)this.beginPeriod.getValue());
            this.setChange();
        }
    }

    protected void endPeriod_dataChanged(DataChangeEvent e) throws Exception {
        UpdateSchemaInfo updateInfo;
        if (this.hasListSelectChange) {
            this.hasListSelectChange = false;
            return;
        }
        Object beginObj = this.beginPeriod.getValue();
        Object endObj = this.endPeriod.getValue();
        if (beginObj != null && endObj != null) {
            Date bDate = (Date)beginObj;
            Date eDate = (Date)endObj;
            if (this.dateCompare(bDate, eDate) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"endDateAfterBeginDate"));
                this.endPeriod.setValue(null);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)beginObj);
            int beginYear = calendar.get(1);
            calendar.setTime((Date)endObj);
            int endYear = calendar.get(1);
            if (beginYear != endYear) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"theSameYear"));
                this.endPeriod.setValue(null);
                return;
            }
        }
        if ((updateInfo = this.getUpdateSchemaInfo()) != null && this.endPeriod.getValue() != null) {
            updateInfo.setEndPeriod((Date)this.endPeriod.getValue());
            this.setChange();
        }
    }

    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        UpdateSchemaInfo updateInfo;
        if (!this.verify()) {
            SysUtil.abort();
        }
        if ((updateInfo = this.getUpdateSchemaInfo()).getSchemaType() == KPISchemaTypeEnum.KPI_CALCULATE) {
            this.calculate(updateInfo);
        }
        this.queryKPIValue(updateInfo);
    }

    private void verifyUpdateSchema(UpdateSchemaInfo updateInfo) {
        UpdateSchemaCompanyRelaCollection companyCols = updateInfo.getCompanyRela();
        UpdateSchemaKPIRelaCollection kpiCols = updateInfo.getSolutionRela();
    }

    public boolean verify() {
        if (this.beginPeriod.getValue() == null && this.endPeriod.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"editDate"));
            return false;
        }
        if (this.kpiList.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_kpi"));
            return false;
        }
        if (this.companyList.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_org"));
            return false;
        }
        if (null != this.endPeriod.getValue() && null != this.beginPeriod.getValue() && ((Date)this.endPeriod.getValue()).before((Date)this.beginPeriod.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateBeforeEndDate"));
            return false;
        }
        return true;
    }

    private void calculate(final UpdateSchemaInfo updateInfo) {
        if (updateInfo.getBeginPeriod() == null && updateInfo.getEndPeriod() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"editDate"));
            return;
        }
        if (updateInfo.getSolutionRela().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_kpi"));
            return;
        }
        if (updateInfo.getCompanyRela().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_org"));
            return;
        }
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog(new JFrame()));
        ltd.getText().setText(EASResource.getString((String)RES, (String)"kpi_updating"));
        ltd.setTitle(EASResource.getString((String)RES, (String)"updating"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    UpdateSchemaFactory.getRemoteInstance().createOrUpdateKPI(updateInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"update_complete"));
    }

    private void queryKPIValue(UpdateSchemaInfo updateInfo) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"updateInfo", (Object)updateInfo);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.NEWWIN).create(KPIQueryResultUI.class.getName(), (Map)uiContext, null, OprtState.ADDNEW);
            uiWindow.show();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private int dateCompare(Date bDate, Date eDate) {
        int eDay;
        int eMonth;
        Calendar bCalendar = Calendar.getInstance();
        bCalendar.setTime(bDate);
        Calendar eCalendar = Calendar.getInstance();
        eCalendar.setTime(eDate);
        int bYear = bCalendar.get(1);
        int eYear = eCalendar.get(1);
        if (bYear < eYear) {
            return -1;
        }
        if (bYear > eYear) {
            return 1;
        }
        int bMonth = bCalendar.get(2);
        if (bMonth < (eMonth = eCalendar.get(2))) {
            return -1;
        }
        if (bMonth > eMonth) {
            return 1;
        }
        int bDay = bCalendar.get(5);
        if (bDay < (eDay = eCalendar.get(5))) {
            return -1;
        }
        if (bDay > eDay) {
            return 1;
        }
        return 0;
    }

    protected void kpiCalculate_actionPerformed(ActionEvent e) throws Exception {
        AbstractUpdateSchemaInfo updateInfo = null;
        updateInfo.setSchemaType(KPISchemaTypeEnum.KPI_CALCULATE);
        this.setChange();
    }

    protected void kpiSearch_actionPerformed(ActionEvent e) throws Exception {
        AbstractUpdateSchemaInfo updateInfo = null;
        updateInfo.setSchemaType(KPISchemaTypeEnum.KPI_SEARCH);
        this.setChange();
    }
}

