/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.sem.mp.BSCCollection;
import com.kingdee.eas.sem.mp.BSCFactory;
import com.kingdee.eas.sem.mp.BSCInfo;
import com.kingdee.eas.sem.mp.CSFCollection;
import com.kingdee.eas.sem.mp.CSFFactory;
import com.kingdee.eas.sem.mp.CSFInfo;
import com.kingdee.eas.sem.mp.IBSC;
import com.kingdee.eas.sem.mp.ICSF;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.ExpandVetoException;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class KPITreeBuilder {
    String currentOrgId;

    public KDTree buildTree(KDTree tree) throws Exception {
        if (tree == null) {
            tree = new KDTree(false);
        }
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode(null);
            tree.setRootVisible(false);
        }
        tree.setShowsRootHandles(true);
        this.buildRoot(tree, rootNode, this.getBscRoot());
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.addTreeWillExpandListener(new TreeWillExpandListener(){

            public void treeWillCollapse(TreeExpansionEvent event) throws ExpandVetoException {
            }

            public void treeWillExpand(TreeExpansionEvent event) throws ExpandVetoException {
                KDTree tree = (KDTree)event.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)event.getPath().getLastPathComponent();
                    KPITreeBuilder.this.getChildren(tree, treeNode);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        ((DefaultTreeModel)tree.getModel()).setRoot((TreeNode)rootNode);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                KDTree tree = (KDTree)e.getSource();
                try {
                    KDTreeNode treeNode = (KDTreeNode)e.getPath().getLastPathComponent();
                    KPITreeBuilder.this.getChildren(tree, treeNode);
                }
                catch (Exception exc) {
                    ExceptionHandler.handle((Component)tree, (Throwable)exc);
                }
            }
        });
        return tree;
    }

    private void getChildren(KDTree tree, KDTreeNode treeNode) throws Exception {
        if (treeNode.isVirtual()) {
            treeNode.setVirtual(false);
            tree.removeAllChildrenFromParent((MutableTreeNode)treeNode);
            Object treeNodeInfo = treeNode.getUserObject();
            if (treeNodeInfo != null) {
                if (treeNodeInfo instanceof BSCInfo) {
                    BSCInfo rootBscInfo = (BSCInfo)treeNodeInfo;
                    if (rootBscInfo.getParent() == null) {
                        this.buildBSCChildren(tree, treeNode, this.getBSCCollection((BSCInfo)treeNodeInfo));
                    } else {
                        this.buildCSFChildren(tree, treeNode, this.getCSFCollection((BSCInfo)treeNodeInfo));
                    }
                } else if (treeNodeInfo instanceof CSFInfo) {
                    this.buildKPIChildren(tree, treeNode, this.getKPICollection((CSFInfo)treeNodeInfo));
                } else if (treeNodeInfo instanceof KPIInfo) {
                    // empty if block
                }
            }
        }
    }

    private KPICollection getKPICollection(CSFInfo csfInfo) throws BOSException {
        String currentOrgId = this.getCurrentCompanyOrgId();
        KPICollection kpis = null;
        IKPI kpi = KPIFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("deletedStatus", (Object)new Integer(1)));
        filter.getFilterItems().add(new FilterItemInfo("csf", (Object)csfInfo.getId().toString()));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("kpiValue.*");
        evi.getSelector().add("CSF.id");
        evi.getSelector().add("CSF.name");
        evi.getSelector().add("CSF.BSC");
        evi.getSelector().add("CSF.BSC.name");
        evi.getSelector().add("isWarnable");
        evi.getSelector().add("partfi.id");
        evi.getSelector().add("partfi.name");
        evi.getSelector().add("currentValue");
        evi.getSelector().add("currentWarnStatus.color");
        evi.getSelector().add("refValue.refValue");
        evi.getSelector().add("numberUnit");
        evi.getSelector().add("displayPrecision");
        evi.getSelector().add("formula");
        evi.getSelector().add("isUnpassedVoucherIncluded");
        SorterItemInfo sortItem = new SorterItemInfo("createTime");
        sortItem.setSortType(SortType.ASCEND);
        evi.getSorter().add(sortItem);
        kpis = kpi.getKPICollection(evi);
        return kpis;
    }

    private CSFCollection getCSFCollection(BSCInfo bscInfo) throws BOSException {
        String currentOrgId = this.getCurrentCompanyOrgId();
        CSFCollection csfs = null;
        ICSF csf = CSFFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("BSC.id", (Object)bscInfo.getId().toString()));
        evi.setFilter(filter);
        evi.getSelector().add("id");
        evi.getSelector().add("number");
        evi.getSelector().add("name");
        evi.getSelector().add("BSC");
        csfs = csf.getCSFCollection(evi);
        return csfs;
    }

    private BSCCollection getBSCCollection(BSCInfo bscInfo) throws BOSException {
        IBSC bsc = BSCFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String currentOrgId = this.getCurrentCompanyOrgId();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)bscInfo.getId().toString()));
        view.setFilter(filter);
        return bsc.getBSCCollection(view);
    }

    private void buildRoot(KDTree tree, KDTreeNode parentNode, BSCInfo bscRoot) throws EASBizException, BOSException {
        if (bscRoot == null) {
            return;
        }
        KDTreeNode bscNode = new KDTreeNode((Object)bscRoot);
        bscNode.setUserObject((Object)bscRoot);
        if (this.hasBscChild(bscRoot)) {
            bscNode.setVirtual(true);
            bscNode.add((MutableTreeNode)new DefaultMutableTreeNode());
        } else {
            bscNode.setVirtual(false);
        }
        parentNode.add((MutableTreeNode)bscNode);
    }

    private void buildBSCChildren(KDTree tree, KDTreeNode parentNode, BSCCollection col) throws EASBizException, BOSException {
        KDTreeNode beforeTreeNode = parentNode;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            BSCInfo treeNodeInfo = (BSCInfo)iter.next();
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (this.hasCsfChild(treeNodeInfo)) {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            } else {
                treeNode.setVirtual(false);
            }
            int index = beforeTreeNode.getChildCount();
            tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
        }
    }

    private void buildCSFChildren(KDTree tree, KDTreeNode parentNode, CSFCollection col) throws EASBizException, BOSException {
        KDTreeNode beforeTreeNode = parentNode;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            CSFInfo treeNodeInfo = (CSFInfo)iter.next();
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            if (this.hasKPIChild(treeNodeInfo)) {
                treeNode.setVirtual(true);
                treeNode.add((MutableTreeNode)new DefaultMutableTreeNode());
            } else {
                treeNode.setVirtual(false);
            }
            int index = beforeTreeNode.getChildCount();
            tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
        }
    }

    private void buildKPIChildren(KDTree tree, KDTreeNode parentNode, KPICollection col) {
        KDTreeNode beforeTreeNode = parentNode;
        Iterator iter = col.iterator();
        while (iter.hasNext()) {
            KPIInfo treeNodeInfo = (KPIInfo)iter.next();
            KDTreeNode treeNode = new KDTreeNode((Object)treeNodeInfo);
            treeNode.setVirtual(false);
            int index = beforeTreeNode.getChildCount();
            tree.insertNodeInto((MutableTreeNode)treeNode, (MutableTreeNode)beforeTreeNode, index);
        }
    }

    private String getCurrentCompanyOrgId() {
        CompanyOrgUnitInfo companyOrg;
        if (this.currentOrgId == null && (companyOrg = SysContext.getSysContext().getCurrentFIUnit()) != null) {
            this.currentOrgId = companyOrg.getId().toString();
        }
        return this.currentOrgId;
    }

    private BSCInfo getBscRoot() throws BOSException {
        IBSC bsc = BSCFactory.getRemoteInstance();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String currentOrgId = this.getCurrentCompanyOrgId();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("isref", (Object)new Integer(1)));
        view.setFilter(filter);
        BSCCollection bscCols = bsc.getBSCCollection(view);
        if (bscCols != null && bscCols.size() > 0) {
            return bscCols.get(0);
        }
        return null;
    }

    private boolean hasBscChild(BSCInfo parentBscInfo) throws EASBizException, BOSException {
        String currentOrgId = this.getCurrentCompanyOrgId();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("parent.id", (Object)parentBscInfo.getId().toString()));
        return BSCFactory.getRemoteInstance().exists(filter);
    }

    private boolean hasCsfChild(BSCInfo parentBscInfo) throws EASBizException, BOSException {
        String currentOrgId = this.getCurrentCompanyOrgId();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("BSC.id", (Object)parentBscInfo.getId().toString()));
        return CSFFactory.getRemoteInstance().exists(filter);
    }

    private boolean hasKPIChild(CSFInfo csfInfo) throws EASBizException, BOSException {
        String currentOrgId = this.getCurrentCompanyOrgId();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi", (Object)currentOrgId));
        filter.getFilterItems().add(new FilterItemInfo("csf.id", (Object)csfInfo.getId().toString()));
        return KPIFactory.getRemoteInstance().exists(filter);
    }
}

