/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.KPICollection;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.client.KPITreeF7;
import java.util.ArrayList;
import java.util.Map;

public class KPITreePromptBox {
    protected IUIObject owner = null;
    protected IUIWindow kpiTreeDialog;
    protected boolean isCanceled = false;
    protected String currCompanyId = null;

    public KPITreePromptBox(IUIObject owner) {
        this.owner = owner;
    }

    public void show() {
        UIContext uiContext = new UIContext((Object)this);
        IUIFactory uiFactory = null;
        uiContext.put((Object)"Owner", (Object)this.owner);
        uiContext.put((Object)"ID", null);
        uiContext.put((Object)"currCompanyId", (Object)this.getCurrCompanyId());
        try {
            uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
            this.kpiTreeDialog = uiFactory.create("com.kingdee.eas.sem.mp.client.KPITreeF7", (Map)uiContext, null, OprtState.VIEW);
            this.kpiTreeDialog.show();
        }
        catch (BOSException ex) {
            ex.printStackTrace();
        }
    }

    public boolean isCanceled() {
        if (this.kpiTreeDialog == null) {
            return this.isCanceled;
        }
        KPITreeF7 rptReportUI = (KPITreeF7)this.kpiTreeDialog.getUIObject();
        if (rptReportUI != null) {
            this.isCanceled = rptReportUI.isCanceled();
        }
        return this.isCanceled;
    }

    public Object getData() {
        if (this.kpiTreeDialog == null) {
            return null;
        }
        try {
            KPITreeF7 kpiListUI = (KPITreeF7)this.kpiTreeDialog.getUIObject();
            ArrayList selectDatas = kpiListUI.getData();
            if (selectDatas == null || selectDatas.size() == 0) {
                return null;
            }
            int selectDatasSize = selectDatas.size();
            StringBuffer ids = new StringBuffer();
            for (int i = 0; i < selectDatasSize; ++i) {
                if (i == 0) {
                    ids.append(selectDatas.get(i).toString());
                    continue;
                }
                ids.append("," + selectDatas.get(i).toString());
            }
            IKPI iKpi = KPIFactory.getRemoteInstance();
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("*"));
            sic.add(new SelectorItemInfo("CSF.*"));
            sic.add(new SelectorItemInfo("measureUnit.*"));
            sic.add(new SelectorItemInfo("currentWarnStatus.*"));
            sic.add(new SelectorItemInfo("refValues.*"));
            sic.add(new SelectorItemInfo("company.*"));
            sic.add(new SelectorItemInfo("parent.*"));
            FilterInfo filter = new FilterInfo();
            FilterItemInfo filterItem = new FilterItemInfo("id", (Object)ids.toString(), CompareType.INCLUDE);
            filter.getFilterItems().add(filterItem);
            view.setFilter(filter);
            KPICollection reportCollection = iKpi.getKPICollection(view);
            return reportCollection.toArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getCurrCompanyId() {
        return this.currCompanyId;
    }

    public void setCurrCompanyId(String string) {
        this.currCompanyId = string;
    }

    public void setOwner(IUIObject object) {
        this.owner = object;
    }
}

