/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.extendcontrols.KDBizPromptBox;
import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTDefaultCellEditor;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.editor.ICellEditor;
import com.kingdee.bos.ctrl.swing.IKDEditor;
import com.kingdee.bos.ctrl.swing.KDPromptSelector;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.EdgeGroupInfo;
import com.kingdee.eas.sem.mp.EdgeParamFactory;
import com.kingdee.eas.sem.mp.EdgeParamInfo;
import com.kingdee.eas.sem.mp.IEdgeParam;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIRefValue;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIRefValueCollection;
import com.kingdee.eas.sem.mp.KPIRefValueFactory;
import com.kingdee.eas.sem.mp.KPIRefValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.KPIWarnShcemaFactory;
import com.kingdee.eas.sem.mp.KPIWarnShcemaInfo;
import com.kingdee.eas.sem.mp.MPException;
import com.kingdee.eas.sem.mp.RefGroupCollection;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.client.AbstractKPIWarnSchemaEditUI;
import com.kingdee.eas.sem.mp.client.EdgeParamFormulaPicker;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.ScriptUtil;
import com.kingdee.util.StringUtils;
import java.awt.event.ActionEvent;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

public class KPIWarnSchemaEditUI
extends AbstractKPIWarnSchemaEditUI {
    private boolean isEdgeGroupChanged = false;
    private boolean isInitParamsGotten = false;
    private KPIWarnParamCollection warnParamCol = new KPIWarnParamCollection();
    private boolean isInitKPIGotten = false;
    private KPIInfo kpiOld;
    private boolean isInitEdgeGroupGotten = false;
    private EdgeGroupInfo edgeGroupOld;
    private HashMap refGroupIdToName;
    private HashMap refGroupNameToId;

    public void loadFields() {
        String orgId;
        this.restoreInitValue();
        this.kdtEdgeParamValues.checkParsed();
        super.loadFields();
        if (this.editData != null && this.editData.getKpi() != null && this.editData.getKpi().getCompany() != null) {
            this.txtOrgId.setText(this.editData.getKpi().getCompany().getId().toString());
        }
        if (this.getOprtState().equalsIgnoreCase("ADDNEW") && (orgId = (String)this.getUIContext().get("company")) != null && orgId.length() > 0) {
            try {
                IAdminOrgUnit org = AdminOrgUnitFactory.getRemoteInstance();
                AdminOrgUnitInfo orgInfo = org.getAdminOrgUnitInfo((IObjectPK)new ObjectUuidPK(orgId));
                this.kdtCompany.setText(orgInfo.getName());
                this.txtOrgId.setText(orgInfo.getId().toString());
            }
            catch (BOSException e) {
                this.handleException((Exception)((Object)e));
            }
            catch (EASBizException e) {
                this.handleException((Exception)((Object)e));
            }
        }
        if (!this.oprtState.equals("ADDNEW")) {
            this.dataBinder.bindDataToTable(this.kdtEdgeParamValues, (IObjectCollection)this.editData.getEdgeParamValues());
        }
        try {
            this.initRefGroupIdToName();
            int count = this.kdtEdgeParamValues.getRowCount();
            for (int i = 0; i < count; ++i) {
                IRow row = this.kdtEdgeParamValues.getRow(i);
                String idFormula = (String)row.getCell("paramValue").getValue();
                String nameFormula = this.convertIdToName(idFormula).toString();
                row.getCell("paramValue").setValue((Object)nameFormula);
            }
        }
        catch (BOSException e) {
            this.handleException((Exception)((Object)e));
        }
        if (!this.isInitParamsGotten) {
            KPIWarnParamCollection warnParams = this.editData.getEdgeParamValues();
            if (warnParams != null) {
                int paramCount = warnParams.size();
                for (int i = 0; i < paramCount; ++i) {
                    this.warnParamCol.add(warnParams.get(i));
                }
            }
            this.isInitParamsGotten = true;
        }
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String txtOrgIdText = this.txtOrgId.getText();
        String existIDs = (String)this.getUIContext().get("existIDs");
        if (txtOrgIdText != null && txtOrgIdText.length() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("company.id", (Object)txtOrgIdText));
            if (existIDs.length() > 0) {
                filter.getFilterItems().add(new FilterItemInfo("id", (Object)existIDs, CompareType.NOTINCLUDE));
            }
            evi.setFilter(filter);
            this.bizPromptKpi.setEntityViewInfo(evi);
        }
        try {
            if (this.editData != null && this.editData.getKpi() != null) {
                if (this.editData == null) {
                    return;
                }
                IKPI kpi = KPIFactory.getRemoteInstance();
                SelectorItemCollection selector = new SelectorItemCollection();
                selector.add("createTime");
                KPIInfo kpiInfo = kpi.getKPIInfo((IObjectPK)new ObjectUuidPK(this.editData.getKpi().getId()), selector);
                if (kpiInfo.getCreateTime() != null) {
                    this.txtCreateTime.setText(kpiInfo.getCreateTime().toString());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.kdtEdgeParamValues.getColumn("paramValue").getStyleAttributes().setNumberFormat("%r-{#,##0.00}15.2f");
        this.chkIsModifiable.setEnabled(false);
        this.bizPromptEdgeGroup.setHasCUDefaultFilter(false);
        this.bizPromptKpi.setHasCUDefaultFilter(false);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        BigDecimal errorHigh;
        if (this.bizPromptKpi.getData() == null || StringUtils.isEmpty((String)this.bizPromptKpi.getData().toString())) {
            this.bizPromptKpi.setRequestFocusEnabled(true);
            this.bizPromptKpi.requestFocusInWindow();
            throw new MPException(MPException.KPIBLANKEXCEPTION);
        }
        if (this.bizPromptEdgeGroup.getData() == null || StringUtils.isEmpty((String)this.bizPromptEdgeGroup.getData().toString())) {
            this.bizPromptEdgeGroup.setRequestFocusEnabled(true);
            this.bizPromptEdgeGroup.requestFocusInWindow();
            throw new MPException(MPException.EDGEGROUPBLANKEXCEPTION);
        }
        KPIWarnParamCollection params = this.editData.getEdgeParamValues();
        ArrayList<BigDecimal> paramCurrentValue = new ArrayList<BigDecimal>();
        int count = params.size();
        for (int i = 0; i < count; ++i) {
            KPIWarnParamInfo paramInfo = params.get(i);
            if (paramInfo.getParamValue() == null || paramInfo.getParamValue().length() == 0 || paramInfo.getParamValue().trim().equalsIgnoreCase("null")) {
                throw new MPException(MPException.WARNSCHEMAPARAMISNULL);
            }
            try {
                BigDecimal value = this.execParamValue(paramInfo.getParamValue());
                paramCurrentValue.add(value);
                continue;
            }
            catch (Exception me) {
                throw new MPException(MPException.WARNSCHEMAPARAMERROR);
            }
        }
        int left = this.editData.getEdgeGroup().getFormula().indexOf(">");
        int right = this.editData.getEdgeGroup().getFormula().indexOf("<");
        if (left > -1 && right > -1) {
            errorHigh = (BigDecimal)paramCurrentValue.get(0);
            BigDecimal errorLow = (BigDecimal)paramCurrentValue.get(1);
            BigDecimal warnHigh = (BigDecimal)paramCurrentValue.get(2);
            BigDecimal warnLow = (BigDecimal)paramCurrentValue.get(3);
            if (errorHigh.compareTo(warnHigh) <= 0 || warnHigh.compareTo(warnLow) <= 0 || warnLow.compareTo(errorLow) <= 0) {
                this.loadFields();
                throw new MPException(MPException.WARNSCHEMAPARAMERROR);
            }
        } else if (left > -1 && right == -1) {
            BigDecimal warnHigh;
            errorHigh = (BigDecimal)paramCurrentValue.get(0);
            if (errorHigh.compareTo(warnHigh = (BigDecimal)paramCurrentValue.get(1)) <= 0) {
                this.loadFields();
                throw new MPException(MPException.WARNSCHEMAPARAMERROR);
            }
        } else if (left == -1 && right > -1) {
            BigDecimal errorLow = (BigDecimal)paramCurrentValue.get(0);
            BigDecimal warnLow = (BigDecimal)paramCurrentValue.get(1);
            if (warnLow.compareTo(errorLow) <= 0) {
                this.loadFields();
                throw new MPException(MPException.WARNSCHEMAPARAMERROR);
            }
        }
    }

    private BigDecimal execParamValue(String paramValue) throws BOSException, MPException {
        KPIInfo kpiInfo = this.editData.getKpi();
        String paramFormulaValue = " " + paramValue;
        StringTokenizer st = new StringTokenizer(paramFormulaValue, "$");
        IKPIRefValue kpiRefValue = KPIRefValueFactory.getRemoteInstance();
        StringBuffer formula = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formula.append(st.nextToken());
            } else {
                String refGroupId = st.nextToken();
                EntityViewInfo evi = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("KPI", (Object)kpiInfo.getId().toString()));
                filter.getFilterItems().add(new FilterItemInfo("refGroup", (Object)refGroupId));
                evi.setFilter(filter);
                KPIRefValueCollection kpiRefValueInfos = kpiRefValue.getKPIRefValueCollection(evi);
                KPIRefValueInfo kpiRefValueInfo = kpiRefValueInfos.get(0);
                if (kpiRefValueInfo == null) {
                    throw new MPException(MPException.WARNSCHEMAPARAMERROR);
                }
                BigDecimal value = kpiRefValueInfo.getRefValue();
                formula.append(value);
            }
            flag = !flag;
        }
        BigDecimal currentValue = new BigDecimal(ScriptUtil.evalExpr((String)formula.toString(), null).toString());
        return currentValue;
    }

    private void initRefGroupIdToName() throws BOSException {
        this.refGroupIdToName = new HashMap();
        this.refGroupNameToId = new HashMap();
        IRefGroup refGroup = RefGroupFactory.getRemoteInstance();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("company", (Object)this.txtOrgId.getText()));
        evi.setFilter(filter);
        RefGroupCollection refGroupInfos = refGroup.getRefGroupCollection(evi);
        int count = refGroupInfos.size();
        for (int i = 0; i < count; ++i) {
            RefGroupInfo refGroupInfo = refGroupInfos.get(i);
            this.refGroupIdToName.put(refGroupInfo.getId().toString(), refGroupInfo.getName());
            this.refGroupNameToId.put(refGroupInfo.getName(), refGroupInfo.getId().toString());
        }
    }

    public void storeFields() {
        int count = this.kdtEdgeParamValues.getRowCount();
        for (int i = 0; i < count; ++i) {
            IRow row = this.kdtEdgeParamValues.getRow(i);
            String nameFormula = (String)row.getCell("paramValue").getValue();
            String idFormula = this.convertNameToId(nameFormula).toString();
            if (null == idFormula || idFormula.length() <= 0 || idFormula.equalsIgnoreCase("null")) continue;
            row.getCell("paramValue").setValue((Object)idFormula);
        }
        super.storeFields();
    }

    protected IObjectValue createNewData() {
        KPIWarnShcemaInfo kpiWarnInfo = new KPIWarnShcemaInfo();
        return kpiWarnInfo;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return KPIWarnShcemaFactory.getRemoteInstance();
    }

    protected void bizPromptKpi_dataChanged(DataChangeEvent e) throws Exception {
        super.bizPromptKpi_dataChanged(e);
        Object obj = e.getNewValue();
        if (!(obj instanceof KPIInfo)) {
            return;
        }
        KPIInfo kpiInfo = (KPIInfo)obj;
        if (!this.isInitKPIGotten) {
            if (this.editData != null) {
                this.kpiOld = this.editData.getKpi();
            }
            this.isInitKPIGotten = true;
        }
        if (this.kpiOld != null && this.kpiOld.equals(kpiInfo)) {
            return;
        }
        this.editData.setKpi(kpiInfo);
        this.kpiOld = kpiInfo;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)kpiInfo.getId().toString()));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.KPIQuery"));
        exec.setObjectView(evi);
        IRowSet rowset = exec.executeQuery();
        if (rowset.next()) {
            this.kdtCompany.setText(rowset.getString("company.name"));
            this.kdtBSC.setText(rowset.getString("BSC.name"));
            this.kdtCSF.setText(rowset.getString("CSF.name"));
            this.kdtCreator.setText(rowset.getString("creator.name"));
            this.txtCreateTime.setText(rowset.getTimestamp("createTime").toString());
            this.chkIsModifiable.setSelected(rowset.getBoolean("isModifiable"));
        }
    }

    protected void bizPromptEdgeGroup_dataChanged(DataChangeEvent e) throws Exception {
        KPIWarnParamCollection params;
        super.bizPromptEdgeGroup_dataChanged(e);
        Object obj = e.getNewValue();
        if (!(obj instanceof EdgeGroupInfo)) {
            return;
        }
        EdgeGroupInfo edgeGroupInfo = (EdgeGroupInfo)obj;
        if (!this.isInitEdgeGroupGotten) {
            if (this.editData != null) {
                this.edgeGroupOld = this.editData.getEdgeGroup();
            }
            this.isInitEdgeGroupGotten = true;
        }
        if (this.edgeGroupOld != null && this.edgeGroupOld.equals(edgeGroupInfo)) {
            this.kdtEdgeParamValues.checkParsed();
            return;
        }
        if (!this.isEdgeGroupChanged) {
            this.isEdgeGroupChanged = true;
        }
        if ((params = this.editData.getEdgeParamValues()) != null) {
            params.clear();
        }
        this.edgeGroupOld = edgeGroupInfo;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        evi.setFilter(filter);
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)edgeGroupInfo.getId().toString()));
        IQueryExecutor exec = QueryExecutorFactory.getRemoteInstance((IMetaDataPK)new MetaDataPK("com.kingdee.eas.sem.mp.app.EdgeGroupParamQuery"));
        exec.setObjectView(evi);
        IRowSet rsParam = exec.executeQuery();
        IWarnGroup warnGroup = WarnGroupFactory.getRemoteInstance();
        WarnGroupCollection warnGroupCol = warnGroup.getWarnGroupCollection();
        WarnGroupInfo wgInfo = null;
        int warnCount = warnGroupCol.size();
        for (int i = 0; i < warnCount; ++i) {
            wgInfo = warnGroupCol.get(i);
            if (wgInfo.getPeriority() != 2) continue;
            warnGroupCol.remove(wgInfo);
            break;
        }
        IEdgeParam edgeParma = EdgeParamFactory.getRemoteInstance();
        for (int i = 0; i < warnGroupCol.size(); ++i) {
            rsParam.beforeFirst();
            while (rsParam.next()) {
                EdgeParamInfo edgeParamInfo = edgeParma.getEdgeParamInfo((IObjectPK)new ObjectUuidPK(rsParam.getString("edgeParam.id")));
                KPIWarnParamInfo warnParam = new KPIWarnParamInfo();
                warnParam.setEdgeParam(edgeParamInfo);
                warnParam.setWarnGroup(warnGroupCol.get(i));
                warnParam.setWarnSchema(this.editData);
                this.editData.getEdgeParamValues().add(warnParam);
            }
        }
        this.dataBinder.bindDataToTable(this.kdtEdgeParamValues, (IObjectCollection)this.editData.getEdgeParamValues());
    }

    protected void showSubmitSuccess() {
        this.restoreInitValue();
        super.showSubmitSuccess();
    }

    private void restoreInitValue() {
        this.isEdgeGroupChanged = false;
        this.isInitEdgeGroupGotten = false;
        this.isInitKPIGotten = false;
        this.isInitParamsGotten = false;
        this.edgeGroupOld = null;
        this.kpiOld = null;
        this.warnParamCol.clear();
    }

    protected void kdtEdgeParamValues_tableSelectChanged(KDTSelectEvent e) throws Exception {
        if (this.editData.getKpi() == null) {
            MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.SELECTKPIFIRSTINEDITWARNSCHEMA"));
            SysUtil.abort();
        }
        KDTSelectBlock blockSelected = e.getSelectBlock();
        int paramValueColumn = this.kdtEdgeParamValues.getColumnIndex("paramValue");
        int col = blockSelected.getBeginCol();
        int row = blockSelected.getEndRow();
        if (col != paramValueColumn) {
            return;
        }
        IRow selectRow = this.kdtEdgeParamValues.getRow(row);
        String title = selectRow.getCell("warnGroup").getValue().toString() + selectRow.getCell("edgeParam").getValue().toString();
        ICell cell = this.kdtEdgeParamValues.getCell(row, col);
        Object obj = cell.getValue();
        KDBizPromptBox bizBox = new KDBizPromptBox();
        bizBox.setEditable(true);
        EdgeParamFormulaPicker promptSelector = new EdgeParamFormulaPicker();
        promptSelector.setOwnerWin(this.getUIWindow());
        promptSelector.setKPI(this.editData.getKpi());
        promptSelector.setParamTitle(title);
        String initFormulaString = "";
        if (obj != null) {
            initFormulaString = obj.toString();
        }
        promptSelector.setInitFormula(initFormulaString);
        bizBox.setSelector((KDPromptSelector)promptSelector);
        cell.setEditor((ICellEditor)new KDTDefaultCellEditor((IKDEditor)bizBox));
    }

    private StringBuffer convertIdToName(String initFormula) {
        StringTokenizer st = new StringTokenizer(" " + initFormula, "$");
        StringBuffer formulaBuffer = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formulaBuffer.append(st.nextToken());
            } else {
                formulaBuffer.append("$");
                formulaBuffer.append(this.refGroupIdToName.get(st.nextToken()));
                formulaBuffer.append("$");
            }
            flag = !flag;
        }
        formulaBuffer = formulaBuffer.deleteCharAt(0);
        return formulaBuffer;
    }

    private StringBuffer convertNameToId(String nameFormula) {
        StringTokenizer st = new StringTokenizer(" " + nameFormula, "$");
        StringBuffer formulaBuffer = new StringBuffer();
        boolean flag = true;
        while (st.hasMoreTokens()) {
            if (flag) {
                formulaBuffer.append(st.nextToken());
            } else {
                formulaBuffer.append("$");
                formulaBuffer.append(this.refGroupNameToId.get(st.nextToken()));
                formulaBuffer.append("$");
            }
            flag = !flag;
        }
        formulaBuffer = formulaBuffer.deleteCharAt(0);
        return formulaBuffer;
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("kpi.*"));
        sic.add(new SelectorItemInfo("edgeGroup.*"));
        sic.add(new SelectorItemInfo("kpi.CSF.BSC.name"));
        sic.add(new SelectorItemInfo("kpi.company.name"));
        sic.add(new SelectorItemInfo("kpi.CSF.name"));
        sic.add(new SelectorItemInfo("isModifiable"));
        sic.add(new SelectorItemInfo("kpi.creator.name"));
        sic.add(new SelectorItemInfo("edgeParamValues.id"));
        sic.add(new SelectorItemInfo("edgeParamValues.paramValue"));
        sic.add(new SelectorItemInfo("edgeParamValues.warnGroup.name"));
        sic.add(new SelectorItemInfo("edgeParamValues.edgeParam.name"));
        sic.add(new SelectorItemInfo("edgeParamValues.*"));
        sic.add(new SelectorItemInfo("edgeParamValues.number"));
        return sic;
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }
}

