/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.swing.dial.KpiRange;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.IKPI;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;

public class KpiDialInfo {
    private KpiRange total;
    private KpiRange warning;
    private KpiRange normal;
    private KpiRange critical;
    private KPIInfo kpiInfo;
    private KPIValueInfo curKpiValueInfo;
    private KPIValueCollection valueCols = null;
    private boolean isDoubleEdge;

    public KpiDialInfo(KPIInfo kpiInfo, KPIValueCollection kpiValueCols, KPIValueInfo kpiValueInfo, boolean isCalc) throws EASBizException, BOSException {
        KPIWarnParamCollection params;
        if (kpiValueInfo == null) {
            if (kpiValueCols == null || kpiValueCols.size() <= 0) {
                return;
            }
            kpiValueInfo = kpiValueCols.get(0);
        }
        boolean isShow = false;
        this.isDoubleEdge = true;
        this.kpiInfo = kpiInfo;
        this.curKpiValueInfo = kpiValueInfo;
        this.valueCols = kpiValueCols;
        double kpiValue = kpiValueInfo.getKpiValue() == null ? 0.0 : kpiValueInfo.getKpiValue().doubleValue();
        boolean isPercent = kpiInfo.isIsPercent();
        if (isPercent) {
            kpiValue *= 100.0;
        }
        if ((params = kpiValueInfo.getWarnparam()) != null && params.size() > 0 && params != null) {
            int count = params.size();
            if (count == 2) {
                double paramLowValue;
                this.isDoubleEdge = false;
                KPIWarnParamInfo paramHigh = params.get(0);
                KPIWarnParamInfo paramLow = params.get(1);
                if (paramHigh.getWarnGroup().getPeriority() > paramLow.getWarnGroup().getPeriority()) {
                    KPIWarnParamInfo temp = paramHigh;
                    paramHigh = paramLow;
                    paramLow = temp;
                }
                double paramHighValue = paramHigh.getCurrentValue() == null ? 0.0 : paramHigh.getCurrentValue().doubleValue();
                double d = paramLowValue = paramLow.getCurrentValue() == null ? 0.0 : paramLow.getCurrentValue().doubleValue();
                if (isPercent) {
                    paramHighValue *= 100.0;
                    paramLowValue *= 100.0;
                }
                if (paramHighValue > paramLowValue) {
                    double high = paramHighValue + (paramHighValue - paramLowValue);
                    double low = paramLowValue - (paramHighValue - paramLowValue);
                    if (kpiValue > high) {
                        high = kpiValue;
                    } else if (kpiValue < low) {
                        low = kpiValue;
                    }
                    this.total = new KpiRange(low, high);
                    this.normal = new KpiRange(low, paramLowValue);
                    this.warning = new KpiRange(paramLowValue, paramHighValue);
                    this.critical = new KpiRange(paramHighValue, high);
                } else {
                    double high = paramHighValue - (paramLowValue - paramHighValue);
                    double low = paramLowValue + (paramLowValue - paramHighValue);
                    if (kpiValue > low) {
                        low = kpiValue;
                    } else if (kpiValue < high) {
                        high = kpiValue;
                    }
                    this.total = new KpiRange(high, low);
                    this.normal = new KpiRange(paramLowValue, low);
                    this.warning = new KpiRange(paramHighValue, paramLowValue);
                    this.critical = new KpiRange(high, paramHighValue);
                }
                isShow = true;
            } else if (count == 4) {
                int i;
                this.isDoubleEdge = false;
                double[] paramValue = new double[4];
                for (i = 0; i < count; ++i) {
                    KPIWarnParamInfo param = params.get(i);
                    paramValue[i] = param.getCurrentValue().doubleValue();
                    if (!isPercent) continue;
                    paramValue[i] = paramValue[i] * 100.0;
                }
                for (i = 0; i < count - 1; ++i) {
                    int min = i;
                    for (int j = i + 1; j < count; ++j) {
                        if (!(paramValue[j] < paramValue[min])) continue;
                        min = j;
                    }
                    if (min == i) continue;
                    double swap = paramValue[i];
                    paramValue[i] = paramValue[min];
                    paramValue[min] = swap;
                }
                double middle = (paramValue[1] + paramValue[2]) / 2.0;
                double lack = middle - paramValue[1];
                if (kpiValue < middle) {
                    double minimum = paramValue[0] - lack;
                    if (minimum > kpiValue) {
                        minimum = kpiValue;
                    }
                    this.total = new KpiRange(minimum, middle);
                    this.critical = new KpiRange(minimum, paramValue[0]);
                    this.warning = new KpiRange(paramValue[0], paramValue[1]);
                    this.normal = new KpiRange(paramValue[1], middle);
                } else {
                    double maxmum = paramValue[3] + lack;
                    if (kpiValue > maxmum) {
                        maxmum = kpiValue;
                    }
                    this.total = new KpiRange(middle, maxmum);
                    this.normal = new KpiRange(middle, paramValue[2]);
                    this.warning = new KpiRange(paramValue[2], paramValue[3]);
                    this.critical = new KpiRange(paramValue[3], maxmum);
                }
                isShow = true;
            } else if (kpiValueInfo.getWarnparam() != null) {
                int periority = 0;
                if (periority == 0) {
                    if (kpiValue == 0.0) {
                        this.total = new KpiRange(-5.0, 1.0);
                        this.warning = new KpiRange(-5.0, -3.0);
                        this.normal = new KpiRange(-3.0, -1.0);
                        this.critical = new KpiRange(-1.0, 1.0);
                    } else {
                        this.total = new KpiRange(0.0, kpiValue * 6.0 / 5.0);
                        this.warning = new KpiRange(0.0, kpiValue * 2.0 / 5.0);
                        this.normal = new KpiRange(kpiValue * 2.0 / 5.0, kpiValue * 4.0 / 5.0);
                        this.critical = new KpiRange(kpiValue * 4.0 / 5.0, kpiValue * 6.0 / 5.0);
                    }
                    isShow = true;
                } else if (periority == 1) {
                    if (kpiValue == 0.0) {
                        this.total = new KpiRange(-1.0, 5.0);
                        this.warning = new KpiRange(-1.0, 1.0);
                        this.normal = new KpiRange(1.0, 3.0);
                        this.critical = new KpiRange(3.0, 5.0);
                    } else {
                        this.total = new KpiRange(0.0, kpiValue * 6.0);
                        this.warning = new KpiRange(0.0, kpiValue * 2.0);
                        this.normal = new KpiRange(kpiValue * 2.0, kpiValue * 4.0);
                        this.critical = new KpiRange(kpiValue * 4.0, kpiValue * 6.0);
                    }
                    isShow = true;
                } else if (periority == 2) {
                    if (kpiValue == 0.0) {
                        this.total = new KpiRange(-3.0, 3.0);
                        this.warning = new KpiRange(-3.0, -1.0);
                        this.normal = new KpiRange(-1.0, 1.0);
                        this.critical = new KpiRange(1.0, 3.0);
                    } else {
                        this.total = new KpiRange(0.0, kpiValue * 2.0);
                        this.normal = new KpiRange(kpiValue * 2.0 / 3.0, kpiValue * 4.0 / 3.0);
                        this.warning = new KpiRange(0.0, kpiValue * 2.0 / 3.0);
                        this.critical = new KpiRange(kpiValue * 4.0 / 3.0, kpiValue * 2.0);
                    }
                    isShow = true;
                }
            }
        }
        if (!isShow) {
            if (kpiValue == 0.0) {
                kpiValue = 5.0;
            }
            this.total = new KpiRange(0.0, kpiValue * 2.0);
            this.normal = new KpiRange(0.0, kpiValue * 2.0);
            this.warning = new KpiRange(0.0, 0.0);
            this.critical = new KpiRange(0.0, 0.0);
            isShow = true;
        }
    }

    private static KPIValueInfo getLastKPIValueInfo(String kpiId) throws BOSException, EASBizException {
        IKPIValue kpiValue = KPIValueFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("timeText");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        KPIValueCollection cols = kpiValue.getKPIValueCollection(ev);
        if (cols != null && cols.size() > 0) {
            return cols.get(0);
        }
        return null;
    }

    private static KPIValueCollection getKpiValueCollection(String kpiId) throws BOSException, EASBizException {
        IKPIValue kpiValue = KPIValueFactory.getRemoteInstance();
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        FilterInfo filter = ev.getFilter();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
        ev.setFilter(filter);
        SorterItemInfo sorterInfo = new SorterItemInfo("timeText");
        sorterInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sorterInfo);
        return kpiValue.getKPIValueCollection(ev);
    }

    private static KPIValueInfo getKpiValueInfo(String kpiValueId) throws BOSException, EASBizException {
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add("*");
        selector.add("warnparam.*");
        selector.add("warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        return KPIValueFactory.getRemoteInstance().getKPIValueInfo((IObjectPK)new ObjectUuidPK(kpiValueId), selector);
    }

    private static KPIInfo getKPIInfo(String kpiId) throws BOSException, EASBizException {
        IKPI kpi = KPIFactory.getRemoteInstance();
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("*");
        selector.add("kpiValue.*");
        selector.add("kpiValue.warnparam.*");
        selector.add("kpiValue.warnparam.warnGroup.*");
        selector.add("currentWarnStatus.*");
        return kpi.getKPIInfo((IObjectPK)new ObjectUuidPK(kpiId), selector);
    }

    public KpiRange getCritical() {
        return this.critical;
    }

    public void setCritical(KpiRange critical) {
        this.critical = critical;
    }

    public boolean isDoubleEdge() {
        return this.isDoubleEdge;
    }

    public void setDoubleEdge(boolean isDoubleEdge) {
        this.isDoubleEdge = isDoubleEdge;
    }

    public KpiRange getNormal() {
        return this.normal;
    }

    public void setNormal(KpiRange normal) {
        this.normal = normal;
    }

    public KpiRange getTotal() {
        return this.total;
    }

    public void setTotal(KpiRange total) {
        this.total = total;
    }

    public KpiRange getWarning() {
        return this.warning;
    }

    public void setWarning(KpiRange warning) {
        this.warning = warning;
    }

    public KPIInfo getKpiInfo() {
        return this.kpiInfo;
    }

    public void setKpiInfo(KPIInfo kpiInfo) {
        this.kpiInfo = kpiInfo;
    }

    public KPIValueInfo getCurKpiValueInfo() {
        return this.curKpiValueInfo;
    }

    public void setCurKpiValueInfo(KPIValueInfo curKpiValueInfo) {
        this.curKpiValueInfo = curKpiValueInfo;
    }

    public KPIValueCollection getValueCols() {
        return this.valueCols;
    }

    public void setValueCols(KPIValueCollection valueCols) {
        this.valueCols = valueCols;
    }
}

