/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.ui.face.IUIObject;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.client.KPIMainListUI;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;

public class KpiTransferHandler
extends TransferHandler {
    private DataFlavor kpiInfoDataFlavor;
    private IUIObject kpiMainList;
    private KDTree source;

    public KpiTransferHandler(IUIObject kpiMainList) {
        this.kpiMainList = kpiMainList;
        this.kpiInfoDataFlavor = new DataFlavor(KPIInfo.class, "KPIInfo");
    }

    protected Transferable createTransferable(JComponent c) {
        if (c instanceof KDTree) {
            DefaultKingdeeTreeNode node;
            Object obj;
            this.source = (KDTree)c;
            TreePath path = this.source.getSelectionPath();
            if (path != null && (obj = (node = (DefaultKingdeeTreeNode)path.getLastPathComponent()).getUserObject()) instanceof KPIInfo) {
                return new KpiInfoTransferable((KPIInfo)obj);
            }
        }
        return null;
    }

    public boolean canImport(JComponent c, DataFlavor[] flavors) {
        int count = flavors.length;
        for (int i = 0; i < count; ++i) {
            if (this.kpiInfoDataFlavor.equals(flavors[i])) continue;
            return false;
        }
        return true;
    }

    public boolean importData(JComponent c, Transferable t) {
        int dest;
        if (!this.canImport(c, t.getTransferDataFlavors())) {
            return false;
        }
        KPIMainListUI kpiMain = (KPIMainListUI)this.kpiMainList;
        if (c == kpiMain.pnlDashboard) {
            dest = kpiMain.TODASHBOARD;
        } else if (c == kpiMain.tblBeacon) {
            dest = kpiMain.TODASHBOARD;
        } else {
            return false;
        }
        try {
            KPIInfo kpiInfo = (KPIInfo)t.getTransferData(this.kpiInfoDataFlavor);
            kpiMain.addKpiToDest(dest, kpiInfo);
            return true;
        }
        catch (UnsupportedFlavorException e) {
            kpiMain.handUIException(e);
        }
        catch (IOException e) {
            kpiMain.handUIException(e);
        }
        return false;
    }

    protected void exportDone(JComponent c, Transferable data, int action) {
    }

    public class KpiInfoTransferable
    implements Transferable {
        private KPIInfo kpiInfo;

        public KpiInfoTransferable(KPIInfo kpiInfo) {
            this.kpiInfo = kpiInfo;
        }

        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{KpiTransferHandler.this.kpiInfoDataFlavor};
        }

        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return KpiTransferHandler.this.kpiInfoDataFlavor.equals(flavor);
        }

        public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(flavor)) {
                throw new UnsupportedFlavorException(flavor);
            }
            return this.kpiInfo;
        }
    }
}

