/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.ICell;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTMergeManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectBlock;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportCollection;
import com.kingdee.eas.sem.mp.BussAnalysisThemeReportInfo;
import com.kingdee.eas.sem.mp.client.AbstractLayoutDesignUI;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class LayoutDesignUI
extends AbstractLayoutDesignUI {
    private static final Logger logger = CoreUIObject.getLogger(LayoutDesignUI.class);
    private int initRows = 0;
    private int initCols = 0;
    private int mark = 1;
    private BussAnalysisThemeReportCollection bussReportList = new BussAnalysisThemeReportCollection();
    private BussAnalysisThemeReportCollection defaultReportList;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        super.onLoad();
        Object obj = this.getUIContext().get("INITROWS");
        if (obj != null && obj instanceof Integer) {
            this.initRows = (Integer)obj;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)"row is error!");
            this.abort();
        }
        obj = this.getUIContext().get("INITCOLS");
        if (obj != null && obj instanceof Integer) {
            this.initCols = (Integer)obj;
        } else {
            MsgBox.showInfo((Component)((Object)this), (String)"cols is error!");
            this.abort();
        }
        obj = this.getUIContext().get("BUSSREPORTLIST");
        if (obj != null && obj instanceof BussAnalysisThemeReportCollection) {
            this.bussReportList = (BussAnalysisThemeReportCollection)((Object)obj);
        }
        this.defaultReportList = (obj = this.getUIContext().get("DEFAULTREPORTLIST")) != null && obj instanceof BussAnalysisThemeReportCollection ? (BussAnalysisThemeReportCollection)((Object)obj) : new BussAnalysisThemeReportCollection();
        this.initTable();
        this.initReportList();
        this.layoutTable.getStyleAttributes().setLocked(true);
        this.btnMerge.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kDWorkButton1.setEnabled(true);
    }

    private void initReportList() {
        this.btnAdd.setEnabled(true);
        this.btnDel.setEnabled(true);
        if (this.bussReportList == null || this.bussReportList.size() <= 0) {
            return;
        }
        Iterator ite = this.bussReportList.iterator();
        while (ite.hasNext()) {
            this.reportList.addElement(ite.next());
        }
    }

    private void initTable() {
        int defHeight = 0;
        int defWidth = 0;
        defHeight = this.layoutTable.getHeight() / this.initRows;
        defWidth = this.layoutTable.getWidth() / this.initCols;
        this.layoutTable.addColumns(this.initCols);
        this.layoutTable.addRows(this.initRows);
        for (int i = 0; i < this.initCols; ++i) {
            this.layoutTable.getColumn(i).setWidth(defWidth);
        }
        for (int j = 0; j < this.initRows; ++j) {
            this.layoutTable.getRow(j).setHeight(defHeight);
        }
        this.layoutTable.getIndexColumn().getStyleAttributes().setHided(true);
        if (this.defaultReportList != null && this.defaultReportList.size() > 0) {
            KDTMergeManager mm = this.layoutTable.getMergeManager();
            Iterator ite = this.defaultReportList.iterator();
            while (ite.hasNext()) {
                BussAnalysisThemeReportInfo reportInfo = (BussAnalysisThemeReportInfo)ite.next();
                this.layoutTable.getRow(reportInfo.getRowNumber()).getCell(reportInfo.getColNumber()).setValue((Object)reportInfo);
                if (reportInfo.getColspan() <= 0 && reportInfo.getRowspan() <= 0) continue;
                mm.mergeBlock(reportInfo.getRowNumber(), reportInfo.getColNumber(), reportInfo.getRowNumber() + reportInfo.getRowspan() - 1, reportInfo.getColNumber() + reportInfo.getColspan() - 1);
            }
        }
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        KDTSelectBlock selectBlock = selectManager.get(0);
        int top_row = selectBlock.getBeginRow();
        int top_col = selectBlock.getBeginCol();
        int bottom_row = selectBlock.getEndRow();
        int bottom_col = selectBlock.getEndCol();
        KDTMergeManager mm = this.layoutTable.getMergeManager();
        mm.splitBlock(top_row, top_col, bottom_row, bottom_col);
    }

    public void actionMerge_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        KDTSelectBlock selectBlock = selectManager.get(0);
        int top_row = selectBlock.getBeginRow();
        int top_col = selectBlock.getBeginCol();
        int bottom_row = selectBlock.getEndRow();
        int bottom_col = selectBlock.getEndCol();
        KDTMergeManager mm = this.layoutTable.getMergeManager();
        mm.mergeBlock(top_row, top_col, bottom_row, bottom_col, 4);
        int beginRow = this.layoutTable.getSelectManager().get(0).getBeginRow();
        int beginCol = this.layoutTable.getSelectManager().get(0).getBeginCol();
        this.layoutTable.getRow(beginRow).getCell(beginCol).getStyleAttributes().setBackground(Color.RED);
    }

    public void actionConfirm_actionPerformed(ActionEvent e) throws Exception {
        super.actionConfirm_actionPerformed(e);
        this.readData();
        this.getUIWindow().close();
    }

    public void actionAddReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionAddReport_actionPerformed(e);
        Object obj = this.reportList.getSelectedValue();
        if (obj == null) {
            MsgBox.showInfo((Component)((Object)this), (String)"please select");
            return;
        }
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        KDTSelectBlock selectBlock = selectManager.get(0);
        int beginRow = selectBlock.getBeginRow();
        int beginCol = selectBlock.getBeginCol();
        Object oldObj = this.layoutTable.getRow(beginRow).getCell(beginCol).getValue();
        if (oldObj != null && oldObj instanceof BussAnalysisThemeReportInfo) {
            this.reportList.addElement(oldObj);
        }
        this.layoutTable.getRow(beginRow).getCell(beginCol).getStyleAttributes().setBackground(Color.RED);
        this.layoutTable.getRow(beginRow).getCell(beginCol).setValue(obj);
        int seleIndex = this.reportList.getSelectedIndex();
        this.reportList.removeElementAt(seleIndex);
        this.bussReportList.remove((BussAnalysisThemeReportInfo)obj);
    }

    public void actionDelReport_actionPerformed(ActionEvent e) throws Exception {
        super.actionDelReport_actionPerformed(e);
        KDTSelectManager selectManager = this.layoutTable.getSelectManager();
        int size = selectManager.size();
        if (size <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.framework.FrameWorkResource.Msg_NoneEntry"));
            return;
        }
        int beginRow = this.layoutTable.getSelectManager().get(0).getBeginRow();
        int beginCol = this.layoutTable.getSelectManager().get(0).getBeginCol();
        this.layoutTable.getRow(beginRow).getCell(beginCol).getStyleAttributes().setBackground(Color.RED);
        Object obj = this.layoutTable.getRow(beginRow).getCell(beginCol).getValue();
        this.layoutTable.getRow(beginRow).getCell(beginCol).setValue(null);
        if (obj != null && obj instanceof BussAnalysisThemeReportInfo) {
            this.reportList.addElement(obj);
            this.bussReportList.addObject((IObjectValue)((BussAnalysisThemeReportInfo)obj));
        }
    }

    private BussAnalysisThemeReportCollection readData() {
        int rowCount = this.layoutTable.getRowCount();
        int colCount = this.layoutTable.getColumnCount();
        this.defaultReportList.clear();
        for (int i = 0; i < rowCount; ++i) {
            ArrayList rowList = new ArrayList(colCount);
            IRow tempRow = this.layoutTable.getRow(i);
            for (int j = 0; j < colCount; ++j) {
                ICell tempCell = tempRow.getCell(j);
                Object obj = tempCell.getValue();
                KDTMergeBlock kdmerge = tempCell.getMergeBlock();
                if (obj == null || !(obj instanceof BussAnalysisThemeReportInfo)) continue;
                BussAnalysisThemeReportInfo layoutInfo = (BussAnalysisThemeReportInfo)obj;
                layoutInfo.setCols(colCount);
                layoutInfo.setRows(rowCount);
                if (kdmerge == null) {
                    layoutInfo.setRowNumber(i);
                    layoutInfo.setColNumber(j);
                    layoutInfo.setRowspan(0);
                    layoutInfo.setColspan(0);
                    layoutInfo.setColWidth(1.0f / (float)colCount);
                    layoutInfo.setRowHeight(1.0f / (float)rowCount);
                } else if (kdmerge.getTop() == i && kdmerge.getLeft() == j) {
                    layoutInfo.setRowNumber(i);
                    layoutInfo.setColNumber(j);
                    layoutInfo.setRowspan(kdmerge.getBottom() - kdmerge.getTop() + 1);
                    layoutInfo.setColspan(kdmerge.getRight() - kdmerge.getLeft() + 1);
                    layoutInfo.setColWidth((float)(kdmerge.getRight() - kdmerge.getLeft() + 1) / (float)colCount);
                    layoutInfo.setRowHeight((float)(kdmerge.getBottom() - kdmerge.getTop() + 1) / (float)rowCount);
                }
                this.defaultReportList.add(layoutInfo);
            }
        }
        return this.defaultReportList;
    }
}

