/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.appframework.client.servicebinding.ActionProxyFactory;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.ctrl.swing.KDWorkButton;
import com.kingdee.bos.ctrl.swing.event.DataChangeEvent;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.ui.face.IItemAction;
import com.kingdee.bos.ui.face.IUIFactory;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.ItemAction;
import com.kingdee.bos.ui.face.UIException;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.ui.util.IUIActionPostman;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.job.client.ProcessSchedulePlan;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.client.longtime.ILongTimeTask;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.fi.rpt.client.ProgressManager;
import com.kingdee.eas.fi.rpt.client.RptHelper;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.client.CoreUI;
import com.kingdee.eas.sem.mp.IUpdateSchema;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPISchemaTypeEnum;
import com.kingdee.eas.sem.mp.UpdateSchemaCollection;
import com.kingdee.eas.sem.mp.UpdateSchemaCompanyRelaCollection;
import com.kingdee.eas.sem.mp.UpdateSchemaCompanyRelaInfo;
import com.kingdee.eas.sem.mp.UpdateSchemaFactory;
import com.kingdee.eas.sem.mp.UpdateSchemaInfo;
import com.kingdee.eas.sem.mp.UpdateSchemaKPIRelaCollection;
import com.kingdee.eas.sem.mp.UpdateSchemaKPIRelaInfo;
import com.kingdee.eas.sem.mp.client.AbstractManualUpdateSolutionUI;
import com.kingdee.eas.sem.mp.client.KPIQueryResultUI;
import com.kingdee.eas.sem.mp.client.KPISelectUI;
import com.kingdee.eas.sem.mp.client.LongTimeDialog;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.ComponentUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.apache.log4j.Logger;

public class ManualUpdateSolutionUI
extends AbstractManualUpdateSolutionUI {
    private static final long serialVersionUID = -3514168294747241376L;
    private static final Logger logger = CoreUIObject.getLogger(ManualUpdateSolutionUI.class);
    private static String MenuCreateKpi = "MenuCreateKpi";
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";
    private boolean selectKPIOK;
    private UpdateSchemaInfo defaultUpdateSchemaInfo = null;
    private boolean isUpdateSolutionAddUIEdit = false;
    private IUpdateSchema iUpdateSchema = UpdateSchemaFactory.getRemoteInstance();
    boolean hasListSelectChange = false;
    private AdminOrgUnitInfo currentAdminOrg = SysContext.getSysContext().getCurrentAdminUnit();
    private String orgID = this.getCurrentOrgId();
    KDWorkButton btnSechDel = new KDWorkButton();
    KDWorkButton btnSechAdd = new KDWorkButton();
    KDWorkButton btnSechSave = new KDWorkButton();
    KDWorkButton btnSechEdit = new KDWorkButton();
    String strSave = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.CaclSolutonUI_Save_cue");
    private Set currentCompanySet = new HashSet();
    private CompanyOrgUnitInfo currentCompanyOrg = SysContext.getSysContext().getCurrentFIUnit();
    private boolean isCurrentSolutionChange = false;
    private boolean hasSaveSolution = false;
    private boolean queryPermission = false;
    private boolean kpiPermission = false;
    private boolean isAddAction = false;
    private static final String IsChange = "IsChange";
    private static final String IsNew = "IsNew";
    boolean isSelfSelect = false;
    private ProgressManager procManager = null;

    public ManualUpdateSolutionUI() throws Exception {
        if (this.currentCompanyOrg == null) {
            throw new KPIException(KPIException.NOT_COMPNAYORTUNIT);
        }
    }

    public void initCtrl() {
        this.btnAdd.setText(null);
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAdd.setToolTipText(EASResource.getString((String)"add"));
        this.btnAdd.setEnabled(true);
        this.btnDel.setText(null);
        this.btnDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDel.setToolTipText(EASResource.getString((String)"delete"));
        this.btnDel.setEnabled(true);
        this.btnUp.setText(null);
        this.btnUp.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnUp.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.up"));
        this.btnUp.setEnabled(true);
        this.btnDown.setText(null);
        this.btnDown.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnDown.setEnabled(true);
        this.btnDown.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.down"));
        this.btnUpCompany.setText(null);
        this.btnUpCompany.setIcon(EASResource.getIcon((String)"imgTbtn_movetop"));
        this.btnUpCompany.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.up"));
        this.btnUpCompany.setEnabled(true);
        this.btnDownCompany.setText(null);
        this.btnDownCompany.setIcon(EASResource.getIcon((String)"imgTbtn_movedown"));
        this.btnDownCompany.setEnabled(true);
        this.btnDownCompany.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.down"));
        this.btnSechAdd.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSechAdd), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnSechAdd.setText(null);
        this.btnSechAdd.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnSechAdd.setToolTipText(EASResource.getString((String)"add"));
        this.btnSechDel.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSechDel), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnSechDel.setText(null);
        this.btnSechDel.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnSechDel.setToolTipText(EASResource.getString((String)"delete"));
        this.btnSechSave.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSechSave), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnSechSave.setText(null);
        this.btnSechSave.setIcon(EASResource.getIcon((String)"imgTbtn_save"));
        this.btnSechSave.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.save"));
        this.btnSechEdit.setAction((Action)((IItemAction)ActionProxyFactory.getProxy((Object)((Object)this.actionSechEdit), (Class[])new Class[]{IItemAction.class}, (Map)this.getServiceContext())));
        this.btnSechEdit.setText(null);
        this.btnSechEdit.setIcon(EASResource.getIcon((String)"imgTbtn_edit"));
        this.btnSechEdit.setToolTipText(EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.edit"));
        this.btnAddCompany.setEnabled(true);
        this.btnAddCompany.setText(null);
        this.btnAddCompany.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.btnAddCompany.setToolTipText(EASResource.getString((String)RES, (String)"addCompany"));
        this.btnDelCompany.setEnabled(true);
        this.btnDelCompany.setText(null);
        this.btnDelCompany.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.btnDelCompany.setToolTipText(EASResource.getString((String)RES, (String)"delCompany"));
        this.btnExecute.setEnabled(true);
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.initSelfListener();
        this.initUpdateSchemas();
        this.setAdminOrgUnitInfo(this.currentAdminOrg);
        this.lstSchema.setVisible(true);
        this.lstSchema.setSelectionMode(0);
        KDTSortManager sm_company = new KDTSortManager(this.companyList);
        sm_company.setSortAuto(true);
        this.companyList.getColumn("number").setSortable(true);
        this.companyList.getColumn("name").setSortable(true);
        KDTSortManager sm_kpi = new KDTSortManager(this.kpiList);
        sm_kpi.setSortAuto(true);
        this.kpiList.getColumn("number").setSortable(true);
        this.kpiList.getColumn("name").setSortable(true);
        this.btnExecute.setIcon(EASResource.getIcon((String)"imgTbtn_execute"));
        if (this.lstSchema.getElementCount() <= 0) {
            this.refreshUpdateSchemaView();
        }
    }

    protected void handlePermissionForItemAction(ItemAction action) {
        if (!this.checkPermission()) {
            String info = EASResource.getString((String)RES, (String)"no_permission_error_1") + SysContext.getSysContext().getCurrentFIUnit().getName() + EASResource.getString((String)RES, (String)"no_permission_error_2");
            MsgBox.showError((Component)((Object)this), (String)info);
            SysUtil.abort();
        }
    }

    private boolean checkPermission() {
        this.queryPermission = this.getPermission("mp_kpi_calculate_query");
        boolean bl = this.kpiPermission = this.getPermission("mp_KPI_addnew") || this.getPermission("mp_KPI_update");
        if (this.queryPermission || this.kpiPermission) {
            if (!this.kpiPermission) {
                this.kpiCalculate.setEnabled(false);
            }
            return true;
        }
        return false;
    }

    private boolean getPermission(String permissionKey) {
        IObjectPK userPK = null;
        IObjectPK orgPK = null;
        userPK = this.getUserPk();
        orgPK = this.getOrgPK(null);
        boolean permissionFlag = false;
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        try {
            IPermission iPermission = PermissionFactory.getRemoteInstance();
            permissionFlag = iPermission.hasFunctionPermission(userPK, orgPK, permissionKey);
        }
        catch (Exception e) {
            // empty catch block
        }
        return permissionFlag;
    }

    public void setButtonEnable(boolean isEnable) {
        this.btnAdd.setEnabled(isEnable);
        this.btnDel.setEnabled(isEnable);
        this.btnUp.setEnabled(isEnable);
        this.btnDown.setEnabled(isEnable);
        this.btnSechDel.setEnabled(isEnable);
        this.btnSechAdd.setEnabled(isEnable);
        this.btnSechSave.setEnabled(isEnable);
        this.btnSechEdit.setEnabled(isEnable);
    }

    public void initUIContentLayout() {
        this.kpiList.checkParsed();
        this.companyList.checkParsed();
        this.initCtrl();
        this.kDContainer2.setMinimumSize(new Dimension(220, 580));
        this.kDContainer2.setMaximumSize(new Dimension(776, 580));
        this.kDContainer2.setPreferredSize(new Dimension(776, 580));
        this.kDContainer1.setMinimumSize(new Dimension(100, 580));
        this.kDContainer1.setMaximumSize(new Dimension(220, 580));
        this.kDContainer1.setPreferredSize(new Dimension(220, 580));
        this.btnSechAdd.setPreferredSize(new Dimension(22, 19));
        this.btnSechEdit.setPreferredSize(new Dimension(22, 19));
        this.btnSechSave.setPreferredSize(new Dimension(22, 19));
        this.btnSechEdit.setPreferredSize(new Dimension(22, 19));
        this.btnSechDel.setPreferredSize(new Dimension(22, 19));
        this.btnSechAdd.setMinimumSize(new Dimension(22, 19));
        this.btnSechAdd.setMaximumSize(new Dimension(22, 19));
        this.btnSechDel.setMinimumSize(new Dimension(22, 19));
        this.btnSechDel.setMaximumSize(new Dimension(22, 19));
        this.btnSechSave.setMinimumSize(new Dimension(22, 19));
        this.btnSechSave.setMaximumSize(new Dimension(22, 19));
        this.btnSechEdit.setMinimumSize(new Dimension(22, 19));
        this.btnSechEdit.setMaximumSize(new Dimension(22, 19));
        this.kDContainer1.addButton((JButton)this.btnSechAdd);
        this.kDContainer1.addButton((JButton)this.btnSechEdit);
        this.kDContainer1.addButton((JButton)this.btnSechSave);
        this.kDContainer1.addButton((JButton)this.btnSechDel);
        this.kDContainer1.setTitleStyle(2);
        super.initUIContentLayout();
        this.kDContainer1.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 220, 550));
        this.kDContainer2.getContentPane().putClientProperty("OriginalBounds", new Rectangle(0, 0, 770, 550));
        this.kpiList.getColumn(1).setWidth(150);
        this.kpiList.getColumn(2).setWidth(250);
        this.kpiList.getColumn(0).getStyleAttributes().setHided(true);
        this.kpiList.getSelectManager().setSelectMode(10);
        this.kpiList.getColumn(1).getStyleAttributes().setLocked(true);
        this.kpiList.getColumn(2).getStyleAttributes().setLocked(true);
        this.companyList.getColumn(1).getStyleAttributes().setLocked(true);
        this.companyList.getColumn(2).getStyleAttributes().setLocked(true);
        this.companyList.getSelectManager().setSelectMode(10);
    }

    private void initSelfListener() {
        this.lstSchema.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (!e.getValueIsAdjusting()) {
                    ManualUpdateSolutionUI.this.listSechChange(e);
                }
            }
        });
        this.lstSchema.addKeyListener(new KeyListener(){

            public void keyPressed(KeyEvent ke) {
            }

            public void keyReleased(KeyEvent ke) {
                if (ke.getKeyCode() == 127) {
                    try {
                        ManualUpdateSolutionUI.this.actionSechDel_actionPerformed(null);
                    }
                    catch (Exception e) {
                        ManualUpdateSolutionUI.this.handUIException(e);
                    }
                }
            }

            public void keyTyped(KeyEvent ke) {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void listSechChange(ListSelectionEvent e) {
        Window window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        try {
            ComponentUtil.setWindowsCursorOfWair((Window)window);
            if (this.isAddAction) {
                this.isAddAction = false;
                this.refreshUpdateSchemaView();
                return;
            }
            if (this.isSelfSelect) {
                this.isSelfSelect = false;
                return;
            }
            int firstIndex = e.getFirstIndex();
            int lastIndex = e.getLastIndex();
            int selectIndex = this.lstSchema.getSelectedIndex();
            int beforeIndex = -1;
            if (firstIndex == selectIndex) {
                beforeIndex = lastIndex;
            } else if (lastIndex == selectIndex) {
                beforeIndex = firstIndex;
            }
            if (beforeIndex >= 0 && beforeIndex <= this.lstSchema.getElementCount() - 1) {
                UpdateSchemaInfo beforeInfo = (UpdateSchemaInfo)this.lstSchema.getElement(beforeIndex);
                if (this.checkSaveUpdateSchemaInfo(beforeInfo)) {
                    this.refreshUpdateSchemaView();
                } else {
                    this.isSelfSelect = true;
                    this.lstSchema.setSelectedIndex(beforeIndex);
                }
            }
        }
        catch (Exception ie) {
            this.handUIException(ie);
        }
        finally {
            ComponentUtil.setWindowCursorOfDefault((Window)window);
        }
    }

    public void initUpdateSchemas() {
        UpdateSchemaCollection updateSchemaCollection = null;
        try {
            EntityViewInfo view = new EntityViewInfo();
            SelectorItemCollection sic = view.getSelector();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("name"));
            sic.add(new SelectorItemInfo("intervalSetted"));
            sic.add(new SelectorItemInfo("jobProcessDef"));
            sic.add(new SelectorItemInfo("actionType"));
            sic.add(new SelectorItemInfo("updateHistory"));
            sic.add(new SelectorItemInfo("timeText"));
            sic.add(new SelectorItemInfo("beginPeriod"));
            sic.add(new SelectorItemInfo("endPeriod"));
            sic.add(new SelectorItemInfo("schemaType"));
            sic.add(new SelectorItemInfo("solutionRela.KPI.number"));
            sic.add(new SelectorItemInfo("solutionRela.KPI.name"));
            sic.add(new SelectorItemInfo("solutionRela.KPI.timeType"));
            sic.add(new SelectorItemInfo("companyRela.partfi.*"));
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)this.orgID));
            filter.getFilterItems().add(new FilterItemInfo("actionType", (Object)MenuCreateKpi));
            view.setFilter(filter);
            updateSchemaCollection = this.iUpdateSchema.getUpdateSchemaCollection(view);
            if (updateSchemaCollection == null || updateSchemaCollection.size() == 0) {
                return;
            }
            int size = updateSchemaCollection.size();
            for (int i = 0; i < size; ++i) {
                this.lstSchema.addElement((Object)updateSchemaCollection.get(i));
                if (i != size - 1) continue;
                this.lstSchema.setSelectedIndex(i);
            }
        }
        catch (Exception e) {
            this.handUIException(e);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    private String getCurrentOrgId() {
        String orgId = null;
        CompanyOrgUnitInfo adminOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (adminOrg != null) {
            orgId = adminOrg.getId().toString();
        }
        return orgId;
    }

    public void actionAdd_actionPerformed(ActionEvent e) throws Exception {
        UIContext uiContext = new UIContext((Object)this);
        ArrayList list = new ArrayList();
        uiContext.put((Object)"Data", list);
        uiContext.put((Object)"KPIAnalysisReportEditUI", (Object)this);
        IUIFactory uiFactory = UIFactory.createUIFactory((String)UIFactoryName.MODEL);
        IUIWindow window = uiFactory.create(KPISelectUI.class.getName(), (Map)uiContext, null, null);
        window.show();
        if (this.isSelectKPIOK() && list != null) {
            UpdateSchemaInfo ui = this.getUpdateSchemaInfo();
            UpdateSchemaKPIRelaCollection uc = ui.getSolutionRela();
            ArrayList<String> oldReportIDs = new ArrayList<String>();
            Iterator it = uc.iterator();
            while (it.hasNext()) {
                UpdateSchemaKPIRelaInfo relaInfo = (UpdateSchemaKPIRelaInfo)it.next();
                if (relaInfo.getKPI().getId() == null || relaInfo.getKPI().getId().toString().length() <= 0) continue;
                oldReportIDs.add(relaInfo.getKPI().getId().toString());
            }
            ArrayList reportDatas = this.filterData(list.toArray(), oldReportIDs);
            if (reportDatas != null && reportDatas.size() > 0) {
                this.isCurrentSolutionChange = true;
                for (int j = 0; j < reportDatas.size(); ++j) {
                    this.addKPITable((KPIInfo)reportDatas.get(j));
                    UpdateSchemaKPIRelaInfo ukr = new UpdateSchemaKPIRelaInfo();
                    ukr.setKPI((KPIInfo)reportDatas.get(j));
                    ukr.setSchema(ui);
                    uc.add(ukr);
                    this.setChange();
                }
            }
        }
    }

    public void actionAddCompany_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo[] tempOrgInfo;
        String orgId = null == SysContext.getSysContext().getCurrentFIUnit() ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(true);
        af7.setRootUnitID(orgId);
        af7.setCheckedOrgIDs(this.currentCompanySet);
        af7.show();
        Object obj = af7.getData();
        if (obj instanceof OrgUnitInfo[] && (tempOrgInfo = (OrgUnitInfo[])obj) != null && tempOrgInfo.length > 0) {
            boolean isAdd = false;
            UpdateSchemaInfo schemaInfo = this.getUpdateSchemaInfo();
            UpdateSchemaCompanyRelaCollection companyRelaCols = schemaInfo.getCompanyRela();
            for (int i = 0; i < tempOrgInfo.length; ++i) {
                IRow tempRow;
                UpdateSchemaCompanyRelaInfo companyInfo;
                isAdd = false;
                OrgUnitInfo tempOuInfo = tempOrgInfo[i];
                String ouId = tempOuInfo.getId().toString();
                int rowCount = this.companyList.getRowCount();
                this.currentCompanySet.add(ouId);
                if (rowCount > 0) {
                    for (int j = 0; j < rowCount; ++j) {
                        String addOuId = this.companyList.getRow(j).getCell("id").getValue().toString();
                        if (!ouId.equals(addOuId)) continue;
                        isAdd = true;
                        break;
                    }
                    if (isAdd) continue;
                    this.setChange();
                    companyInfo = new UpdateSchemaCompanyRelaInfo();
                    companyInfo.setPartFI((CompanyOrgUnitInfo)tempOrgInfo[i]);
                    companyInfo.setSchema(schemaInfo);
                    companyRelaCols.add(companyInfo);
                    tempRow = this.companyList.addRow();
                    tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                    tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                    tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                    tempRow.setUserObject((Object)companyInfo);
                    continue;
                }
                this.setChange();
                companyInfo = new UpdateSchemaCompanyRelaInfo();
                companyInfo.setPartFI((CompanyOrgUnitInfo)tempOrgInfo[i]);
                companyInfo.setSchema(schemaInfo);
                companyRelaCols.add(companyInfo);
                tempRow = this.companyList.addRow();
                tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                tempRow.setUserObject((Object)companyInfo);
            }
        }
    }

    private void addKPITable(KPIInfo kpiInfo) {
        try {
            IRow row = this.kpiList.addRow();
            row.getCell(0).setValue((Object)kpiInfo);
            row.getCell(1).setValue((Object)kpiInfo.getNumber());
            row.getCell(2).setValue((Object)kpiInfo.getName());
            row.getCell(3).setValue((Object)kpiInfo.getTimeType());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void addCompanyTable(CompanyOrgUnitInfo companyInfo) {
        try {
            IRow row = this.companyList.addRow();
            row.getCell(0).setValue((Object)companyInfo.getId());
            row.getCell(1).setValue((Object)companyInfo.getNumber());
            row.getCell(2).setValue((Object)companyInfo.getName());
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private ArrayList filterData(Object[] newReports, ArrayList oldReports) {
        if (newReports == null || newReports.length == 0) {
            return null;
        }
        ArrayList<Object> returnDatas = new ArrayList<Object>();
        int oldReportDatasSize = newReports.length;
        for (int i = 0; i < oldReportDatasSize; ++i) {
            String id;
            if (newReports[i] == null || ((KPIInfo)newReports[i]).getId() == null || oldReports.contains(id = ((KPIInfo)newReports[i]).getId().toString())) continue;
            returnDatas.add(newReports[i]);
        }
        return returnDatas;
    }

    public void actionDel_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.kpiList.getSelectManager();
        if (null == this.kpiList.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.plsSelectKPI"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kpiList);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.kpiList.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.kpiList.removeRow(selectRows[i]);
                KPIInfo kpi = (KPIInfo)row.getCell(0).getValue();
                this.deleteKPIFromUpdateSchema(kpi);
            }
        }
    }

    public void actionDelCompany_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.companyList.getSelectManager();
        if (null == this.companyList.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"no_select"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.companyList);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.companyList.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.companyList.removeRow(selectRows[i]);
                String companyId = row.getCell(0).getValue().toString();
                this.deleteCompanyFromUpdateSchema(companyId);
            }
            this.setChange();
        }
    }

    private void deleteKPIFromUpdateSchema(KPIInfo kpi) {
        if (kpi != null) {
            Iterator it = this.getUpdateSchemaInfo().getSolutionRela().iterator();
            while (it.hasNext()) {
                UpdateSchemaKPIRelaInfo ukpiR = (UpdateSchemaKPIRelaInfo)it.next();
                if (!ukpiR.getKPI().getId().toString().equals(kpi.getId().toString())) continue;
                it.remove();
                this.setChange();
                break;
            }
        }
    }

    private void deleteCompanyFromUpdateSchema(String companyId) {
        if (companyId != null) {
            Iterator it = this.getUpdateSchemaInfo().getCompanyRela().iterator();
            while (it.hasNext()) {
                UpdateSchemaCompanyRelaInfo ukpiR = (UpdateSchemaCompanyRelaInfo)it.next();
                if (!ukpiR.getPartFI().getId().toString().equals(companyId)) continue;
                it.remove();
                this.setChange();
                break;
            }
        }
    }

    private void setChange() {
        this.getUpdateSchemaInfo().put(IsChange, IsChange);
    }

    protected void delSelectLine(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > -1) {
            table.removeRow(selectRpw);
        }
    }

    public void actionDownCompany_actionPerformed(ActionEvent e) throws Exception {
        this.downRow(this.companyList);
    }

    public void actionUpCompany_actionPerformed(ActionEvent e) throws Exception {
        this.upRow(this.companyList);
    }

    public void actionUp_actionPerformed(ActionEvent e) throws Exception {
        this.upRow(this.kpiList);
    }

    public void actionDown_actionPerformed(ActionEvent e) throws Exception {
        this.downRow(this.kpiList);
    }

    private void upRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw > 0) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw - 1, selectRow);
            table.getSelectManager().select(selectRpw - 1, 0);
        }
    }

    private void downRow(KDTable table) throws Exception {
        int selectRpw = table.getSelectManager().getActiveRowIndex();
        if (selectRpw >= 0 && selectRpw < table.getRowCount() - 1) {
            IRow selectRow = table.getRow(selectRpw);
            this.delSelectLine(table);
            table.addRow(selectRpw + 1, selectRow);
            table.getSelectManager().select(selectRpw + 1, 0);
        }
    }

    private void setInfoName(UpdateSchemaInfo info, String name) {
        if (info != null) {
            info.setName(name, new Locale("l1"));
            info.setName(name, new Locale("l2"));
            info.setName(name, new Locale("l3"));
        }
    }

    public void actionSechEdit_actionPerformed(ActionEvent e) throws Exception {
        if (this.getUpdateSchemaInfo() == null || this.getUpdateSchemaInfo().getName() == null || this.getUpdateSchemaInfo().getName().trim().length() == 0) {
            return;
        }
        this.isUpdateSolutionAddUIEdit = true;
        String strName = this.inputName();
        if (strName == null) {
            return;
        }
        String oldName = this.getUpdateSchemaInfo().getName();
        this.setInfoName(this.getUpdateSchemaInfo(), strName);
        boolean isExist = this.checkNameExits(this.getUpdateSchemaInfo());
        if (isExist) {
            this.setInfoName(this.getUpdateSchemaInfo(), oldName);
            String strSameName = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.CaclSolutonUI_SameName");
            MsgBox.showInfo((Component)((Object)this), (String)strSameName);
            return;
        }
        this.setChange();
        this.lstSchema.repaint();
    }

    protected void selfClearUI() {
        this.beginPeriod.setValue(null);
        this.endPeriod.setValue(null);
        this.kpiList.removeRows();
        this.companyList.removeRows();
    }

    public void actionSechAdd_actionPerformed(ActionEvent e) throws Exception {
        UpdateSchemaInfo tempInfo;
        int selectIndex = this.lstSchema.getSelectedIndex();
        if (selectIndex >= 0 && !this.checkSaveUpdateSchemaInfo(tempInfo = (UpdateSchemaInfo)this.lstSchema.getElement(selectIndex))) {
            return;
        }
        this.isUpdateSolutionAddUIEdit = false;
        this.defaultUpdateSchemaInfo = null;
        this.isCurrentSolutionChange = true;
        this.hasSaveSolution = false;
        this.isAddAction = true;
        String name = this.createSchemaName();
        if (name == null) {
            return;
        }
        this.selfClearUI();
        UpdateSchemaInfo updateSchemaInfo = new UpdateSchemaInfo();
        this.setInfoName(updateSchemaInfo, name);
        updateSchemaInfo.setActionType(MenuCreateKpi);
        updateSchemaInfo.setJobProcessDef(MenuCreateKpi);
        updateSchemaInfo.put(IsNew, IsNew);
        this.lstSchema.addElement((Object)updateSchemaInfo);
        this.lstSchema.setSelectedIndex(this.lstSchema.getElementCount() - 1);
        this.lstSchema.repaint();
    }

    private String inputName() throws UIException {
        String sUIName = "com.kingdee.eas.sem.mp.client.UpdateSolutionAddUI";
        UIContext uiContext = new UIContext((Object)this);
        Hashtable<String, String> option = new Hashtable<String, String>();
        if (this.isUpdateSolutionAddUIEdit) {
            option.put("name", this.getUpdateSchemaInfo().getName());
        }
        uiContext.put((Object)"option", option);
        IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(sUIName, (Map)uiContext);
        uiWindow.show();
        String action = (String)option.get("action");
        if (action != null && action.equals("CANCEL")) {
            return null;
        }
        String strName = (String)option.get("name");
        if (strName == null || strName.length() == 0) {
            return null;
        }
        return strName.trim();
    }

    private boolean checkNameExits(UpdateSchemaInfo info) throws EASBizException, BOSException {
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = view.getSelector();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("partFI.id"));
        FilterInfo filter = new FilterInfo();
        if (info.getId() != null) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)info.getId().toString(), CompareType.NOTEQUALS));
        }
        filter.getFilterItems().add(new FilterItemInfo("name", (Object)info.getName().trim()));
        filter.getFilterItems().add(new FilterItemInfo("partFI.id", (Object)this.orgID));
        filter.getFilterItems().add(new FilterItemInfo("actionType", (Object)"MenuCreateKpi"));
        boolean isExist = this.iUpdateSchema.exists(filter);
        if (!isExist) {
            int size = this.lstSchema.getElementCount();
            for (int i = 0; i < size; ++i) {
                UpdateSchemaInfo ui = (UpdateSchemaInfo)this.lstSchema.getElement(i);
                if (ui == info || ui.getName() == null || !ui.getName().trim().equals(info.getName().trim())) continue;
                isExist = true;
                break;
            }
        }
        return isExist;
    }

    private String createSchemaName() throws EASBizException, BOSException {
        boolean isExist = true;
        while (isExist) {
            String strName = this.inputName();
            if (strName == null) {
                return null;
            }
            UpdateSchemaInfo info = new UpdateSchemaInfo();
            this.setInfoName(info, strName);
            isExist = this.checkNameExits(info);
            if (isExist) {
                String strSameName = EASResource.getString((String)"com.kingdee.eas.fi.rpt.ReportResource.CaclSolutonUI_SameName");
                MsgBox.showInfo((Component)((Object)this), (String)strSameName);
                continue;
            }
            return strName.trim();
        }
        return null;
    }

    public void refreshUpdateSchemaView() {
        UpdateSchemaInfo updateInfo = this.getUpdateSchemaInfo();
        if (updateInfo == null) {
            this.selfClearUI();
            return;
        }
        this.kpiList.removeRows();
        this.companyList.removeRows();
        this.isCurrentSolutionChange = false;
        this.hasListSelectChange = true;
        this.beginPeriod.setValue((Object)updateInfo.getBeginPeriod());
        this.endPeriod.setValue((Object)updateInfo.getEndPeriod());
        if (null != updateInfo.getSchemaType() && updateInfo.getSchemaType().equals((Object)KPISchemaTypeEnum.KPI_CALCULATE)) {
            if (this.getPermission("mp_KPI_addnew") || this.getPermission("mp_KPI_update")) {
                this.kpiCalculate.setSelected(true);
            } else {
                this.kpiSearch.setSelected(true);
            }
        } else {
            this.kpiSearch.setSelected(true);
        }
        UpdateSchemaKPIRelaCollection c = updateInfo.getSolutionRela();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            KPIInfo ki = ((UpdateSchemaKPIRelaInfo)it.next()).getKPI();
            if (ki == null) continue;
            this.addKPITable(ki);
        }
        UpdateSchemaCompanyRelaCollection companyCols = updateInfo.getCompanyRela();
        it = companyCols.iterator();
        this.currentCompanySet.clear();
        while (it.hasNext()) {
            CompanyOrgUnitInfo companyInfo = ((UpdateSchemaCompanyRelaInfo)it.next()).getPartFI();
            if (companyInfo == null) continue;
            this.addCompanyTable(companyInfo);
            this.currentCompanySet.add(companyInfo.getId().toString());
        }
        this.hasListSelectChange = false;
    }

    private boolean saveUpdateSchema(UpdateSchemaInfo info) {
        try {
            if (info.getBeginPeriod() == null && info.getEndPeriod() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)(info.getName() + EASResource.getString((String)RES, (String)"editDate")));
                return false;
            }
            if (null != info.getEndPeriod() && null != info.getBeginPeriod() && info.getEndPeriod().before(info.getBeginPeriod())) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateBeforeEndDate"));
                return false;
            }
            if (info.getName() == null) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.UpdateSchemaNoName"));
                return false;
            }
            if (info.getSolutionRela() == null || info.getSolutionRela().size() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)(info.getName() + " : " + EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.NOKPI")));
                return false;
            }
            if (info.getCompanyRela() == null || info.getCompanyRela().size() <= 0) {
                MsgBox.showInfo((Component)((Object)this), (String)(info.getName() + " : " + EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.NO_COMPANY")));
                return false;
            }
            if (info.get(IsNew) != null) {
                BOSUuid uuid = BOSUuid.create((BOSObjectType)this.iUpdateSchema.getType());
                ObjectUuidPK pk = new ObjectUuidPK(uuid);
                info.setId(uuid);
                info.setCompany(this.currentAdminOrg);
                info.setPartFI(this.currentCompanyOrg);
                this.iUpdateSchema.submit((IObjectPK)pk, (CoreBaseInfo)info);
            } else if (info.get(IsChange) != null) {
                ObjectUuidPK schemePk = new ObjectUuidPK(info.getId());
                this.iUpdateSchema.submit((IObjectPK)schemePk, (CoreBaseInfo)info);
            }
            info.put(IsNew, null);
            info.put(IsChange, null);
        }
        catch (Exception e) {
            this.handUIException(e);
            String strSavefailed = EASResource.getString((String)(info.getName() + " :  saveFailed"));
            this.getProgressManager().popMessage(strSavefailed);
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void actionSechSave_actionPerformed(ActionEvent e) throws Exception {
        if (this.defaultUpdateSchemaInfo != null) {
            if (this.defaultUpdateSchemaInfo.getName() == null) {
                String name = this.createSchemaName();
                if (name == null) {
                    return;
                }
                this.setInfoName(this.defaultUpdateSchemaInfo, name);
            }
            if (!this.saveUpdateSchema(this.defaultUpdateSchemaInfo)) return;
            this.lstSchema.addElement((Object)this.defaultUpdateSchemaInfo);
            this.defaultUpdateSchemaInfo = null;
            this.lstSchema.setSelectedIndex(this.lstSchema.getElementCount() - 1);
            this.lstSchema.repaint();
            this.showMessageBar(EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.UpdateSchemaSaveSucess"));
            return;
        } else {
            UpdateSchemaInfo tempInfo;
            int selectedIndex = this.lstSchema.getSelectedIndex();
            if (selectedIndex < 0 || !this.saveUpdateSchema(tempInfo = (UpdateSchemaInfo)this.lstSchema.getElement(selectedIndex))) return;
            this.showMessageBar(EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.UpdateSchemaSaveSucess"));
        }
    }

    public ProgressManager getProgressManager() {
        if (this.procManager == null) {
            this.procManager = new ProgressManager((CoreUI)this);
            this.procManager.setMainStatusBar(this.getMainStatusBar());
            this.procManager.setProgressBar(ProgressManager.getProgressBar((CoreUI)this));
            this.procManager.setEstimateTime(5000);
        }
        return this.procManager;
    }

    public void actionSechDel_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.lstSchema.getSelectedValue();
        if (obj == null) {
            return;
        }
        String strSave = EASResource.getString((String)RES, (String)"confirmDelete");
        int answer = MsgBox.showConfirm2((Component)((Object)this), (String)strSave);
        if (answer == 0) {
            Object[] os = this.lstSchema.getSelectedValues();
            if (os != null) {
                for (int j = 0; j < os.length; ++j) {
                    UpdateSchemaInfo aUpdateSchemaInfo = (UpdateSchemaInfo)os[j];
                    if (aUpdateSchemaInfo.getId() != null && aUpdateSchemaInfo.getId().toString().trim().length() > 0) {
                        ObjectUuidPK pk = new ObjectUuidPK(aUpdateSchemaInfo.getId());
                        this.iUpdateSchema.delete((IObjectPK)pk);
                    }
                    this.lstSchema.removeElement((Object)aUpdateSchemaInfo);
                }
            }
            this.selfClearUI();
            if (this.lstSchema.getElementCount() != 0) {
                this.lstSchema.setSelectedIndex(0);
                this.refreshUpdateSchemaView();
            }
        }
    }

    public void actionSchedule_actionPerformed(ActionEvent e) throws Exception {
        super.actionSchedule_actionPerformed(e);
        String tempSchedule = ProcessSchedulePlan.open((Object)((Object)this), (String)this.getUpdateSchemaInfo().getIntervalSetted());
        if (tempSchedule != null) {
            this.getUpdateSchemaInfo().setIntervalSetted(tempSchedule);
            this.setChange();
        }
    }

    public UpdateSchemaInfo getUpdateSchemaInfo() {
        if (this.lstSchema.getElementCount() == 0 && this.defaultUpdateSchemaInfo == null) {
            this.defaultUpdateSchemaInfo = new UpdateSchemaInfo();
            this.defaultUpdateSchemaInfo.setActionType(MenuCreateKpi);
            this.defaultUpdateSchemaInfo.setJobProcessDef(MenuCreateKpi);
            this.defaultUpdateSchemaInfo.put(IsNew, IsNew);
        }
        if (this.defaultUpdateSchemaInfo != null) {
            return this.defaultUpdateSchemaInfo;
        }
        int selectIndex = this.lstSchema.getSelectedIndex();
        if (selectIndex >= 0) {
            return (UpdateSchemaInfo)this.lstSchema.getElement(selectIndex);
        }
        if (this.lstSchema.getElementCount() > 0) {
            return (UpdateSchemaInfo)this.lstSchema.getElement(0);
        }
        return null;
    }

    public AdminOrgUnitInfo getAdminOrgUnitInfo() {
        return this.currentAdminOrg;
    }

    public void setAdminOrgUnitInfo(AdminOrgUnitInfo adminOrgUnitInfo) {
        this.currentAdminOrg = adminOrgUnitInfo;
    }

    protected String getObjectUpdateId() {
        UpdateSchemaInfo updateSchemaInfo = this.getUpdateSchemaInfo();
        if (updateSchemaInfo != null && updateSchemaInfo.getId() != null && updateSchemaInfo.getId().toString().length() != 0) {
            return updateSchemaInfo.getId().toString();
        }
        return null;
    }

    public void onShow() throws Exception {
        super.onShow();
        RptHelper.setEscAction((CoreUIObject)this, (Action)this.actionExitCurrent);
    }

    private void showMessageBar(String msg) {
        this.setMessageText(msg);
        this.showMessage();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    public boolean isSelectKPIOK() {
        return this.selectKPIOK;
    }

    public void setSelectKPIOK(boolean selectKPIOK) {
        this.selectKPIOK = selectKPIOK;
    }

    protected void beginPeriod_dataChanged(DataChangeEvent e) throws Exception {
        UpdateSchemaInfo updateInfo;
        if (this.hasListSelectChange) {
            return;
        }
        Object beginObj = this.beginPeriod.getValue();
        Object endObj = this.endPeriod.getValue();
        if (beginObj != null && endObj != null) {
            Date bDate = (Date)beginObj;
            Date eDate = (Date)endObj;
            if (this.dateCompare(bDate, eDate) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateBeforeEndDate"));
                this.beginPeriod.setValue(null);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)beginObj);
            int beginYear = calendar.get(1);
            calendar.setTime((Date)endObj);
            int endYear = calendar.get(1);
            if (beginYear != endYear) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"theSameYear"));
                this.beginPeriod.setValue(null);
                return;
            }
        }
        if ((updateInfo = this.getUpdateSchemaInfo()) != null && this.beginPeriod.getValue() != null) {
            updateInfo.setBeginPeriod((Date)this.beginPeriod.getValue());
            this.setChange();
        }
    }

    protected void endPeriod_dataChanged(DataChangeEvent e) throws Exception {
        UpdateSchemaInfo updateInfo;
        if (this.hasListSelectChange) {
            return;
        }
        Object beginObj = this.beginPeriod.getValue();
        Object endObj = this.endPeriod.getValue();
        if (beginObj != null && endObj != null) {
            Date bDate = (Date)beginObj;
            Date eDate = (Date)endObj;
            if (this.dateCompare(bDate, eDate) > 0) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"endDateAfterBeginDate"));
                this.endPeriod.setValue(null);
                return;
            }
            Calendar calendar = Calendar.getInstance();
            calendar.setTime((Date)beginObj);
            int beginYear = calendar.get(1);
            calendar.setTime((Date)endObj);
            int endYear = calendar.get(1);
            if (beginYear != endYear) {
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"theSameYear"));
                this.endPeriod.setValue(null);
                return;
            }
        }
        if ((updateInfo = this.getUpdateSchemaInfo()) != null && this.endPeriod.getValue() != null) {
            updateInfo.setEndPeriod((Date)this.endPeriod.getValue());
            this.setChange();
        }
    }

    public void actionExecute_actionPerformed(ActionEvent e) throws Exception {
        UpdateSchemaInfo updateInfo;
        if (!this.verify()) {
            SysUtil.abort();
        }
        if ((updateInfo = this.getUpdateSchemaInfo()).getSchemaType() == KPISchemaTypeEnum.KPI_CALCULATE) {
            this.calculate(updateInfo);
        }
        this.queryKPIValue(updateInfo);
    }

    public boolean verify() throws Exception {
        if (this.beginPeriod.getValue() == null && this.endPeriod.getValue() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"editDate"));
            return false;
        }
        if (this.kpiList.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_kpi"));
            return false;
        }
        if (this.companyList.getRowCount() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_org"));
            return false;
        }
        if (null != this.endPeriod.getValue() && null != this.beginPeriod.getValue() && ((Date)this.endPeriod.getValue()).before((Date)this.beginPeriod.getValue())) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"beginDateBeforeEndDate"));
            return false;
        }
        return true;
    }

    private void calculate(final UpdateSchemaInfo updateInfo) {
        if (updateInfo.getBeginPeriod() == null && updateInfo.getEndPeriod() == null) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"editDate"));
            return;
        }
        if (updateInfo.getSolutionRela().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_kpi"));
            return;
        }
        if (updateInfo.getCompanyRela().size() <= 0) {
            MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"add_org"));
            return;
        }
        Window win = KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow();
        LongTimeDialog ltd = null;
        ltd = win instanceof Frame ? new LongTimeDialog((Frame)win) : (win instanceof Dialog ? new LongTimeDialog((Dialog)win) : new LongTimeDialog(new JFrame()));
        ltd.getText().setText(EASResource.getString((String)RES, (String)"kpi_updating"));
        ltd.setTitle(EASResource.getString((String)RES, (String)"updating"));
        ltd.setLongTimeTask(new ILongTimeTask(){

            public Object exec() throws Exception {
                try {
                    UpdateSchemaFactory.getRemoteInstance().createOrUpdateKPI(updateInfo);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return new Boolean(true);
            }

            public void afterExec(Object result) throws Exception {
            }
        });
        ltd.show();
        MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"update_complete"));
    }

    private void queryKPIValue(UpdateSchemaInfo updateInfo) {
        try {
            UIContext uiContext = new UIContext((Object)this);
            LinkedHashMap orderMap = new LinkedHashMap();
            this.setCompanyOrder(orderMap);
            uiContext.put((Object)"updateInfo", (Object)updateInfo);
            uiContext.put((Object)"orderMap", orderMap);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.NEWWIN).create(KPIQueryResultUI.class.getName(), (Map)uiContext, null, null);
            uiWindow.show();
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    private void setCompanyOrder(Map orderMap) {
        KDTable table = this.companyList;
        String companyName = "";
        IRow iRow = null;
        for (int i = 0; i < table.getRowCount(); ++i) {
            iRow = table.getRow(i);
            companyName = (String)iRow.getCell("name").getValue();
            orderMap.put(new Integer(i), companyName);
        }
    }

    private int dateCompare(Date bDate, Date eDate) {
        int eDay;
        int eMonth;
        Calendar bCalendar = Calendar.getInstance();
        bCalendar.setTime(bDate);
        Calendar eCalendar = Calendar.getInstance();
        eCalendar.setTime(eDate);
        int bYear = bCalendar.get(1);
        int eYear = eCalendar.get(1);
        if (bYear < eYear) {
            return -1;
        }
        if (bYear > eYear) {
            return 1;
        }
        int bMonth = bCalendar.get(2);
        if (bMonth < (eMonth = eCalendar.get(2))) {
            return -1;
        }
        if (bMonth > eMonth) {
            return 1;
        }
        int bDay = bCalendar.get(5);
        if (bDay < (eDay = eCalendar.get(5))) {
            return -1;
        }
        if (bDay > eDay) {
            return 1;
        }
        return 0;
    }

    protected void kpiCalculate_actionPerformed(ActionEvent e) throws Exception {
        UpdateSchemaInfo updateInfo = this.getUpdateSchemaInfo();
        updateInfo.setSchemaType(KPISchemaTypeEnum.KPI_CALCULATE);
        this.setChange();
    }

    protected void kpiSearch_actionPerformed(ActionEvent e) throws Exception {
        UpdateSchemaInfo updateInfo = this.getUpdateSchemaInfo();
        updateInfo.setSchemaType(KPISchemaTypeEnum.KPI_SEARCH);
        this.setChange();
    }

    public boolean destroyWindow() {
        if ((this.queryPermission || this.kpiPermission) && this.checkSaveUpdateSchemaInfo(this.getUpdateSchemaInfo())) {
            return super.destroyWindow();
        }
        return false;
    }

    private boolean checkSaveUpdateSchemaInfo(UpdateSchemaInfo schemaInfo) {
        int result;
        if (schemaInfo == null) {
            return true;
        }
        if (schemaInfo.get(IsNew) != null && schemaInfo.get(IsChange) != null ? (result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"updateSchema_notSave"))) == 0 : schemaInfo.get(IsChange) != null && (result = MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)RES, (String)"updateSchema_ischange"))) == 0) {
            return this.saveUpdateSchema(schemaInfo);
        }
        return true;
    }

    public boolean isPrepareInit() {
        return true;
    }

    public boolean isPrepareActionExecute() {
        return true;
    }

    public RequestContext prepareActionExecute(IItemAction itemAction) throws Exception {
        RequestContext request = super.prepareActionExecute(itemAction);
        return request;
    }

    public IUIActionPostman prepareInit() {
        IUIActionPostman clientHanlder = super.prepareInit();
        RequestContext request = (RequestContext)clientHanlder.getRequestContext();
        request.put("userPk", (Object)this.getUserPk());
        IObjectPK orgPK = null;
        orgPK = this.getOrgPK(null);
        if (orgPK == null && this.getUIContext().get(this.getMainBizOrgType()) != null) {
            orgPK = new ObjectUuidPK(((OrgUnitInfo)this.getUIContext().get(this.getMainBizOrgType())).getId());
        }
        request.put("orgPk", (Object)orgPK);
        request.put("companyOrgUnitInfo", (Object)SysContext.getSysContext().getCurrentFIUnit());
        return clientHanlder;
    }
}

