/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.swing.KDTree;
import com.kingdee.bos.ctrl.swing.event.TreeExpansionAdapter;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.INewOrgViewFacade;
import com.kingdee.eas.basedata.org.IOrgStructure;
import com.kingdee.eas.basedata.org.NewOrgViewFacadeFactory;
import com.kingdee.eas.basedata.org.OrgStructureFactory;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.client.tree.DefaultLNOrgTreeNodeCtrl;
import com.kingdee.eas.basedata.org.client.tree.ILNOrgTreeNodeCtrl;
import com.kingdee.eas.basedata.org.client.tree.LNOrgTreeBuilder;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.client.tree.KDTreeNode;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MpOrgTreeUtil {
    private static final Icon groupIcon = EASResource.getIcon((String)"imgTree_group");
    private static final Icon companyIcon = EASResource.getIcon((String)"imgTree_company");

    public static void createOrgTree(final KDTree tree, OrgTreeInfo treeInfo, int initialLevel, int expandLevel, boolean isGroup, FilterInfo filter, boolean isInAvailGroup) throws Exception {
        if (treeInfo == null) {
            return;
        }
        IOrgStructure iOrgStruc = null;
        iOrgStruc = OrgStructureFactory.getRemoteInstance();
        DefaultLNOrgTreeNodeCtrl nodeCtrls = new DefaultLNOrgTreeNodeCtrl(iOrgStruc, treeInfo, isInAvailGroup);
        LNOrgTreeBuilder treeBuilder = null;
        treeBuilder = new LNOrgTreeBuilder((ILNOrgTreeNodeCtrl)nodeCtrls, initialLevel, expandLevel, isGroup, isInAvailGroup);
        KDTreeNode rootNode = null;
        if (tree.getModel() != null && tree.getModel().getRoot() != null && tree.getModel().getRoot() instanceof KDTreeNode) {
            rootNode = (KDTreeNode)tree.getModel().getRoot();
        } else {
            rootNode = new KDTreeNode((Object)"");
            tree.setRootVisible(false);
            tree.setShowsRootHandles(true);
        }
        IRowSet rows = null;
        INewOrgViewFacade facade = NewOrgViewFacadeFactory.getRemoteInstance();
        rows = facade.buildRowSetByCU(SysContext.getSysContext().getCurrentCtrlUnit().getCU().getId().toString(), "00000000-0000-0000-0000-0000000000034F2827FD");
        if (rows != null && rows.size() == 1) {
            tree.putClientProperty((Object)"JTree.lineStyle", (Object)"None");
        } else {
            tree.putClientProperty((Object)"JTree.lineStyle", (Object)"Angled");
        }
        if (rows != null) {
            // empty if block
        }
        tree.addTreeExpansionListener((TreeExpansionListener)new TreeExpansionAdapter(){

            public void treeCollapsed(TreeExpansionEvent event) {
                if (event.getPath().getLastPathComponent().equals(tree.getModel().getRoot())) {
                    tree.expandPath(new TreePath(tree.getModel().getRoot()));
                }
            }
        });
        tree.setRootVisible(true);
        tree.setModel((TreeModel)new DefaultTreeModel((TreeNode)MpOrgTreeUtil.buildTreeNodeByRowSet(rows)));
        tree.setShowsRootHandles(true);
    }

    private static DefaultKingdeeTreeNode buildTreeNodeByRowSet(IRowSet rows) throws Exception {
        if (rows == null) {
            return null;
        }
        KDTreeNode rootTreeNode = null;
        HashMap<String, KDTreeNode> nodeMap = new HashMap<String, KDTreeNode>();
        while (rows.next()) {
            AdminOrgUnitInfo adminInfo = MpOrgTreeUtil.createAdminUnitInfo(rows);
            if (rootTreeNode == null) {
                rootTreeNode = new KDTreeNode((Object)adminInfo);
                rootTreeNode.setCustomIcon(groupIcon);
                nodeMap.put(adminInfo.getId().toString(), rootTreeNode);
                continue;
            }
            KDTreeNode subTreeNode = new KDTreeNode((Object)adminInfo);
            subTreeNode.setCustomIcon(companyIcon);
            if (nodeMap.containsKey(adminInfo.getParent().getId().toString())) {
                ((DefaultKingdeeTreeNode)nodeMap.get(adminInfo.getParent().getId().toString())).add((MutableTreeNode)subTreeNode);
            }
            nodeMap.put(adminInfo.getId().toString(), subTreeNode);
        }
        return rootTreeNode;
    }

    private static AdminOrgUnitInfo createAdminUnitInfo(IRowSet row) throws Exception {
        AdminOrgUnitInfo adminInfo = new AdminOrgUnitInfo();
        adminInfo.setId(BOSUuid.read((String)row.getString("id")));
        adminInfo.setName(row.getString("name"));
        adminInfo.setNumber(row.getString("number"));
        adminInfo.setLongNumber(row.getString("longNumber"));
        adminInfo.setLevel(row.getInt("level"));
        adminInfo.setIsLeaf(row.getBoolean("isLeaf"));
        AdminOrgUnitInfo parentInfo = new AdminOrgUnitInfo();
        if (row.getString("parent.id") == null || row.getString("parent.id").equals("")) {
            parentInfo = null;
        } else {
            parentInfo.setId(BOSUuid.read((String)row.getString("parent.id")));
        }
        adminInfo.setParent(parentInfo);
        return adminInfo;
    }
}

