/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSelectManager;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeInfo;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.client.f7.CompanyF7;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.sem.mp.OrgClassEntryCollection;
import com.kingdee.eas.sem.mp.OrgClassEntryFactory;
import com.kingdee.eas.sem.mp.OrgClassEntryInfo;
import com.kingdee.eas.sem.mp.OrgClassFactory;
import com.kingdee.eas.sem.mp.OrgClassGroupInfo;
import com.kingdee.eas.sem.mp.OrgClassInfo;
import com.kingdee.eas.sem.mp.client.AbstractOrgClassEditUI;
import com.kingdee.eas.sem.mp.client.KPISpecialCompanyTreeHandler;
import com.kingdee.eas.util.SysUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.event.ActionEvent;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import javax.swing.tree.TreeModel;
import org.apache.log4j.Logger;

public class OrgClassEditUI
extends AbstractOrgClassEditUI {
    private static final Logger logger = CoreUIObject.getLogger(OrgClassEditUI.class);
    protected static final String RES = "com.kingdee.eas.sem.mp.client.KPIResource";

    public void onLoad() throws Exception {
        CtrlUnitInfo cuInfo = SysContext.getSysContext().getCurrentCtrlUnit().getCU();
        this.prmtCU.setData((Object)cuInfo);
        super.onLoad();
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString()));
        evi.setFilter(filter);
        this.prmtClassGroup.setEntityViewInfo(evi);
        KDTSortManager sm = new KDTSortManager(this.kdtEntries);
        sm.setSortAuto(true);
        this.kdtEntries.getColumn("number").setSortable(true);
        this.kdtEntries.getColumn("name").setSortable(true);
        this.kdtEntries.getColumn("name").getStyleAttributes().setLocked(true);
        this.kdtEntries.getColumn("number").getStyleAttributes().setLocked(true);
    }

    protected void verifyInput(ActionEvent e) throws Exception {
        if (this.editData.getName() == null || this.editData.getName().trim().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u586b\u5199\u5206\u7c7b\u540d\u79f0");
            SysUtil.abort();
        }
        if (this.editData.getClassGroup() == null || this.editData.getClassGroup().getName().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u9009\u62e9\u5206\u7c7b\u7ec4\u540d\u79f0");
            SysUtil.abort();
        }
        if (this.editData.getNumber() == null || this.editData.getNumber().trim().equalsIgnoreCase("")) {
            MsgBox.showInfo((String)"\u8bf7\u586b\u5199\u7c7b\u522b\u7f16\u7801");
            SysUtil.abort();
        }
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.actionNext.setVisible(false);
        this.actionPre.setVisible(false);
        this.actionLast.setVisible(false);
        this.actionFirst.setVisible(false);
        this.actionPrintPreview.setVisible(false);
        this.actionPrint.setVisible(false);
        this.actionCancelCancel.setVisible(false);
        this.actionCancel.setVisible(false);
        this.actionSave.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
        this.menuBiz.setVisible(false);
        this.actionAddCompany.setEnabled(true);
        this.actionDelCompany.setEnabled(true);
        if (this.getOprtState().equalsIgnoreCase("VIEW")) {
            this.actionAddCompany.setEnabled(false);
            this.actionDelCompany.setEnabled(false);
        }
        this.addCompany.setIcon(EASResource.getIcon((String)"imgTbtn_new"));
        this.addCompany.setToolTipText(EASResource.getString((String)"add"));
        this.delCompany.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.delCompany.setToolTipText(EASResource.getString((String)"delete"));
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
        if (this.getOprtState().equalsIgnoreCase("EDIT")) {
            this.actionAddCompany.setEnabled(true);
            this.actionDelCompany.setEnabled(true);
        }
    }

    public void storeFields() {
        super.storeFields();
    }

    public void loadFields() {
        super.loadFields();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        view.setFilter(filter);
        view.getSelector().add(new SelectorItemInfo("company.id"));
        view.getSelector().add(new SelectorItemInfo("company.name"));
        view.getSelector().add(new SelectorItemInfo("company.number"));
        filter.getFilterItems().add(new FilterItemInfo("orgClass", (Object)this.editData.getId()));
        this.kdtEntries.removeRows();
        this.kdtEntries.checkParsed();
        try {
            OrgClassEntryInfo entryInfo = null;
            OrgClassEntryCollection cols = OrgClassEntryFactory.getRemoteInstance().getOrgClassEntryCollection(view);
            if (null != cols && cols.size() > 0) {
                IRow row = null;
                for (int i = 0; i < cols.size(); ++i) {
                    entryInfo = cols.get(i);
                    row = this.kdtEntries.addRow();
                    row.getCell("id").setValue((Object)entryInfo.getCompany().getId());
                    row.getCell("number").setValue((Object)entryInfo.getCompany().getNumber());
                    row.getCell("name").setValue((Object)entryInfo.getCompany().getName());
                    row.setUserObject((Object)entryInfo.getCompany());
                }
            }
        }
        catch (Exception e) {
            this.handleException(e);
        }
    }

    public void actionSubmit_actionPerformed(ActionEvent e) throws Exception {
        this.prepareSubmit1();
        super.actionSubmit_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        OrgClassInfo orgClass = new OrgClassInfo();
        orgClass.setId(BOSUuid.create((BOSObjectType)orgClass.getBOSType()));
        UserInfo user = SysContext.getSysContext().getCurrentUserInfo();
        orgClass.setCreator(user);
        orgClass.setCreateTime(this.getTime());
        orgClass.setCU((CtrlUnitInfo)this.prmtCU.getData());
        return orgClass;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return OrgClassFactory.getRemoteInstance();
    }

    private void prepareSubmit1() {
        this.editData.getEntries().clear();
        this.editData.setClassGroup((OrgClassGroupInfo)this.prmtClassGroup.getData());
        OrgClassEntryCollection cols = new OrgClassEntryCollection();
        int count = this.kdtEntries.getRowCount();
        OrgClassEntryInfo entryInfo = null;
        for (int i = 0; i < count; ++i) {
            entryInfo = new OrgClassEntryInfo();
            IRow tempRow = this.kdtEntries.getRow(i);
            entryInfo.setCompany((CompanyOrgUnitInfo)tempRow.getUserObject());
            entryInfo.setOrgClass(this.editData);
            cols.add(entryInfo);
        }
        this.editData.getEntries().addCollection(cols);
    }

    private Timestamp getTime() {
        Date date = new Date();
        long time = date.getTime();
        Calendar d = Calendar.getInstance();
        d.setTime(new Timestamp(time));
        d.set(14, 0);
        Timestamp createtime = new Timestamp(d.getTime().getTime());
        return createtime;
    }

    public void actionAddCompany_actionPerformed(ActionEvent e) throws Exception {
        OrgUnitInfo[] tempOrgInfo;
        String orgId = null == SysContext.getSysContext().getCurrentFIUnit() ? null : SysContext.getSysContext().getCurrentFIUnit().getId().toString();
        CompanyF7 af7 = new CompanyF7();
        af7.setMultiSelect(true);
        af7.setRootUnitID(orgId);
        af7.disablePerm(this.getMap(), true);
        OrgTreeInfo oti = new OrgTreeInfo();
        oti.setId(BOSUuid.read((String)"00000000-0000-0000-0000-0000000000034F2827FD"));
        TreeModel model = af7.getTreeModel(OrgViewType.ADMIN, oti);
        HashMap newMap = KPISpecialCompanyTreeHandler.getTreeCols(model);
        CompanyF7 newAF7 = new CompanyF7();
        newAF7.setMultiSelect(true);
        newAF7.setRootUnitID(orgId);
        newAF7.disablePerm(newMap, true);
        newAF7.show();
        if (newAF7.isCanceled()) {
            return;
        }
        Object obj = newAF7.getData();
        if (obj instanceof OrgUnitInfo[] && (tempOrgInfo = (OrgUnitInfo[])obj) != null && tempOrgInfo.length > 0) {
            boolean isAdd = false;
            if (tempOrgInfo != null && tempOrgInfo.length > 0) {
                for (int i = 0; i < tempOrgInfo.length; ++i) {
                    IRow tempRow;
                    isAdd = false;
                    OrgUnitInfo tempOuInfo = tempOrgInfo[i];
                    String ouId = tempOuInfo.getId().toString();
                    int rowCount = this.kdtEntries.getRowCount();
                    if (rowCount > 0) {
                        for (int j = 0; j < rowCount; ++j) {
                            String addOuId = this.kdtEntries.getRow(j).getCell("id").getValue().toString();
                            if (!ouId.equals(addOuId)) continue;
                            isAdd = true;
                            break;
                        }
                        if (isAdd) continue;
                        tempRow = this.kdtEntries.addRow();
                        tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                        tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                        tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                        tempRow.setUserObject((Object)tempOrgInfo[i]);
                        continue;
                    }
                    tempRow = this.kdtEntries.addRow();
                    tempRow.getCell("id").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getId());
                    tempRow.getCell("number").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getNumber());
                    tempRow.getCell("name").setValue((Object)((CompanyOrgUnitInfo)tempOrgInfo[i]).getName());
                    tempRow.setUserObject((Object)tempOrgInfo[i]);
                }
            }
        }
    }

    public void actionDelCompany_actionPerformed(ActionEvent e) throws Exception {
        KDTSelectManager kdtSelectManager = this.kdtEntries.getSelectManager();
        if (null == this.kdtEntries.getSelectManager() || kdtSelectManager.size() < 1) {
            MsgBox.showConfirm2((String)EASResource.getString((String)RES, (String)"no_select"));
            return;
        }
        int[] selectRows = KDTableUtil.getSelectedRows((KDTable)this.kdtEntries);
        if (selectRows.length > 0) {
            for (int i = selectRows.length - 1; i >= 0; --i) {
                IRow row = this.kdtEntries.getRow(selectRows[i]);
                if (row == null) continue;
                row = this.kdtEntries.removeRow(selectRows[i]);
            }
        }
    }

    private HashMap getMap() {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        try {
            CompanyOrgUnitCollection coms = CompanyOrgUnitFactory.getRemoteInstance().getCompanyOrgUnitCollection("select id");
            map = new HashMap();
            int n = coms.size();
            for (int i = 0; i < n; ++i) {
                map.put(coms.get(i).getId().toString(), new Boolean(false));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            return null;
        }
        return map;
    }
}

