/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.event.KDTSelectEvent;
import com.kingdee.bos.ctrl.kdf.util.render.IBasicRender;
import com.kingdee.bos.ctrl.kdf.util.render.SimpleTextRender;
import com.kingdee.bos.ctrl.kdf.util.style.Style;
import com.kingdee.bos.ctrl.swing.tree.DefaultKingdeeTreeNode;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.resource.BizEnumValueInfo;
import com.kingdee.bos.ui.face.IUIWindow;
import com.kingdee.bos.ui.face.UIFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgTreeCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.common.client.UIContext;
import com.kingdee.eas.common.client.UIFactoryName;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.DeletedStatusEnum;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.ITreeBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.IRefGroup;
import com.kingdee.eas.sem.mp.KPIValueRefStandardValueFactory;
import com.kingdee.eas.sem.mp.MPResUtil;
import com.kingdee.eas.sem.mp.RefGroupFactory;
import com.kingdee.eas.sem.mp.RefGroupInfo;
import com.kingdee.eas.sem.mp.client.AbstractRefGroupTreeListUI;
import com.kingdee.eas.sem.mp.client.ImportGroupRefsExtendedDlg;
import com.kingdee.eas.sem.mp.client.RefGroupEditUI;
import com.kingdee.eas.sem.mp.util.MCUtil;
import com.kingdee.eas.util.client.EASResource;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.eas.util.client.MsgBox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Shape;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.Map;

public class RefGroupTreeListUI
extends AbstractRefGroupTreeListUI {
    private OrgTreeCollection treeInfos;
    private static final String resName = "com.kingdee.eas.base.forewarn.client.Forewarn";
    private static String kpiResouce = "com.kingdee.eas.sem.mp.client.KPIResource";
    private Color deletedColor = new Color(232, 232, 227);
    private boolean isConfirm = false;

    protected String getEditUIModal() {
        return UIFactoryName.MODEL;
    }

    public void onLoad() throws Exception {
        super.onLoad();
        this.tblMain.getColumn("deletedStatus").setRenderer(new IBasicRender(){

            public void draw(Graphics graphics, Shape clip, Object object, Style cellStyle) {
                int flag = ((BizEnumValueInfo)object).getInt();
                String display = "";
                if (flag == 2) {
                    display = EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.DELETEDSTATE");
                } else if (flag == 1) {
                    display = EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.NORMALSTATE");
                }
                new SimpleTextRender().draw(graphics, clip, display, cellStyle);
            }
        });
        this.btnDisable.setVisible(false);
        this.btnEnable.setVisible(false);
    }

    protected FilterInfo getDefaultFilterForQuery() {
        return null;
    }

    public void loadFields() {
        super.loadFields();
    }

    protected void initWorkButton() {
        super.initWorkButton();
        this.btnEnable.setIcon(EASResource.getIcon((String)"imgTbtn_staruse"));
        this.btnDisable.setIcon(EASResource.getIcon((String)"imgTbtn_forbid"));
        this.btnImportData.setText(EASResource.getString((String)"com.kingdee.eas.basedata.master.account.client.AccountResource", (String)"import"));
        this.btnImportData.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.menuItemImport.setIcon(EASResource.getIcon((String)"imgTbtn_importcyclostyle"));
        this.menuItemImport.setEnabled(true);
    }

    protected void menuItemImportData_actionPerformed(ActionEvent e) throws Exception {
        super.menuItemImportData_actionPerformed(e);
        this.importAction();
    }

    public void actionRemove_actionPerformed(ActionEvent e) throws Exception {
        super.actionRemove_actionPerformed(e);
    }

    public void actionImport_actionPerformed(ActionEvent e) throws Exception {
        if (null == ((DefaultKingdeeTreeNode)this.treeMain.getLastSelectedPathComponent()).getUserObject()) {
            MsgBox.showInfo((Component)((Object)this), (String)MCUtil.getString("notAdminOrg"));
            return;
        }
        this.importAction();
    }

    private void importAction() throws Exception {
        CompanyOrgUnitInfo currentAdminOrg = this.getCurrentCompany();
        CompanyOrgUnitInfo parentAdminOrg = this.getParentCompany(currentAdminOrg);
        if (parentAdminOrg == null) {
            MsgBox.showInfo((Component)((Object)this), (String)MPResUtil.getRes("NoCUpCompany"));
        } else {
            UIContext uiContext = new UIContext((Object)this);
            uiContext.put((Object)"currentAdminOrg", (Object)currentAdminOrg);
            uiContext.put((Object)"parentAdminOrg", (Object)parentAdminOrg);
            this.setConfirm(false);
            uiContext.put((Object)"parentUI", (Object)this);
            HashMap<String, CompanyOrgUnitInfo> orgMap = new HashMap<String, CompanyOrgUnitInfo>();
            orgMap.put("currentAdminOrg", currentAdminOrg);
            orgMap.put("parentAdminOrg", parentAdminOrg);
            IUIWindow uiWindow = UIFactory.createUIFactory((String)UIFactoryName.MODEL).create(ImportGroupRefsExtendedDlg.class.getName(), (Map)uiContext, null, OprtState.VIEW);
            uiWindow.show();
            IObjectPK[] selectedPKs = ImportGroupRefsExtendedDlg.selectedPKs;
            if (this.isConfirm() && selectedPKs != null && selectedPKs.length > 0) {
                IRefGroup iRef = RefGroupFactory.getRemoteInstance();
                iRef.importDataFromParent(selectedPKs, orgMap);
                this.refreshList();
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)kpiResouce, (String)"ref_import_success"));
            }
        }
    }

    protected void initTree() throws Exception {
    }

    protected void execQuery() {
        super.execQuery();
        this.setBackColor();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected ITreeBase getTreeInterface() throws Exception {
        return null;
    }

    protected ICoreBase getBizInterface() throws Exception {
        return RefGroupFactory.getRemoteInstance();
    }

    protected String getEditUIName() {
        return RefGroupEditUI.class.getName();
    }

    public void onShow() throws Exception {
        super.onShow();
        this.setBackColor();
    }

    private void setBackColor() {
        int rowCount = this.tblMain.getRowCount();
        for (int i = 0; i < rowCount; ++i) {
            IRow row = this.tblMain.getRow(i);
            Object obj = row.getCell("deletedStatus").getValue();
            if (obj == null || ((BizEnumValueInfo)obj).getInt() != 2) continue;
            row.getStyleAttributes().setBackground(this.deletedColor);
        }
    }

    protected void refresh(ActionEvent e) throws Exception {
        this.buildTreeFilter();
        this.execQuery();
    }

    public void tblMain_tableSelectChanged(KDTSelectEvent e) throws Exception {
        String id;
        if (this.tblMain.getRowCount() > 0 && (id = this.getSelectedKeyValue().trim()) != "") {
            IRefGroup refGroup = (IRefGroup)this.getBizInterface();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add("id");
            selector.add("parent.id");
            RefGroupInfo refGroupInfo = refGroup.getRefGroupInfo((IObjectPK)new ObjectUuidPK(id), selector);
            if (refGroupInfo.getParent() != null) {
                this.actionEdit.setEnabled(false);
            } else {
                this.actionEdit.setEnabled(true);
            }
        }
    }

    public void actionEnable_actionPerformed(ActionEvent e) throws Exception {
        super.actionEnable_actionPerformed(e);
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"selectEnableItemWarning"));
            return;
        }
        int selectedRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)this.tblMain.getRow(selectedRowIndex).getCell(0).getValue().toString()));
        RefGroupInfo refGroupInfo = ((IRefGroup)this.getBizInterface()).getRefGroupInfo((IObjectPK)objectPK);
        if (refGroupInfo.getDeletedStatus() == DeletedStatusEnum.NORMAL) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"itemAlreadyEnable"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"enableItemAlert")) == 0) {
            try {
                refGroupInfo.setDeletedStatus(DeletedStatusEnum.NORMAL);
                ((IRefGroup)this.getBizInterface()).update((IObjectPK)new ObjectUuidPK(refGroupInfo.getId()), (CoreBaseInfo)refGroupInfo);
                RefGroupFactory.getRemoteInstance().insertNewDataToKPI((IObjectValue)refGroupInfo);
                MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"enableItemSucceed"));
                this.refresh(e);
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"enableItemFail"), (Throwable)e1);
            }
        }
    }

    public void actionDisable_actionPerformed(ActionEvent e) throws Exception {
        super.actionDisable_actionPerformed(e);
        if (this.tblMain.getSelectManager().size() == 0) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"selectDisableItemWarning"));
            return;
        }
        int selectedRowIndex = this.tblMain.getSelectManager().getActiveRowIndex();
        ObjectUuidPK objectPK = new ObjectUuidPK(BOSUuid.read((String)this.tblMain.getRow(selectedRowIndex).getCell(0).getValue().toString()));
        RefGroupInfo refGroupInfo = ((IRefGroup)this.getBizInterface()).getRefGroupInfo((IObjectPK)objectPK);
        if (refGroupInfo.getDeletedStatus().equals((Object)DeletedStatusEnum.DELETED)) {
            MsgBox.showWarning((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"itemAlreadyDisable"));
            return;
        }
        if (MsgBox.showConfirm2((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"disableItemAlert")) == 0) {
            try {
                if (!this.isRefByKpiValue(refGroupInfo.getId().toString())) {
                    refGroupInfo.setDeletedStatus(DeletedStatusEnum.DELETED);
                    ((IRefGroup)this.getBizInterface()).update((IObjectPK)new ObjectUuidPK(refGroupInfo.getId()), (CoreBaseInfo)refGroupInfo);
                    MsgBox.showInfo((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"disableItemSucceed"));
                    RefGroupFactory.getRemoteInstance().deleteDataFromKPI((IObjectValue)refGroupInfo);
                    this.refresh(e);
                } else {
                    MsgBox.showInfo((String)EASResource.getString((String)"com.kingdee.eas.sem.mp.MPResource.Refed_CanNotUnAble"));
                }
            }
            catch (Exception e1) {
                ExceptionHandler.handle((Component)((Object)this), (String)EASResource.getString((String)resName, (String)"disableItemFail"), (Throwable)e1);
            }
        }
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    private boolean isRefByKpiValue(String refId) throws EASBizException, BOSException {
        FilterInfo filter1 = new FilterInfo();
        filter1.getFilterItems().add(new FilterItemInfo("refGroup.id", (Object)refId));
        return KPIValueRefStandardValueFactory.getRemoteInstance().exists(filter1);
    }

    public boolean isConfirm() {
        return this.isConfirm;
    }

    public void setConfirm(boolean isConfirm) {
        this.isConfirm = isConfirm;
    }

    public boolean isPrepareInit() {
        return false;
    }
}

