/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.ctrl.kdf.table.KDTSortManager;
import com.kingdee.bos.ctrl.kdf.table.KDTable;
import com.kingdee.bos.ctrl.kdf.table.util.KDTableUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.sem.mp.KPIException;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.client.AbstractSelectKPINewUI;
import java.awt.event.ActionEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.log4j.Logger;

public class SelectKPINewUI
extends AbstractSelectKPINewUI {
    private static final Logger logger = CoreUIObject.getLogger(SelectKPINewUI.class);
    private List dataList;
    private Object parent;
    private CompanyOrgUnitInfo currentCompanyOrg = null;
    private HashMap params = new HashMap();

    public void onLoad() throws Exception {
        this.queryKPISelectQuery = new EntityViewInfo();
        this.currentCompanyOrg = SysContext.getSysContext().getCurrentFIUnit();
        if (this.currentCompanyOrg == null) {
            throw new KPIException(KPIException.NOT_COMPNAYORTUNIT);
        }
        super.onLoad();
        this.params = (HashMap)this.getUIContext().get("params");
        String orgId = (String)this.getUIContext().get("currentOrg");
        this.btnOK.setEnabled(true);
        this.btnCancel.setEnabled(true);
        this.kpiList.checkParsed();
        this.kpiList.getStyleAttributes().setLocked(true);
        this.kpiList.getSelectManager().setSelectMode(10);
        Object obj = this.getUIContext().get("Data");
        this.dataList = (List)obj;
        Set selectKpi = (Set)this.getUIContext().get("hasSelected");
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("partfi.id", (Object)orgId, CompareType.EQUALS));
        if (selectKpi != null && selectKpi.size() > 0) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)selectKpi, CompareType.NOTINCLUDE));
        }
        this.queryKPISelectQuery.setFilter(filter);
        this.setTableSort();
    }

    public void actionCancel_actionPerformed(ActionEvent e) throws Exception {
        this.params.put("isConfirm", Boolean.FALSE);
        this.getUIWindow().close();
    }

    public void actionOK_actionPerformed(ActionEvent e) throws Exception {
        this.params.put("isConfirm", Boolean.TRUE);
        int[] selectCount = KDTableUtil.getSelectedRows((KDTable)this.kpiList);
        for (int i = 0; i < selectCount.length; ++i) {
            KPIInfo tempInfo = new KPIInfo();
            this.setKpiInfo(tempInfo, this.kpiList.getRow(selectCount[i]));
            this.dataList.add(tempInfo);
        }
        this.getUIWindow().close();
    }

    private void setKpiInfo(KPIInfo kpiInfo, IRow row) {
        if (kpiInfo == null || row == null) {
            return;
        }
        Object obj = row.getCell("id").getValue();
        if (obj == null) {
            kpiInfo.setId(null);
        } else {
            kpiInfo.setId(BOSUuid.read((String)row.getCell("id").getValue().toString()));
        }
        obj = row.getCell("number").getValue();
        if (obj == null) {
            kpiInfo.setNumber(null);
        } else {
            kpiInfo.setNumber(row.getCell("number").getValue().toString());
        }
        obj = row.getCell("name").getValue();
        if (obj == null) {
            kpiInfo.setName(null);
        } else {
            kpiInfo.setName(obj.toString());
        }
        obj = row.getCell("description").getValue();
        if (obj == null) {
            kpiInfo.setDescription(null);
        } else {
            kpiInfo.setDescription(obj.toString());
        }
    }

    private void setTableSort() {
        KDTSortManager sm = new KDTSortManager(this.kpiList);
        sm.setSortAuto(true);
        this.kpiList.getColumn("number").setSortable(true);
        this.kpiList.getColumn("name").setSortable(true);
    }
}

