/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.client.AbstractUnAtomFormulaSelectedUI;
import com.kingdee.eas.util.client.EASResource;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.DefaultListModel;

public class UnAtomFormulaSelectedUI
extends AbstractUnAtomFormulaSelectedUI {
    private static final long serialVersionUID = 2228916167182989961L;
    private static final List countSymbol = Collections.unmodifiableList(Arrays.asList("+", "-", "*", "/"));

    public UnAtomFormulaSelectedUI() throws Exception {
        this.btnAdd.setIcon(EASResource.getIcon((String)"imgTbtn_plussign"));
        this.btnSubstract.setIcon(EASResource.getIcon((String)"imgTbtn_minussign"));
        this.btnMuti.setIcon(EASResource.getIcon((String)"imgTbtn_multiplysign"));
        this.btnDivide.setIcon(EASResource.getIcon((String)"imgTbtn_dividesign"));
        this.btnSymbol.setIcon(EASResource.getIcon((String)"imgTbtn_unequaltosign"));
        this.btnClear.setIcon(EASResource.getIcon((String)"imgTbtn_delete"));
        this.showFormulaList();
        this.formulaList.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() >= 2) {
                    try {
                        UnAtomFormulaSelectedUI.this.btnMoveToRight_actionPerformed(null);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
            }
        });
    }

    public void onLoad() throws Exception {
        this.txtFormula.setSelectAllOnFocus(false);
    }

    public void loadFields() {
        super.loadFields();
    }

    public void storeFields() {
        super.storeFields();
    }

    protected void btnMoveToRight_actionPerformed(ActionEvent e) throws Exception {
        Object obj = this.formulaList.getSelectedValue();
        if (obj == null) {
            return;
        }
        KPIInfo info = (KPIInfo)obj;
        this.setTxtFormulaArea(info);
    }

    protected void btnCancel_actionPerformed(ActionEvent e) throws Exception {
        this.getUIWindow().close();
    }

    protected void btnOK_actionPerformed(ActionEvent e) throws Exception {
        super.btnOK_actionPerformed(e);
    }

    protected void btnSubstract_actionPerformed(ActionEvent e) throws Exception {
        this.addCountSymbolToFormulaText("-");
    }

    protected void btnDivide_actionPerformed(ActionEvent e) throws Exception {
        this.addCountSymbolToFormulaText("/");
    }

    protected void btnSymbol_actionPerformed(ActionEvent e) throws Exception {
        String content = this.txtFormula.getText();
        if (content != null) {
            int pos = this.txtFormula.getCaretPosition();
            this.txtFormula.insert("()", pos);
            this.txtFormula.setCaretPosition(pos + 1);
        }
        this.txtFormula.requestFocus();
    }

    protected void btnMuti_actionPerformed(ActionEvent e) throws Exception {
        this.addCountSymbolToFormulaText("*");
    }

    protected void btnClear_actionPerformed(ActionEvent e) throws Exception {
        this.txtFormula.setText("");
        this.txtFormula.requestFocus();
    }

    protected void btnAdd_actionPerformed(ActionEvent e) throws Exception {
        this.addCountSymbolToFormulaText("+");
    }

    private void showFormulaList() {
        Iterator itr = null;
        try {
            itr = KPIFactory.getRemoteInstance().getCollection("select name,formula").iterator();
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        DefaultListModel listModel = (DefaultListModel)this.formulaList.getModel();
        listModel.removeAllElements();
        while (itr.hasNext()) {
            KPIInfo info = (KPIInfo)itr.next();
            listModel.addElement(info);
        }
    }

    private void setTxtFormulaArea(KPIInfo info) {
        String content = this.txtFormula.getText().trim();
        if (content == null || "".equals(content)) {
            content = info.getName();
        } else if (this.strEndsWithSpecialSymbol(content)) {
            content = content + info.getName();
        } else {
            System.out.println("please select a count symbol first !");
        }
        this.txtFormula.setText(content);
    }

    private void addCountSymbolToFormulaText(String symbol) {
        String content = this.txtFormula.getText().trim();
        if ("".equals(content)) {
            return;
        }
        if (this.strEndsWithSpecialSymbol(content)) {
            return;
        }
        content = content + symbol;
        this.txtFormula.setText(content);
    }

    private boolean strEndsWithSpecialSymbol(String str) {
        String lastChar = str.substring(str.length() - 1);
        return countSymbol.contains(lastChar);
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }
}

