/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.ctrl.kdf.table.IRow;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.ui.face.CoreUIObject;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.sem.mp.KPIFactory;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.client.AbstractViewKpiListUI;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.apache.log4j.Logger;

public class ViewKpiListUI
extends AbstractViewKpiListUI {
    private static final Logger logger = CoreUIObject.getLogger(ViewKpiListUI.class);
    private KPIInfo kpiInfo;

    public void storeFields() {
        super.storeFields();
    }

    public void onLoad() throws Exception {
        this.kDTable1.checkParsed();
        super.onLoad();
        String kpiId = this.getUIContext().get("KPIID").toString();
        this.kpiInfo = this.initKPI(kpiId);
        if (kpiId != null) {
            this.initTable(this.getKpiValues(kpiId));
        }
        this.kDTable1.getSelectManager().setSelectMode(2);
        this.kDTable1.getStyleAttributes().setLocked(true);
    }

    private void initTable(KPIValueCollection cols) {
        if (cols != null) {
            IRow row = null;
            KPIValueInfo kpiValueInfo = null;
            int j = cols.size();
            for (int i = 0; i < j; ++i) {
                kpiValueInfo = cols.get(i);
                row = this.kDTable1.addRow();
                row.getCell("kpiValueId").setValue((Object)kpiValueInfo.getId().toString());
                row.getCell("kpiName").setValue((Object)kpiValueInfo.getName());
                row.getCell("lastCalTime").setValue((Object)kpiValueInfo.getLastUpdateTime());
                int _displayPrecision = 2;
                if (this.kpiInfo != null) {
                    _displayPrecision = this.kpiInfo.getDisplayPrecision();
                }
                if (!this.kpiInfo.isIsPercent()) {
                    row.getCell("kpiValue").getStyleAttributes().setNumberFormat("");
                    NumberFormat ft = NumberFormat.getInstance();
                    ((DecimalFormat)ft).setDecimalSeparatorAlwaysShown(true);
                    ((DecimalFormat)ft).setGroupingSize(3);
                    ((DecimalFormat)ft).setMaximumFractionDigits(_displayPrecision);
                    ((DecimalFormat)ft).setMinimumFractionDigits(_displayPrecision);
                    ((DecimalFormat)ft).setMinimumIntegerDigits(1);
                    row.getCell("kpiValue").setValue((Object)ft.format(kpiValueInfo.getKpiValue()));
                    continue;
                }
                DecimalFormat percentFt = new DecimalFormat("###.##'%'");
                percentFt.setMaximumFractionDigits(_displayPrecision);
                percentFt.setMinimumFractionDigits(_displayPrecision);
                row.getCell("kpiValue").setValue((Object)percentFt.format(kpiValueInfo.getKpiValue()));
            }
        }
    }

    private KPIValueCollection getKpiValues(String kpiId) throws EASBizException, BOSException {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
        ev.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("bizDate");
        sortInfo.setSortType(SortType.DESCEND);
        ev.getSorter().getSorter().add(sortInfo);
        KPIValueCollection kpiValueCols = KPIValueFactory.getRemoteInstance().getKPIValueCollection(ev);
        return kpiValueCols;
    }

    private KPIInfo initKPI(String kpiId) throws EASBizException, BOSException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("name");
        selector.add("displayPrecision");
        selector.add("isPercent");
        return KPIFactory.getRemoteInstance().getKPIInfo((IObjectPK)new ObjectUuidPK(kpiId), selector);
    }
}

