/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.client;

import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.dtp.StringConverter;
import com.kingdee.eas.common.client.OprtState;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.WarnGroupInfo;
import com.kingdee.eas.sem.mp.client.AbstractWarnGroupEditUI;
import java.awt.Color;
import java.awt.event.ActionEvent;

public class WarnGroupEditUI
extends AbstractWarnGroupEditUI {
    public void onLoad() throws Exception {
        super.onLoad();
        this.txtNumber.setMaxLength(80);
        this.mltName.setMaxLength(255);
        this.mltDescription.setMaxLength(255);
        if (OprtState.VIEW.equals(this.getOprtState())) {
            this.actionEdit.setEnabled(true);
        } else {
            this.actionEdit.setEnabled(false);
        }
    }

    public void loadFields() {
        super.loadFields();
        Color color = StringConverter.convertToColor((String)this.editData.getColor());
        this.comboColor.setColor(color);
        this.actionRemove.setEnabled(false);
        this.txtNumber.setEnabled(false);
        this.ntPeriority.setEnabled(false);
        this.actionAddNew.setVisible(false);
        this.actionCopy.setVisible(false);
        this.actionRemove.setVisible(false);
    }

    public void storeFields() {
        super.storeFields();
        StringBuffer color = new StringBuffer();
        color.append("r " + this.comboColor.getColor().getRed());
        color.append(",g " + this.comboColor.getColor().getGreen());
        color.append(",b " + this.comboColor.getColor().getBlue());
        String webColor = this.getWebColor(this.comboColor.getColor());
        this.editData.setColor(color.toString());
        this.editData.setWebColor(webColor);
        this.editData.setIntColor(Integer.decode(webColor));
    }

    public SelectorItemCollection getSelectors() {
        SelectorItemCollection sic = super.getSelectors();
        sic.add(new SelectorItemInfo("webColor"));
        sic.add(new SelectorItemInfo("intColor"));
        return sic;
    }

    protected void unLockUI() {
        super.unLockUI();
        this.txtNumber.setEnabled(false);
        this.ntPeriority.setEnabled(false);
    }

    public void actionEdit_actionPerformed(ActionEvent e) throws Exception {
        super.actionEdit_actionPerformed(e);
    }

    protected IObjectValue createNewData() {
        return new WarnGroupInfo();
    }

    protected ICoreBase getBizInterface() throws Exception {
        return WarnGroupFactory.getRemoteInstance();
    }

    protected SystemEnum getSystemEnumForOA() {
        return SystemEnum.BUSS_ANALYSIS;
    }

    protected String getWebColor(Color color) {
        StringBuffer webColor = new StringBuffer();
        webColor.append("#");
        int rValue = color.getRed();
        int gValue = color.getGreen();
        int bValue = color.getBlue();
        if (rValue <= 15) {
            webColor.append("0").append(Integer.toHexString(rValue).toUpperCase());
        } else {
            webColor.append(Integer.toHexString(rValue).toUpperCase());
        }
        if (gValue <= 15) {
            webColor.append("0").append(Integer.toHexString(gValue).toUpperCase());
        } else {
            webColor.append(Integer.toHexString(gValue).toUpperCase());
        }
        if (bValue <= 15) {
            webColor.append("0").append(Integer.toHexString(bValue).toUpperCase());
        } else {
            webColor.append(Integer.toHexString(bValue).toUpperCase());
        }
        return webColor.toString();
    }
}

