/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.util;

import java.io.Serializable;

public class KPIValueStructure
implements Serializable {
    private String[][] kpiRefValueTable = null;
    private String[] rowTitles = null;
    private String[] columnTitles = null;
    private int tLength = 0;
    private int tWidth = 0;
    private String[] kpiIds = null;

    public KPIValueStructure(int length, int width) {
        this.tLength = length;
        this.tWidth = width;
        this.rowTitles = new String[length];
        this.columnTitles = new String[width];
        this.kpiRefValueTable = new String[length][width];
    }

    public int getTLength() {
        return this.tLength;
    }

    public int getTWidth() {
        return this.tWidth;
    }

    public void setRowTitle(int rowID, String title) {
        if (this.tLength < rowID) {
            throw new RuntimeException("rowID has exceeded the table length!");
        }
        this.rowTitles[rowID - 1] = title;
    }

    public String getRowTitle(int rowID) {
        if (this.tLength < rowID) {
            throw new RuntimeException("rowID has exceeded the table length!");
        }
        return this.rowTitles[rowID - 1];
    }

    public void setColumnTitle(int columnID, String title) {
        if (this.tWidth < columnID) {
            throw new RuntimeException("columnID has exceeded the table widht!");
        }
        this.columnTitles[columnID - 1] = title;
    }

    public String getColumnTitle(int columnID) {
        if (this.tWidth < columnID) {
            throw new RuntimeException("columnID has exceeded the table widht!");
        }
        return this.columnTitles[columnID - 1];
    }

    public void setValueByRowAndColun(String value, int rowID, int columnID) {
        if (this.tLength < rowID) {
            throw new RuntimeException("rowID has exceeded the table length!");
        }
        if (this.tWidth < columnID) {
            throw new RuntimeException("columnID has exceeded the table widht!");
        }
        this.kpiRefValueTable[rowID - 1][columnID - 1] = value;
    }

    public String getValueByRowAndColun(int rowID, int columnID) {
        if (this.tLength < rowID) {
            throw new RuntimeException("rowID has exceeded the table length!");
        }
        if (this.tWidth < columnID) {
            throw new RuntimeException("columnID has exceeded the table widht!");
        }
        return this.kpiRefValueTable[rowID - 1][columnID - 1];
    }

    public String[] getColumn(int columnIndex) {
        if (this.tWidth < columnIndex) {
            throw new RuntimeException("columnIndex has exceeded the table widht!");
        }
        String[] columnValue = new String[this.tLength - 1];
        for (int i = 2; i <= this.tLength; ++i) {
            columnValue[i - 2] = this.getValueByRowAndColun(2, columnIndex);
        }
        return columnValue;
    }

    public String[] getRowTitles() {
        return this.rowTitles;
    }

    public String[] getColumTitles() {
        return this.columnTitles;
    }

    public String[] getKpiIds() {
        return this.kpiIds;
    }

    public void setKpiIds(String[] kpiIds) {
        this.kpiIds = kpiIds;
    }

    public String[][] getTotalTable() {
        int i;
        String[][] table = new String[this.tLength + 1][this.tWidth + 1];
        table[0][0] = "KPI\u540d\u79f0";
        for (i = 1; i <= this.tWidth; ++i) {
            table[0][i] = this.getColumnTitle(i);
        }
        for (i = 1; i <= this.tLength; ++i) {
            table[i][0] = this.getRowTitle(i);
            for (int j = 1; j <= this.tWidth; ++j) {
                table[i][j] = this.getValueByRowAndColun(i, j);
            }
        }
        return table;
    }
}

