/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.sem.mp.web.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.swing.dial.KpiRange;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.attachment.BoAttchAssoCollection;
import com.kingdee.eas.base.attachment.BoAttchAssoFactory;
import com.kingdee.eas.base.attachment.BoAttchAssoInfo;
import com.kingdee.eas.base.attachment.IBoAttchAsso;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.cp.common.web.util.WebContextUtil;
import com.kingdee.eas.cp.eip.mc.web.service.MessageWebService;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.sem.mp.BussAnalysisThemeFactory;
import com.kingdee.eas.sem.mp.DailScopeInfo;
import com.kingdee.eas.sem.mp.DisplaySchemeUtil;
import com.kingdee.eas.sem.mp.IKPIAnalysisReportSet;
import com.kingdee.eas.sem.mp.IKPIComment;
import com.kingdee.eas.sem.mp.IKPIValue;
import com.kingdee.eas.sem.mp.IKPIWarnParam;
import com.kingdee.eas.sem.mp.IWarnGroup;
import com.kingdee.eas.sem.mp.KPIAnalysisReportOfCompanyCollection;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetFactory;
import com.kingdee.eas.sem.mp.KPIAnalysisReportSetInfo;
import com.kingdee.eas.sem.mp.KPICommentCollection;
import com.kingdee.eas.sem.mp.KPICommentFactory;
import com.kingdee.eas.sem.mp.KPICommentInfo;
import com.kingdee.eas.sem.mp.KPIInfo;
import com.kingdee.eas.sem.mp.KPIToFlashInfo;
import com.kingdee.eas.sem.mp.KPIValueCollection;
import com.kingdee.eas.sem.mp.KPIValueFactory;
import com.kingdee.eas.sem.mp.KPIValueInfo;
import com.kingdee.eas.sem.mp.KPIWarnParamCollection;
import com.kingdee.eas.sem.mp.KPIWarnParamFactory;
import com.kingdee.eas.sem.mp.KPIWarnParamInfo;
import com.kingdee.eas.sem.mp.WarnGroupCollection;
import com.kingdee.eas.sem.mp.WarnGroupFactory;
import com.kingdee.eas.sem.mp.app.AttachInfoForBuffalo;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.net.URLDecoder;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.buffalo.server.BuffaloService;
import org.apache.log4j.Logger;

public class BussAnalysisService
extends BuffaloService {
    Logger logger = Logger.getLogger((String)MessageWebService.class.getName());

    public boolean isExistAndPermission(String bussThemeId) {
        boolean mark = false;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        if (this.hasExist(ctx, bussThemeId = URLDecoder.decode(bussThemeId)) && this.hasPermission(ctx, bussThemeId)) {
            mark = true;
        }
        return mark;
    }

    public boolean hasExist(String bussThemeId) {
        boolean exist = false;
        bussThemeId = URLDecoder.decode(bussThemeId);
        try {
            HttpServletRequest request = (HttpServletRequest)this.getRequest();
            Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
            exist = BussAnalysisThemeFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bussThemeId)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return exist;
    }

    private boolean hasExist(Context ctx, String bussThemeId) {
        boolean exist = false;
        try {
            exist = BussAnalysisThemeFactory.getLocalInstance(ctx).exists((IObjectPK)new ObjectUuidPK(BOSUuid.read((String)bussThemeId)));
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return exist;
    }

    private boolean hasPermission(Context ctx, String bussThemeId) {
        boolean hasPermission;
        block3: {
            hasPermission = false;
            try {
                IRowSet rowSet = this.getPermissonReport(ctx);
                if (rowSet == null) break block3;
                while (rowSet.next()) {
                    String strTemp = rowSet.getString("ID");
                    if (strTemp == null || !strTemp.equals(bussThemeId)) continue;
                    hasPermission = true;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"HASPERMISSION ERROR");
                e.printStackTrace();
            }
        }
        return hasPermission;
    }

    public boolean hasPermission(String bussThemeId) {
        boolean hasPermission;
        block3: {
            bussThemeId = URLDecoder.decode(bussThemeId);
            hasPermission = false;
            try {
                HttpServletRequest request = (HttpServletRequest)this.getRequest();
                Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
                IRowSet rowSet = this.getPermissonReport(ctx);
                if (rowSet == null) break block3;
                while (rowSet.next()) {
                    String strTemp = rowSet.getString("ID");
                    if (strTemp == null || !strTemp.equals(bussThemeId)) continue;
                    hasPermission = true;
                    break;
                }
            }
            catch (Exception e) {
                this.logger.info((Object)"HASPERMISSION ERROR");
                e.printStackTrace();
            }
        }
        return hasPermission;
    }

    public String[] getCompanyChild(String companyLongNumber, String reportSetId) {
        if (reportSetId == null || companyLongNumber == null) {
            return new String[0];
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("ofCompany.company.id"));
        selector.add(new SelectorItemInfo("ofCompany.company.number"));
        selector.add(new SelectorItemInfo("ofCompany.company.longnumber"));
        String[] numbers = new String[]{};
        try {
            KPIAnalysisReportOfCompanyCollection companyCols;
            int size;
            IKPIAnalysisReportSet iSet = KPIAnalysisReportSetFactory.getLocalInstance(ctx);
            KPIAnalysisReportSetInfo setInfo = iSet.getKPIAnalysisReportSetInfo((IObjectPK)new ObjectUuidPK(reportSetId), selector);
            if (setInfo != null && (size = (companyCols = setInfo.getOfCompany()).size()) > 0) {
                numbers = new String[size];
                for (int i = 0; i < size; ++i) {
                    numbers[i] = companyCols.get(i).getCompany().getLongNumber();
                }
            }
        }
        catch (BOSException e) {
            this.logger.info((Object)"In the BuffAnalysisService getCompanyChild Error! 1111");
            e.printStackTrace();
        }
        catch (EASBizException e) {
            this.logger.info((Object)"In the BuffAnalysisService getCompanyChild Error! 2222");
            e.printStackTrace();
        }
        String selectSql = "select flevel from T_ORG_Admin where flongnumber=? ";
        int currentLevel = -10;
        try {
            IRowSet rowSet1 = DbUtil.executeQuery((Context)ctx, (String)selectSql, (Object[])new String[]{companyLongNumber});
            if (rowSet1 != null && rowSet1.next()) {
                currentLevel = rowSet1.getInt("flevel");
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (numbers.length <= 0) {
            return numbers;
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select flongnumber from T_ORG_Admin ");
        sql.append(" where flongnumber like '");
        sql.append(companyLongNumber);
        sql.append("!%'");
        sql.append(" and flevel=");
        sql.append(currentLevel + 1);
        sql.append(" and flongnumber in(''");
        for (int i = 0; i < numbers.length; ++i) {
            sql.append(",'");
            sql.append(numbers[i]);
            sql.append("'");
        }
        sql.append(")");
        try {
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            if (rowSet != null) {
                int j = 0;
                numbers = new String[rowSet.size()];
                while (rowSet.next()) {
                    numbers[j] = rowSet.getString("flongnumber");
                    ++j;
                }
            }
        }
        catch (BOSException e) {
            this.logger.info((Object)"In the BuffAnalysisService getCompanyChild Error! 3333");
            e.printStackTrace();
        }
        catch (SQLException e) {
            this.logger.info((Object)"In the BuffAnalysisService getCompanyChild Error! 4444");
            e.printStackTrace();
        }
        return numbers;
    }

    public void updateComment(String kpiValueId, String commentId, String comment) {
        if (kpiValueId == null || commentId == null) {
            return;
        }
        kpiValueId = kpiValueId.replaceAll(" ", "+");
        int tempIndex = (commentId = commentId.replaceAll(" ", "+")).indexOf("true");
        if (tempIndex >= 0) {
            commentId = commentId.substring(0, tempIndex);
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            IKPIComment iKpiComment = KPICommentFactory.getLocalInstance(ctx);
            KPICommentInfo commentInfo = iKpiComment.getKPICommentInfo((IObjectPK)new ObjectUuidPK(commentId));
            commentInfo.setComment(comment);
            iKpiComment.update((IObjectPK)new ObjectUuidPK(commentId), (CoreBaseInfo)commentInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String addComment(String kpiValueId, String comment) {
        if (kpiValueId == null) {
            return null;
        }
        kpiValueId = kpiValueId.replaceAll(" ", "+");
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            IKPIValue iKpiValue = KPIValueFactory.getLocalInstance(ctx);
            if (iKpiValue.exists((IObjectPK)new ObjectUuidPK(kpiValueId))) {
                KPIValueInfo valueInfo = iKpiValue.getKPIValueInfo((IObjectPK)new ObjectUuidPK(kpiValueId));
                KPICommentInfo commentInfo = new KPICommentInfo();
                commentInfo.setComment(comment);
                commentInfo.setKpiValue(valueInfo);
                return KPICommentFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)commentInfo).toString();
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean deleteComment(String commentIds) {
        boolean result = true;
        if (commentIds == null) {
            return false;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        String commentSelectIds = commentIds.replaceAll(" ", "+");
        String[] sIds = commentSelectIds.split(",");
        if (sIds.length > 0) {
            ObjectUuidPK[] pks = new ObjectUuidPK[sIds.length];
            for (String tempId : sIds) {
                int tempIndex = tempId.indexOf("true");
                if (tempIndex >= 0) {
                    tempId = tempId.substring(0, tempIndex);
                }
                pks[i] = new ObjectUuidPK(tempId);
            }
            try {
                KPICommentFactory.getLocalInstance(ctx).delete((IObjectPK[])pks);
            }
            catch (Exception e) {
                result = false;
                e.printStackTrace();
            }
        } else {
            result = false;
        }
        return result;
    }

    public KPIToFlashInfo getKPIValueInfo(String kpiId, String kpiValueId) {
        if (kpiId == null || kpiValueId == null) {
            return null;
        }
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        EntityViewInfo ev = new EntityViewInfo();
        SelectorItemCollection selector = ev.getSelector();
        selector.add(new SelectorItemInfo("kpi.*"));
        selector.add(new SelectorItemInfo("*"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpi.id", (Object)kpiId));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)kpiValueId));
        ev.setFilter(filter);
        KPIValueInfo kpiValueInfo = null;
        KPIInfo kpiInfo = null;
        KPIValueCollection valueCols = null;
        try {
            valueCols = KPIValueFactory.getLocalInstance(ctx).getKPIValueCollection(ev);
            if (valueCols != null && valueCols.size() > 0) {
                kpiValueInfo = valueCols.get(0);
                kpiInfo = kpiValueInfo.getKpi();
                KPIWarnParamCollection warnParamCols = this.getKPIWarnParamCollection(ctx, kpiValueInfo.getId().toString());
                Map soluColor = this.construstSoluColor(ctx);
                int rountSize = 2;
                rountSize = kpiInfo.getDisplayPrecision();
                if (rountSize < 0 || rountSize > 10) {
                    rountSize = 2;
                }
                if (kpiInfo.isIsPercent()) {
                    rountSize = 4;
                }
                DailScopeInfo[] dailScopeInfo = this.generateRange(warnParamCols, kpiValueInfo, soluColor, kpiValueInfo.getKpiValue().doubleValue(), rountSize, kpiInfo.isIsPercent());
                KPIToFlashInfo flashParam = new KPIToFlashInfo();
                flashParam.setShowMode(String.valueOf(kpiInfo.isIsPercent() ? 2 : 1));
                flashParam.setDisplayPrecision(String.valueOf(kpiInfo.getDisplayPrecision()));
                flashParam.setNumberUnit(kpiInfo.getNumberUnit());
                flashParam.setMyType(String.valueOf(kpiInfo.isIsPercent() ? 2 : 1));
                if (kpiInfo.isIsPercent()) {
                    flashParam.setNumValue(kpiValueInfo.getKpiValue().setScale(rountSize, 4).toString());
                } else {
                    flashParam.setNumValue(kpiValueInfo.getKpiValue().setScale(rountSize, 4).toString());
                }
                flashParam.setTitle(kpiInfo.getName());
                flashParam.setNumMin(String.valueOf(dailScopeInfo[0].getMin()));
                flashParam.setNumMax(String.valueOf(dailScopeInfo[2].getMax()));
                flashParam.setNumAlerm(String.valueOf(dailScopeInfo[1].getMax()));
                flashParam.setNumDanger(String.valueOf(dailScopeInfo[0].getMax()));
                flashParam.setColor1(DisplaySchemeUtil.transColorDataToHex(dailScopeInfo[0].getColor()));
                flashParam.setColor2(DisplaySchemeUtil.transColorDataToHex(dailScopeInfo[1].getColor()));
                flashParam.setColor3(DisplaySchemeUtil.transColorDataToHex(dailScopeInfo[2].getColor()));
                return flashParam;
            }
        }
        catch (BOSException e) {
            this.logger.info((Object)"get kpi flash info error!");
            e.printStackTrace();
        }
        return null;
    }

    public String[] getKPIComment(String kpiValueId) {
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpiValue.id", (Object)kpiValueId));
        ev.setFilter(filter);
        SorterItemInfo sortInfo = new SorterItemInfo("createTime");
        sortInfo.setSortType(SortType.DESCEND);
        ev.getSorter().add(sortInfo);
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        try {
            KPICommentCollection comments = KPICommentFactory.getLocalInstance(ctx).getKPICommentCollection(ev);
            if (comments != null) {
                String[] commentArray = new String[comments.size()];
                int n = comments.size();
                for (int i = 0; i < n; ++i) {
                    KPICommentInfo commentInfo = comments.get(i);
                    commentArray[i] = commentInfo.getComment();
                }
                return commentArray;
            }
        }
        catch (BOSException e1) {
            e1.printStackTrace();
        }
        return null;
    }

    public AttachInfoForBuffalo[] getCompanyAttachs(String companyId) {
        AttachInfoForBuffalo[] attachInfos = null;
        HttpServletRequest request = (HttpServletRequest)this.getRequest();
        Context ctx = WebContextUtil.getEasContext((HttpServletRequest)request);
        IBoAttchAsso boAtt = null;
        Object info = null;
        BoAttchAssoCollection cols = null;
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("attachment.id"));
        selector.add(new SelectorItemInfo("attachment.name"));
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("boID", (Object)companyId, CompareType.EQUALS));
        filter.setMaskString(" #0 ");
        ev.setSelector(selector);
        ev.setFilter(filter);
        try {
            boAtt = BoAttchAssoFactory.getLocalInstance((Context)ctx);
            cols = boAtt.getBoAttchAssoCollection(ev);
            int size = cols.size();
            if (size >= 0) {
                attachInfos = new AttachInfoForBuffalo[size];
                for (int i = 0; i < size; ++i) {
                    AttachInfoForBuffalo tempInfo = new AttachInfoForBuffalo();
                    BoAttchAssoInfo attInfo = cols.get(i);
                    tempInfo.setName(attInfo.getAttachment().getName());
                    tempInfo.setId(attInfo.getAttachment().getId().toString());
                    attachInfos[i] = tempInfo;
                }
            }
        }
        catch (BOSException e) {
            this.logger.info((Object)"get company's attach error!");
            e.printStackTrace();
        }
        return attachInfos;
    }

    private IRowSet getPermissonReport(Context ctx) throws BOSException, EASBizException {
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        String strTemp = iPermission.getQueryPermissionSQL(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(ContextUtil.getCurrentCtrlUnit((Context)ctx).getId().toString()), "buss_analysisThemeReport_config");
        IRowSet rowSet = null;
        rowSet = DbUtil.executeQuery((Context)ctx, (String)strTemp);
        return rowSet;
    }

    private DailScopeInfo[] generateRange(KPIWarnParamCollection params, KPIValueInfo kpiValueInfo, Map soluColor, double kpiValue, int rountSize, boolean isPercent) {
        KpiRange normal = new KpiRange(0.0, kpiValue * 2.0);
        KpiRange warning = new KpiRange(0.0, 0.0);
        KpiRange critical = new KpiRange(0.0, 0.0);
        boolean isShow = false;
        if (params != null) {
            int count = params.size();
            if (count == 2) {
                double low;
                double high;
                double paramLowValue;
                double paramHighValue;
                KPIWarnParamInfo paramHigh = params.get(0);
                KPIWarnParamInfo paramLow = params.get(1);
                if (paramHigh.getWarnGroup().getPeriority() > paramLow.getWarnGroup().getPeriority()) {
                    KPIWarnParamInfo temp = paramHigh;
                    paramHigh = paramLow;
                    paramLow = temp;
                }
                if ((paramHighValue = paramHigh.getCurrentValue().doubleValue()) > (paramLowValue = paramLow.getCurrentValue().doubleValue())) {
                    high = paramHighValue + (paramHighValue - paramLowValue);
                    low = paramLowValue - (paramHighValue - paramLowValue);
                    if (kpiValue > high) {
                        high = kpiValue;
                    } else if (kpiValue < low) {
                        low = kpiValue;
                    }
                    normal = new KpiRange(low, paramLowValue);
                    warning = new KpiRange(paramLowValue, paramHighValue);
                    critical = new KpiRange(paramHighValue, high);
                } else {
                    high = paramHighValue - (paramLowValue - paramHighValue);
                    low = paramLowValue + (paramLowValue - paramHighValue);
                    if (kpiValue > low) {
                        low = kpiValue;
                    } else if (kpiValue < high) {
                        high = kpiValue;
                    }
                    normal = new KpiRange(paramLowValue, low);
                    warning = new KpiRange(paramHighValue, paramLowValue);
                    critical = new KpiRange(high, paramHighValue);
                }
                isShow = true;
            } else if (count == 4) {
                int i;
                double[] paramValue = new double[4];
                for (i = 0; i < count; ++i) {
                    KPIWarnParamInfo param = params.get(i);
                    paramValue[i] = param.getCurrentValue().doubleValue();
                    if (!isPercent) continue;
                    paramValue[i] = paramValue[i] * 100.0;
                }
                for (i = 0; i < count - 1; ++i) {
                    int min = i;
                    for (int j = i + 1; j < count; ++j) {
                        if (!(paramValue[j] < paramValue[min])) continue;
                        min = j;
                    }
                    if (min == i) continue;
                    double swap = paramValue[i];
                    paramValue[i] = paramValue[min];
                    paramValue[min] = swap;
                }
                double middle = (paramValue[1] + paramValue[2]) / 2.0;
                double lack = middle - paramValue[1];
                if (kpiValue < middle) {
                    double minimum = paramValue[0] - lack;
                    if (minimum > kpiValue) {
                        minimum = kpiValue;
                    }
                    critical = new KpiRange(minimum, paramValue[0]);
                    warning = new KpiRange(paramValue[0], paramValue[1]);
                    normal = new KpiRange(paramValue[1], middle);
                } else {
                    double maxmum = paramValue[3] + lack;
                    if (kpiValue > maxmum) {
                        maxmum = kpiValue;
                    }
                    normal = new KpiRange(middle, paramValue[2]);
                    warning = new KpiRange(paramValue[2], paramValue[3]);
                    critical = new KpiRange(paramValue[3], maxmum);
                }
                isShow = true;
            } else if (kpiValueInfo.getCurrentWarnStatus() != null) {
                int periority = 0;
                if (periority == 0) {
                    if (kpiValue == 0.0) {
                        warning = new KpiRange(-5.0, -3.0);
                        normal = new KpiRange(-3.0, -1.0);
                        critical = new KpiRange(-1.0, 1.0);
                    } else {
                        warning = new KpiRange(0.0, kpiValue * 2.0 / 5.0);
                        normal = new KpiRange(kpiValue * 2.0 / 5.0, kpiValue * 4.0 / 5.0);
                        critical = new KpiRange(kpiValue * 4.0 / 5.0, kpiValue * 6.0 / 5.0);
                    }
                    isShow = true;
                } else if (periority == 1) {
                    if (kpiValue == 0.0) {
                        warning = new KpiRange(-1.0, 1.0);
                        normal = new KpiRange(1.0, 3.0);
                        critical = new KpiRange(3.0, 5.0);
                    } else {
                        warning = new KpiRange(0.0, kpiValue * 2.0);
                        normal = new KpiRange(kpiValue * 2.0, kpiValue * 4.0);
                        critical = new KpiRange(kpiValue * 4.0, kpiValue * 6.0);
                    }
                    isShow = true;
                } else if (periority == 2) {
                    if (kpiValue == 0.0) {
                        warning = new KpiRange(-3.0, -1.0);
                        normal = new KpiRange(-1.0, 1.0);
                        critical = new KpiRange(1.0, 3.0);
                    } else {
                        normal = new KpiRange(kpiValue * 2.0 / 3.0, kpiValue * 4.0 / 3.0);
                        warning = new KpiRange(0.0, kpiValue * 2.0 / 3.0);
                        critical = new KpiRange(kpiValue * 4.0 / 3.0, kpiValue * 2.0);
                    }
                    isShow = true;
                }
            }
        }
        int[] sort = new int[]{0, 1, 2};
        if (isShow) {
            double[] v = new double[]{normal.getLowerBound() + normal.getUpperBound(), warning.getLowerBound() + warning.getUpperBound(), critical.getLowerBound() + critical.getUpperBound()};
            int minIndex = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == minIndex || !(v[i] < v[minIndex])) continue;
                minIndex = i;
            }
            int maxIndex = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == maxIndex || !(v[i] > v[maxIndex])) continue;
                maxIndex = i;
            }
            int mid = 0;
            for (int i = 0; i < 3; ++i) {
                if (i == minIndex || i == maxIndex) continue;
                mid = i;
            }
            sort[0] = minIndex;
            sort[1] = mid;
            sort[2] = maxIndex;
        }
        if (!isShow) {
            if (kpiValue == 0.0) {
                kpiValue = 5.0;
            }
            normal = new KpiRange(0.0, kpiValue * 2.0);
            warning = new KpiRange(0.0, 0.0);
            critical = new KpiRange(0.0, 0.0);
            sort[0] = 0;
            sort[1] = 1;
            sort[2] = 2;
            isShow = true;
        }
        DailScopeInfo normaldailScopeInfo = new DailScopeInfo();
        normaldailScopeInfo.setMin(new BigDecimal(normal.getLowerBound()).setScale(rountSize, 4));
        normaldailScopeInfo.setMax(new BigDecimal(normal.getUpperBound()).setScale(rountSize, 4));
        normaldailScopeInfo.setType(2);
        normaldailScopeInfo.setColor(soluColor.get("2").toString());
        DailScopeInfo warningldailScopeInfo = new DailScopeInfo();
        warningldailScopeInfo.setMin(new BigDecimal(warning.getLowerBound()).setScale(rountSize, 4));
        warningldailScopeInfo.setMax(new BigDecimal(warning.getUpperBound()).setScale(rountSize, 4));
        warningldailScopeInfo.setType(1);
        warningldailScopeInfo.setColor(soluColor.get("1").toString());
        DailScopeInfo criticaldailScopeInfo = new DailScopeInfo();
        criticaldailScopeInfo.setMin(new BigDecimal(critical.getLowerBound()).setScale(rountSize, 4));
        criticaldailScopeInfo.setMax(new BigDecimal(critical.getUpperBound()).setScale(rountSize, 4));
        criticaldailScopeInfo.setType(0);
        criticaldailScopeInfo.setColor(soluColor.get("0").toString());
        DailScopeInfo[] temp = new DailScopeInfo[]{normaldailScopeInfo, warningldailScopeInfo, criticaldailScopeInfo};
        DailScopeInfo[] dailScopeInfoArry = new DailScopeInfo[3];
        for (int i = 0; i < 3; ++i) {
            dailScopeInfoArry[i] = temp[sort[i]];
        }
        return dailScopeInfoArry;
    }

    private Map construstSoluColor(Context ctx) throws BOSException {
        HashMap<String, String> soluColor = new HashMap<String, String>();
        IWarnGroup iWarnGroup = ctx != null ? WarnGroupFactory.getLocalInstance(ctx) : WarnGroupFactory.getRemoteInstance();
        WarnGroupCollection warnGroupCollection = iWarnGroup.getWarnGroupCollection();
        int size = warnGroupCollection.size();
        for (int i = 0; i < size; ++i) {
            soluColor.put(String.valueOf(warnGroupCollection.get(i).getPeriority()), warnGroupCollection.get(i).getColor());
        }
        return soluColor;
    }

    private KPIWarnParamCollection getKPIWarnParamCollection(Context ctx, String kpiValueId) throws BOSException {
        IKPIWarnParam iKPIWarnParam = KPIWarnParamFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sc = view.getSelector();
        sc.add(new SelectorItemInfo("id"));
        sc.add(new SelectorItemInfo("warnGroup.id"));
        sc.add(new SelectorItemInfo("warnGroup.periority"));
        sc.add(new SelectorItemInfo("edgeParam"));
        sc.add(new SelectorItemInfo("paramValue"));
        sc.add(new SelectorItemInfo("currentValue"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("kpiValue.id", (Object)kpiValueId));
        view.setFilter(filter);
        KPIWarnParamCollection cols = iKPIWarnParam.getKPIWarnParamCollection(view);
        return cols;
    }
}

