/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.atsContrl.plan;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.hr.ats.AtsCommonResEnum;
import com.kingdee.eas.hr.ats.AtsDateCommonResEnum;
import com.kingdee.eas.hr.ats.AttendancePeriodCollection;
import com.kingdee.eas.hr.ats.AttendancePeriodFactory;
import com.kingdee.eas.hr.ats.AttendancePeriodInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEQFn;
import com.kingdee.eas.hr.ats.util.common.AtsEntityUtile;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.vo.common.AtsErrorMsg;
import com.kingdee.eas.hr.atsContrl.AttenceOTCycleType;
import com.kingdee.eas.hr.atsContrl.OTCtrlPlanDepItemInfo;
import com.kingdee.eas.hr.atsContrl.OTCtrlPlanInfo;
import com.kingdee.eas.hr.atsContrl.OTCtrlPlanPerItemInfo;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class OTCLimitGenerator<T, L extends CoreBaseInfo>
extends AtsErrorMsg {
    protected int curCycle;
    protected Calendar generateTime;
    protected Timestamp curTime;
    protected UserInfo currentUserInfo;
    protected CtrlUnitInfo cuInfo;
    protected Set<String> bizTargets;
    protected T planItem;
    protected OTCtrlPlanInfo plan;
    protected Date beginDate1;
    protected Date endDate1;
    protected String limitCycleName1;
    protected ArrayList<OTCLimitCyc> cycs = new ArrayList();
    protected Map<String, BigDecimal> usedLimitMap = new HashMap<String, BigDecimal>();
    protected HashMap<String, List<L>> existLimitMap = new HashMap();
    protected List<L> generateResults = new ArrayList<L>();
    protected List<L> updateColl = new ArrayList<L>();
    protected List<L> newColl = new ArrayList<L>();
    protected ICoreBase iCoreBase;
    protected String tableName;
    protected AttendancePeriodInfo periodOnAttedCycle;
    protected AtsEQFn<L> limitEquasComparator;

    public void generater() {
        this.newColl.clear();
        this.updateColl.clear();
        this.usedLimitMap.clear();
        this.existLimitMap.clear();
        this.generateResults.clear();
        if (this.planItem instanceof OTCtrlPlanPerItemInfo && AtsCollectionUtile.isEmpty((IObjectCollection)((OTCtrlPlanPerItemInfo)this.planItem).getRules())) {
            AtsLog.getLog().error((Object)(this.plan.getName() + "can not find rule in plan!"));
            return;
        }
        this.innerBeforeGenerater();
        if (this.beginDate1 == null || this.endDate1 == null || this.limitCycleName1 == null) {
            AtsLog.getLog().error((Object)"init cycle error!");
            return;
        }
        this.beforeGenerater();
        this.generateLimitInfo();
        this.afterGenerater();
        if (!AtsCollectionUtile.isEmpty(this.generateResults)) {
            this.initExistLimitMap();
            this.initIcoreBase();
            this.beforeSaveResults();
            this.saveResults();
            this.afterSaveResults();
        }
    }

    public void init() {
        if (this.beginDate1 != null && this.endDate1 != null && this.plan != null) {
            return;
        }
        this.plan = this.planItem instanceof OTCtrlPlanPerItemInfo ? ((OTCtrlPlanPerItemInfo)this.planItem).getGroup() : ((OTCtrlPlanDepItemInfo)this.planItem).getGroup();
        this.curTime = new Timestamp(System.currentTimeMillis());
        this.currentUserInfo = (UserInfo)this.ctx.get((Object)"UserInfo");
        this.cuInfo = (CtrlUnitInfo)this.ctx.get((Object)OrgType.ControlUnit);
        this.initGenerateDateRange();
    }

    protected void generateLimitInfo() {
    }

    protected void innerBeforeGenerater() {
        this.initUsedLimitMap();
    }

    protected void beforeGenerater() {
    }

    protected void afterGenerater() {
    }

    protected void saveResults() {
        this.initLimitEquasComparator();
        this.groupUpdateAndNew();
        if (this.iCoreBase != null) {
            if (!AtsCollectionUtile.isEmpty(this.updateColl)) {
                this.doUpdate();
            }
            if (!AtsCollectionUtile.isEmpty(this.newColl)) {
                this.doAddNew();
            }
        }
    }

    protected void groupUpdateAndNew() {
    }

    protected void processUpdateInfo(L newInfo, L oldInfo) {
    }

    protected void initLimitEquasComparator() {
    }

    protected void doUpdate() {
        try {
            this.iCoreBase.updateBatchData((CoreBaseCollection)AtsCollectionUtile.toCoreCollection(this.updateColl, CoreBaseCollection.class));
        }
        catch (EASBizException e) {
            AtsLog.getLog().error((Object)(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.SaveUpdateError, (Context)this.ctx) + "!"), (Throwable)e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.SaveUpdateError, (Context)this.ctx) + "!"), (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void doAddNew() {
        try {
            this.iCoreBase.addnewBatchData((CoreBaseCollection)AtsCollectionUtile.toCoreCollection(this.newColl, CoreBaseCollection.class));
        }
        catch (EASBizException e) {
            AtsLog.getLog().error((Object)(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.SaveAddError, (Context)this.ctx) + "!"), (Throwable)e);
            e.printStackTrace();
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)(MLUtile.getRes((ResourceEnum)AtsCommonResEnum.SaveAddError, (Context)this.ctx) + "!"), (Throwable)e);
            e.printStackTrace();
        }
    }

    private void initIcoreBase() {
        try {
            this.tableName = AtsEntityUtile.getTableName((Context)this.ctx, (CoreBaseInfo)((CoreBaseInfo)this.generateResults.get(0)));
            this.iCoreBase = AtsEntityUtile.getBizInterface((Context)this.ctx, (CoreBaseInfo)((CoreBaseInfo)this.generateResults.get(0)));
        }
        catch (BOSException e) {
            AtsLog.getLog().error((Object)"get biz interface error!", (Throwable)e);
            e.printStackTrace();
        }
    }

    protected void beforeSaveResults() {
    }

    protected void afterSaveResults() {
    }

    protected void initUsedLimitMap() {
    }

    protected void initExistLimitMap() {
    }

    protected void initGenerateDateRange() {
        AttenceOTCycleType cycleType = this.plan.getCycleType();
        if (cycleType == AttenceOTCycleType.attenceCycle) {
            this.initRangeWithCycle();
        } else if (cycleType == AttenceOTCycleType.Season) {
            this.initRangeWithSeason();
        } else {
            this.initRangeWithMonth();
        }
        if (this.cycs.size() > 0 && this.cycs.get(this.cycs.size() - 1).getEndDate() != null && this.needGenerateNextPeriod(this.cycs.get(this.cycs.size() - 1).getEndDate())) {
            ++this.curCycle;
            this.generateTime = Calendar.getInstance();
            this.generateTime.setTime(this.cycs.get(this.cycs.size() - 1).getEndDate());
            this.cycs.get(this.cycs.size() - 1).setEndDate(AtsCommonUtile.getDayEnd((Date)this.cycs.get(this.cycs.size() - 1).getEndDate()));
            this.initGenerateDateRange();
        }
        if (this.cycs.size() > 0) {
            this.cycs.get(this.cycs.size() - 1).setEndDate(AtsCommonUtile.getDayEnd((Date)this.cycs.get(this.cycs.size() - 1).getEndDate()));
        }
    }

    private void initRangeWithMonth() {
        Calendar curCalendar = (Calendar)this.generateTime.clone();
        curCalendar.set(5, 27);
        curCalendar.set(2, curCalendar.get(2) + this.curCycle);
        OTCLimitCyc otcLimitCyc = new OTCLimitCyc();
        otcLimitCyc.setBeginDate(AtsCommonUtile.getMonthFirstDay((Date)curCalendar.getTime()));
        otcLimitCyc.setEndDate(AtsCommonUtile.getMonthLastDay((Date)curCalendar.getTime()));
        otcLimitCyc.setLimitCycleName(new SimpleDateFormat("YYYYMM").format(curCalendar.getTime()));
        this.cycs.add(otcLimitCyc);
    }

    private void initRangeWithCycle() {
        Calendar curCalendar = (Calendar)this.generateTime.clone();
        curCalendar.set(curCalendar.get(1) - 1, 0, 1);
        EntityViewInfo evi = AtsViewUtile.getViewBySelector((String[])new String[]{"startDate", "endDate", "name", "id", ""});
        FilterInfo filerInfo = new FilterInfo();
        filerInfo.getFilterItems().add(new FilterItemInfo("group.id", (Object)this.plan.getAttenceCycle().getId().toString(), CompareType.EQUALS));
        filerInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)curCalendar.getTime(), CompareType.GREATER));
        filerInfo.getFilterItems().add(new FilterItemInfo("startDate", (Object)curCalendar.getTime(), CompareType.LESS_EQUALS));
        filerInfo.getFilterItems().add(new FilterItemInfo("endDate", (Object)curCalendar.getTime(), CompareType.GREATER_EQUALS));
        filerInfo.setMaskString(" #0 and ( #1 or #2 and #3 )");
        evi.setFilter(filerInfo);
        AtsViewUtile.addSorter((String)"startDate", (SortType)SortType.ASCEND, (EntityViewInfo)evi);
        AttendancePeriodCollection attencePeriods = null;
        try {
            attencePeriods = AttendancePeriodFactory.getLocalInstance((Context)this.ctx).getAttendancePeriodCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)attencePeriods)) {
            int needCycleIndex;
            int curCycleInd = -1;
            for (int i = 0; i < attencePeriods.size(); ++i) {
                if (!attencePeriods.get(i).getStartDate().after(this.generateTime.getTime())) continue;
                this.periodOnAttedCycle = attencePeriods.get(i);
                curCycleInd = i - 1;
                break;
            }
            if (curCycleInd == -1) {
                AtsLog.getLog().error((Object)"can not find the cycle the now belong!");
            }
            if ((needCycleIndex = curCycleInd + this.curCycle) > -1 && needCycleIndex < attencePeriods.size()) {
                OTCLimitCyc otcLimitCyc = new OTCLimitCyc();
                otcLimitCyc.setBeginDate(attencePeriods.get(needCycleIndex).getStartDate());
                otcLimitCyc.setEndDate(attencePeriods.get(needCycleIndex).getEndDate());
                otcLimitCyc.setLimitCycleName(attencePeriods.get(needCycleIndex).getName());
                this.cycs.add(otcLimitCyc);
            }
        }
    }

    private void initRangeWithSeason() {
        Calendar curCalendar = (Calendar)this.generateTime.clone();
        int y = 0;
        y = this.curCycle == 0 ? 0 : 3 * this.curCycle - 2;
        curCalendar.set(2, curCalendar.get(2) + y);
        int StartMont = 3 * (curCalendar.get(2) / 3);
        Calendar beginCal = (Calendar)this.generateTime.clone();
        beginCal.set(this.generateTime.get(1), StartMont, 1);
        Calendar endCal = (Calendar)beginCal.clone();
        endCal.set(2, StartMont + 2);
        OTCLimitCyc otcLimitCyc = new OTCLimitCyc();
        otcLimitCyc.setBeginDate(AtsCommonUtile.getMonthFirstDay((Date)beginCal.getTime()));
        otcLimitCyc.setEndDate(AtsCommonUtile.getMonthLastDay((Date)endCal.getTime()));
        otcLimitCyc.setLimitCycleName(MLUtile.getRes((ResourceEnum)AtsDateCommonResEnum.YearAndQuarter, (Context)this.ctx, (Object[])new Object[]{this.generateTime.get(1), endCal.get(2) / 3 + 1}));
        this.cycs.add(otcLimitCyc);
    }

    private boolean needGenerateNextPeriod(Date curPeriodEndDate) {
        Date nextPeriodStartDate = AtsCommonUtile.dateAdd((Date)curPeriodEndDate, (int)5, (int)(-this.plan.getCreateNextBeforDays()));
        return AtsCommonUtile.getDayStart((Date)this.generateTime.getTime()).after(nextPeriodStartDate);
    }

    public final Set<String> getBizTargets() {
        return this.bizTargets;
    }

    public final void setBizTargets(Set<String> bizTarget) {
        this.bizTargets = bizTarget;
    }

    public final T getPlanItem() {
        return this.planItem;
    }

    public final void setPlanItem(T planItem) {
        this.planItem = planItem;
    }

    public final Calendar getGenerateTime() {
        return this.generateTime;
    }

    public final void setGenerateTime(Calendar generateTime) {
        this.generateTime = generateTime;
    }

    public final OTCtrlPlanInfo getPlan() {
        return this.plan;
    }

    public final void setPlan(OTCtrlPlanInfo plan) {
        this.plan = plan;
    }

    public final int getCurCycle() {
        return this.curCycle;
    }

    public final void setCurCycle(int curCycle) {
        this.curCycle = curCycle;
    }

    public final HashMap<String, List<L>> getExistLimitMap() {
        return this.existLimitMap;
    }

    public final void setExistLimitMap(HashMap<String, List<L>> existLimitMap) {
        this.existLimitMap = existLimitMap;
    }

    public final List<L> getGenerateResults() {
        return this.generateResults;
    }

    public final void setGenerateResults(List<L> generateResults) {
        this.generateResults = generateResults;
    }

    public final Map<String, BigDecimal> getUsedLimitMap() {
        return this.usedLimitMap;
    }

    public final void setUsedLimitMap(Map<String, BigDecimal> usedLimitMap) {
        this.usedLimitMap = usedLimitMap;
    }

    public final List<L> getUpdateColl() {
        return this.updateColl;
    }

    public final void setUpdateColl(List<L> updateColl) {
        this.updateColl = updateColl;
    }

    public final List<L> getNewColl() {
        return this.newColl;
    }

    public final void setNewColl(List<L> newColl) {
        this.newColl = newColl;
    }

    public final ICoreBase getiCoreBase() {
        return this.iCoreBase;
    }

    public final void setiCoreBase(ICoreBase iCoreBase) {
        this.iCoreBase = iCoreBase;
    }

    public final String getTableName() {
        return this.tableName;
    }

    public final void setTableName(String tableName) {
        this.tableName = tableName;
    }

    public final Timestamp getCurTime() {
        return this.curTime;
    }

    public final void setCurTime(Timestamp curTime) {
        this.curTime = curTime;
    }

    public UserInfo getCurrentUserInfo() {
        return this.currentUserInfo;
    }

    public void setCurrentUserInfo(UserInfo currentUserInfo) {
        this.currentUserInfo = currentUserInfo;
    }

    public CtrlUnitInfo getCuInfo() {
        return this.cuInfo;
    }

    public void setCuInfo(CtrlUnitInfo cuInfo) {
        this.cuInfo = cuInfo;
    }

    public Date getBeginDate1() {
        return this.beginDate1;
    }

    public void setBeginDate1(Date beginDate1) {
        this.beginDate1 = beginDate1;
    }

    public Date getEndDate1() {
        return this.endDate1;
    }

    public void setEndDate1(Date endDate1) {
        this.endDate1 = endDate1;
    }

    public String getLimitCycleName1() {
        return this.limitCycleName1;
    }

    public void setLimitCycleName1(String limitCycleName1) {
        this.limitCycleName1 = limitCycleName1;
    }

    public ArrayList<OTCLimitCyc> getCycs() {
        return this.cycs;
    }

    public void setCycs(ArrayList<OTCLimitCyc> cycs) {
        this.cycs = cycs;
    }

    public class OTCLimitCyc {
        private Date beginDate;
        private Date endDate;
        private String limitCycleName;

        public Date getBeginDate() {
            return this.beginDate;
        }

        public void setBeginDate(Date beginDate) {
            this.beginDate = beginDate;
        }

        public Date getEndDate() {
            return this.endDate;
        }

        public void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        public String getLimitCycleName() {
            return this.limitCycleName;
        }

        public void setLimitCycleName(String limitCycleName) {
            this.limitCycleName = limitCycleName;
        }
    }
}

