/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.hr.atsContrl.plan.person;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.hr.ats.AtsFileResEnum;
import com.kingdee.eas.hr.ats.AttendanceFileHISCollection;
import com.kingdee.eas.hr.ats.AttendanceFileHISFactory;
import com.kingdee.eas.hr.ats.AttendanceFileHISInfo;
import com.kingdee.eas.hr.ats.ResourceEnum;
import com.kingdee.eas.hr.ats.util.AtsViewUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCollectionUtile;
import com.kingdee.eas.hr.ats.util.common.AtsCommonUtile;
import com.kingdee.eas.hr.ats.util.common.AtsEQFn;
import com.kingdee.eas.hr.ats.util.common.AtsLog;
import com.kingdee.eas.hr.ats.util.common.AtsMapFn;
import com.kingdee.eas.hr.ats.util.common.MLUtile;
import com.kingdee.eas.hr.ats.util.common.TwoFieldProcessor;
import com.kingdee.eas.hr.atsContrl.AtsPersonOTLimitCollection;
import com.kingdee.eas.hr.atsContrl.AtsPersonOTLimitFactory;
import com.kingdee.eas.hr.atsContrl.AtsPersonOTLimitInfo;
import com.kingdee.eas.hr.atsContrl.AttenceOTControlType;
import com.kingdee.eas.hr.atsContrl.EOTUpdateType;
import com.kingdee.eas.hr.atsContrl.OTCtrlPlanPerItemInfo;
import com.kingdee.eas.hr.atsContrl.OTCtrlPlanPerRuleInfo;
import com.kingdee.eas.hr.atsContrl.plan.OTCLUtile;
import com.kingdee.eas.hr.atsContrl.plan.OTCLimitGenerator;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class OTCPerGenerator
extends OTCLimitGenerator<OTCtrlPlanPerItemInfo, AtsPersonOTLimitInfo> {
    private Map<String, AttendanceFileHISInfo> attFileMap;

    @Override
    protected void beforeGenerater() {
        super.beforeGenerater();
        this.initAttFileMap();
    }

    @Override
    public void generateLimitInfo() {
        if (this.attFileMap == null) {
            AtsLog.getLog().error((Object)MLUtile.getRes((ResourceEnum)AtsFileResEnum.InitHisError, (Context)this.ctx));
            return;
        }
        for (String personId : this.bizTargets) {
            int total = ((OTCtrlPlanPerItemInfo)this.planItem).getRules().size();
            for (int i = 0; i < total; ++i) {
                this.generateSpecialLimitInfo(personId, ((OTCtrlPlanPerItemInfo)this.planItem).getRules().get(i));
            }
        }
    }

    @Override
    protected void groupUpdateAndNew() {
        for (AtsPersonOTLimitInfo info : this.generateResults) {
            int index;
            List perList = (List)this.existLimitMap.get(info.getProposer().getId().toString());
            int n = index = perList == null ? -1 : AtsCollectionUtile.indexOf((Collection)perList, (Object)info, (AtsEQFn)this.limitEquasComparator);
            if (index == -1) {
                this.newColl.add(info);
                continue;
            }
            if (perList == null) continue;
            this.processUpdateInfo(info, (AtsPersonOTLimitInfo)perList.get(index));
        }
    }

    @Override
    protected void processUpdateInfo(AtsPersonOTLimitInfo newInfo, AtsPersonOTLimitInfo oldInfo) {
        EOTUpdateType updateType = this.plan.getUpdateType();
        if (updateType == EOTUpdateType.updateAdminChage) {
            if (newInfo.getAdminHashCode() != oldInfo.getAdminHashCode()) {
                newInfo.setId(oldInfo.getId());
                newInfo.setCreateTime(oldInfo.getCreateTime());
                newInfo.setCreator(oldInfo.getCreator());
                this.updateColl.add(newInfo);
            }
        } else if (updateType == EOTUpdateType.cover) {
            newInfo.setId(oldInfo.getId());
            newInfo.setCreateTime(oldInfo.getCreateTime());
            newInfo.setCreator(oldInfo.getCreator());
            this.updateColl.add(newInfo);
        }
    }

    @Override
    protected void initLimitEquasComparator() {
        this.limitEquasComparator = new AtsEQFn<AtsPersonOTLimitInfo>(){

            public boolean eq(AtsPersonOTLimitInfo t1, Object t2) {
                if (t1 == t2) {
                    return true;
                }
                if (t1 == null || t2 == null) {
                    return false;
                }
                if (t1.getClass() != t2.getClass()) {
                    return false;
                }
                AtsPersonOTLimitInfo other = (AtsPersonOTLimitInfo)t2;
                if (t1.getHrOrgHashCode() != other.getHrOrgHashCode()) {
                    return false;
                }
                if (t1.getPerHashCode() != other.getPerHashCode()) {
                    return false;
                }
                if (t1.getLiTypeHashCode() != other.getLiTypeHashCode()) {
                    return false;
                }
                return t1.getdateVHashCode() == other.getdateVHashCode();
            }
        };
    }

    @Override
    protected void initExistLimitMap() {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector((String[])new String[]{"id", "proposer.id", "limittype", "dateValue", "startDate", "hrOrgUnit.id", "cycleDateType", "adminOrgUnit.id", "creator", "createTime"});
        List ctrlTypes = AtsCollectionUtile.map((AbstractObjectCollection)((OTCtrlPlanPerItemInfo)this.planItem).getRules(), (AtsMapFn)new AtsMapFn<OTCtrlPlanPerRuleInfo, String>(){

            public String map(OTCtrlPlanPerRuleInfo t) {
                return t.getCtrlType().getValue();
            }
        });
        AtsViewUtile.getViewByFilter((String)"hrOrgUnit.id", (Object)this.plan.getHrOrgUnit().getId().toString(), (CompareType)CompareType.EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"limittype", new HashSet(ctrlTypes), (CompareType)CompareType.INCLUDE, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"proposer.id", (Object)this.bizTargets, (CompareType)CompareType.INCLUDE, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"startDate", (Object)this.endDate1, (CompareType)CompareType.LESS_EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"endDate", (Object)this.beginDate1, (CompareType)CompareType.GREATER_EQUALS, (EntityViewInfo)evi);
        AtsPersonOTLimitCollection coll = null;
        try {
            coll = AtsPersonOTLimitFactory.getLocalInstance(this.ctx).getAtsPersonOTLimitCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)coll)) {
            this.existLimitMap.clear();
            for (int i = 0; i < coll.size(); ++i) {
                String personId = coll.get(i).getProposer().getId().toString();
                ArrayList<AtsPersonOTLimitInfo> perOTBill = (ArrayList<AtsPersonOTLimitInfo>)this.existLimitMap.get(personId);
                if (perOTBill == null) {
                    perOTBill = new ArrayList<AtsPersonOTLimitInfo>();
                    this.existLimitMap.put(personId, perOTBill);
                }
                perOTBill.add(coll.get(i));
            }
        }
    }

    private void generateSpecialLimitInfo(String personId, OTCtrlPlanPerRuleInfo rule) {
        AttendanceFileHISInfo attFileHis = this.attFileMap.get(personId);
        if (attFileHis == null) {
            AtsLog.getLog().error((Object)("can not find the attFileHis of the personid:" + personId));
            return;
        }
        AtsPersonOTLimitInfo atsPersonOTLimitInfo = new AtsPersonOTLimitInfo();
        atsPersonOTLimitInfo.setProposer(attFileHis.getProposer());
        atsPersonOTLimitInfo.setAdminOrgUnit(attFileHis.getAdminOrgUnit());
        atsPersonOTLimitInfo.setPosition(attFileHis.getPosition());
        atsPersonOTLimitInfo.setHrOrgUnit(attFileHis.getHrOrgUnit());
        atsPersonOTLimitInfo.setIsDefaultManage(attFileHis.isIsDefaultManage());
        atsPersonOTLimitInfo.setAttAdminOrgUnit(attFileHis.getAttAdminOrgUnit());
        atsPersonOTLimitInfo.setOtLimitControlParam(this.plan.getLimitCtrlParam());
        BigDecimal used = (BigDecimal)this.usedLimitMap.get(personId + rule.getCtrlType().getValue());
        used = used == null ? new BigDecimal(0) : used;
        atsPersonOTLimitInfo.setUsed(used);
        atsPersonOTLimitInfo.setStartDate(this.beginDate1);
        atsPersonOTLimitInfo.setEndDate(this.endDate1);
        atsPersonOTLimitInfo.setCycleDateType(this.plan.getCycleType());
        atsPersonOTLimitInfo.setDateValue(this.limitCycleName1);
        atsPersonOTLimitInfo.setWarnValue(rule.getWarnVal());
        atsPersonOTLimitInfo.setLimitValue(rule.getCtrlVal());
        atsPersonOTLimitInfo.setRemained(rule.getCtrlVal().subtract(used));
        atsPersonOTLimitInfo.setLimitType(rule.getCtrlType());
        atsPersonOTLimitInfo.setCreateTime(this.getCurTime());
        atsPersonOTLimitInfo.setCreator(this.getCurrentUserInfo());
        atsPersonOTLimitInfo.setLastUpdateTime(this.getCurTime());
        atsPersonOTLimitInfo.setLastUpdateUser(this.getCurrentUserInfo());
        atsPersonOTLimitInfo.setCU(this.getCuInfo());
        this.generateResults.add(atsPersonOTLimitInfo);
    }

    @Override
    protected void initUsedLimitMap() {
        StringBuffer sqlbuf = new StringBuffer();
        for (int i = 0; i < ((OTCtrlPlanPerItemInfo)this.planItem).getRules().size(); ++i) {
            AttenceOTControlType ctrType = ((OTCtrlPlanPerItemInfo)this.planItem).getRules().get(i).getCtrlType();
            sqlbuf.append(" select concat(person.fid, '").append(ctrType.getValue()).append("' ) perCtrType , sum(billentry.frealottime) userdTime");
            sqlbuf.append(" from T_HR_ATS_OverTimeBillEntry billentry");
            sqlbuf.append(" join T_HR_ATS_OverTimeBill bill on bill.fid=billentry.fbillid and bill.fbillstate=3");
            sqlbuf.append(" join T_BD_Person person on billentry.fpersonid=person.fid ");
            sqlbuf.append(" where bill.fbillstate=3");
            sqlbuf.append(" and person.fid in ").append(AtsCollectionUtile.joinForSqlWithBrackets((Collection)this.bizTargets));
            sqlbuf.append(" and billentry.fotdate <= { ts '").append(AtsCommonUtile.getDayEndStr((Date)this.endDate1)).append("'}");
            sqlbuf.append(" and billentry.fotdate >= { ts '").append(AtsCommonUtile.formateDate((Date)this.beginDate1)).append("'}");
            sqlbuf.append(" and bill.fhrOrgUnitId = '" + this.plan.getHrOrgUnit().getId().toString() + "' ");
            sqlbuf.append(OTCLUtile.getOTBillCycleTypeSql(ctrType));
            sqlbuf.append(" group by person.fid");
            sqlbuf.append(" union all");
        }
        sqlbuf.setLength(sqlbuf.length() - "union all".length());
        TwoFieldProcessor usedLimetProcess = new TwoFieldProcessor(sqlbuf.toString(), this.ctx);
        usedLimetProcess.setCollectAllData(true).process();
        this.usedLimitMap = usedLimetProcess.getAllPageDataForTwoField();
    }

    private void initAttFileMap() {
        EntityViewInfo evi = AtsViewUtile.getViewBySelector((String[])new String[]{"hrOrgUnit.id", "attAdminOrgUnit.id", "attPosition.id", "adminOrgUnit.id", "position.id", "isDefaultManage", "manageRelation.id", "proposer.id", "attendanceNum", "attencePolicy.id", "atsShift.id", "attendFileState", "EFFDT", "LEFFDT", "proposer.id"});
        AtsViewUtile.getViewByFilter((String)"hrOrgUnit.id", (Object)this.plan.getHrOrgUnit().getId().toString(), (CompareType)CompareType.EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"proposer.id", (Object)this.bizTargets, (CompareType)CompareType.INCLUDE, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"attendFileState", (Object)"1", (CompareType)CompareType.EQUALS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"EFFDT", (Object)this.endDate1, (CompareType)CompareType.LESS, (EntityViewInfo)evi);
        AtsViewUtile.getViewByFilter((String)"LEFFDT", (Object)this.beginDate1, (CompareType)CompareType.GREATER, (EntityViewInfo)evi);
        AtsViewUtile.addSorter((String)"EFFDT", (SortType)SortType.ASCEND, (EntityViewInfo)evi);
        AttendanceFileHISCollection coll = null;
        try {
            coll = AttendanceFileHISFactory.getLocalInstance((Context)this.ctx).getAttendanceFileHISCollection(evi);
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        if (!AtsCollectionUtile.isEmpty((IObjectCollection)coll)) {
            this.attFileMap = new HashMap<String, AttendanceFileHISInfo>(coll.size());
            for (int i = 0; i < coll.size(); ++i) {
                if (this.attFileMap.containsKey(coll.get(i).getProposer().getId().toString())) continue;
                this.attFileMap.put(coll.get(i).getProposer().getId().toString(), coll.get(i));
            }
        }
    }

    public final Map<String, AttendanceFileHISInfo> getAttFileMap() {
        return this.attFileMap;
    }

    public final void setAttFileMap(Map<String, AttendanceFileHISInfo> attFileMap) {
        this.attFileMap = attFileMap;
    }
}

