/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.costbudget.util;

import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateHelper {
    private static final String DATE_FORMAT = "yyyy-MM-dd";

    public static Calendar getCurrentCalendar() {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        return calendar;
    }

    public static Calendar getCalendarOfDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar;
    }

    public static int getCurrentYear() {
        return DateHelper.getCurrentCalendar().get(1);
    }

    public static int getCurrentMonth() {
        return DateHelper.getCurrentCalendar().get(2) + 1;
    }

    public static Timestamp getTimestamp(Date effdt) {
        Timestamp datetime = new Timestamp(effdt.getTime());
        return datetime;
    }

    public static String formatDateString(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT);
        return "{ts'" + sdf.format(date) + "'}";
    }

    public static int getYearOfDate(Date date) {
        return DateHelper.getCalendarOfDate(date).get(1);
    }

    public static int getMonthOfDate(Date date) {
        return DateHelper.getCalendarOfDate(date).get(2) + 1;
    }

    public static Date getYearOfFirstDay(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getYearOfLastDay(int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, 11);
        calendar.set(5, 31);
        return calendar.getTime();
    }

    public static Date getMonthOfFirstDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMinimum(5));
        return calendar.getTime();
    }

    public static Date getMonthOfLastDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        return calendar.getTime();
    }

    public static Date[] getFirstDateOfMonthAndNextMonth(int year, int month) {
        Calendar calendar1 = Calendar.getInstance();
        calendar1.set(1, year);
        calendar1.set(2, month - 1);
        calendar1.set(5, calendar1.getActualMinimum(5));
        calendar1.set(11, 0);
        calendar1.set(14, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        Calendar calendar2 = Calendar.getInstance();
        calendar2.set(1, year);
        calendar2.set(2, month);
        calendar2.set(5, calendar1.getActualMinimum(5));
        calendar2.set(11, 0);
        calendar1.set(14, 0);
        calendar2.set(12, 0);
        calendar2.set(13, 0);
        return new Date[]{calendar1.getTime(), calendar2.getTime()};
    }
}

