/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.staffcontrol.util;

import com.kingdee.bos.Context;
import com.kingdee.shr.base.syssetting.util.DateUtils;
import com.kingdee.shr.costbudget.util.DateHelper;
import com.kingdee.shr.staffcontrol.StaffManageChannelEnum;
import com.kingdee.shr.staffcontrol.util.IStaffManageChannel;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelHalfYear;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelMonth;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelQua;
import com.kingdee.shr.staffcontrol.util.StaffManageChannelYear;
import com.kingdee.util.StringUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class StaffManageChannelUtil {
    public static final String HIS_CHANNEL_CUT = "hisChannelCut";
    public static final String NOW_CHANNEL_CUT = "nowChannelCut";
    public static final String FUT_CHANNEL_CUT = "futChannelCut";

    public static IStaffManageChannel getInstance(StaffManageChannelEnum type) {
        if (type == null) {
            return null;
        }
        switch (type.getValue()) {
            case 1: {
                return new StaffManageChannelYear();
            }
            case 2: {
                return new StaffManageChannelHalfYear();
            }
            case 3: {
                return new StaffManageChannelQua();
            }
            case 4: {
                return new StaffManageChannelMonth();
            }
        }
        return null;
    }

    public static String getStaffChannel(int channel) {
        int curMonth = DateHelper.getCurrentMonth();
        String staffChannelStr = "";
        if (channel == 1) {
            staffChannelStr = "FStaffYear";
        } else if (channel == 2) {
            if (curMonth >= 1 && curMonth <= 6) {
                staffChannelStr = "FStaffHaffYear1";
            } else if (curMonth >= 7 && curMonth <= 12) {
                staffChannelStr = "FStaffHaffYear2";
            }
        } else if (channel == 3) {
            if (curMonth >= 1 && curMonth <= 3) {
                staffChannelStr = "FStaffQuarter1";
            } else if (curMonth >= 4 && curMonth <= 6) {
                staffChannelStr = "FStaffQuarter2";
            } else if (curMonth >= 7 && curMonth <= 9) {
                staffChannelStr = "FStaffQuarter3";
            } else if (curMonth >= 10 && curMonth <= 12) {
                staffChannelStr = "FStaffQuarter4";
            }
        } else if (channel == 4) {
            staffChannelStr = "FStaffMonth" + curMonth;
        }
        return staffChannelStr;
    }

    public static String getStaffChannel(int channel, int curMonth) {
        String staffChannelStr = "";
        if (channel == 1) {
            staffChannelStr = "FStaffYear";
        } else if (channel == 2) {
            if (curMonth >= 1 && curMonth <= 6) {
                staffChannelStr = "FStaffHaffYear1";
            } else if (curMonth >= 7 && curMonth <= 12) {
                staffChannelStr = "FStaffHaffYear2";
            }
        } else if (channel == 3) {
            if (curMonth >= 1 && curMonth <= 3) {
                staffChannelStr = "FStaffQuarter1";
            } else if (curMonth >= 4 && curMonth <= 6) {
                staffChannelStr = "FStaffQuarter2";
            } else if (curMonth >= 7 && curMonth <= 9) {
                staffChannelStr = "FStaffQuarter3";
            } else if (curMonth >= 10 && curMonth <= 12) {
                staffChannelStr = "FStaffQuarter4";
            }
        } else if (channel == 4) {
            staffChannelStr = "FStaffMonth" + curMonth;
        }
        return staffChannelStr;
    }

    public static Date getMonthOfFirstDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMinimum(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getMonthOfLastDay(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, calendar.getActualMaximum(5));
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        return calendar.getTime();
    }

    public static Date getDateZeroFormat(Date date) {
        String dateStr = new SimpleDateFormat("yyyy-MM-dd").format(date);
        return DateUtils.parseCustomDateString((String)dateStr, (String)"yyyy-MM-dd");
    }

    public static int getMonthByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(2) + 1;
    }

    public static int getYearByDate(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Map<String, List<String>> getStaffChannelCutMap(Context ctx, StaffManageChannelEnum channelType, int projectYear) {
        HashMap<String, List<String>> channelCutMap = new HashMap<String, List<String>>();
        IStaffManageChannel iStaffManageChannel = StaffManageChannelUtil.getInstance(channelType);
        String channelSQLChip = iStaffManageChannel.getSQLChip();
        String nowChip = StaffManageChannelUtil.getStaffChannel(channelType.getValue());
        ArrayList<String> hisChannelChips = new ArrayList<String>();
        ArrayList<String> nowChannelChips = new ArrayList<String>();
        ArrayList<String> futChannelChips = new ArrayList<String>();
        int curYear = DateHelper.getCurrentYear();
        if (projectYear != curYear) {
            String[] channelSQLArr;
            for (String channelChip : channelSQLArr = channelSQLChip.split(",")) {
                hisChannelChips.add(channelChip);
            }
            if (projectYear < curYear) {
                channelCutMap.put(HIS_CHANNEL_CUT, hisChannelChips);
            } else {
                channelCutMap.put(FUT_CHANNEL_CUT, hisChannelChips);
            }
        } else {
            if (!channelSQLChip.contains(",")) {
                nowChannelChips.add(nowChip);
                channelCutMap.put(NOW_CHANNEL_CUT, nowChannelChips);
                return channelCutMap;
            }
            String nowChipSplit = nowChip;
            if (channelSQLChip.startsWith(nowChip)) {
                String[] cArr;
                nowChipSplit = nowChipSplit + ",";
                String[] channelSQLArr = channelSQLChip.split(nowChipSplit);
                for (String cStr : cArr = channelSQLArr[1].split(",")) {
                    if (StringUtils.isEmpty((String)cStr)) continue;
                    futChannelChips.add(cStr);
                }
                channelCutMap.put(FUT_CHANNEL_CUT, futChannelChips);
            } else if (channelSQLChip.endsWith(nowChip)) {
                String[] cArr;
                nowChipSplit = "," + nowChipSplit;
                String[] channelSQLArr = channelSQLChip.split(nowChipSplit);
                for (String cStr : cArr = channelSQLArr[0].split(",")) {
                    if (StringUtils.isEmpty((String)cStr)) continue;
                    hisChannelChips.add(cStr);
                }
                channelCutMap.put(HIS_CHANNEL_CUT, hisChannelChips);
            } else {
                String[] cArr;
                String[] channelSQLArr = channelSQLChip.split(nowChipSplit);
                if (channelSQLArr[0].length() > 0) {
                    for (String cStr : cArr = channelSQLArr[0].split(",")) {
                        if (StringUtils.isEmpty((String)cStr)) continue;
                        hisChannelChips.add(cStr);
                    }
                    channelCutMap.put(HIS_CHANNEL_CUT, hisChannelChips);
                }
                if (channelSQLArr[1].length() > 0) {
                    for (String cStr : cArr = channelSQLArr[1].split(",")) {
                        if (StringUtils.isEmpty((String)cStr)) continue;
                        futChannelChips.add(cStr);
                    }
                    channelCutMap.put(FUT_CHANNEL_CUT, futChannelChips);
                }
            }
            nowChannelChips.add(nowChip);
            channelCutMap.put(NOW_CHANNEL_CUT, nowChannelChips);
        }
        return channelCutMap;
    }
}

