/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteforother.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.inteforother.InteMainConfigException;
import com.kingdee.shr.inteforother.InterEntityAllowCollection;
import com.kingdee.shr.inteforother.InterEntityAllowFactory;
import com.kingdee.shr.inteforother.InterEntityAllowInfo;
import com.kingdee.shr.inteforother.InterfaceExecuteLogFactory;
import com.kingdee.shr.inteforother.InterfaceExecuteLogInfo;
import com.kingdee.shr.inteforother.InterfaceMainConfigInfo;
import com.kingdee.shr.inteforother.service.IHRMainInterfaceService;
import com.kingdee.shr.inteforother.util.HRMainSqlHelper;
import com.kingdee.shr.inteforother.vo.InteMainResult;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractHRInterfaceForOtherService
implements IHRMainInterfaceService {
    public static Logger logger = LoggerFactory.getLogger(AbstractHRInterfaceForOtherService.class);

    @Override
    public InteMainResult executeForRead(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        if (logger.isInfoEnabled()) {
            logger.info("AbstractInterfaceForOtherService.execute param: " + param);
        }
        InterfaceMainConfigInfo inteMainConfig = (InterfaceMainConfigInfo)param.get("inteMainConfig");
        IObjectPK logPK = this._recordInterfaceLog(ctx, param, inteMainConfig);
        this._beforeExecuteData(ctx, inteMainConfig);
        InteMainResult result = this._executeData(ctx, inteMainConfig);
        InteMainResult resultAfter = this._afterExecuteGetData(ctx, inteMainConfig, result, logPK);
        return resultAfter;
    }

    protected IObjectPK _recordInterfaceLog(Context ctx, Map<String, Object> param, InterfaceMainConfigInfo inteMainConfig) throws BOSException, EASBizException {
        InterfaceExecuteLogInfo logInfo = new InterfaceExecuteLogInfo();
        String clientIp = ctx.getClientHostIP();
        String paramStr = param.toString();
        logInfo.setInterfaceMainConfig(inteMainConfig);
        logInfo.setExecuteParam(paramStr);
        logInfo.setExecuteIP(clientIp);
        IObjectPK objectPK = InterfaceExecuteLogFactory.getLocalInstance(ctx).addnew(logInfo);
        return objectPK;
    }

    protected void _beforeExecuteData(Context ctx, InterfaceMainConfigInfo inteMainConfig) throws BOSException, EASBizException {
        String queryImpl = inteMainConfig.getQueryImpl();
        if (!StringUtils.isEmpty((CharSequence)queryImpl)) {
            Set<String> queryEntitys = HRMainSqlHelper.getQueryEntityFullName(queryImpl);
            ArrayList<String> allowEntityList = new ArrayList<String>();
            InterEntityAllowCollection allowColl = InterEntityAllowFactory.getLocalInstance(ctx).getInterEntityAllowCollection();
            for (int i = 0; i < allowColl.size(); ++i) {
                InterEntityAllowInfo allowInfo = allowColl.get(i);
                String allowEntityName = allowInfo.getEntityFulleName();
                allowEntityList.add(allowEntityName);
            }
            for (String queryEntity : queryEntitys) {
                if (allowEntityList.contains(queryEntity)) continue;
                throw new InteMainConfigException(InteMainConfigException.NOT_ALLOWED_ENTITY, new Object[]{queryEntity});
            }
        }
    }

    protected InteMainResult _executeData(Context ctx, InterfaceMainConfigInfo inteMainConfig) throws BOSException, EASBizException {
        return null;
    }

    protected InteMainResult _afterExecuteGetData(Context ctx, InterfaceMainConfigInfo inteMainConfig, InteMainResult result, IObjectPK logPK) throws BOSException, EASBizException {
        return result;
    }

    @Override
    public IObjectPK executeForWrite(Context ctx, Map<String, Object> param) throws BOSException, EASBizException {
        return null;
    }

    public static List<HashMap<String, Object>> getRsListData(IRowSet rs) throws BOSException {
        ArrayList<HashMap<String, Object>> dataList = new ArrayList<HashMap<String, Object>>();
        try {
            int columnCount = rs.getMetaData().getColumnCount();
            while (rs.next()) {
                HashMap<String, String> dataMap = new HashMap<String, String>();
                for (int i = 0; i < columnCount; ++i) {
                    String colName = rs.getMetaData().getColumnName(i + 1);
                    if (colName.equals("temprownumber") || colName.equals("tempcolumn")) continue;
                    dataMap.put(colName, rs.getString(colName));
                }
                dataList.add(dataMap);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return dataList;
    }
}

