/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteforother.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.PermItemFactory;
import com.kingdee.eas.base.permission.PermItemInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.base.permission.api.service.SHRFunctionPermissionService;
import com.kingdee.shr.inteforother.InteMainConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HRMainDataPermItemCheckUtil {
    private static Logger logger = LoggerFactory.getLogger(HRMainDataPermItemCheckUtil.class);

    public static void checkPermItemForInterface(Context ctx, PermItemInfo permItemInfo) throws EASBizException, BOSException {
        if (permItemInfo == null) {
            throw new InteMainConfigException(InteMainConfigException.NO_PERMITEM);
        }
        PermItemInfo permInfo = PermItemFactory.getLocalInstance((Context)ctx).getPermItemInfo((IObjectPK)new ObjectUuidPK(permItemInfo.getId()));
        if (logger.isInfoEnabled()) {
            logger.info("HRMainDataPermItemCheckUtil.checkPermItemForInterface permItemInfo: " + permItemInfo.getId());
        }
        try {
            SHRFunctionPermissionService.checkCurrnetUserFunctionPermission((Context)ctx, (PermItemInfo)permInfo);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            String userNumber = ContextUtil.getCurrentUserInfo((Context)ctx).getNumber();
            throw new InteMainConfigException(InteMainConfigException.USER_NO_PERMISSION, new Object[]{userNumber});
        }
    }
}

