/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.integraterec.osf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.syssetting.app.osf.OSFAppUtil;
import com.kingdee.shr.base.syssetting.util.DataValueTranslatorUtil;
import com.kingdee.shr.integraterec.IIntegrateLog;
import com.kingdee.shr.integraterec.IInvokeColumnValue;
import com.kingdee.shr.integraterec.IntegrateAccountCollection;
import com.kingdee.shr.integraterec.IntegrateAccountFactory;
import com.kingdee.shr.integraterec.IntegrateAccountInfo;
import com.kingdee.shr.integraterec.IntegrateLogCollection;
import com.kingdee.shr.integraterec.IntegrateLogFactory;
import com.kingdee.shr.integraterec.IntegrateLogInfo;
import com.kingdee.shr.integraterec.InvokeColumnInfo;
import com.kingdee.shr.integraterec.InvokeColumnValueCollection;
import com.kingdee.shr.integraterec.InvokeColumnValueFactory;
import com.kingdee.shr.integraterec.InvokeColumnValueInfo;
import com.kingdee.shr.integraterec.InvokeInterfaceCollection;
import com.kingdee.shr.integraterec.InvokeInterfaceColumnCollection;
import com.kingdee.shr.integraterec.InvokeInterfaceColumnInfo;
import com.kingdee.shr.integraterec.InvokeInterfaceFactory;
import com.kingdee.shr.integraterec.InvokeInterfaceInfo;
import com.kingdee.shr.integraterec.app.IntegrateType;
import com.kingdee.shr.integraterec.app.InterfaceFrequencyType;
import com.kingdee.shr.integraterec.app.YesOrNoEnum;
import com.kingdee.shr.integraterec.osf.IntegrateResVO;
import com.kingdee.shr.integraterec.utils.DateUtil;
import com.kingdee.shr.integraterec.utils.HttpUtil;
import com.kingdee.shr.integraterec.utils.IntegrateDBUtil;
import com.kingdee.shr.integraterec.utils.IntegrateJSONUtil;
import com.kingdee.shr.integraterec.utils.JSONUtil;
import com.kingdee.shr.integraterec.utils.RandomUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushIntegrateRecService
implements IHRMsfService {
    private Logger logger = LoggerFactory.getLogger(PushIntegrateRecService.class);
    private String from;
    private String triggerKey;
    private String billIds;
    private int offset;
    private int limit;
    private String hireMode;
    private String resBillIds;
    private String requestId;
    private String integrateType;
    private String pathParam;
    private String requestBodyParam;
    private String queryFilterParam;
    private String cloudServiceUrl;

    public Object process(Context ctx, Map param) throws EASBizException, BOSException {
        String[] keys;
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("**************PushIntegrateRecService START***************");
        }
        this.from = (String)param.get("from");
        this.triggerKey = (String)param.get("triggerKey");
        this.integrateType = (String)param.get("integrateType");
        this.billIds = (String)param.get("billIds");
        this.queryFilterParam = (String)param.get("queryFilterParam");
        this.requestBodyParam = (String)param.get("requestBodyParam");
        this.offset = param.get("offset") != null ? (Integer)param.get("offset") : 0;
        this.limit = param.get("limit") != null ? (Integer)param.get("limit") : 0;
        String string = this.hireMode = param.get("hireMode") != null ? (String)param.get("hireMode") : "";
        if (StringUtils.isEmpty((CharSequence)this.billIds)) {
            this.resBillIds = "null";
            this.billIds = "";
        } else {
            this.resBillIds = this.billIds;
        }
        this.pathParam = (String)param.get("pathParam");
        this.requestId = this.getServerNode() + RandomUtil.getRequestId();
        JSONObject result = new JSONObject();
        result.put("state", (Object)1);
        result.put("requestId", (Object)this.requestId);
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{this.triggerKey})) {
            result.put("success", (Object)0);
            String msg = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"PUSH_INTE_ERROR1", (Context)ctx);
            result.put("message", (Object)msg);
            this.processFailLog(ctx, msg);
            return result;
        }
        InvokeInterfaceCollection interfaceCollection = new InvokeInterfaceCollection();
        String interfaceSql = "where invokeStatus=1 ";
        if (StringUtils.isNotEmpty((CharSequence)this.integrateType)) {
            if (this.integrateType.contains(",")) {
                String[] split = this.integrateType.split(",");
                interfaceSql = interfaceSql + " and integrateType in ( ";
                for (String type : split) {
                    interfaceSql = interfaceSql + Integer.parseInt(type);
                    interfaceSql = interfaceSql + ",";
                }
                interfaceSql = interfaceSql.substring(0, interfaceSql.length() - 1);
                interfaceSql = interfaceSql + " )";
            } else {
                interfaceSql = interfaceSql + " and integrateType =" + Integer.parseInt(this.integrateType);
            }
        }
        for (String key : keys = this.triggerKey.split(",")) {
            interfaceSql = interfaceSql + " and triggerKey like '%" + key + "%' ";
            interfaceCollection.addCollection(InvokeInterfaceFactory.getLocalInstance(ctx).getInvokeInterfaceCollection(interfaceSql));
        }
        if (interfaceCollection.size() == 0) {
            result.put("state", (Object)0);
            String msg = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"NO_INTERFACE", (Context)ctx);
            msg = this.triggerKey.replace(",", "|") + msg;
            result.put("message", (Object)msg);
            this.processFailLog(ctx, msg);
            return result;
        }
        JSONObject integrateRes = this.processIntegrate(ctx, interfaceCollection);
        result.put("integrateRes", (Object)integrateRes);
        return result;
    }

    private JSONObject processIntegrate(Context ctx, InvokeInterfaceCollection interfaceCollection) throws BOSException, EASBizException {
        JSONObject res = new JSONObject();
        IntegrateResVO vo = new IntegrateResVO();
        vo.setState(0);
        String msg1 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"DOING_INVOKE", (Context)ctx);
        for (int i = 0; i < interfaceCollection.size(); ++i) {
            List list;
            String[] msgFail;
            String msgFail2;
            String msg;
            Map dataObj;
            String resData;
            JSONObject osfObj;
            HashMap param;
            String osfName;
            String msg2;
            InvokeInterfaceInfo interfaceInfo = interfaceCollection.get(i);
            vo.setType(interfaceInfo.getIntegrateType().getAlias());
            if (interfaceInfo.getIntegrateType() == IntegrateType.MOKA) {
                IntegrateAccountInfo moka = this.getIntegrateAccount(ctx, interfaceInfo);
                if (moka == null) {
                    msg2 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"NO_INVOKE_ACCOUNT", (Context)ctx);
                    this.logger.error(msg1 + interfaceInfo.getIntegrateType().getAlias() + msg2);
                    vo.setMsg(msg1 + interfaceInfo.getIntegrateType().getAlias() + msg2);
                    if (res.containsKey((Object)this.resBillIds)) {
                        List list2 = (List)res.get((Object)this.resBillIds);
                        list2.add(vo);
                        res.put(this.resBillIds, (Object)list2);
                    } else {
                        res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    }
                    return res;
                }
                if (StringUtils.isEmpty((CharSequence)moka.getCode())) {
                    msg2 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"NO_MOKA_CODE", (Context)ctx);
                    this.logger.error(msg1 + interfaceInfo.getIntegrateType().getAlias() + msg2);
                    vo.setMsg(msg1 + interfaceInfo.getIntegrateType().getAlias() + msg2);
                    if (res.containsKey((Object)this.resBillIds)) {
                        List list3 = (List)res.get((Object)this.resBillIds);
                        list3.add(vo);
                        res.put(this.resBillIds, (Object)list3);
                    } else {
                        res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    }
                    return res;
                }
            }
            if (interfaceInfo.getIntegrateType() == IntegrateType.TUPU) {
                IntegrateAccountInfo tupu = this.getIntegrateAccount(ctx, interfaceInfo);
                if (tupu == null) {
                    this.logger.error(msg1 + interfaceInfo.getIntegrateType().getAlias() + "\u65e0\u5bf9\u5e94\u96c6\u6210\u8d26\u53f7");
                    vo.setMsg(msg1 + interfaceInfo.getIntegrateType().getAlias() + "\u65e0\u5bf9\u5e94\u96c6\u6210\u8d26\u53f7");
                    if (res.containsKey((Object)this.resBillIds)) {
                        List list4 = (List)res.get((Object)this.resBillIds);
                        list4.add(vo);
                        res.put(this.resBillIds, (Object)list4);
                    } else {
                        res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    }
                    return res;
                }
                if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{tupu.getCode(), tupu.getName()})) {
                    msg2 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"NO_MOKA_CODE", (Context)ctx);
                    this.logger.error(msg1 + interfaceInfo.getIntegrateType().getAlias() + msg2);
                    vo.setMsg(msg1 + interfaceInfo.getIntegrateType().getAlias() + msg2);
                    if (res.containsKey((Object)this.resBillIds)) {
                        List list5 = (List)res.get((Object)this.resBillIds);
                        list5.add(vo);
                        res.put(this.resBillIds, (Object)list5);
                    } else {
                        res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    }
                    return res;
                }
            }
            if (interfaceInfo.getIntegrateExecuteType().getValue() == 1) {
                String[] billIdArr;
                if (interfaceInfo.getInvokeType().getValue() == 1) {
                    osfName = interfaceInfo.getInvokeOSF();
                    if (StringUtils.isNotEmpty((CharSequence)osfName)) {
                        param = Maps.newHashMap();
                        param.put("billIds", this.billIds);
                        param.put("offset", this.offset);
                        param.put("limit", this.limit);
                        param.put("hireMode", this.hireMode);
                        param.put("invokeInterfaceId", interfaceInfo.getId().toString());
                        Object o = OSFAppUtil.callService((Context)ctx, (String)osfName, (Map)param);
                        String osfRes = o.toString();
                        try {
                            if (this.logger.isDebugEnabled()) {
                                this.logger.debug("PushIntegrateRecService requestOSF\uff1a" + osfName + "res: " + osfRes);
                            }
                            if ((osfObj = JSONUtil.getJSON(osfRes)).get((Object)"code").toString().equals("0")) {
                                resData = osfObj.get((Object)"data").toString();
                                dataObj = (Map)JSON.parseObject((String)resData, Map.class);
                                for (Map.Entry entry : dataObj.entrySet()) {
                                    String billId = (String)entry.getKey();
                                    vo = this.integrateCloudService(ctx, interfaceInfo, ((JSONObject)entry.getValue()).toJSONString(), billId);
                                    if (res.containsKey((Object)billId)) {
                                        List list6 = (List)res.get((Object)this.resBillIds);
                                        list6.add(vo);
                                        res.put(billId, (Object)list6);
                                        continue;
                                    }
                                    res.put(billId, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                                }
                                continue;
                            }
                            msg = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"DOING_OSF", (Context)ctx);
                            msgFail2 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"FAILURE_KEY", (Context)ctx);
                            vo.setMsg(interfaceInfo.getInvokeName() + msg + osfName + msgFail2);
                            res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                        }
                        catch (Exception e) {
                            String msgFail3 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"REQUEST_OSF_FAIL", (Context)ctx);
                            this.logger.error(msgFail3 + e.getMessage(), (Throwable)e);
                            vo.setMsg(msgFail3 + ":" + e.getMessage());
                            if (res.containsKey((Object)this.resBillIds)) {
                                List list7 = (List)res.get((Object)this.resBillIds);
                                list7.add(vo);
                                res.put(this.resBillIds, (Object)list7);
                                continue;
                            }
                            res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                        }
                        continue;
                    }
                    msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"REQUEST_OSF_NOT_EXIST", (Context)ctx);
                    this.logger.error(interfaceInfo.getInvokeName() + (String)msgFail);
                    vo.setMsg(interfaceInfo.getInvokeName() + (String)msgFail);
                    if (res.containsKey((Object)this.resBillIds)) {
                        List list8 = (List)res.get((Object)this.resBillIds);
                        list8.add(vo);
                        res.put(this.resBillIds, (Object)list8);
                        continue;
                    }
                    res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    continue;
                }
                if (interfaceInfo.getInvokeType().getValue() == 3) {
                    vo = this.doRequestInvokeInterface(ctx, interfaceInfo, this.billIds);
                    if (res.containsKey((Object)this.resBillIds)) {
                        list = (List)res.get((Object)this.resBillIds);
                        list.add(vo);
                        res.put(this.resBillIds, (Object)list);
                        continue;
                    }
                    res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    continue;
                }
                if (interfaceInfo.getInvokeType().getValue() != 2) continue;
                if (StringUtils.isEmpty((CharSequence)this.billIds)) {
                    vo = this.doQueryInvokeInterface(ctx, interfaceInfo, this.billIds);
                    if (res.containsKey((Object)this.resBillIds)) {
                        list = (List)res.get((Object)this.resBillIds);
                        list.add(vo);
                        res.put(this.resBillIds, (Object)list);
                        continue;
                    }
                    res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    continue;
                }
                for (String billId : billIdArr = this.billIds.split(",")) {
                    vo = this.doQueryInvokeInterface(ctx, interfaceInfo, billId);
                    if (res.containsKey((Object)billId)) {
                        List list9 = (List)res.get((Object)this.resBillIds);
                        list9.add(vo);
                        res.put(billId, (Object)list9);
                        continue;
                    }
                    res.put(billId, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                }
                continue;
            }
            if (interfaceInfo.getIntegrateExecuteType().getValue() != 2) continue;
            if (interfaceInfo.getInvokeType().getValue() == 1) {
                osfName = interfaceInfo.getInvokeOSF();
                if (StringUtils.isNotEmpty((CharSequence)osfName)) {
                    param = Maps.newHashMap();
                    param.put("billIds", this.billIds);
                    param.put("offset", this.offset);
                    param.put("limit", this.limit);
                    param.put("hireMode", this.hireMode);
                    param.put("invokeInterfaceId", interfaceInfo.getId().toString());
                    Object o = OSFAppUtil.callService((Context)ctx, (String)osfName, (Map)param);
                    String osfRes = o.toString();
                    this.logger.error("PushIntegrateRecService requstOSF\uff1a" + osfName + " res \uff1a " + osfRes);
                    osfObj = JSONUtil.getJSON(osfRes);
                    if (osfObj.get((Object)"code").toString().equals("0")) {
                        resData = osfObj.get((Object)"data").toString();
                        dataObj = (Map)JSON.parseObject((String)resData, Map.class);
                        String tempBillIds = dataObj.get(this.billIds) != null ? ((JSONObject)dataObj.get(this.billIds)).toJSONString() : "";
                        vo = this.integrateCloudService(ctx, interfaceInfo, tempBillIds, this.billIds);
                        if (res.containsKey((Object)this.resBillIds)) {
                            List list10 = (List)res.get((Object)this.resBillIds);
                            list10.add(vo);
                            res.put(this.resBillIds, (Object)list10);
                            continue;
                        }
                        res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                        continue;
                    }
                    msg = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"DOING_OSF", (Context)ctx);
                    msgFail2 = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"FAILURE_KEY", (Context)ctx);
                    vo.setMsg(interfaceInfo.getInvokeName() + msg + osfName + msgFail2);
                    if (res.containsKey((Object)this.resBillIds)) {
                        List list11 = (List)res.get((Object)this.resBillIds);
                        list11.add(vo);
                        res.put(this.resBillIds, (Object)list11);
                        continue;
                    }
                    res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                    continue;
                }
                msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"REQUEST_OSF_NOT_EXIST", (Context)ctx);
                this.logger.error(interfaceInfo.getInvokeName() + (String)msgFail);
                vo.setMsg(interfaceInfo.getInvokeName() + (String)msgFail);
                if (res.containsKey((Object)this.resBillIds)) {
                    List list12 = (List)res.get((Object)this.resBillIds);
                    list12.add(vo);
                    res.put(this.resBillIds, (Object)list12);
                    continue;
                }
                res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                continue;
            }
            if (interfaceInfo.getInvokeType().getValue() == 2) {
                vo = this.doQueryInvokeInterface(ctx, interfaceInfo, this.billIds);
                if (res.containsKey((Object)this.resBillIds)) {
                    list = (List)res.get((Object)this.resBillIds);
                    list.add(vo);
                    res.put(this.resBillIds, (Object)list);
                    continue;
                }
                res.put(this.resBillIds, (Object)Lists.newArrayList((Object[])new IntegrateResVO[]{vo}));
                continue;
            }
            if (interfaceInfo.getInvokeType().getValue() != 3) continue;
        }
        return res;
    }

    private IntegrateResVO doQueryInvokeInterface(Context ctx, InvokeInterfaceInfo interfaceInfo, String billId) throws EASBizException, BOSException {
        String queryFilter;
        String interfaceParam;
        IntegrateResVO vo = new IntegrateResVO();
        vo.setState(0);
        vo.setType(interfaceInfo.getIntegrateType().getAlias());
        boolean checkFrequency = this.checkFrequency(ctx, interfaceInfo);
        if (checkFrequency) {
            String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"OUT_FREQUNENCY", (Context)ctx);
            this.logger.error(interfaceInfo.getInvokeName() + msgFail);
            vo.setMsg(interfaceInfo.getInvokeName() + msgFail);
            return vo;
        }
        String queryName = interfaceInfo.getInvokeQuery();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{queryName, interfaceParam = interfaceInfo.getInterfaceParam()})) {
            return this.integrateCloudService(ctx, interfaceInfo, null, null);
        }
        InvokeInterfaceColumnCollection invokeConfig = interfaceInfo.getInvokeConfig();
        SelectorItemCollection sic = this.getSelectorCollection(invokeConfig);
        if (sic.size() == 0) {
            String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"NO_INVOKE_COLUMN_CONFIG", (Context)ctx);
            this.logger.error(interfaceInfo.getInvokeName() + msgFail);
            vo.setMsg(interfaceInfo.getInvokeName() + msgFail);
            return vo;
        }
        MetaDataPK query = MetaDataPK.create((String)queryName);
        IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
        IRowSet resultSet = null;
        EntityViewInfo ev = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        boolean checkRepeat = this.checkRepeat(ctx, interfaceInfo.getId().toString(), billId);
        if (checkRepeat) {
            String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"ALREADY_EXECUTE", (Context)ctx);
            this.logger.error(interfaceInfo.getInvokeName() + msgFail);
            vo.setMsg(interfaceInfo.getInvokeName() + msgFail);
            return vo;
        }
        if (StringUtils.isNotEmpty((CharSequence)billId)) {
            filter.getFilterItems().add(new FilterItemInfo("id", (Object)DataValueTranslatorUtil.stringArray2Set((String[])billId.split(",")), CompareType.INCLUDE));
        }
        if (StringUtils.isNotEmpty((CharSequence)(queryFilter = interfaceInfo.getQueryFilter()))) {
            if (StringUtils.isNotEmpty((CharSequence)this.queryFilterParam)) {
                JsonElement json = IntegrateJSONUtil.getJSON(this.queryFilterParam);
                queryFilter = IntegrateJSONUtil.replaceUrl(json, queryFilter);
            }
            filter.getFilterItems().add(new FilterItemInfo(queryFilter));
        }
        ev.setFilter(filter);
        ev.setSelector(sic);
        exec.setObjectView(ev);
        resultSet = exec.executeQuery();
        if (resultSet == null || resultSet.size() == 0) {
            String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"DOING_INVOKE_NO_DATA", (Context)ctx);
            this.logger.error(interfaceInfo.getInvokeName() + msgFail);
            vo.setMsg(interfaceInfo.getInvokeName() + msgFail);
            return vo;
        }
        return this.processIntegrateInterfaceQueryRes(ctx, interfaceInfo, resultSet);
    }

    private IntegrateResVO doRequestInvokeInterface(Context ctx, InvokeInterfaceInfo interfaceInfo, String billId) throws EASBizException, BOSException {
        IntegrateResVO vo = new IntegrateResVO();
        vo.setState(0);
        vo.setType(interfaceInfo.getIntegrateType().getAlias());
        boolean checkFrequency = this.checkFrequency(ctx, interfaceInfo);
        if (checkFrequency) {
            String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"OUT_FREQUNENCY", (Context)ctx);
            this.logger.error(interfaceInfo.getInvokeName() + msgFail);
            vo.setMsg(interfaceInfo.getInvokeName() + msgFail);
            return vo;
        }
        String interfaceParam = interfaceInfo.getInterfaceParam();
        if (StringUtils.isAnyEmpty((CharSequence[])new CharSequence[]{interfaceParam, this.requestBodyParam})) {
            return this.integrateCloudService(ctx, interfaceInfo, null, null);
        }
        JsonElement json = IntegrateJSONUtil.getJSON(this.requestBodyParam);
        interfaceParam = IntegrateJSONUtil.replaceUrl(json, interfaceParam);
        return this.integrateCloudService(ctx, interfaceInfo, interfaceParam, null);
    }

    private SelectorItemCollection getSelectorCollection(InvokeInterfaceColumnCollection invokeConfig) {
        SelectorItemCollection sic = new SelectorItemCollection();
        if (invokeConfig == null || invokeConfig.size() == 0) {
            return sic;
        }
        for (int i = 0; i < invokeConfig.size(); ++i) {
            InvokeInterfaceColumnInfo info = invokeConfig.get(i);
            if (info.getConfigStatus() != YesOrNoEnum.YES || !StringUtils.isNotEmpty((CharSequence)info.getTargetName())) continue;
            sic.add(new SelectorItemInfo(info.getSourceName()));
        }
        return sic;
    }

    private IntegrateAccountInfo getIntegrateAccount(Context ctx, InvokeInterfaceInfo interfaceInfo) throws BOSException {
        IntegrateAccountCollection collection = IntegrateAccountFactory.getLocalInstance(ctx).getIntegrateAccountCollection("where integrateStatus = 1 and integrateType = " + interfaceInfo.getIntegrateType().getValue());
        if (collection.size() > 0) {
            return collection.get(0);
        }
        return null;
    }

    private IntegrateResVO processIntegrateInterfaceQueryRes(Context ctx, InvokeInterfaceInfo interfaceInfo, IRowSet resultSet) throws BOSException, EASBizException {
        IntegrateResVO vo = new IntegrateResVO();
        vo.setState(0);
        vo.setType(interfaceInfo.getIntegrateType().getAlias());
        this.processInvokeInterfaceConfig(ctx, interfaceInfo);
        InvokeInterfaceColumnCollection invokeConfig = interfaceInfo.getInvokeConfig();
        ArrayList columnInfoList = Lists.newArrayList();
        for (int i = 0; i < invokeConfig.size(); ++i) {
            InvokeInterfaceColumnInfo columnInfo = invokeConfig.get(i);
            if (columnInfo.getConfigStatus() == null || columnInfo.getConfigStatus() != YesOrNoEnum.YES || columnInfo.getInvokeColumn() == null) continue;
            columnInfoList.add(columnInfo);
        }
        JsonElement interfaceParam = IntegrateJSONUtil.getJSON(interfaceInfo.getInterfaceParam());
        IntegrateJSONUtil.filterJSON(interfaceParam);
        IntegrateJSONUtil.setNull(interfaceParam);
        String requestParam = interfaceParam.toString();
        HashMap rowDataMap = Maps.newHashMap();
        JsonElement result = null;
        boolean replaceEQ = false;
        try {
            rowDataMap = Maps.newHashMap();
            ResultSetMetaData meta = resultSet.getMetaData();
            while (resultSet.next()) {
                InvokeInterfaceColumnInfo columnInfo;
                int i;
                JsonElement temp = IntegrateJSONUtil.getJSON(requestParam);
                for (i = 1; i <= meta.getColumnCount(); ++i) {
                    rowDataMap.put(meta.getColumnName(i).toUpperCase(), resultSet.getString(meta.getColumnName(i)));
                }
                for (i = 0; i < columnInfoList.size(); ++i) {
                    columnInfo = (InvokeInterfaceColumnInfo)columnInfoList.get(i);
                    String sourceName = columnInfo.getSourceName().toUpperCase();
                    String valueFromRow = (String)rowDataMap.get(sourceName);
                    String valueInvoke = this.processValueInvoke(valueFromRow, columnInfo.getInvokeColumn());
                    rowDataMap.put(sourceName, valueInvoke);
                }
                for (i = 0; i < invokeConfig.size(); ++i) {
                    columnInfo = invokeConfig.get(i);
                    if (columnInfo.getConfigStatus() == YesOrNoEnum.NO || StringUtils.isEmpty((CharSequence)columnInfo.getTargetName())) continue;
                    String valueInvoke = (String)rowDataMap.get(columnInfo.getSourceName().toUpperCase());
                    IntegrateJSONUtil.replaceJsonTreeDataByRow(temp, columnInfo.getTargetName(), valueInvoke);
                }
                if (result == null) {
                    result = temp;
                    continue;
                }
                result = IntegrateJSONUtil.mergeJson(result, temp, interfaceParam);
            }
        }
        catch (SQLException e) {
            String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"PROCESS_QUERY_RES_ERROR", (Context)ctx);
            this.logger.error(interfaceInfo.getInvokeName() + msgFail, (Throwable)e);
            vo.setMsg(interfaceInfo.getInvokeName() + msgFail);
            return vo;
        }
        return this.integrateCloudService(ctx, interfaceInfo, result.toString(), (String)rowDataMap.get("id"));
    }

    private void processInvokeInterfaceConfig(Context ctx, InvokeInterfaceInfo interfaceInfo) throws BOSException {
        InvokeInterfaceColumnCollection invokeConfig = interfaceInfo.getInvokeConfig();
        ArrayList invokeColumnIds = Lists.newArrayList();
        for (int i = 0; i < invokeConfig.size(); ++i) {
            InvokeInterfaceColumnInfo columnInfo = invokeConfig.get(i);
            if (columnInfo.getConfigStatus() == null || columnInfo.getConfigStatus() != YesOrNoEnum.YES || columnInfo.getInvokeColumn() == null) continue;
            invokeColumnIds.add(columnInfo.getInvokeColumn().getId().toString());
        }
        if (invokeColumnIds.size() > 0) {
            IInvokeColumnValue iInvokeColumnValue = InvokeColumnValueFactory.getLocalInstance(ctx);
            InvokeColumnValueCollection invokeColumnValueCollection = iInvokeColumnValue.getInvokeColumnValueCollection("where invokeColumn in ('" + Joiner.on((String)"','").join((Iterable)invokeColumnIds) + "')");
            HashMap columnValueMap = Maps.newHashMap();
            if (invokeColumnValueCollection.size() > 0) {
                String columnId;
                int i;
                for (i = 0; i < invokeColumnValueCollection.size(); ++i) {
                    InvokeColumnValueInfo invokeColumnValueInfo = invokeColumnValueCollection.get(i);
                    columnId = invokeColumnValueInfo.getInvokeColumn().getId().toString();
                    if (columnValueMap.containsKey(columnId)) {
                        ((InvokeColumnValueCollection)((Object)columnValueMap.get(columnId))).add(invokeColumnValueInfo);
                        continue;
                    }
                    InvokeColumnValueCollection coreBaseCollection = new InvokeColumnValueCollection();
                    coreBaseCollection.add(invokeColumnValueInfo);
                    columnValueMap.put(columnId, coreBaseCollection);
                }
                for (i = 0; i < invokeConfig.size(); ++i) {
                    InvokeColumnInfo columnInfo = invokeConfig.get(i).getInvokeColumn();
                    if (columnInfo == null || !columnValueMap.containsKey(columnId = columnInfo.getId().toString())) continue;
                    columnInfo.put("invokeValue", columnValueMap.get(columnId));
                }
            }
        }
    }

    private IntegrateResVO integrateCloudService(Context ctx, InvokeInterfaceInfo interfaceInfo, String data, String id) throws EASBizException, BOSException {
        IntegrateResVO vo = new IntegrateResVO();
        vo.setState(0);
        vo.setType(interfaceInfo.getIntegrateType().getAlias());
        String msgFail = SHRServerResource.getString((String)"com.kingdee.shr.integraterec.properties.IntegrateRecResource", (String)"GET_CLOUD_SERVER_ERROR", (Context)ctx);
        try {
            if (StringUtils.isEmpty((CharSequence)this.cloudServiceUrl)) {
                this.cloudServiceUrl = IntegrateDBUtil.getIntegrateServiceUrlV1(ctx);
            }
        }
        catch (BOSException e) {
            this.logger.error(msgFail + e.getMessage(), (Throwable)e);
            vo.setMsg(msgFail);
            return vo;
        }
        catch (SQLException e) {
            this.logger.error(msgFail + e.getMessage(), (Throwable)e);
            vo.setMsg(msgFail);
            return vo;
        }
        String res = "";
        if (StringUtils.isEmpty((CharSequence)this.cloudServiceUrl)) {
            this.logger.error(msgFail);
            vo.setMsg(msgFail);
            return vo;
        }
        if (StringUtils.isNotEmpty((CharSequence)data)) {
            data = IntegrateJSONUtil.getJSON(data).toString();
        }
        if (interfaceInfo.getIntegrateType() == IntegrateType.MOKA) {
            IntegrateAccountInfo moka = this.getIntegrateAccount(ctx, interfaceInfo);
            res = this.pushCloudService(ctx, moka, data, this.cloudServiceUrl, interfaceInfo);
        } else if (interfaceInfo.getIntegrateType() == IntegrateType.TUPU) {
            IntegrateAccountInfo tupu = this.getIntegrateAccount(ctx, interfaceInfo);
            res = this.pushCloudService(ctx, tupu, data, this.cloudServiceUrl, interfaceInfo);
        }
        this.processSuccessLog(ctx, interfaceInfo, res, id);
        try {
            if (StringUtils.isNotEmpty((CharSequence)res)) {
                JsonElement resEle = IntegrateJSONUtil.getJSON(res);
                JsonObject resObj = resEle.getAsJsonObject();
                if (resObj.get("code") != null && resObj.get("code").toString().equalsIgnoreCase("0")) {
                    vo.setState(1);
                    vo.setData(resObj.get("data") != null ? resObj.get("data").toString() : "");
                } else {
                    vo.setState(0);
                    vo.setMsg(resObj.get("msg") != null ? resObj.get("msg").toString() : null);
                }
            } else {
                vo.setState(0);
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage(), (Throwable)e);
            vo.setMsg(res);
            vo.setState(0);
        }
        return vo;
    }

    private String pushCloudService(Context ctx, IntegrateAccountInfo integrateAccountInfo, String data, String cloudServiceUrl, InvokeInterfaceInfo interfaceInfo) {
        HashMap param = Maps.newHashMap();
        String url = interfaceInfo.getUrl();
        if (StringUtils.isNotEmpty((CharSequence)this.pathParam)) {
            JsonElement json = IntegrateJSONUtil.getJSON(this.pathParam);
            url = IntegrateJSONUtil.replaceUrl(json, url);
            param.put("requestApi", url);
        } else {
            param.put("requestApi", url);
        }
        if (interfaceInfo.getIntegrateType() == IntegrateType.MOKA) {
            param.put("header", integrateAccountInfo.getCode());
        } else if (interfaceInfo.getIntegrateType() == IntegrateType.TUPU) {
            JSONObject header = new JSONObject();
            header.put("name", (Object)integrateAccountInfo.getName());
            header.put("code", (Object)integrateAccountInfo.getCode());
            param.put("header", header.toString());
        }
        param.put("integrateType", integrateAccountInfo.getIntegrateType().getName());
        param.put("data", data);
        param.put("httpType", interfaceInfo.getHttpType().getAlias());
        param.put("requestType", interfaceInfo.getRequestType().getAlias());
        return HttpUtil.post(ctx, cloudServiceUrl, param);
    }

    private String processValueInvoke(String source, InvokeColumnInfo invokeColumn) {
        if (invokeColumn == null) {
            return source;
        }
        InvokeColumnValueCollection invokeValue = invokeColumn.getInvokeValue();
        if (invokeValue == null || invokeValue.size() == 0) {
            return source;
        }
        for (int i = 0; i < invokeValue.size(); ++i) {
            if (!source.equalsIgnoreCase(invokeValue.get(i).getSourceValue())) continue;
            return invokeValue.get(i).getTargetValue();
        }
        return source;
    }

    private boolean checkFrequency(Context ctx, InvokeInterfaceInfo info) throws BOSException {
        if (info.getRequestLimit() > 0) {
            InterfaceFrequencyType frequencyType = info.getFrequencyType();
            if (frequencyType == null) {
                frequencyType = InterfaceFrequencyType.MINUTE;
            }
            Date startTime = new Date();
            switch (frequencyType.getValue()) {
                case 1: {
                    startTime = DateUtil.getBeginDay();
                    break;
                }
                case 2: {
                    startTime = DateUtil.getHourAgo(startTime);
                    break;
                }
                case 3: {
                    startTime = DateUtil.getMinuteAge(startTime);
                    break;
                }
                default: {
                    startTime = DateUtil.getMinuteAge(startTime);
                }
            }
            IIntegrateLog localInstance = IntegrateLogFactory.getLocalInstance(ctx);
            String sqlDate = DateUtil.getSqlDate(startTime);
            IntegrateLogCollection collection = localInstance.getIntegrateLogCollection("where interfaceId = '" + info.getId().toString() + "' and createTime > " + sqlDate);
            return collection.size() > info.getRequestLimit() - 1;
        }
        return false;
    }

    private boolean checkRepeat(Context ctx, String id, String billIds) throws BOSException {
        IntegrateLogCollection integrateLogCollection;
        IIntegrateLog localInstance = IntegrateLogFactory.getLocalInstance(ctx);
        String oql = "select id where interfaceId = '" + id + "' and requestId = '" + this.requestId + "'";
        if (StringUtils.isNotEmpty((CharSequence)billIds)) {
            oql = oql + " and billIds = '" + billIds + "'";
        }
        return (integrateLogCollection = localInstance.getIntegrateLogCollection(oql)).size() > 0;
    }

    private void processOSFLog(Context ctx, InvokeInterfaceInfo interfaceInfo, String msg) throws EASBizException, BOSException {
        IIntegrateLog iIntegrateLog = IntegrateLogFactory.getLocalInstance(ctx);
        IntegrateLogInfo info = new IntegrateLogInfo();
        info.setRequstFrom(this.from);
        info.setTriggerKey(this.triggerKey);
        info.setIntegrateType(interfaceInfo.getIntegrateType().getAlias());
        info.setInterfaceId(interfaceInfo.getId().toString());
        info.setBillIds(this.billIds);
        info.setRequestRes(msg);
        info.setRequestStatus(YesOrNoEnum.YES);
        info.setDbInfo(ctx.getAIS());
        String serverNode = this.getServerNode();
        info.setRequestId(this.requestId);
        info.setServerNode(serverNode);
        iIntegrateLog.addnew(info);
    }

    private void processSuccessLog(Context ctx, InvokeInterfaceInfo interfaceInfo, String msg, String id) throws EASBizException, BOSException {
        IIntegrateLog iIntegrateLog = IntegrateLogFactory.getLocalInstance(ctx);
        IntegrateLogInfo info = new IntegrateLogInfo();
        info.setRequstFrom(this.from);
        info.setTriggerKey(this.triggerKey);
        info.setIntegrateType(interfaceInfo.getIntegrateType().getAlias());
        info.setInterfaceId(interfaceInfo.getId().toString());
        info.setBillIds(id);
        if (StringUtils.isNotEmpty((CharSequence)msg) && msg.length() > 2000) {
            msg = msg.substring(0, 1000);
            this.logger.error("requestRes:" + msg);
        }
        info.setRequestRes(msg);
        info.setRequestStatus(YesOrNoEnum.YES);
        info.setDbInfo(ctx.getAIS());
        String serverNode = this.getServerNode();
        info.setRequestId(this.requestId);
        info.setServerNode(serverNode);
        iIntegrateLog.addnew(info);
    }

    private void processFailLog(Context ctx, String msg) throws BOSException, EASBizException {
        IIntegrateLog iIntegrateLog = IntegrateLogFactory.getLocalInstance(ctx);
        IntegrateLogInfo info = new IntegrateLogInfo();
        info.setRequstFrom(this.from);
        info.setTriggerKey(this.triggerKey);
        info.setIntegrateType(this.integrateType);
        info.setBillIds(this.billIds);
        info.setRequestRes(msg);
        info.setRequestStatus(YesOrNoEnum.NO);
        info.setDbInfo(ctx.getAIS());
        String serverNode = this.getServerNode();
        info.setRequestId(this.requestId);
        info.setServerNode(serverNode);
        iIntegrateLog.addnew(info);
    }

    private String getServerNode() {
        return System.getProperty("EAS_INSTANCE_NAME");
    }
}

