/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.integraterec.utils;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.integraterec.utils.MySecureProtocolSocketFactory;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.protocol.Protocol;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpUtil {
    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);
    public static final String DEFAULT_CHARSET = "utf-8";
    private static final int DEFAULT_CONNECTION_TIMEOUT = 10000;
    private static final int DEFAULT_SO_TIMEOUT = 30000;

    private static HttpClient createHttpClient() {
        HttpClient httpClient = HttpUtil.createHttpClient(10000, 30000);
        return httpClient;
    }

    private static HttpClient createHttpClient(int connectionTimeout, int soTimeout) {
        HttpClient httpClient = new HttpClient();
        httpClient.getHttpConnectionManager().getParams().setConnectionTimeout(connectionTimeout);
        httpClient.getHttpConnectionManager().getParams().setSoTimeout(soTimeout);
        return httpClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String post(Context ctx, String url, Map<String, String> param) {
        HttpClient client = HttpUtil.createHttpClient();
        client.getParams().setParameter("http.protocol.content-charset", (Object)DEFAULT_CHARSET);
        PostMethod postMethod = new PostMethod(url);
        if (param != null && param.size() > 0) {
            NameValuePair[] datas = new NameValuePair[param.size()];
            int index = 0;
            for (String key : param.keySet()) {
                datas[index++] = new NameValuePair(key, param.get(key));
            }
            postMethod.setRequestBody(datas);
        }
        HttpUtil.setSafeHeader(ctx, (HttpMethod)postMethod);
        String result = null;
        try {
            result = HttpUtil.executeMethod(client, (HttpMethod)postMethod);
        }
        catch (IOException e) {
            logger.error("\u8bf7\u6c42\u53d1\u9001\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url);
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (Exception e) {
            logger.error("\u8bf7\u6c42\u5931\u8d25\uff0c\u8bf7\u6c42url\uff1a" + url);
            logger.error(e.getMessage(), (Throwable)e);
        }
        finally {
            if (postMethod != null) {
                postMethod.releaseConnection();
            }
        }
        return result;
    }

    public static void setSafeHeader(Context ctx, HttpMethod method) {
        try {
            String sql = "select FAccessToken,FServiceID,FServiceKey from T_CDS_CloudServiceConfig";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            while (rs.next()) {
                method.addRequestHeader("SHR_SAFE_VERSION", "V1");
                method.addRequestHeader("SHR_SAFE_TOKEN", rs.getString("FAccessToken"));
                method.addRequestHeader("SHR_APPID", rs.getString("FServiceID"));
            }
        }
        catch (BOSException e) {
            logger.error("\u8bf7\u6c42\u4e91\u670d\u52a1\u65f6\uff0c\u83b7\u53d6shr\u7684\u4e91\u670d\u52a1\u6ce8\u518ctoken\u5931\u8d25\uff1a" + e.getMessage());
        }
        catch (SQLException e) {
            logger.error("\u8bf7\u6c42\u4e91\u670d\u52a1\u65f6\uff0c\u83b7\u53d6shr\u7684\u4e91\u670d\u52a1\u6ce8\u518ctoken\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
        }
    }

    private static String executeMethod(HttpClient client, HttpMethod method) throws IOException {
        String result = null;
        try {
            int statusCode = client.executeMethod(method);
            if (statusCode == 200) {
                result = method.getResponseBodyAsString();
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("\u8bf7\u6c42\u672a\u6210\u529f\uff0cresponse status\uff1a" + statusCode);
                }
                if (statusCode == 302) {
                    Header redirectHeader = method.getResponseHeader("location");
                    if (logger.isDebugEnabled()) {
                        logger.debug("\u8bf7\u6c42\u88ab\u91cd\u5b9a\u5411\u5730\u5740\uff1a" + redirectHeader.getValue());
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("\u8bf7\u6c42\u672a\u6210\u529f\uff0cresponse body content\uff1a" + method.getResponseBodyAsString());
                }
            }
        }
        catch (HttpException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw e;
        }
        return result;
    }

    static {
        MySecureProtocolSocketFactory fcty = new MySecureProtocolSocketFactory();
        Protocol.registerProtocol((String)"https", (Protocol)new Protocol("https", (ProtocolSocketFactory)fcty, 443));
    }
}

