/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.integraterec.utils;

import com.alibaba.fastjson.JSONObject;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.bsf.service.app.IHRMsfService;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonCollection;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.shr.integraterec.InitialSyncBaseRecInfo;
import com.kingdee.shr.integraterec.IntegrateRecException;
import com.kingdee.shr.osf.service.ServiceLocator;
import com.kingdee.util.StringUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;

public class SyncThirdDataByCloudOSFUtil {
    private static Logger logger = Logger.getLogger(SyncThirdDataByCloudOSFUtil.class);

    public Map<String, Object> syncThirdDataByCloudOSF(Context ctx, String billId, String triggerKey, InitialSyncBaseRecInfo initialBaseInfo, Map<String, Object> param) throws BOSException, EASBizException {
        int thirdPartType = initialBaseInfo.getIntegrateType().getValue();
        IHRMsfService imsf = (IHRMsfService)ServiceLocator.getInstance().lookupService(ctx, "PushIntegrateRecService");
        HashMap<String, String> paramForInte = new HashMap<String, String>();
        paramForInte.put("billIds", null);
        paramForInte.put("triggerKey", triggerKey);
        paramForInte.put("integrateType", String.valueOf(thirdPartType));
        if (param != null && param.keySet().size() > 0) {
            JSONObject resultObject = new JSONObject();
            for (Map.Entry<String, Object> entry : param.entrySet()) {
                String paramKey = entry.getKey();
                String paramValue = entry.getValue().toString();
                resultObject.put(paramKey, (Object)paramValue);
            }
            paramForInte.put("queryFilterParam", resultObject.toString());
        }
        logger.error((Object)("SyncThirdDataByCloudOSFUtil.syncThirdDataByCloudOSF-paramForInte: " + paramForInte));
        Map result = (Map)imsf.process(ctx, paramForInte);
        logger.error((Object)("SyncThirdDataByCloudOSFUtil.syncThirdDataByCloudOSF-result: " + result));
        return result;
    }

    public static PersonInfo getCurrentPersonInfo(Context ctx) throws EASBizException {
        UserInfo user = SyncThirdDataByCloudOSFUtil.getCurrentUserInfo(ctx);
        PersonInfo person = user.getPerson();
        if (person == null) {
            return null;
        }
        if ((person = SyncThirdDataByCloudOSFUtil.getPersonInfo(ctx, person.getId().toString())) == null) {
            throw new IntegrateRecException(IntegrateRecException.INITIAL_GETPERSON, new Object[]{user.getName()});
        }
        return person;
    }

    public static PersonInfo getPersonInfo(Context ctx, String personId) {
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        PersonInfo currentPerson = null;
        try {
            IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
            PersonCollection coll = iPerson.getPersonCollection("where id = '" + personId + "'");
            if (coll != null && coll.size() > 0) {
                currentPerson = coll.get(0);
            }
        }
        catch (BOSException e) {
            logger.error((Object)e.getMessage(), (Throwable)e);
        }
        return currentPerson;
    }

    public static UserInfo getCurrentUserInfo(Context ctx) {
        return ContextUtil.getCurrentUserInfo((Context)ctx);
    }
}

