/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.inteshrtrain.service;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.IQueryExecutor;
import com.kingdee.bos.dao.query.QueryExecutorFactory;
import com.kingdee.bos.metadata.IMetaDataPK;
import com.kingdee.bos.metadata.MetaDataPK;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.inteshrtrain.InteSchemeConfigInfo;
import com.kingdee.shr.inteshrtrain.InteSchemeInfo;
import com.kingdee.shr.inteshrtrain.InteShrTrainException;
import com.kingdee.shr.inteshrtrain.app.RequestArea;
import com.kingdee.shr.inteshrtrain.app.RequestKey;
import com.kingdee.shr.inteshrtrain.app.RequestType;
import com.kingdee.shr.inteshrtrain.service.AbstractSyncModelData;
import com.kingdee.shr.inteshrtrain.service.InteShrTrainService;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SyncPositionModelData
implements AbstractSyncModelData {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.inteshrtrain.service.SyncPositionModelData");

    @Override
    public Map<String, Integer> initSyncOfModel(Context ctx, InteSchemeInfo schemeInfo, RequestArea ra, String taskNumber) throws EASBizException {
        HashMap<String, Integer> resultMap;
        block15: {
            resultMap = new HashMap<String, Integer>();
            int totalCount = 0;
            int successNum = 0;
            int totalReqNumber = 0;
            int maxNum = schemeInfo.getMaxRequestNum() == 0 ? 1000 : schemeInfo.getMaxRequestNum();
            try {
                String token = InteShrTrainService.getInstance().getToken(ctx, schemeInfo);
                if (StringUtils.isEmpty((CharSequence)token)) break block15;
                InteSchemeConfigInfo configInfoForAdd = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.ADDPOSITION);
                InteSchemeConfigInfo configInfoForUpdate = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.UPDATEPOSITION);
                if (configInfoForAdd != null && configInfoForUpdate != null && configInfoForAdd.isIsStart() && configInfoForUpdate.isIsStart()) {
                    MetaDataPK query = MetaDataPK.create((String)configInfoForAdd.getQueryName());
                    IQueryExecutor exec = QueryExecutorFactory.getLocalInstance((Context)ctx, (IMetaDataPK)query);
                    IRowSet resultSet = exec.executeQuery();
                    totalCount = resultSet.getRow();
                    try {
                        while (resultSet.next()) {
                            totalCount = resultSet.getRow();
                            if (++totalReqNumber == maxNum) {
                                if (logger.isInfoEnabled()) {
                                    logger.info((Object)(":" + maxNum + ","));
                                }
                                Thread.sleep(60000L);
                                totalReqNumber = 0;
                            }
                            boolean result = false;
                            boolean checkSended = InteShrTrainService.getInstance().checkSended(ctx, schemeInfo.getId().toString(), resultSet.getString("baseDataId"), ra);
                            result = checkSended ? InteShrTrainService.getInstance().syncModel(ctx, schemeInfo, configInfoForUpdate, resultSet, taskNumber) : InteShrTrainService.getInstance().syncModel(ctx, schemeInfo, configInfoForAdd, resultSet, taskNumber);
                            if (result) {
                                ++successNum;
                            } else {
                                InteShrTrainService.getInstance().saveInteDefeatData(ctx, resultSet, null, ra, RequestType.OTHER, schemeInfo);
                            }
                            resultMap.put("totalCount", totalCount);
                            resultMap.put("successCount", successNum);
                            resultMap.put("defeatCount", totalCount - successNum);
                        }
                        break block15;
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        break block15;
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                        break block15;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        break block15;
                    }
                }
                throw new InteShrTrainException(InteShrTrainException.INTERFACE_NOT_START, new Object[]{ra.toString()});
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
        }
        return resultMap;
    }

    @Override
    public void syncTrainDataForAdd(Context ctx, InteSchemeInfo schemeInfo, RequestArea ra, IRowSet resultSet) throws EASBizException {
    }

    @Override
    public void syncTrainDataForOther(Context ctx, InteSchemeInfo schemeInfo, RequestArea ra, IRowSet resultSet) throws EASBizException {
        block11: {
            try {
                InteSchemeConfigInfo configInfoForAdd = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.ADDPOSITION);
                InteSchemeConfigInfo configInfoForUpdate = InteShrTrainService.getInstance().getInteSchemeConfigInfo(ctx, schemeInfo.getId().toString(), ra, RequestKey.UPDATEPOSITION);
                String token = InteShrTrainService.getInstance().getToken(ctx, schemeInfo);
                if (StringUtils.isEmpty((CharSequence)token)) break block11;
                if (configInfoForAdd != null && configInfoForUpdate != null && configInfoForAdd.isIsStart() && configInfoForUpdate.isIsStart()) {
                    try {
                        while (resultSet.next()) {
                            boolean result = false;
                            boolean checkSended = InteShrTrainService.getInstance().checkSended(ctx, schemeInfo.getId().toString(), resultSet.getString("baseDataId"), ra);
                            if (checkSended) {
                                result = InteShrTrainService.getInstance().syncModel(ctx, schemeInfo, configInfoForUpdate, resultSet, null);
                                continue;
                            }
                            result = InteShrTrainService.getInstance().syncModel(ctx, schemeInfo, configInfoForAdd, resultSet, null);
                        }
                        break block11;
                    }
                    catch (EASBizException e) {
                        e.printStackTrace();
                        break block11;
                    }
                    catch (BOSException e) {
                        e.printStackTrace();
                        break block11;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        break block11;
                    }
                }
                throw new InteShrTrainException(InteShrTrainException.INTERFACE_NOT_START, new Object[]{ra.toString()});
            }
            catch (EASBizException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
            catch (BOSException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
            catch (SQLException e) {
                e.printStackTrace();
                throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
            }
        }
    }

    @Override
    public void syncTrainDataForDelete(Context ctx, InteSchemeInfo schemeInfo, RequestArea ra, HashSet<String> resultSet) throws EASBizException {
        try {
            InteShrTrainService.getInstance().syncTrainDataForDelete(ctx, schemeInfo, ra, resultSet, false);
        }
        catch (EASBizException e) {
            e.printStackTrace();
            throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new InteShrTrainException(InteShrTrainException.INTE_FAILED);
        }
    }
}

