/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.config;

import com.kingdee.bos.BOSException;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.manager.config.MGRChartConfigData;
import com.kingdee.shr.manager.config.MGRChartConfigDataGenertator;
import com.kingdee.shr.self.config.generator.ConfigDataGeneratorStore;
import com.kingdee.shr.self.config.generator.IConfigDataGenerator;
import com.kingdee.shr.self.model.BaseConfigData;
import com.kingdee.shr.self.model.ConfigData;
import com.kingdee.shr.self.model.NavigationConfigData;
import com.kingdee.shr.self.model.TableConfigData;
import com.kingdee.shr.self.util.HRXmlReader;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Map;
import org.jdom2.Element;

public abstract class MGRConfigDataGenerator {
    protected ConfigData getRealConfigData(IRowSet rs, HRXmlReader reader) throws SQLException, BOSException {
        String elementName;
        MGRChartConfigDataGenertator iConfigDataGenerator = null;
        Object configData = null;
        String number = rs.getString("fnumber");
        String serviceName = rs.getString("fservicename");
        String configName = rs.getString("fconfigname");
        String belongElement = rs.getString("fbelongelement");
        String templateUrl = rs.getString("ftemplateUrl");
        String errorTemplateUrl = rs.getString("ferrortemplateurl");
        String externalDataClass = rs.getString("fexternaldataclass");
        String param = rs.getString("fparam");
        String config = rs.getString("fconfig");
        String extend = rs.getString("fextend");
        if (!StringUtils.isEmpty((String)extend)) {
            config = extend;
        }
        Element root = reader.parse(config);
        Iterator iter = root.getChildren().iterator();
        Element element = null;
        while (iter.hasNext()) {
            element = (Element)iter.next();
        }
        String string = elementName = element == null ? "" : element.getName();
        configData = elementName.equals("shrchart") ? new MGRChartConfigData(number, configName, belongElement, templateUrl, errorTemplateUrl, element) : (elementName.equals("shrnavigation") ? new NavigationConfigData(number, configName, belongElement, templateUrl, errorTemplateUrl, element) : (elementName.equals("shrbase") ? new BaseConfigData(number, configName, belongElement, templateUrl, errorTemplateUrl, element) : (elementName.equals("shrtable") ? new TableConfigData(number, configName, belongElement, templateUrl, errorTemplateUrl, element) : new ConfigData(number, configName, belongElement, templateUrl, errorTemplateUrl, element))));
        iConfigDataGenerator = elementName.equals("shrchart") ? new MGRChartConfigDataGenertator() : this.getConfigDataGenerator(elementName);
        if (iConfigDataGenerator != null) {
            iConfigDataGenerator.getConfigDta(element, (ConfigData)configData);
        }
        configData.setServiceName(serviceName);
        configData.setExternalDataClass(externalDataClass);
        configData.setParam(param);
        return configData;
    }

    private IConfigDataGenerator getConfigDataGenerator(String elementName) throws BOSException {
        Map map = ConfigDataGeneratorStore.getInstance().getConfigDataStoreMap();
        String className = (String)map.get(elementName);
        if (StringUtils.isEmpty((String)className)) {
            className = (String)map.get("default");
        }
        if (StringUtils.isEmpty((String)className)) {
            return null;
        }
        try {
            Class<?> clazz = Class.forName(className);
            return (IConfigDataGenerator)clazz.newInstance();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

