/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.query.server.PagingHelper;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.manager.util.EmployeeDatasetManagerSqlUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmployeeEnrollRetentionRateDetailService
extends AbstractJavaDataQueryService {
    private static final String ENROLL_NUBER = "001";
    private static final String ENHIRE_NUMBER = "002";
    public static final Logger logger = LoggerFactory.getLogger(EmployeeEnrollRetentionRateDetailService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        this.getData(ctx, param, result);
        return result;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        this.getData(ctx, param, result);
        return result;
    }

    protected void getData(Context ctx, JavaAPIParam param, DataResult result) throws EASBizException, BOSException {
        List<Object> list = new ArrayList();
        String permItemId = param.getPermItemId();
        String orgTypeValue = (String)super.getParamValue(ctx, "orgId", param);
        Date pDate = (Date)super.getParamValue(ctx, "p_year", param);
        String pDateVal = pDate != null ? pDate.toString() : "";
        String enrollNumber = (String)super.getParamValue(ctx, "enrollNumber", param);
        int page = param.getPage();
        int pageSize = param.getRows();
        result.setPage(page);
        result.setRecords((long)pageSize);
        if (logger.isInfoEnabled()) {
            logger.info("EmployeeEnrollRetentionRateService_param: " + orgTypeValue + "," + pDateVal + "," + enrollNumber + "," + page + "," + pageSize);
        }
        if (StringUtils.isEmpty((String)orgTypeValue) || StringUtils.isEmpty((String)pDateVal) || StringUtils.isEmpty((String)enrollNumber)) {
            return;
        }
        try {
            pDateVal = DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)pDateVal, (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (ENROLL_NUBER.equals(enrollNumber)) {
            list = this.getEnrollEmpCountDetail(ctx, orgTypeValue, pDateVal, permItemId, result);
        } else if (ENHIRE_NUMBER.equals(enrollNumber)) {
            list = this.getEnrollHireEmpCountDetail(ctx, orgTypeValue, pDateVal, permItemId, result);
        } else {
            int year = 1;
            switch (enrollNumber) {
                case "003": {
                    year = 1;
                    break;
                }
                case "004": {
                    year = 2;
                    break;
                }
                case "005": {
                    year = 3;
                    break;
                }
                case "006": {
                    year = 5;
                }
            }
            list = this.getEnrollCompanyYearsDetail(ctx, orgTypeValue, pDateVal, permItemId, year, result);
        }
        result.setRows(list);
    }

    protected List<Map<String, Object>> getEnrollEmpCountDetail(Context ctx, String adminOrg, String pDate, String permItemId, DataResult result) throws BOSException, EASBizException {
        StringBuilder countSql = new StringBuilder("select count(1) enrollCount from ").append("(").append(EmployeeDatasetManagerSqlUtil.getEmpCountSql(ctx, adminOrg, pDate, permItemId)).append(" and (bizdefine.FBIZDEFINETYPE = 1 or bizdefine.FBIZDEFINETYPE = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(") tt ").append(EmployeeDatasetManagerSqlUtil.getRelatiedTable());
        IRowSet rowSetCount = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
        try {
            while (rowSetCount.next()) {
                int resultCount = rowSetCount.getInt("enrollCount");
                result.setTotal((long)resultCount);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuilder sql = new StringBuilder(EmployeeDatasetManagerSqlUtil.getDetailSelector(ctx)).append("(").append(EmployeeDatasetManagerSqlUtil.getEmpCountSql(ctx, adminOrg, pDate, permItemId)).append(" and (bizdefine.FBIZDEFINETYPE = 1 or bizdefine.FBIZDEFINETYPE = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(") tt ").append(EmployeeDatasetManagerSqlUtil.getRelatiedTable());
        PagingHelper p = new PagingHelper();
        int page = result.getPage();
        int pageSize = (int)result.getRecords();
        String realSql = p.getPagingSqlNoOptmize(ctx, sql.toString(), (page - 1) * pageSize, pageSize);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)realSql.toString());
        List<Map<String, Object>> resultList = EmployeeDatasetManagerSqlUtil.getRsListData(rowSet);
        return resultList;
    }

    protected List<Map<String, Object>> getEnrollHireEmpCountDetail(Context ctx, String adminOrg, String pDate, String permItemId, DataResult result) throws BOSException, EASBizException {
        StringBuilder countSql = new StringBuilder("select count(1) enrollCount from ").append("(").append(EmployeeDatasetManagerSqlUtil.getEmpCountSql(ctx, adminOrg, pDate, permItemId)).append(" and empType.FIsHireState = 1").append(") tt").append(EmployeeDatasetManagerSqlUtil.getRelatiedTable());
        IRowSet rowSetCount = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
        try {
            while (rowSetCount.next()) {
                int resultCount = rowSetCount.getInt("enrollCount");
                result.setTotal((long)resultCount);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuilder sql = new StringBuilder(EmployeeDatasetManagerSqlUtil.getDetailSelector(ctx)).append("(").append(EmployeeDatasetManagerSqlUtil.getEmpCountSql(ctx, adminOrg, pDate, permItemId)).append(" and empType.FIsHireState = 1").append(") tt").append(EmployeeDatasetManagerSqlUtil.getRelatiedTable());
        PagingHelper p = new PagingHelper();
        int page = result.getPage();
        int pageSize = (int)result.getRecords();
        String realSql = p.getPagingSqlNoOptmize(ctx, sql.toString(), (page - 1) * pageSize, pageSize);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)realSql.toString());
        List<Map<String, Object>> resultList = EmployeeDatasetManagerSqlUtil.getRsListData(rowSet);
        return resultList;
    }

    protected List<Map<String, Object>> getEnrollCompanyYearsDetail(Context ctx, String adminOrg, String pDate, String permItemId, int year, DataResult result) throws BOSException, EASBizException {
        StringBuilder countSql = new StringBuilder("select count(1) enrollCount from ").append("(").append(EmployeeDatasetManagerSqlUtil.getEnrollCompanyYearsSql(ctx, adminOrg, pDate, permItemId)).append(" having sum(pphis.FJoinCompanyYears) >=").append(year).append(") tt").append(EmployeeDatasetManagerSqlUtil.getRelatiedTableForCompanyYears());
        IRowSet rowSetCount = DbUtil.executeQuery((Context)ctx, (String)countSql.toString());
        try {
            while (rowSetCount.next()) {
                int resultCount = rowSetCount.getInt("enrollCount");
                result.setTotal((long)resultCount);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        StringBuilder sql = new StringBuilder(EmployeeDatasetManagerSqlUtil.getDetailSelector(ctx)).append("(").append(EmployeeDatasetManagerSqlUtil.getEnrollCompanyYearsSql(ctx, adminOrg, pDate, permItemId)).append(" having sum(pphis.FJoinCompanyYears) >=").append(year).append(") tt").append(EmployeeDatasetManagerSqlUtil.getRelatiedTableForCompanyYears());
        PagingHelper p = new PagingHelper();
        int page = result.getPage();
        int pageSize = (int)result.getRecords();
        String realSql = p.getPagingSqlNoOptmize(ctx, sql.toString(), (page - 1) * pageSize, pageSize);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)realSql.toString());
        List<Map<String, Object>> resultList = EmployeeDatasetManagerSqlUtil.getRsListData(rowSet);
        return resultList;
    }
}

