/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.manager.util.EmployeeDatasetManagerSqlUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmployeeEnrollRetentionRateForStuService
extends AbstractJavaDataQueryService {
    public static final Logger logger = LoggerFactory.getLogger(EmployeeEnrollRetentionRateForStuService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    protected List<Map<String, Object>> getData(Context ctx, JavaAPIParam param) throws EASBizException, BOSException {
        String pDateVal;
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String permItemId = param.getPermItemId();
        String orgTypeValue = (String)super.getParamValue(ctx, "orgId", param);
        Date pDate = (Date)super.getParamValue(ctx, "p_year", param);
        String string = pDateVal = pDate != null ? pDate.toString() : "";
        if (logger.isInfoEnabled()) {
            logger.info("EmployeeEnrollRetentionRateService_param: " + orgTypeValue + "," + pDateVal);
        }
        try {
            pDateVal = DateTimeUtils.format((Date)DateTimeUtils.parseDate((String)pDateVal, (String)"yyyy-MM-dd"));
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        if (StringUtils.isEmpty((String)orgTypeValue) || StringUtils.isEmpty((String)pDateVal)) {
            return list;
        }
        int enrollCount = this.getEnrollEmpCount(ctx, orgTypeValue, pDateVal, permItemId, list);
        this.getEnrollHireEmpCount(ctx, orgTypeValue, pDateVal, permItemId, list, enrollCount);
        this.getEnrollCompanyYears(ctx, orgTypeValue, pDateVal, permItemId, list, enrollCount);
        return list;
    }

    protected int getEnrollEmpCount(Context ctx, String adminOrg, String pDate, String permItemId, List<Map<String, Object>> resultList) throws BOSException, EASBizException {
        int resultCount = 0;
        String resourceLbl = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label453", (Context)ctx);
        HashMap<String, Object> result = new HashMap<String, Object>();
        StringBuilder sql = new StringBuilder("select count(*) enrollCount from (").append(EmployeeDatasetManagerSqlUtil.getEmpCountSqlForStudent(ctx, adminOrg, pDate, permItemId)).append(" and (bizdefine.FBIZDEFINETYPE = 1 or bizdefine.FBIZDEFINETYPE = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(") t1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                resultCount = rowSet.getInt("enrollCount");
                result.put("enrollNumber", "001");
                result.put("enrollName", resourceLbl);
                result.put("enrollCount", resultCount);
                double enrollReten = 0.0;
                if (resultCount > 0) {
                    enrollReten = 100.0;
                }
                result.put("enrollReten", enrollReten);
                result.put("adminOrgId", adminOrg.replaceAll("'", ""));
                result.put("pYear", pDate);
                resultList.add(result);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return resultCount;
    }

    protected void getEnrollHireEmpCount(Context ctx, String adminOrg, String pDate, String permItemId, List<Map<String, Object>> resultList, int enrollCount) throws BOSException, EASBizException {
        int resultCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String resourceLbl = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label454", (Context)ctx);
        StringBuilder sql = new StringBuilder("select count(1) enhireCount from (").append(EmployeeDatasetManagerSqlUtil.getEmpCountSqlForStudent(ctx, adminOrg, pDate, permItemId)).append(" and empType.FIsHireState = 1").append(") t1");
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            while (rowSet.next()) {
                resultCount = rowSet.getInt("enhireCount");
                result.put("enrollNumber", "002");
                result.put("enrollName", resourceLbl);
                result.put("enrollCount", resultCount);
                double hireReten = 0.0;
                if (enrollCount > 0) {
                    hireReten = Math.round((double)resultCount / (double)enrollCount * 100.0);
                }
                result.put("enrollReten", hireReten);
                result.put("adminOrgId", adminOrg.replaceAll("'", ""));
                result.put("pYear", pDate);
                resultList.add(result);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    protected void getEnrollCompanyYears(Context ctx, String adminOrg, String pDate, String permItemId, List<Map<String, Object>> resultList, int enrollCount) throws BOSException, EASBizException {
        int resultCount = 0;
        HashMap<String, Object> result = new HashMap<String, Object>();
        String resourceLbl = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label455", (Context)ctx);
        String resourceLb2 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label456", (Context)ctx);
        String resourceLb3 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label457", (Context)ctx);
        String resourceLb4 = SHRServerResource.getString((String)"com.kingdee.eas.hr.emp.EmployeeBizResource", (String)"label458", (Context)ctx);
        try {
            String sqlCount = EmployeeDatasetManagerSqlUtil.getEnrollCompanyYearsAnyForStudent(ctx, adminOrg, pDate, permItemId, 1);
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlCount.toString());
            while (rowSet.next()) {
                result = new HashMap();
                resultCount = rowSet.getInt("companyYears");
                result.put("enrollNumber", "003");
                result.put("enrollName", resourceLbl);
                result.put("enrollCount", resultCount);
                double oneReten = 0.0;
                if (enrollCount > 0) {
                    oneReten = Math.round((double)resultCount / (double)enrollCount * 100.0);
                }
                result.put("enrollReten", oneReten);
                result.put("adminOrgId", adminOrg.replaceAll("'", ""));
                result.put("pYear", pDate);
                resultList.add(result);
            }
            sqlCount = EmployeeDatasetManagerSqlUtil.getEnrollCompanyYearsAnyForStudent(ctx, adminOrg, pDate, permItemId, 2);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlCount.toString());
            while (rowSet.next()) {
                result = new HashMap();
                resultCount = rowSet.getInt("companyYears");
                result.put("enrollNumber", "004");
                result.put("enrollName", resourceLb2);
                result.put("enrollCount", resultCount);
                double twoReten = 0.0;
                if (enrollCount > 0) {
                    twoReten = Math.round((double)resultCount / (double)enrollCount * 100.0);
                }
                result.put("enrollReten", twoReten);
                result.put("adminOrgId", adminOrg.replaceAll("'", ""));
                result.put("pYear", pDate);
                resultList.add(result);
            }
            sqlCount = EmployeeDatasetManagerSqlUtil.getEnrollCompanyYearsAnyForStudent(ctx, adminOrg, pDate, permItemId, 3);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlCount.toString());
            while (rowSet.next()) {
                result = new HashMap();
                resultCount = rowSet.getInt("companyYears");
                result.put("enrollNumber", "005");
                result.put("enrollName", resourceLb3);
                result.put("enrollCount", resultCount);
                double threeReten = 0.0;
                if (enrollCount > 0) {
                    threeReten = Math.round((double)resultCount / (double)enrollCount * 100.0);
                }
                result.put("enrollReten", threeReten);
                result.put("adminOrgId", adminOrg.replaceAll("'", ""));
                result.put("pYear", pDate);
                resultList.add(result);
            }
            sqlCount = EmployeeDatasetManagerSqlUtil.getEnrollCompanyYearsAnyForStudent(ctx, adminOrg, pDate, permItemId, 5);
            rowSet = DbUtil.executeQuery((Context)ctx, (String)sqlCount.toString());
            while (rowSet.next()) {
                result = new HashMap();
                resultCount = rowSet.getInt("companyYears");
                result.put("enrollNumber", "006");
                result.put("enrollName", resourceLb4);
                result.put("enrollCount", resultCount);
                double fiveReten = 0.0;
                if (enrollCount > 0) {
                    fiveReten = Math.round((double)resultCount / (double)enrollCount * 100.0);
                }
                result.put("enrollReten", fiveReten);
                result.put("adminOrgId", adminOrg.replaceAll("'", ""));
                result.put("pYear", pDate);
                resultList.add(result);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }
}

