/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.manager.dataset.EmployeeEnrollRetentionRateService;
import com.kingdee.shr.manager.util.EmployeeDatasetManagerSqlUtil;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EmployeePoliticalStrucService
extends AbstractJavaDataQueryService {
    public static final Logger logger = LoggerFactory.getLogger(EmployeeEnrollRetentionRateService.class);

    public DataResult getAllData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    public DataResult getPageData(Context ctx, JavaAPIParam param) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(ctx, param));
        return result;
    }

    protected List<Map<String, Object>> getData(Context ctx, JavaAPIParam param) throws EASBizException, BOSException {
        List<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String permItemId = param.getPermItemId();
        String orgTypeValue = (String)super.getParamValue(ctx, "orgId", param);
        if (logger.isInfoEnabled()) {
            logger.info("EmployeeEnrollRetentionRateService_param: " + orgTypeValue);
        }
        if (StringUtils.isEmpty((String)orgTypeValue)) {
            return list;
        }
        list = this.getEmployeePoliticalCount(ctx, orgTypeValue, permItemId);
        return list;
    }

    protected List<Map<String, Object>> getEmployeePoliticalCount(Context ctx, String adminOrg, String permItemId) throws BOSException, EASBizException {
        ArrayList<Map<String, Object>> list = new ArrayList();
        String sql = this.getEmployeePoliticalSql(ctx, adminOrg, permItemId);
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        list = EmployeeDatasetManagerSqlUtil.getRsListData(rowSet);
        return list;
    }

    protected String getEmployeePoliticalSql(Context ctx, String adminOrg, String permItemId) throws EASBizException, BOSException {
        String localLan = ctx.getLocale().getLanguage();
        StringBuilder sql = new StringBuilder();
        sql.append("select political.fid politicalId,political.fname_").append(localLan).append(" politicalName,political.findex poIndex,political.fnumber poNumber,politicalTable.adminId  adminOrg, count(politicalTable.personid) employeeCount ").append(" from t_bd_HRPolitical political left join  ( ").append(" select person.fid personid, person.fpoliticalfaceId,adcount.fid adminId ").append(" from T_ORG_Admin adcount inner join T_ORG_Admin child  on ( charindex(concat(adcount.flongnumber, '!'), child.flongnumber) = 1  or adcount.flongnumber = child.flongnumber) ").append(" inner join ( ").append(EmployeeDatasetManagerSqlUtil.getManagerAdminOrgRangeSql(ctx, permItemId)).append(" ) range   on child.fid = range.forgid ").append(" inner join T_HR_EmpOrgRelation emprelation  on child.fid = emprelation.fadminorgid ").append(" inner join T_HR_EmpLaborRelation laborrelation  on emprelation.flaborrelationid = laborrelation.fid ").append(" inner join T_HR_BDEmployeeType emptype  on laborrelation.flaborrelationstateid = emptype.fid ").append(" inner join T_BD_Person person  on person.fid = emprelation.fpersonid ").append(" where ").append(" adcount.fid in (").append(adminOrg).append(")").append(" and child.fissealup = 0  ").append(" and child.fisstartshr = 1  ").append(" and emprelation.fisenrolled = 1  ").append(" and emprelation.fisinner = 1  ").append(" and emprelation.fleffdt = {ts'2199-12-31'} ").append(" and emprelation.FIsLatestInAday = 1 ").append(" and emprelation.FAssignType = 1 ").append(" and emptype.fisonthestrength = 1 ").append(" ) politicalTable on politicalTable.fpoliticalfaceId = political.fid ").append(" where political.fstate = 1 and politicalTable.personid is not null ").append("group by political.fid,political.fname_").append(localLan).append(",political.findex,political.fnumber,politicalTable.adminId");
        return sql.toString();
    }
}

