/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.manager.util.HRManagerPersonCountUtil;
import com.kingdee.util.DateTimeUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class EnrollAndResignCountDataService
extends AbstractJavaDataQueryService {
    public DataResult getAllData(Context context, JavaAPIParam javaAPIParam) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(context, javaAPIParam));
        return result;
    }

    public DataResult getPageData(Context context, JavaAPIParam javaAPIParam) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(context, javaAPIParam));
        return result;
    }

    protected List<Map<String, Object>> getData(Context ctx, JavaAPIParam param) throws EASBizException, BOSException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String orgTypeValue = (String)super.getParamValue(ctx, "orgId", param);
        Date time = (Date)super.getParamValue(ctx, "time", param);
        String permItemId = param.getPermItemId();
        Date monthDate = null;
        monthDate = time != null ? DateTimeUtils.truncateDate((Date)time) : DateTimeUtils.truncateDate((Date)new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(DateTimeUtils.truncateDate((Date)new Date()));
        int nowYear = nowCalendar.get(1);
        int nowMonth = nowCalendar.get(2) + 1;
        boolean isNow = false;
        if (year == nowYear && month == nowMonth) {
            isNow = true;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("parent", (Object)orgTypeValue));
        filterItemColl.add(new FilterItemInfo("isSealUp", (Object)false));
        SorterItemCollection sort = new SorterItemCollection();
        sort.add(new SorterItemInfo("sortCode"));
        sort.add(new SorterItemInfo("longNumber"));
        sort.add(new SorterItemInfo("number"));
        view.setSorter(sort);
        view.setFilter(filter);
        AdminOrgUnitCollection adminOrgUnitCollection = AdminOrgUnitFactory.getLocalInstance((Context)ctx).getAdminOrgUnitCollection(view);
        if (!adminOrgUnitCollection.isEmpty()) {
            for (int i = 0; i < adminOrgUnitCollection.size(); ++i) {
                AdminOrgUnitInfo info = adminOrgUnitCollection.get(i);
                HashMap<String, Object> enroll = new HashMap<String, Object>();
                enroll.put("name", "enroll");
                enroll.put("orgId", info.getId().toString());
                enroll.put("orgName", info.getName());
                if (isNow) {
                    enroll.put("personCount", HRManagerPersonCountUtil.getRealEnrollPersonCount(ctx, year, month, info.getId().toString(), permItemId));
                } else {
                    enroll.put("personCount", HRManagerPersonCountUtil.getEnrollPersonCount(ctx, year, month, info.getId().toString()));
                }
                list.add(enroll);
                HashMap<String, Object> resign = new HashMap<String, Object>();
                resign.put("name", "resign");
                resign.put("orgId", info.getId().toString());
                resign.put("orgName", info.getName());
                if (isNow) {
                    resign.put("personCount", HRManagerPersonCountUtil.getRealResignPersonCount(ctx, year, month, info.getId().toString(), permItemId));
                } else {
                    resign.put("personCount", HRManagerPersonCountUtil.getResignPersonCount(ctx, year, month, info.getId().toString()));
                }
                list.add(resign);
            }
        }
        return list;
    }
}

