/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.dataset;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.shr.dataset.model.DataResult;
import com.kingdee.shr.dataset.model.JavaAPIParam;
import com.kingdee.shr.dataset.service.java.AbstractJavaDataQueryService;
import com.kingdee.shr.manager.util.HRManagerPersonCountUtil;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class EnrollMonthCountDataService
extends AbstractJavaDataQueryService {
    public DataResult getAllData(Context context, JavaAPIParam javaAPIParam) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(context, javaAPIParam));
        return result;
    }

    public DataResult getPageData(Context context, JavaAPIParam javaAPIParam) throws BOSException, EASBizException {
        DataResult result = new DataResult();
        result.setRows(this.getData(context, javaAPIParam));
        return result;
    }

    protected List<Map<String, Object>> getData(Context ctx, JavaAPIParam param) throws EASBizException, BOSException {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        String orgTypeValue = (String)super.getParamValue(ctx, "orgId", param);
        Date time = (Date)super.getParamValue(ctx, "time", param);
        String permItemId = param.getPermItemId();
        Date monthDate = null;
        monthDate = time != null ? DateTimeUtils.truncateDate((Date)time) : DateTimeUtils.truncateDate((Date)new Date());
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(monthDate);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        Calendar nowCalendar = Calendar.getInstance();
        nowCalendar.setTime(DateTimeUtils.truncateDate((Date)new Date()));
        int nowYear = nowCalendar.get(1);
        int nowMonth = nowCalendar.get(2) + 1;
        for (int i = 0; i < 12; ++i) {
            HashMap<String, Object> nowResult = new HashMap<String, Object>();
            int realMonth = month - 11 + i;
            int realYear = year;
            if (realMonth <= 0) {
                realMonth += 12;
                --realYear;
            }
            boolean isNow = false;
            if (realYear == nowYear && realMonth == nowMonth) {
                isNow = true;
            }
            String monthStr = this.getMonthStr(ctx, realMonth);
            nowResult.put("name", SHRServerResource.getString((String)"com.kingdee.eas.hr.base.ManagerResource", (String)"label25", (Context)ctx));
            nowResult.put("orgId", orgTypeValue.replaceAll("'", ""));
            nowResult.put("month", monthStr);
            nowResult.put("p_year", "" + realYear + "-" + realMonth + "-01'");
            if (isNow) {
                nowResult.put("count", HRManagerPersonCountUtil.getRealEnrollPersonCount(ctx, realYear, realMonth, orgTypeValue, permItemId));
            } else {
                nowResult.put("count", HRManagerPersonCountUtil.getEnrollPersonCount(ctx, realYear, realMonth, orgTypeValue));
            }
            list.add(nowResult);
            HashMap<String, Object> preResult = new HashMap<String, Object>();
            preResult.put("name", SHRServerResource.getString((String)"com.kingdee.eas.hr.base.ManagerResource", (String)"label26", (Context)ctx));
            preResult.put("orgId", orgTypeValue.replaceAll("'", ""));
            preResult.put("month", monthStr);
            preResult.put("p_year", "" + (realYear - 1) + "-" + realMonth + "-01'");
            preResult.put("count", HRManagerPersonCountUtil.getEnrollPersonCount(ctx, realYear - 1, realMonth, orgTypeValue));
            list.add(preResult);
        }
        return list;
    }

    private String getMonthStr(Context ctx, int realMonth) {
        String monthStr = "";
        if (StringUtils.equalsIgnoreCase((String)"l1", (String)LocaleUtils.getShortCode((Locale)ctx.getLocale()))) {
            switch (realMonth) {
                case 1: {
                    monthStr = "Jan";
                    break;
                }
                case 2: {
                    monthStr = "Feb";
                    break;
                }
                case 3: {
                    monthStr = "Mar";
                    break;
                }
                case 4: {
                    monthStr = "Apr";
                    break;
                }
                case 5: {
                    monthStr = "May";
                    break;
                }
                case 6: {
                    monthStr = "Jun";
                    break;
                }
                case 7: {
                    monthStr = "Jul";
                    break;
                }
                case 8: {
                    monthStr = "Aug";
                    break;
                }
                case 9: {
                    monthStr = "Sep";
                    break;
                }
                case 10: {
                    monthStr = "Oct";
                    break;
                }
                case 11: {
                    monthStr = "Nov";
                    break;
                }
                case 12: {
                    monthStr = "Dec";
                }
            }
        } else {
            monthStr = realMonth + "\u6708";
        }
        return monthStr;
    }
}

