/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemCollection;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.manager.HRAffairHeadcountCollection;
import com.kingdee.shr.manager.HRAffairHeadcountFactory;
import com.kingdee.shr.manager.HRHeadcountCollection;
import com.kingdee.shr.manager.HRHeadcountFactory;
import com.kingdee.shr.manager.util.EmployeeDatasetManagerSqlUtil;
import com.kingdee.shr.manager.util.HRManagerUtil;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;

public class HRManagerPersonCountUtil {
    private static String getHisLongnumber(Context ctx, int year, int month, String adminOrgId) throws BOSException {
        String longNumber = "";
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("year", (Object)year));
        filterItemColl.add(new FilterItemInfo("month", (Object)month));
        filterItemColl.add(new FilterItemInfo("adminOrg", (Object)adminOrgId.replaceAll("'", ""), CompareType.INCLUDE));
        view.setFilter(filter);
        HRAffairHeadcountCollection coll = HRAffairHeadcountFactory.getLocalInstance(ctx).getHRAffairHeadcountCollection(view);
        if (!coll.isEmpty()) {
            longNumber = coll.get(0).getLongNumber();
        }
        return longNumber;
    }

    public static int getEnrollPersonCount(Context ctx, int year, int month, String adminOrgId) throws BOSException, EASBizException {
        int sum = 0;
        String longnumber = HRManagerPersonCountUtil.getHisLongnumber(ctx, year, month, adminOrgId);
        if (StringUtils.isEmpty((String)longnumber)) {
            return sum;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("year", (Object)year));
        filterItemColl.add(new FilterItemInfo("month", (Object)month));
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longnumber));
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longnumber + "!%"), CompareType.LIKE));
        filterInfo1.mergeFilter(filterInfo2, "OR");
        filter.mergeFilter(filterInfo1, "AND");
        view.setFilter(filter);
        HRAffairHeadcountCollection coll = HRAffairHeadcountFactory.getLocalInstance(ctx).getHRAffairHeadcountCollection(view);
        if (coll.isEmpty()) {
            return sum;
        }
        for (int i = 0; i < coll.size(); ++i) {
            sum += coll.get(i).getEnrollHeadcount();
        }
        return sum;
    }

    public static int getResignPersonCount(Context ctx, int year, int month, String adminOrgId) throws BOSException, EASBizException {
        int sum = 0;
        String longnumber = HRManagerPersonCountUtil.getHisLongnumber(ctx, year, month, adminOrgId);
        if (StringUtils.isEmpty((String)longnumber)) {
            return sum;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("year", (Object)year));
        filterItemColl.add(new FilterItemInfo("month", (Object)month));
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("longNumber", (Object)longnumber));
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("longNumber", (Object)(longnumber + "!%"), CompareType.LIKE));
        filterInfo1.mergeFilter(filterInfo2, "OR");
        filter.mergeFilter(filterInfo1, "AND");
        view.setFilter(filter);
        HRAffairHeadcountCollection coll = HRAffairHeadcountFactory.getLocalInstance(ctx).getHRAffairHeadcountCollection(view);
        if (coll.isEmpty()) {
            return sum;
        }
        for (int i = 0; i < coll.size(); ++i) {
            sum += coll.get(i).getResignHeadcount();
        }
        return sum;
    }

    public static int getBeginHeadcount(Context ctx, int year, int month, String adminOrgId) throws BOSException, EASBizException {
        int sum = 0;
        String longnumber = HRManagerPersonCountUtil.getHisLongnumber(ctx, year, month, adminOrgId);
        if (StringUtils.isEmpty((String)longnumber)) {
            return sum;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("year", (Object)year));
        filterItemColl.add(new FilterItemInfo("month", (Object)month));
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("beginLongNumber", (Object)longnumber));
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("beginLongNumber", (Object)(longnumber + "!%"), CompareType.LIKE));
        filterInfo1.mergeFilter(filterInfo2, "OR");
        filter.mergeFilter(filterInfo1, "AND");
        view.setFilter(filter);
        HRHeadcountCollection coll = HRHeadcountFactory.getLocalInstance(ctx).getHRHeadcountCollection(view);
        if (coll.isEmpty()) {
            return sum;
        }
        for (int i = 0; i < coll.size(); ++i) {
            sum += coll.get(i).getBeginHeadcount();
        }
        return sum;
    }

    public static int getEndHeadcount(Context ctx, int year, int month, String adminOrgId) throws BOSException, EASBizException {
        int sum = 0;
        String longnumber = HRManagerPersonCountUtil.getHisLongnumber(ctx, year, month, adminOrgId);
        if (StringUtils.isEmpty((String)longnumber)) {
            return sum;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        FilterItemCollection filterItemColl = filter.getFilterItems();
        filterItemColl.add(new FilterItemInfo("year", (Object)year));
        filterItemColl.add(new FilterItemInfo("month", (Object)month));
        FilterInfo filterInfo1 = new FilterInfo();
        filterInfo1.getFilterItems().add(new FilterItemInfo("endLongNumber", (Object)longnumber));
        FilterInfo filterInfo2 = new FilterInfo();
        filterInfo2.getFilterItems().add(new FilterItemInfo("endLongNumber", (Object)(longnumber + "!%"), CompareType.LIKE));
        filterInfo1.mergeFilter(filterInfo2, "OR");
        filter.mergeFilter(filterInfo1, "AND");
        view.setFilter(filter);
        HRHeadcountCollection coll = HRHeadcountFactory.getLocalInstance(ctx).getHRHeadcountCollection(view);
        if (coll.isEmpty()) {
            return sum;
        }
        for (int i = 0; i < coll.size(); ++i) {
            sum += coll.get(i).getEndHeadcount();
        }
        return sum;
    }

    public static int getRealEnrollPersonCount(Context ctx, int year, int month, String adminOrgId, String permItemId) throws BOSException, EASBizException {
        int sum = 0;
        try {
            int day = HRManagerUtil.getDay(year, month);
            String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
            StringBuffer headCounSql = new StringBuffer();
            headCounSql.append("select count(emprelation.fpersonid) as enrollHeadcount").append(" from " + HRManagerPersonCountUtil.getEnrollCountRelation(ctx, permItemId)).append(" where " + HRManagerPersonCountUtil.getEnrollCountFilter(ctx, adminOrgId, beginDateStr, endDateStr));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)headCounSql.toString());
            while (rowSet.next()) {
                sum = rowSet.getInt("enrollHeadcount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sum;
    }

    private static String getEnrollCountRelation(Context ctx, String permItemId) throws EASBizException, BOSException {
        StringBuffer relationBuffer = new StringBuffer();
        relationBuffer.append(" T_ORG_Admin adcount inner join T_ORG_Admin child  on ( charindex(concat(adcount.flongnumber, '!'), child.flongnumber) = 1  or adcount.flongnumber = child.flongnumber) ").append(" inner join (").append(EmployeeDatasetManagerSqlUtil.getManagerAdminOrgRangeSql(ctx, permItemId)).append(") range   on child.fid = range.forgid ").append(" inner join T_HR_EmpOrgRelation emprelation on empRelation.FADMINORGID  = child.fid").append(" inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid").append(" and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid").append(" inner join T_HR_HRBizDefine bizDefine on emprelation.factionid = bizDefine.fid");
        return relationBuffer.toString();
    }

    private static String getEnrollCountFilter(Context ctx, String adminOrgId, String beginDateStr, String endDateStr) {
        StringBuffer filterBuffer = new StringBuffer();
        filterBuffer.append(" (bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')").append(" and laborRelationHis.fenterdate >= ").append(beginDateStr).append(" and laborRelationHis.fenterdate <= ").append(endDateStr).append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emptype.fisonthestrength = 1").append(" and adcount.fid in ( ").append(adminOrgId).append(" ) ");
        return filterBuffer.toString();
    }

    public static int getRealResignPersonCount(Context ctx, int year, int month, String adminOrgId, String permItemId) throws EASBizException, BOSException {
        int sum = 0;
        try {
            int day = HRManagerUtil.getDay(year, month);
            String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
            String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
            StringBuffer headCounSql = new StringBuffer();
            headCounSql.append("select count(emprelation.fpersonid) as resignHeadcount").append(" from " + HRManagerPersonCountUtil.getResignCountRelation(ctx, permItemId)).append(" where " + HRManagerPersonCountUtil.getResignCountFilter(ctx, adminOrgId, beginDateStr, endDateStr));
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)headCounSql.toString());
            while (rowSet.next()) {
                sum = rowSet.getInt("resignHeadcount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sum;
    }

    public static String getResignCountRelation(Context ctx, String permItemId) throws EASBizException, BOSException {
        StringBuffer relationBuffer = new StringBuffer();
        relationBuffer.append(" T_ORG_Admin adcount inner join T_ORG_Admin child  on ( charindex(concat(adcount.flongnumber, '!'), child.flongnumber) = 1  or adcount.flongnumber = child.flongnumber) ").append(" inner join (").append(EmployeeDatasetManagerSqlUtil.getManagerAdminOrgRangeSql(ctx, permItemId)).append(") range   on child.fid = range.forgid ").append(" inner join T_HR_EmpOrgRelation emprelation on empRelation.FADMINORGID  = child.fid").append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid").append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid").append(" and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid").append(" inner join T_HR_HRBizDefine bizDefine on emprelation.factionid = bizDefine.fid").append(" left join T_HR_BDEmployeeType empTypeLast  ON laborRelationHis.FLASTLABORRELASTATEID = empTypeLast.fid");
        return relationBuffer.toString();
    }

    public static String getResignCountFilter(Context ctx, String adminOrgId, String beginDateStr, String endDateStr) {
        StringBuffer filterBuffer = new StringBuffer();
        filterBuffer.append(" ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)").append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))").append(" and pphis.FLeftCompanyDate >= ").append(beginDateStr).append(" and pphis.FLeftCompanyDate <= ").append(endDateStr).append(" and emprelation.fisinner = 1").append(" and (emptype.fisonthestrength = 0 or emprelation.fisenrolled = 0)").append(" and adcount.fid in ( ").append(adminOrgId).append(" ) ");
        return filterBuffer.toString();
    }

    public static int getRealBeginHeadcount(Context ctx, int year, int month, String adminOrgId, String permItemId) throws EASBizException, BOSException {
        String beginDateStr = "{ts'" + year + "-" + month + "-01'}";
        return HRManagerPersonCountUtil.getPersonCountByDate(ctx, adminOrgId, permItemId, beginDateStr);
    }

    public static int getRealEndHeadcount(Context ctx, int year, int month, String adminOrgId, String permItemId) throws EASBizException, BOSException {
        int day = HRManagerUtil.getDay(year, month);
        String endDateStr = "{ts'" + year + "-" + month + "-" + day + "'}";
        return HRManagerPersonCountUtil.getPersonCountByDate(ctx, adminOrgId, permItemId, endDateStr);
    }

    private static int getPersonCountByDate(Context ctx, String adminOrgId, String permItemId, String dateStr) throws EASBizException, BOSException {
        int sum = 0;
        try {
            StringBuffer headCountSql = new StringBuffer();
            headCountSql.append(" select count(emprelation.fpersonid) as headcount").append(" from T_ORG_Admin adcount inner join T_ORG_Admin child  on ( charindex(concat(adcount.flongnumber, '!'), child.flongnumber) = 1  or adcount.flongnumber = child.flongnumber) ").append(" inner join (").append(EmployeeDatasetManagerSqlUtil.getManagerAdminOrgRangeSql(ctx, permItemId)).append(") range   on child.fid = range.forgid ").append(" inner join T_HR_EmpOrgRelation emprelation on empRelation.FADMINORGID  = child.fid").append(" inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid").append(" and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime").append(" inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid").append(" where emprelation.fisenrolled = 1 and emprelation.fisinner = 1").append(" and emptype.fisonthestrength = 1").append(" and emprelation.feffdt <= ").append(dateStr).append(" and emprelation.fleffdt >= ").append(dateStr).append(" and emprelation.FIsLatestInAday = 1").append(" and adcount.fid in ( ").append(adminOrgId).append(" ) ");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)headCountSql.toString());
            while (rowSet.next()) {
                sum = rowSet.getInt("headcount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return sum;
    }
}

