/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.framework.ejb.HistoryUtil;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.HistoryConstant;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.AssignTypeEnum;
import com.kingdee.eas.hr.base.EmpPosOrgRelationCollection;
import com.kingdee.eas.hr.base.EmpPosOrgRelationFactory;
import com.kingdee.eas.hr.base.EmpPosOrgRelationInfo;
import com.kingdee.eas.hr.emp.EmpPostRankCollection;
import com.kingdee.eas.hr.emp.EmpPostRankFactory;
import com.kingdee.eas.hr.emp.EmpPostRankInfo;
import com.kingdee.eas.hr.org.HRJobInfo;
import com.kingdee.eas.hr.org.PositionExtendCollection;
import com.kingdee.eas.hr.org.PositionExtendFactory;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.util.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class HRManagerPersonCurDataUtil {
    public static final String PERSON_ID = "_###PersonId###";
    public static final String PERSON_NUMBER = "_###PersonNumber###";
    public static final String PERSON_NAME = "_###PersonName###";
    public static final String HRORGUNIT_ID = "_###HROrgUnitId###";
    public static final String HRORGUNIT_NUMBER = "_###HROrgUnitNumber###";
    public static final String HRORGUNIT_NAME = "_###HROrgUnitName###";
    public static final String ADMINORG_ID = "_###AdminOrgId###";
    public static final String ADMINORG_NUMBER = "_###AdminOrgNumber###";
    public static final String ADMINORG_NAME = "_###AdminOrgName###";
    public static final String ADMINORG_DISPLAYNAME = "_###AdminOrgDisplayName###";
    public static final String COMPANY_ID = "_###CompanyId###";
    public static final String COMPANY_NUMBER = "_###CompanyNumber###";
    public static final String COMPANY_NAME = "_###CompanyName###";
    public static final String DEPARTMENT_ID = "_###DepartmentId###";
    public static final String DEPARTMENT_NUMBER = "_###DepartmentNumber###";
    public static final String DEPARTMENT_NAME = "_###DepartmentName###";
    public static final String POSITION_ID = "_###PositionId###";
    public static final String POSITION_NUMBER = "_###PositionNumber###";
    public static final String POSITION_NAME = "_###PositionName###";
    public static final String LABOR_RELA_STATE_ID = "_###LaborRelationStateId###";
    public static final String LABOR_RELA_STATE_NUMBER = "_###LaborRelationStateNumber###";
    public static final String LABOR_RELA_STATE_NAME = "_###LaborRelationStateName###";
    public static final String HRJOB_ID = "_###HRJobId###";
    public static final String HRJOB_NUMBER = "_###HRJobNumber###";
    public static final String HRJOB_NAME = "_###HRJobName###";
    public static final String JOBLEVEL_ID = "_###JobLevelId###";
    public static final String JOBLEVEL_NUMBER = "_###JobLevelNumber###";
    public static final String JOBLEVEL_NAME = "_###JobLevelName###";
    public static final String JOBLEVEL_INDEX = "_###JobLevelIndex###";
    public static final String JOBGRADE_ID = "_###JobGradeId###";
    public static final String JOBGRADE_NUMBER = "_###JobGradeNumber###";
    public static final String JOBGRADE_NAME = "_###JobGradeName###";
    public static final String JOBGRADE_INDEX = "_###JobLevelIndex###";

    public static String getPersonCurDataByKey(Context ctx, String key) throws EASBizException, BOSException {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo == null) {
            return "";
        }
        if (userInfo.getPerson() == null && userInfo.getPerson().getId() == null) {
            return "";
        }
        String personId = userInfo.getPerson().getId().toString();
        Map<String, String> curPersonData = HRManagerPersonCurDataUtil.getPersonCurData(ctx, personId);
        return curPersonData.get(key) == null ? "" : curPersonData.get(key);
    }

    public static Map<String, String> getPersonCurData(Context ctx, String personId) throws EASBizException, BOSException {
        EmpPostRankCollection empPostRankColl;
        HRJobInfo hrJobInfo;
        PositionExtendCollection posExtColl;
        if (StringUtils.isEmpty((String)personId)) {
            return Collections.emptyMap();
        }
        EmpPosOrgRelationCollection empPosOrgRelaColl = HRManagerPersonCurDataUtil.getLastMainEmpOrgRelation(ctx, personId);
        if (empPosOrgRelaColl == null || empPosOrgRelaColl.size() == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        EmpPosOrgRelationInfo empOrgRelaInfo = empPosOrgRelaColl.get(0);
        if (empOrgRelaInfo.getPerson() != null) {
            result.put(PERSON_ID, empOrgRelaInfo.getPerson().getId().toString());
            result.put(PERSON_NUMBER, empOrgRelaInfo.getPerson().getNumber());
            result.put(PERSON_NAME, empOrgRelaInfo.getPerson().getName());
        }
        if (empOrgRelaInfo.getHrOrgUnit() != null) {
            result.put(HRORGUNIT_ID, empOrgRelaInfo.getHrOrgUnit().getId().toString());
            result.put(HRORGUNIT_NUMBER, empOrgRelaInfo.getHrOrgUnit().getNumber());
            result.put(HRORGUNIT_NAME, empOrgRelaInfo.getHrOrgUnit().getName());
        }
        if (empOrgRelaInfo.getAdminOrg() != null) {
            result.put(ADMINORG_ID, empOrgRelaInfo.getAdminOrg().getId().toString());
            result.put(ADMINORG_NUMBER, empOrgRelaInfo.getAdminOrg().getNumber());
            result.put(ADMINORG_NAME, empOrgRelaInfo.getAdminOrg().getName());
            result.put(ADMINORG_DISPLAYNAME, empOrgRelaInfo.getAdminOrg().getDisplayName());
            if (empOrgRelaInfo.getAdminOrg().getCompany() != null) {
                result.put(COMPANY_ID, empOrgRelaInfo.getAdminOrg().getCompany().getId().toString());
                result.put(COMPANY_NUMBER, empOrgRelaInfo.getAdminOrg().getCompany().getNumber());
                result.put(COMPANY_NAME, empOrgRelaInfo.getAdminOrg().getCompany().getName());
            }
            if (empOrgRelaInfo.getAdminOrg().getDepartment() != null) {
                result.put(DEPARTMENT_ID, empOrgRelaInfo.getAdminOrg().getDepartment().getId().toString());
                result.put(DEPARTMENT_NUMBER, empOrgRelaInfo.getAdminOrg().getDepartment().getNumber());
                result.put(DEPARTMENT_NAME, empOrgRelaInfo.getAdminOrg().getDepartment().getName());
            }
        }
        if (empOrgRelaInfo.getPosition() != null) {
            result.put(POSITION_ID, empOrgRelaInfo.getPosition().getId().toString());
            result.put(POSITION_NUMBER, empOrgRelaInfo.getPosition().getNumber());
            result.put(POSITION_NAME, empOrgRelaInfo.getPosition().getName());
        }
        if (empOrgRelaInfo.getLaborRelation() != null && empOrgRelaInfo.getLaborRelation().getLaborRelationState() != null) {
            result.put(LABOR_RELA_STATE_ID, empOrgRelaInfo.getLaborRelation().getLaborRelationState().getId().toString());
            result.put(LABOR_RELA_STATE_NUMBER, empOrgRelaInfo.getLaborRelation().getLaborRelationState().getNumber());
            result.put(LABOR_RELA_STATE_NAME, empOrgRelaInfo.getLaborRelation().getLaborRelationState().getName());
        }
        if ((posExtColl = PositionExtendFactory.getLocalInstance((Context)ctx).getPositionExtendCollection("select hrJob.id,hrJob.number,hrJob.name where position = '" + empOrgRelaInfo.getPosition().getId().toString() + "'")) != null && posExtColl.size() > 0 && (hrJobInfo = posExtColl.get(0).getHrJob()) != null) {
            result.put(HRJOB_ID, hrJobInfo.getId().toString());
            result.put(HRJOB_NUMBER, hrJobInfo.getNumber());
            result.put(HRJOB_NAME, hrJobInfo.getName());
        }
        if ((empPostRankColl = HRManagerPersonCurDataUtil.getLastEmpPostRankByPerson(ctx, personId)) != null && empPostRankColl.size() > 0) {
            EmpPostRankInfo empPostRankInfo = empPostRankColl.get(0);
            result.put(JOBLEVEL_ID, empPostRankInfo.getJobLevel() == null ? "" : empPostRankInfo.getJobLevel().getId().toString());
            result.put(JOBLEVEL_NUMBER, empPostRankInfo.getJobLevel() == null ? "" : empPostRankInfo.getJobLevel().getNumber());
            result.put(JOBLEVEL_NAME, empPostRankInfo.getJobLevel() == null ? "" : empPostRankInfo.getJobLevel().getName());
            result.put("_###JobLevelIndex###", empPostRankInfo.getJobLevel() == null ? "" : empPostRankInfo.getJobLevel().getIndex() + "");
            result.put(JOBGRADE_ID, empPostRankInfo.getJobGrade() == null ? "" : empPostRankInfo.getJobGrade().getId().toString());
            result.put(JOBGRADE_NUMBER, empPostRankInfo.getJobGrade() == null ? "" : empPostRankInfo.getJobGrade().getNumber());
            result.put(JOBGRADE_NAME, empPostRankInfo.getJobGrade() == null ? "" : empPostRankInfo.getJobGrade().getName());
            result.put(JOBGRADE_NAME, empPostRankInfo.getJobGrade() == null ? "" : empPostRankInfo.getJobGrade().getIndex() + "");
        }
        return result;
    }

    public static EmpPostRankCollection getLastEmpPostRankByPerson(Context ctx, String personId) throws BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("jobLevel.id"));
        sic.add(new SelectorItemInfo("jobLevel.name"));
        sic.add(new SelectorItemInfo("jobLevel.number"));
        sic.add(new SelectorItemInfo("jobLevel.index"));
        sic.add(new SelectorItemInfo("jobGrade.id"));
        sic.add(new SelectorItemInfo("jobGrade.name"));
        sic.add(new SelectorItemInfo("jobGrade.number"));
        sic.add(new SelectorItemInfo("jobGrade.index"));
        view.setSelector(sic);
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isLatest", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo("empPositionType", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)HistoryUtil.getMaxDate(), CompareType.EQUALS));
        view.setFilter(filter);
        return EmpPostRankFactory.getLocalInstance((Context)ctx).getEmpPostRankCollection(view);
    }

    public static EmpPosOrgRelationCollection getLastMainEmpOrgRelation(Context ctx, String personId) throws BOSException {
        if (StringUtils.isEmpty((String)personId)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("person.id", (Object)personId));
        filter.getFilterItems().add(new FilterItemInfo("isInner", (Object)true));
        filter.getFilterItems().add(new FilterItemInfo("assignType", (Object)AssignTypeEnum.MAIN));
        filter.getFilterItems().add(new FilterItemInfo("isLatestInAday", (Object)1));
        filter.getFilterItems().add(new FilterItemInfo(HistoryConstant.LEFFDT, (Object)HistoryUtil.getMaxDate(), CompareType.EQUALS));
        view.setFilter(filter);
        view.setSelector(HRManagerPersonCurDataUtil.getSelector());
        return EmpPosOrgRelationFactory.getLocalInstance((Context)ctx).getEmpPosOrgRelationCollection(view);
    }

    public static SelectorItemCollection getSelector() {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("person.id"));
        sic.add(new SelectorItemInfo("person.name"));
        sic.add(new SelectorItemInfo("person.number"));
        sic.add(new SelectorItemInfo("adminOrg.id"));
        sic.add(new SelectorItemInfo("adminOrg.name"));
        sic.add(new SelectorItemInfo("adminOrg.number"));
        sic.add(new SelectorItemInfo("adminOrg.displayName"));
        sic.add(new SelectorItemInfo("adminOrg.company.id"));
        sic.add(new SelectorItemInfo("adminOrg.company.name"));
        sic.add(new SelectorItemInfo("adminOrg.company.number"));
        sic.add(new SelectorItemInfo("adminOrg.company.displayName"));
        sic.add(new SelectorItemInfo("adminOrg.department.id"));
        sic.add(new SelectorItemInfo("adminOrg.department.name"));
        sic.add(new SelectorItemInfo("adminOrg.department.number"));
        sic.add(new SelectorItemInfo("adminOrg.department.displayName"));
        sic.add(new SelectorItemInfo("position.id"));
        sic.add(new SelectorItemInfo("position.name"));
        sic.add(new SelectorItemInfo("position.number"));
        sic.add(new SelectorItemInfo("laborRelation.laborRelationState.id"));
        sic.add(new SelectorItemInfo("laborRelation.laborRelationState.name"));
        sic.add(new SelectorItemInfo("laborRelation.laborRelationState.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.id"));
        sic.add(new SelectorItemInfo("hrOrgUnit.name"));
        sic.add(new SelectorItemInfo("hrOrgUnit.number"));
        sic.add(new SelectorItemInfo("hrOrgUnit.displayName"));
        sic.add(new SelectorItemInfo("id"));
        return sic;
    }
}

