/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.manager.util;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.cache.service.CacheService;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.sql.util.Base64;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.hr.base.util.HRUtil;
import com.kingdee.eas.hr.base.util.HRUtilExtend;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.shr.base.permission.api.auth.SHRUserOrgPermissionApi;
import com.kingdee.shr.base.permission.sql.SHRPermissionSQL;
import com.kingdee.shr.manager.HRAdminFacadeFactory;
import com.kingdee.shr.self.model.ConfigData;
import com.kingdee.shr.self.service.IExternalDataService;
import com.kingdee.shr.self.util.HRConfigUtil;
import com.kingdee.util.DateTimeUtils;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Blob;
import java.sql.SQLException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpSession;
import net.sf.json.JSONObject;
import org.apache.log4j.Logger;

public class HRManagerUtil {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.shr.manager.util.HRManagerUtil");
    public static final int monthBoundary = 0;
    public static final String defaultMaleImgPath = "/shr/addon/manager/web/webviews/framework/resource/male.png";
    public static final String defaultFemaleImgPath = "/shr/addon/manager/web/webviews/framework/resource/female.png";
    public static final String defaultNeutralImgPath = "/shr/addon/manager/web/webviews/framework/resource/neutral.png";
    public static final int maxIndicator = 2;
    public static final String nodataImgPath = "/shr/addon/manager/web/webviews/framework/resource/nodata.png";
    public static final String initPersonBizDefine = "P/OSDCPfQXqU0TB/LQoA6uZovtk=";
    private static final String shrSelfCacheKey = "shr.shrSelf";

    public static String getTempTableName(Context ctx) throws Exception {
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        String tempTableName = pool.createTempTableName();
        return tempTableName;
    }

    public static void relaseTempTable(Context ctx, String tempTableName) throws BOSException {
        if (!StringUtils.isEmpty((String)tempTableName)) {
            TempTablePool pool = TempTablePool.getInstance((Context)ctx);
            pool.releaseTable(tempTableName);
        }
    }

    public static String createTempTable(Context ctx, String orgId) throws BOSException {
        String userId = HRManagerUtil.getUserId(ctx);
        String tempTableName = null;
        try {
            tempTableName = HRManagerUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer(" select adminOrg.fid,adminOrg.fname_" + HRManagerUtil.getLocal(ctx) + " as fname,adminOrg.flongnumber,adminOrg.fisleaf into ").append(tempTableName).append(" from T_ORG_Admin adminOrg").append(" inner join (").append(HRManagerUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRManagerUtil.getAdminRangeSql(ctx, userId)).append(" ) orgRange on adminOrg.fid = orgRange.forgid").append(" where adminOrg.fparentid = '").append(orgId).append("' and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static String createForewarnOrgRangeTempTable(Context ctx, String userId) throws BOSException {
        String userSql = HRManagerUtil.getUserSql(userId);
        String tempTableName = null;
        try {
            tempTableName = HRManagerUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer("select * into ").append(tempTableName).append(" from (").append(" select pmuser.fid fuserid,adminOrg.fid forgid,adminOrg.fname_" + HRManagerUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adminOrg on position.fadminorgunitid = adminOrg.fid").append(" where pmuser.fid in ").append(userSql).append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" union").append(" select subOrg.fuserid,adminOrg.fid forgid,adminOrg.fname_" + HRManagerUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_PM_OrgRangeIncludeSubOrg subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.forgid = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" inner join T_HR_PersonPositionExtend pp on pp.fpersonid = pmuser.fpersonid").append(" where subOrg.fuserid in ").append(userSql).append(" and subOrg.ftype = 20 and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" ) userOrgRange order by userOrgRange.fuserid asc,userOrgRange.flongnumber asc");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static int getDay(int year, int month) {
        int day = 0;
        switch (month) {
            case 1: {
                day = 31;
                break;
            }
            case 2: {
                day = year % 4 == 0 && year % 100 != 0 || year % 400 == 0 ? 29 : 28;
                break;
            }
            case 3: {
                day = 31;
                break;
            }
            case 4: {
                day = 30;
                break;
            }
            case 5: {
                day = 31;
                break;
            }
            case 6: {
                day = 30;
                break;
            }
            case 7: {
                day = 31;
                break;
            }
            case 8: {
                day = 31;
                break;
            }
            case 9: {
                day = 30;
                break;
            }
            case 10: {
                day = 31;
                break;
            }
            case 11: {
                day = 30;
                break;
            }
            case 12: {
                day = 31;
            }
        }
        return day;
    }

    public static double mul(double d1, double d2) {
        BigDecimal b1 = BigDecimal.valueOf(d1);
        BigDecimal b2 = BigDecimal.valueOf(d2);
        return b1.multiply(b2).doubleValue();
    }

    public static double round(double d, int len) {
        if (len != 0) {
            BigDecimal b1 = BigDecimal.valueOf(d);
            BigDecimal b2 = new BigDecimal(1);
            return b1.divide(b2, len, 4).doubleValue();
        }
        return 0.0;
    }

    public static String rate(double d1, double d2) {
        if (d2 != 0.0) {
            BigDecimal b1 = BigDecimal.valueOf(d1);
            BigDecimal b2 = BigDecimal.valueOf(d2);
            double result = b1.divide(b2, 4, 4).doubleValue();
            return HRManagerUtil.round(HRManagerUtil.mul(result, 100.0), 2) + "%";
        }
        return "0%";
    }

    public static void getPercent(List<Map> list, int headcount, String calculateName) {
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map map = list.get(i);
            int count = (Integer)map.get(calculateName);
            String percent = HRManagerUtil.rate(count, headcount);
            map.put("percent", percent);
        }
    }

    public static List getPercent(List list, int headcount) {
        ArrayList<Double> dataList = new ArrayList<Double>();
        if (list.size() < 1) {
            return dataList;
        }
        if (list.get(0) instanceof Integer) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                Integer count = (Integer)list.get(i);
                double data = HRManagerUtil.percent(count.intValue(), headcount);
                dataList.add(data);
            }
        } else if (list.get(0) instanceof Map) {
            HRManagerUtil.getPercent(list, headcount, "count");
        }
        return dataList;
    }

    public static void getValue(List<Map> list, double[] temp) {
        String tempStr = "";
        int size = list.size();
        block0: for (int i = 0; i < size; ++i) {
            Map map = list.get(i);
            String countStr = map.get("count").toString();
            double count = Double.parseDouble(countStr);
            int length = temp.length;
            for (int j = 0; j < length; ++j) {
                if (count != temp[j] || tempStr.indexOf(j + "") >= 0) continue;
                map.put("value", j + 1);
                tempStr = tempStr + j + ",";
                continue block0;
            }
        }
    }

    public static double percent(double d1, double d2) {
        if (d2 != 0.0) {
            BigDecimal b1 = BigDecimal.valueOf(d1);
            BigDecimal b2 = BigDecimal.valueOf(d2);
            double result = b1.divide(b2, 4, 4).doubleValue();
            return HRManagerUtil.round(HRManagerUtil.mul(result, 100.0), 2);
        }
        return 0.0;
    }

    public static Date getDefaultStartDate(Date date) throws BOSException {
        Date startDate = null;
        int year = DateTimeUtils.getYear((Date)date);
        int month = DateTimeUtils.getMonth((Date)date);
        if (month < 6) {
            --year;
            month += 7;
        } else {
            month -= 5;
        }
        int day = HRManagerUtil.getDay(year, month);
        try {
            startDate = DateTimeUtils.parseDate((String)(year + "-" + month + "-" + day));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return startDate;
    }

    public static String getFilterStr(Context ctx, Date startDate, Date endDate) {
        StringBuffer filterStr = new StringBuffer("");
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            if (endMonth == 1) {
                endMonth = 12;
                --endYear;
            } else {
                --endMonth;
            }
        }
        if (startYear == endYear && startMonth <= endMonth) {
            filterStr.append("fyear = ").append(startYear).append(" and fmonth in (");
            while (startMonth <= endMonth) {
                filterStr.append(startMonth).append(",");
                ++startMonth;
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")");
        } else {
            filterStr.append("(fyear = ").append(startYear).append(" and fmonth in (");
            while (startMonth <= 12) {
                filterStr.append(startMonth).append(",");
                ++startMonth;
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")) or (fyear = ").append(endYear).append(" and fmonth in (");
            for (int m = 1; m <= endMonth; ++m) {
                filterStr.append(m).append(",");
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append("))");
        }
        return filterStr.toString();
    }

    public static Map getDateEndFilterMap(Context ctx, Date startDate, Date endDate) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            if (endMonth == 1) {
                endMonth = 12;
                --endYear;
            } else {
                --endMonth;
            }
        }
        if (startYear == endYear && startMonth <= endMonth) {
            while (startMonth <= endMonth) {
                resultMap.put(startYear + "-" + startMonth, "{ts'" + startYear + "-" + startMonth + "-" + HRManagerUtil.getDay(startYear, startMonth) + "'}");
                ++startMonth;
            }
        } else {
            while (startMonth <= 12) {
                resultMap.put(startYear + "-" + startMonth, "{ts'" + startYear + "-" + startMonth + "-" + HRManagerUtil.getDay(startYear, startMonth) + "'}");
                ++startMonth;
            }
            for (int m = 1; m <= endMonth; ++m) {
                resultMap.put(endYear + "-" + m, "{ts'" + endYear + "-" + m + "-" + HRManagerUtil.getDay(endYear, m) + "'}");
            }
        }
        return resultMap;
    }

    public static Map getDateBeginFilterMap(Context ctx, Date startDate, Date endDate) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        if (endYear == year && endMonth == month) {
            if (endMonth == 1) {
                endMonth = 12;
                --endYear;
            } else {
                --endMonth;
            }
        }
        if (startYear == endYear && startMonth <= endMonth) {
            while (startMonth <= endMonth) {
                resultMap.put(startYear + "-" + startMonth, "{ts'" + startYear + "-" + startMonth + "-" + 1 + "'}");
                ++startMonth;
            }
        } else {
            while (startMonth <= 12) {
                resultMap.put(startYear + "-" + startMonth, "{ts'" + startYear + "-" + startMonth + "-" + 1 + "'}");
                ++startMonth;
            }
            for (int m = 1; m <= endMonth; ++m) {
                resultMap.put(endYear + "-" + m, "{ts'" + endYear + "-" + m + "-" + 1 + "'}");
            }
        }
        return resultMap;
    }

    public static String getYOYFilterStr(Context ctx, Date startDate, Date endDate) {
        int startMonth;
        StringBuffer filterStr = new StringBuffer("");
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (--startYear == --endYear && startMonth <= endMonth) {
            filterStr.append("fyear = ").append(startYear).append(" and fmonth in (");
            for (startMonth = DateTimeUtils.getMonth((Date)startDate); startMonth <= endMonth; ++startMonth) {
                filterStr.append(startMonth).append(",");
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")");
        } else {
            filterStr.append("(fyear = ").append(startYear).append(" and fmonth in (");
            while (startMonth <= 12) {
                filterStr.append(startMonth).append(",");
                ++startMonth;
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append(")) or (fyear = ").append(endYear).append(" and fmonth in (");
            for (int m = 1; m <= endMonth; ++m) {
                filterStr.append(m).append(",");
            }
            filterStr.delete(filterStr.length() - 1, filterStr.length());
            filterStr.append("))");
        }
        return filterStr.toString();
    }

    public static Date getDefaultMinStartDate(Date date) throws BOSException {
        Date startDate = null;
        int year = DateTimeUtils.getYear((Date)date);
        try {
            startDate = DateTimeUtils.parseDate((String)(year + "-01-01"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return startDate;
    }

    public static Date getDefaultMaxEndDate(Date date) throws BOSException {
        Date endDate = null;
        int year = DateTimeUtils.getYear((Date)date);
        try {
            endDate = DateTimeUtils.parseDate((String)(year + "-12-31"));
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return endDate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String convertBlobToBase64(Blob blob) {
        String str = "";
        if (blob != null) {
            byte[] data = null;
            InputStream in = null;
            try {
                in = blob.getBinaryStream();
                data = new byte[in.available()];
                in.read(data);
            }
            catch (IOException e) {
                e.printStackTrace();
                logger.error((Object)"getBase64PersonPhoto===", (Throwable)e);
            }
            catch (SQLException e) {
                e.printStackTrace();
                logger.error((Object)"getBase64PersonPhoto===", (Throwable)e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                    }
                }
            }
            str = Base64.encodeBytes((byte[])data);
        }
        return str;
    }

    public static String getUserId(Context ctx) {
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userId = userInfo != null ? userInfo.getId().toString() : (String)ctx.get((Object)"userID");
        return userId;
    }

    public static String getLocal(Context ctx) {
        String local = ctx.getLocale() != null ? ctx.getLocale().toString() : "l2";
        return local;
    }

    public static String getPersonPositionResponseAdminSql(String userId) {
        StringBuffer sql = new StringBuffer("select child.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and child.fissealup = 0").append(" and child.fisstartshr = 1");
        return sql.toString();
    }

    public static String getAdminRangeSql(Context ctx, String userId) {
        String firstSqlStr = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a22PERMITEM");
        String secondSqlStr = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a24PERMITEM");
        String thirdSqlStr = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a26PERMITEM");
        String fourthSqlStr = SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a28PERMITEM");
        StringBuffer resultSql = new StringBuffer("select tb1.FAdminOrgID forgId from (" + firstSqlStr + ") tb1 ");
        if (!firstSqlStr.equals(secondSqlStr)) {
            resultSql.append(" inner join (" + secondSqlStr + ")tb2 on tb1.FAdminOrgID = tb2.FAdminOrgID");
        }
        if (resultSql.toString().indexOf(thirdSqlStr) == -1) {
            resultSql.append(" inner join (" + thirdSqlStr + ")tb3 on tb1.FAdminOrgID = tb3.FAdminOrgID");
        }
        if (resultSql.toString().indexOf(fourthSqlStr) == -1) {
            resultSql.append(" inner join (" + fourthSqlStr + ")tb4 on tb1.FAdminOrgID = tb4.FAdminOrgID");
        }
        return resultSql.toString();
    }

    public static Set<String> getAdminRangeSet(Context ctx, String userId) {
        ArrayList<String> firstList = new ArrayList<String>();
        HashSet<String> secondSet = new HashSet<String>();
        HashSet<String> thirdSet = new HashSet<String>();
        HashSet<String> fourthSet = new HashSet<String>();
        HashSet<String> realAdminRangeIdsSet = new HashSet<String>();
        try {
            StringBuffer firstSql = new StringBuffer("select adminOrg.fid as forgId from t_org_admin adminOrg");
            firstSql.append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a22PERMITEM") + ")");
            IRowSet firstRowSet = DbUtil.executeQuery((Context)ctx, (String)firstSql.toString());
            while (firstRowSet.next()) {
                firstList.add(firstRowSet.getString("forgId"));
            }
            StringBuffer secondSql = new StringBuffer("select adminOrg.fid as forgId from t_org_admin adminOrg");
            secondSql.append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a24PERMITEM") + ")");
            IRowSet secondRowSet = DbUtil.executeQuery((Context)ctx, (String)secondSql.toString());
            while (secondRowSet.next()) {
                secondSet.add(secondRowSet.getString("forgId"));
            }
            StringBuffer thirdSql = new StringBuffer("select adminOrg.fid as forgId from t_org_admin adminOrg");
            thirdSql.append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a26PERMITEM") + ")");
            IRowSet thirdRowSet = DbUtil.executeQuery((Context)ctx, (String)thirdSql.toString());
            while (thirdRowSet.next()) {
                thirdSet.add(thirdRowSet.getString("forgId"));
            }
            StringBuffer fourthSql = new StringBuffer("select adminOrg.fid as forgId from t_org_admin adminOrg");
            fourthSql.append(" where fid in (").append(SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)"fffffff0-ffff-efff-f2bd-0000000f4a26PERMITEM") + ")");
            IRowSet fourthRowSet = DbUtil.executeQuery((Context)ctx, (String)fourthSql.toString());
            while (fourthRowSet.next()) {
                fourthSet.add(fourthRowSet.getString("forgId"));
            }
            int count = firstList.size();
            for (int i = 0; i < count; ++i) {
                String tempId = (String)firstList.get(i);
                if (!secondSet.contains(tempId) || !thirdSet.contains(tempId) || !fourthSet.contains(tempId)) continue;
                realAdminRangeIdsSet.add(tempId);
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return realAdminRangeIdsSet;
    }

    public static String getUserSql(String userId) {
        if (!StringUtils.isEmpty((String)userId)) {
            StringBuffer sql = new StringBuffer("(");
            String[] userIds = userId.split(",");
            int length = userIds.length;
            for (int i = 0; i < length; ++i) {
                sql.append("'").append(userIds[i]).append("',");
            }
            int length2 = sql.length();
            sql.delete(length2 - 1, length2);
            sql.append(")");
            return sql.toString();
        }
        return "('')";
    }

    public static Map convertObjectToMap(Object o) throws BOSException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            PropertyDescriptor[] propertyDescriptors;
            BeanInfo beanInfo = Introspector.getBeanInfo(o.getClass());
            for (PropertyDescriptor property : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                String key = property.getName();
                if (key.compareToIgnoreCase("class") == 0 || o instanceof ConfigData && key.equalsIgnoreCase("element")) continue;
                Method getter = property.getReadMethod();
                Object value = getter != null ? getter.invoke(o, new Object[0]) : null;
                map.put(key, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    public static Object getExternalData(String externalDataClass, Map param) throws BOSException {
        HashMap map = null;
        try {
            Class<?> clazz = Class.forName(externalDataClass);
            IExternalDataService iExternalDataService = (IExternalDataService)clazz.newInstance();
            Object obj = iExternalDataService.getExternalData(param);
            if (obj != null) {
                JSONObject jsonObj = JSONObject.fromObject((Object)obj);
                map = HRConfigUtil.convertJSONMap((JSONObject)jsonObj);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return map;
    }

    public static int getToltalCount(Context ctx, String sql) throws BOSException, EASBizException {
        int toltalCount = 0;
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        try {
            while (rowSet.next()) {
                toltalCount = rowSet.getInt("totalCount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return toltalCount;
    }

    public static String getDefaultOrgId(Context ctx) throws BOSException, EASBizException {
        String orgId = "";
        Map map = HRAdminFacadeFactory.getLocalInstance(ctx).getOrgTreeData(orgId);
        if (map.size() > 0) {
            Map defaultOrgMap = (Map)((List)map.get("orgTree")).get(0);
            orgId = (String)defaultOrgMap.get("id");
        }
        return orgId;
    }

    public static String getStringFilter(String str) {
        StringBuffer filter = new StringBuffer("");
        String[] s = str.split(",");
        if (s.length > 0) {
            filter.append(" in ( ");
            int size = s.length;
            for (int i = 0; i < size; ++i) {
                filter.append("'").append(s[i]).append("',");
            }
            filter.delete(filter.length() - 1, filter.length());
            filter.append(" )");
        }
        return filter.toString();
    }

    public static String getIntFilter(String str) {
        StringBuffer filter = new StringBuffer("");
        String[] s = str.split(",");
        if (s.length > 0) {
            filter.append(" in ( ");
            int size = s.length;
            for (int i = 0; i < size; ++i) {
                filter.append(s[i]).append(",");
            }
            filter.delete(filter.length() - 1, filter.length());
            filter.append(" )");
        }
        return filter.toString();
    }

    public static boolean containStr(String source, String target) {
        StringBuffer filter = new StringBuffer("");
        String[] s = source.split(",");
        for (int i = 0; i < s.length; ++i) {
            if (!s[i].equals(target)) continue;
            return true;
        }
        return false;
    }

    public static String createUserOrgRangeTempTable(Context ctx, String userId) throws BOSException {
        String userSql = HRManagerUtil.getUserSql(userId);
        String tempTableName = null;
        try {
            tempTableName = HRManagerUtil.getTempTableName(ctx);
            StringBuffer sql = new StringBuffer("select * into ").append(tempTableName).append(" from (").append(" select pmuser.fid fuserid,adminOrg.fid forgid,adminOrg.fname_" + HRManagerUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid = emprelation.fpositionid").append(" inner join T_ORG_Admin adminOrg on position.fadminorgunitid = adminOrg.fid").append(" where pmuser.fid in ").append(userSql).append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" union").append(" select subOrg.fuserid,adminOrg.fid forgid,adminOrg.fname_" + HRManagerUtil.getLocal(ctx) + " fname,adminOrg.flongnumber").append(" from T_PM_OrgRangeIncludeSubOrg subOrg").append(" inner join T_ORG_Admin adminOrg on subOrg.forgid = adminOrg.fid").append(" inner join T_PM_User pmuser on subOrg.fuserid = pmuser.fid").append(" inner join T_HR_PersonPositionExtend pp on pp.fpersonid = pmuser.fpersonid").append(" where subOrg.fuserid in ").append(userSql).append(" and subOrg.ftype = 20 and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" ) userOrgRange order by userOrgRange.fuserid asc,userOrgRange.flongnumber asc");
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return tempTableName;
    }

    public static Map getSixMonthData() throws BOSException {
        LinkedHashMap<String, Integer> map = new LinkedHashMap<String, Integer>();
        Date startDate = HRManagerUtil.getDefaultStartDate(new Date());
        Date endDate = new Date();
        int startYear = DateTimeUtils.getYear((Date)startDate);
        int startMonth = DateTimeUtils.getMonth((Date)startDate);
        int endYear = DateTimeUtils.getYear((Date)endDate);
        int endMonth = DateTimeUtils.getMonth((Date)endDate);
        if (startYear == endYear) {
            for (int m = startMonth; m <= endMonth; ++m) {
                map.put(startYear + "-" + m, 0);
            }
        } else {
            int m;
            for (m = startMonth; m <= 12; ++m) {
                map.put(startYear + "-" + m, 0);
            }
            for (m = 1; m <= endMonth; ++m) {
                map.put(endYear + "-" + m, 0);
            }
        }
        return map;
    }

    public static Map getTrendMap(Map map) throws BOSException {
        HashMap resultMap = new HashMap();
        ArrayList<String> labelList = new ArrayList<String>();
        ArrayList<Integer> dataList = new ArrayList<Integer>();
        for (Map.Entry entry : map.entrySet()) {
            String label = (String)entry.getKey();
            labelList.add(label);
            int data = (Integer)entry.getValue();
            dataList.add(data);
        }
        resultMap.put("labelList", labelList);
        resultMap.put("dataList", dataList);
        return resultMap;
    }

    public static HashSet<String> getDefaultId() {
        HashSet<String> defualtBillId = new HashSet<String>();
        defualtBillId.add("8r0AAAAKskiyfgJj");
        defualtBillId.add("8r0AAAAKxdAVWxqK");
        defualtBillId.add("8r0AAAALeYNA42+n");
        defualtBillId.add("8r0AAAAKf5D8Co0g");
        defualtBillId.add("8r0AAAAKf4lsrgZ3");
        defualtBillId.add("8r0AAAAKf4aYteXk");
        defualtBillId.add("8r0AAAAKg272/Jmm");
        defualtBillId.add("8r0AAAAKg3Vjc0wq");
        defualtBillId.add("8r0AAAAKh1AM86z1");
        return defualtBillId;
    }

    public static String getRootAdminId() {
        return "00000000-0000-0000-0000-000000000000CCE7AED4";
    }

    public static List getSixMonth() {
        ArrayList<String> result = new ArrayList<String>();
        int year = DateTimeUtils.getYear((Date)new Date());
        int month = DateTimeUtils.getMonth((Date)new Date());
        for (int i = 0; i < 6; ++i) {
            result.add(year + "-" + month);
            if (month == 1) {
                --year;
                month = 12;
                continue;
            }
            --month;
        }
        return result;
    }

    public static int getBeginHeadcount(Context ctx, String orgId, int year, int month) throws BOSException {
        String userId = HRManagerUtil.getUserId(ctx);
        String includeSubSql = null;
        includeSubSql = HRManagerUtil.isUserOrgIncludeSub(ctx, userId, orgId) ? " where t1.fadminorgid = '" + orgId + "'" : " where t2.fadminorgid = '" + orgId + "' and t1.fadminorgid = '" + orgId + "'";
        int headcount = 0;
        try {
            StringBuffer sql = new StringBuffer("select isnull(sum(t2.fbeginheadcount),0) headcount").append(" from T_MGR_HRHeadcount t1").append(" inner join T_MGR_HRHeadcount t2 on (charindex(concat(t1.fbeginlongnumber,'!'),t2.fbeginlongnumber) = 1 or t1.fbeginlongnumber = t2.fbeginlongnumber)").append(" inner join (").append(HRManagerUtil.getPersonPositionResponseAdminSql(userId)).append(" union ").append(HRManagerUtil.getAdminRangeSql(ctx, userId)).append(" ) range on t1.fadminorgid = range.forgid").append(includeSubSql).append(" and t1.fyear = " + year + " and t1.fmonth = " + month).append(" and t1.fyear = t2.fyear and t1.fmonth = t2.fmonth");
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rowSet.next()) {
                headcount = rowSet.getInt("headcount");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw new BOSException((Throwable)e);
        }
        return headcount;
    }

    public static boolean isUserOrgIncludeSub(Context ctx, String userId, String orgId) throws BOSException {
        String tempSql;
        IRowSet tempRowSet;
        List<String> permIdList = HRManagerUtil.getMangaerPermList(ctx, userId);
        StringBuffer responseSql = new StringBuffer("select child.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and child.fid = '").append(orgId).append("'");
        IRowSet responseAdmin = DbUtil.executeQuery((Context)ctx, (String)responseSql.toString());
        if (responseAdmin.size() > 0) {
            return true;
        }
        StringBuffer hrAdminNotIncludeSubSql = new StringBuffer().append(" select adminOrg.fid as forgId FROM T_HR_SHRUserAdminOrgPerm adminorgperm").append(" inner join T_ORG_Admin adminOrg on adminorgperm.fadminorgid = adminOrg.fid").append(" inner join T_PM_User as pmuser on pmuser.fid = adminorgperm.fuserid").append(" inner join T_HR_PersonPositionExtend as pp on pp.fpersonid = pmuser.fpersonid").append(" where adminorgperm.fuserid = '").append(userId).append("'").append(" and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" and adminorgperm.fpermitemid in ").append(HRUtilExtend.getStrFromList(permIdList)).append(" and adminorgperm.FIsIncludeSubOrg = 0").append(" union").append(" SELECT t0.FAdminOrgID fid FROM T_HR_SHRRoleAdminOrgPerm t0 ").append(" inner join T_ORG_Admin adminOrg on t0.fadminorgid = adminOrg.fid").append(" inner join T_PM_User as pmuser on pmuser.fid = t0.fuserid").append(" inner join T_PM_RolePerm t2 on t2.FROLEID=t0.FRoleID  ").append(" inner join T_HR_PersonPositionExtend as pp on pp.fpersonid = pmuser.fpersonid").append(" where t0.fuserid = '").append(userId).append("'").append(" and t2.FPermItemId in ").append(HRUtilExtend.getStrFromList(permIdList)).append(" and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=t0.FRoleID and t1.FUserId = '").append(userId).append("') ").append(" and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" and t0.FIsIncludeSubOrg = 0");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("hrAdminNotIncludeSubSql******getSql*****\n:" + hrAdminNotIncludeSubSql));
        }
        StringBuffer easAdminNotIncludeSubSql = new StringBuffer().append(" select adminOrg.fid as forgId").append(" from T_PM_OrgRangeIncludeSubOrg range").append(" inner join T_ORG_Admin adminOrg on range.forgid = adminOrg.fid").append(" inner join T_PM_User as pmuser on pmuser.fid = range.fuserid").append(" inner join T_HR_PersonPositionExtend as pp on pp.fpersonid = pmuser.fpersonid").append(" where range.fuserid = '").append(userId).append("' and range.ftype = 20").append(" and pp.fisleader = 1").append(" and adminOrg.fissealup = 0").append(" and adminOrg.fisstartshr = 1").append(" and range.FIsIncludeSubOrg = 0");
        if (permIdList.size() < 4 && permIdList.size() > 0 ? (tempRowSet = DbUtil.executeQuery((Context)ctx, (String)(tempSql = "select * from t_org_admin where ( fid in (" + hrAdminNotIncludeSubSql + ") or fid in (" + easAdminNotIncludeSubSql + ")) and fid ='" + orgId + "'"))).size() > 0 : (permIdList.size() == 0 ? (tempRowSet = DbUtil.executeQuery((Context)ctx, (String)(tempSql = "select * from t_org_admin where ( fid in (" + easAdminNotIncludeSubSql + ")) and fid ='" + orgId + "'"))).size() > 0 : permIdList.size() == 4 && (tempRowSet = DbUtil.executeQuery((Context)ctx, (String)(tempSql = "select * from t_org_admin where ( fid in (" + hrAdminNotIncludeSubSql + ")) and fid ='" + orgId + "'"))).size() > 0)) {
            return false;
        }
        Set<String> adminRangeSet = HRManagerUtil.getAdminRangeSet(ctx, userId);
        return adminRangeSet.contains(orgId);
    }

    public static String getConfigId(Context ctx, String adminorgid, String tableName) throws BOSException {
        HashMap<String, String> adminConfigMap = new HashMap<String, String>();
        ArrayList<String> adminIdList = new ArrayList<String>();
        String configId = null;
        try {
            String tempSqlString = "select fadminorgid,fid from " + tableName + " where fstate = 1";
            IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)tempSqlString);
            while (rowSet.next()) {
                adminConfigMap.put(rowSet.getString("fadminorgid"), rowSet.getString("fid"));
                adminIdList.add(rowSet.getString("fadminorgid"));
            }
            String configAdminIdsStr = HRUtilExtend.getStrFromList(adminIdList);
            String sourceLongnumber = null;
            HashMap<String, String> targetMap = new HashMap<String, String>();
            String sourceSql = "select flongnumber from t_org_admin where fid = '" + adminorgid + "'";
            String targetSql = "select flongnumber,fid from t_org_admin where fid in " + configAdminIdsStr;
            IRowSet sourceRowSet = DbUtil.executeQuery((Context)ctx, (String)sourceSql);
            while (sourceRowSet.next()) {
                sourceLongnumber = sourceRowSet.getString("flongnumber");
            }
            IRowSet targetRowSet = DbUtil.executeQuery((Context)ctx, (String)targetSql);
            while (targetRowSet.next()) {
                targetMap.put(targetRowSet.getString("flongnumber"), targetRowSet.getString("fid"));
            }
            if (targetMap.containsKey(sourceLongnumber)) {
                configId = (String)targetMap.get(sourceLongnumber);
            }
            String newLongnumber = sourceLongnumber;
            int sourceLevel = sourceLongnumber == null ? 0 : sourceLongnumber.split("!").length + 1;
            for (int i = 0; i < sourceLevel; ++i) {
                if (targetMap.containsKey(newLongnumber)) {
                    configId = (String)targetMap.get(newLongnumber);
                    break;
                }
                if (newLongnumber == null || "".equals(newLongnumber)) continue;
                int index = newLongnumber.lastIndexOf("!");
                newLongnumber = newLongnumber.substring(0, index);
            }
            if (configId == null) {
                logger.info((Object)"******HRManagerUtil*****configId***is  null");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return (String)adminConfigMap.get(configId);
    }

    public static List<String> getMangaerPermList(Context ctx, String userId) {
        ArrayList<String> resultList = new ArrayList<String>();
        ArrayList<String> permIdsList = new ArrayList<String>();
        permIdsList.add("fffffff0-ffff-efff-f2bd-0000000f4a22PERMITEM");
        permIdsList.add("fffffff0-ffff-efff-f2bd-0000000f4a24PERMITEM");
        permIdsList.add("fffffff0-ffff-efff-f2bd-0000000f4a26PERMITEM");
        permIdsList.add("fffffff0-ffff-efff-f2bd-0000000f4a28PERMITEM");
        String permItemIds = HRUtilExtend.getStrFromList(permIdsList);
        StringBuffer sql = new StringBuffer();
        sql.append("select count(distinct uniontemp.fpermitemid) cnt, uniontemp.fpermitemid ").append(" from (").append(" select shruser.fpermitemid  from T_HR_SHRUserAdminOrgPerm  shruser ").append(" where  shruser.FUserId ='").append(userId).append("' and  shruser.FPermItemId in ").append(permItemIds).append(" union ").append(" select t2.fpermitemid from  T_HR_SHRRoleAdminOrgPerm  t0").append(" inner join T_PM_RolePerm t2 on t2.FROLEID=t0.FRoleID").append(" where ").append(" t0.FUserId = '").append(userId).append("'").append(" and t2.FPermItemId in ").append(permItemIds).append(" and exists(SELECT 1 FROM T_PM_UserRoleOrg t1 where t1.FROLEID=t0.FRoleID and t1.FUserId = '").append(userId).append("') ").append(" ) uniontemp ").append("  group by uniontemp.fpermitemid");
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("getMangaerPermList******sql******:\n" + sql));
            }
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (iRowSet.next()) {
                resultList.add(iRowSet.getString("fpermitemid"));
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return resultList;
    }

    public static boolean userIsLeader(Context ctx, String userId) {
        boolean isLeader = false;
        String sql = "select * from T_HR_PersonPositionExtend ppe inner join t_pm_user kuser on kuser.fpersonid = ppe.fpersonid where ppe.fisleader=1 and kuser.fid = ?";
        try {
            IRowSet iRowSet = DbUtil.executeQuery((Context)ctx, (String)sql, (Object[])new Object[]{userId});
            if (iRowSet.next()) {
                isLeader = true;
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return isLeader;
    }

    public static String getEnrollCountSelector() {
        return " select count(emprelation.fpersonid) as enrollHeadcount,emprelation.fadminorgid";
    }

    public static String getEnrollCountRelation(String onStr) {
        StringBuffer relationBuffer = new StringBuffer();
        relationBuffer.append(" T_HR_EmpOrgRelation emprelation");
        if (!StringUtils.isEmpty((String)onStr)) {
            relationBuffer.append(onStr);
        }
        relationBuffer.append(" inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid");
        relationBuffer.append(" and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime");
        relationBuffer.append(" inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid");
        relationBuffer.append(" inner join T_HR_HRBizDefine bizDefine on emprelation.factionid = bizDefine.fid");
        return relationBuffer.toString();
    }

    public static String getEnrollCountFilter(String beginDateStr, String endDateStr) {
        StringBuffer filterBuffer = new StringBuffer();
        filterBuffer.append(" (bizDefine.fbizdefinetype = 1 or bizDefine.fbizdefinetype = 16 or bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=')");
        filterBuffer.append(" and laborRelationHis.fenterdate >= ").append(beginDateStr).append(" and laborRelationHis.fenterdate <= ").append(endDateStr);
        filterBuffer.append(" and emprelation.fisenrolled = 1 and emprelation.fisinner = 1");
        filterBuffer.append(" and emptype.fisonthestrength = 1");
        return filterBuffer.toString();
    }

    public static String getEnrollCountGroup() {
        return " group by emprelation.fadminorgid";
    }

    public static String getResignCountSelector() {
        return "  select count(emprelation.fpersonid) as resignHeadcount,emprelation.fadminorgid";
    }

    public static String getResignCountRelation(String onStr) {
        StringBuffer relationBuffer = new StringBuffer();
        relationBuffer.append(" T_HR_EmpOrgRelation emprelation");
        if (!StringUtils.isEmpty((String)onStr)) {
            relationBuffer.append(onStr);
        }
        relationBuffer.append(" inner join t_hr_personpositionhis pphis on emprelation.fpersonid = pphis.fpersonid");
        relationBuffer.append(" and pphis.FStartDateTime <= emprelation.FEndDateTime and pphis.FEndDateTime >= emprelation.FEndDateTime");
        relationBuffer.append(" inner join T_HR_EmpLaborRelationHis laborRelationHis on emprelation.flaborrelationid = laborRelationHis.fhistoryrelateid");
        relationBuffer.append(" and laborRelationHis.FStartDateTime <= emprelation.FEndDateTime and laborRelationHis.FEndDateTime >= emprelation.FEndDateTime");
        relationBuffer.append(" inner join T_HR_BDEmployeeType empType on laborRelationHis.flaborrelationstateid = empType.fid");
        relationBuffer.append(" inner join T_HR_HRBizDefine bizDefine on emprelation.factionid = bizDefine.fid");
        relationBuffer.append(" left join T_HR_BDEmployeeType empTypeLast  ON laborRelationHis.FLASTLABORRELASTATEID = empTypeLast.fid");
        return relationBuffer.toString();
    }

    public static String getResignCountFilter(String beginDateStr, String endDateStr) {
        StringBuffer filterBuffer = new StringBuffer();
        filterBuffer.append(" ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)");
        filterBuffer.append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))");
        filterBuffer.append(" and pphis.FLeftCompanyDate >= ").append(beginDateStr).append(" and pphis.FLeftCompanyDate <= ").append(endDateStr);
        filterBuffer.append(" and emprelation.fisinner = 1");
        filterBuffer.append(" and (emptype.fisonthestrength = 0 or emprelation.fisenrolled = 0)");
        return filterBuffer.toString();
    }

    public static String getResignCountFilter(String beginDateStr, String endDateStr, String modleType) {
        StringBuffer filterBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)modleType)) {
            filterBuffer.append(" ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1").append(" and  modlelast.FNUMBER = '").append(modleType).append("')");
            filterBuffer.append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2").append(" and  modle.FNUMBER = '").append(modleType).append("'))");
        } else {
            filterBuffer.append(" ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)");
            filterBuffer.append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))");
        }
        filterBuffer.append(" and pphis.FLeftCompanyDate >= ").append(beginDateStr).append(" and pphis.FLeftCompanyDate <= ").append(endDateStr);
        filterBuffer.append(" and emprelation.fisinner = 1");
        filterBuffer.append(" and (emptype.fisonthestrength = 0 or emprelation.fisenrolled = 0)");
        return filterBuffer.toString();
    }

    public static String getResignCountFilter(String beginDateStr, String endDateStr, String modleType, String YOYBeginDateStr, String YOYEndDateStr) {
        StringBuffer filterBuffer = new StringBuffer();
        if (!StringUtils.isEmpty((String)modleType)) {
            filterBuffer.append(" ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1").append(" and  modlelast.FNUMBER = '").append(modleType).append("')");
            filterBuffer.append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2").append(" and  modle.FNUMBER = '").append(modleType).append("'))");
        } else {
            filterBuffer.append(" ((bizDefine.fbizdefinetype = 4 and empTypeLast.FISONTHESTRENGTH =1)");
            filterBuffer.append(" or (bizDefine.fid='P/OSDCPfQXqU0TB/LQoA6uZovtk=' and empType.FINSERVICE = 2))");
        }
        filterBuffer.append(" and(");
        filterBuffer.append(" ( pphis.FLeftCompanyDate >= ").append(beginDateStr).append(" and pphis.FLeftCompanyDate <= ").append(endDateStr).append(")");
        filterBuffer.append(" or (pphis.FLeftCompanyDate >=" + YOYBeginDateStr + "and pphis.FLeftCompanyDate <=" + YOYEndDateStr + ")");
        filterBuffer.append(")");
        filterBuffer.append(" and emprelation.fisinner = 1");
        filterBuffer.append(" and (emptype.fisonthestrength = 0 or emprelation.fisenrolled = 0)");
        return filterBuffer.toString();
    }

    public static String getResignCountGroup() {
        return " group by emprelation.fadminorgid";
    }

    public static String getUserRangePersonSql(Context ctx, String userId) {
        return null;
    }

    public static List<String> transferMothToEnMoth(List<String> paramsList, String splitGex) {
        ArrayList<String> resultEnMonthList = new ArrayList<String>();
        if (paramsList == null || paramsList.size() == 0) {
            return null;
        }
        int size = paramsList.size();
        for (int i = 0; i < size; ++i) {
            if (!StringUtils.isEmpty((String)splitGex)) {
                String month1 = paramsList.get(i).split(splitGex)[1];
                String enMonth = HRManagerUtil.returnEnMonth(Integer.valueOf(month1));
                String year = paramsList.get(i).split(splitGex)[0];
                String monthYear = enMonth + " " + year;
                resultEnMonthList.add(monthYear);
                continue;
            }
            String enMonth = HRManagerUtil.returnEnMonth(Integer.valueOf(paramsList.get(i)));
            resultEnMonthList.add(enMonth);
        }
        return resultEnMonthList;
    }

    public static String returnEnMonth(int month) {
        String enMoth = "";
        switch (month) {
            case 1: {
                enMoth = "Jan";
                break;
            }
            case 2: {
                enMoth = "Feb";
                break;
            }
            case 3: {
                enMoth = "Mar";
                break;
            }
            case 4: {
                enMoth = "Apr";
                break;
            }
            case 5: {
                enMoth = "May";
                break;
            }
            case 6: {
                enMoth = "Jun";
                break;
            }
            case 7: {
                enMoth = "Jul";
                break;
            }
            case 8: {
                enMoth = "Aug";
                break;
            }
            case 9: {
                enMoth = "Sep";
                break;
            }
            case 10: {
                enMoth = "Oct";
                break;
            }
            case 11: {
                enMoth = "Nov";
                break;
            }
            case 12: {
                enMoth = "Dec";
            }
        }
        return enMoth;
    }

    public static String getPersonPositionResponseAdminSql(String userId, String orgId) {
        StringBuffer sql = new StringBuffer("select child.fid as forgId").append(" from T_HR_EmpOrgRelation emprelation").append(" inner join T_PM_User pmuser on pmuser.fpersonid = emprelation.fpersonid").append(" inner join T_ORG_Position position on position.fid= emprelation.fpositionid").append(" inner join T_ORG_Admin adcount on position.fadminorgunitid = adcount.fid").append(" left join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber)").append(" where pmuser.fid = '").append(userId).append("'").append(" and emprelation.fisinner = 1").append(" and emprelation.fleffdt = ").append(HRUtilExtend.getDateStringWithoutMininuteTs((Date)HRUtil.getMaxEndDate())).append(" and emprelation.FIsLatestInAday = 1").append(" and position.fisrespposition = 1").append(" and child.fissealup = 0").append(" and child.fisstartshr = 1").append(" and adcount.fisstartshr = 1").append(" and adcount.fid = '").append(orgId).append("'");
        return sql.toString();
    }

    public static boolean queryPositionExtIsLeader(Context ctx, String userId) throws BOSException {
        String posExtSql = "SELECT count(1) as num FROM  T_HR_PersonPositionExtend posExt inner join T_PM_User pmuser on pmuser.fpersonid = posExt.fpersonid where pmuser.FID ='" + userId + "' and posExt.FISLEADER=1";
        IRowSet executeQuery = DbUtil.executeQuery((Context)ctx, (String)posExtSql);
        try {
            while (executeQuery.next()) {
                String num = executeQuery.getString("num");
                if (Integer.valueOf(num) <= 0) continue;
                return true;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    public static String sqlReplaceHandler(Context ctx, String orgId, String dataConfigsql) throws BOSException {
        if (dataConfigsql.indexOf("@permissionsql") > -1) {
            StringBuffer sql = HRManagerUtil.getManagerDataPermissionAdminIdSql(ctx, orgId);
            dataConfigsql = dataConfigsql.replace("@permissionsql", sql.toString());
        }
        if (dataConfigsql.indexOf("@includeSubSql") > -1) {
            String includeSubSql = "";
            String userId = HRManagerUtil.getUserId(ctx);
            includeSubSql = HRManagerUtil.isUserOrgIncludeSub(ctx, userId, orgId) ? " adcount.fid = '" + orgId + "'" : " child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
            dataConfigsql = dataConfigsql.replace("@includeSubSql", includeSubSql);
        }
        if (dataConfigsql.indexOf("@orgId") > -1) {
            dataConfigsql = dataConfigsql.replace("@orgId", orgId);
        }
        if (dataConfigsql.indexOf("&lt;") > -1) {
            dataConfigsql = dataConfigsql.replace("&lt;", "<");
        }
        if (dataConfigsql.indexOf("&gt;") > -1) {
            dataConfigsql = dataConfigsql.replace("&gt;", ">");
        }
        return dataConfigsql;
    }

    public static StringBuffer getManagerDataPermissionAdminIdSql(Context ctx, String orgId) throws BOSException {
        String userId = HRManagerUtil.getUserId(ctx);
        String includeSubSql = "";
        includeSubSql = HRManagerUtil.isUserOrgIncludeSub(ctx, userId, orgId) ? " where adcount.fid = '" + orgId + "'" : " where child.fid = '" + orgId + "' and adcount.fid = '" + orgId + "'";
        StringBuffer sql = new StringBuffer("select child.fid as forgId ");
        sql.append(" from T_ORG_Admin adcount ").append(" inner join T_ORG_Admin child on (charindex(concat(adcount.flongnumber,'!'),child.flongnumber) = 1 or adcount.flongnumber = child.flongnumber) ").append(" inner join (").append(HRManagerUtil.getPersonPositionResponseAdminSql(userId));
        if (HRManagerUtil.queryPositionExtIsLeader(ctx, userId)) {
            sql.append(" union ").append(HRManagerUtil.getAdminRangeSql(ctx, userId));
        }
        sql.append(" ) range on child.fid = range.forgid").append(includeSubSql).append(" and child.fissealup = 0").append(" and child.fisstartshr = 1");
        return sql;
    }

    public static void filterMgrAdminResponseOrAdminLeader(FilterInfo filter, Context ctx, String userId, String adminOrgId) throws BOSException {
        FilterInfo adminOrgResponseAdminFilter = HRManagerUtil.getPersonPositionResponseAdminfilter(adminOrgId, userId);
        try {
            filter.mergeFilter(adminOrgResponseAdminFilter, "and");
            if (HRManagerUtil.queryPositionExtIsLeader(ctx, userId)) {
                FilterInfo adminOrgRangeFilter = HRManagerUtil.getPersonAdminOrgRangefilter(ctx, adminOrgId, userId);
                filter.mergeFilter(adminOrgRangeFilter, "or");
            }
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
    }

    public static FilterInfo getPersonPositionResponseAdminfilter(String adminOrgIdField, String userId) {
        FilterInfo adminOrgResponseAdminFilter = new FilterInfo();
        adminOrgResponseAdminFilter.getFilterItems().add(new FilterItemInfo(adminOrgIdField, (Object)HRManagerUtil.getPersonPositionResponseAdminSql(userId), CompareType.INNER));
        return adminOrgResponseAdminFilter;
    }

    public static FilterInfo getPersonAdminOrgRangefilter(Context ctx, String adminOrgIdField, String userId, String permItemId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(adminOrgIdField, (Object)SHRUserOrgPermissionApi.getUserAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId), CompareType.INNER));
        return filter;
    }

    public static FilterInfo getPersonAdminOrgRangefilter(Context ctx, String adminOrgIdField, String userId) {
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(adminOrgIdField, (Object)HRManagerUtil.getAdminRangeSql(ctx, userId), CompareType.INNER));
        return filter;
    }

    public static String replaceStartEndFlag(String dataConfigsql) {
        if (dataConfigsql.indexOf("@start") > -1 && dataConfigsql.indexOf("@end") > -1) {
            dataConfigsql = dataConfigsql.replace("@start", "");
            dataConfigsql = dataConfigsql.replace("@end", "");
        }
        return dataConfigsql;
    }

    public static String getInnerStartEndSql(String dataConfigsql) {
        int startIndex = dataConfigsql.indexOf("@start");
        int endIndex = dataConfigsql.indexOf("@end");
        if (startIndex > -1 && endIndex > -1) {
            dataConfigsql = dataConfigsql.substring(startIndex + 6, endIndex);
            return dataConfigsql;
        }
        return null;
    }

    public static String replaceFilterColumnFlag(String dataConfigsql, boolean isJump) {
        if (!isJump) {
            return dataConfigsql;
        }
        int sIndex11 = dataConfigsql.indexOf("@s1_");
        int sIndex12 = dataConfigsql.indexOf("_s1@");
        if (sIndex11 > -1 && sIndex12 > -1) {
            dataConfigsql = dataConfigsql.replace("@s1_", "");
            dataConfigsql = dataConfigsql.replace("_s1@", "");
        }
        int sIndex21 = dataConfigsql.indexOf("@s2_");
        int sIndex22 = dataConfigsql.indexOf("_s2@");
        if (sIndex21 > -1 && sIndex22 > -1) {
            dataConfigsql = dataConfigsql.replace("@s2_", "");
            dataConfigsql = dataConfigsql.replace("_s2@", "");
        }
        return dataConfigsql;
    }

    public static boolean isJump(String dataConfigsql) {
        int sIndex11 = dataConfigsql.indexOf("@s1_");
        int sIndex12 = dataConfigsql.indexOf("_s1@");
        int sIndex21 = dataConfigsql.indexOf("@s2_");
        int sIndex22 = dataConfigsql.indexOf("_s2@");
        return sIndex11 > -1 && sIndex12 > -1 || sIndex21 > -1 && sIndex22 > -1;
    }

    public static String getInnerFilterColumns(String dataConfigsql, List<String> filterColumns) {
        int sIndex11 = dataConfigsql.indexOf("@s1_");
        int sIndex12 = dataConfigsql.indexOf("_s1@");
        String filterClounmn1 = "";
        if (sIndex11 > -1 && sIndex12 > -1) {
            filterClounmn1 = dataConfigsql.substring(sIndex11 + 4, sIndex12);
            filterColumns.add(filterClounmn1);
            dataConfigsql = dataConfigsql.replace("@s1_", "");
            dataConfigsql = dataConfigsql.replace("_s1@", "");
        }
        int sIndex21 = dataConfigsql.indexOf("@s2_");
        int sIndex22 = dataConfigsql.indexOf("_s2@");
        String filterClounmn2 = "";
        if (sIndex21 > -1 && sIndex22 > -1) {
            filterClounmn2 = dataConfigsql.substring(sIndex21 + 4, sIndex22);
            filterColumns.add(filterClounmn2);
            dataConfigsql = dataConfigsql.replace("@s2_", "");
            dataConfigsql = dataConfigsql.replace("_s2@", "");
        }
        return dataConfigsql;
    }

    public static String replaceOrderColumnFlag(String dataSql) {
        int orderStartIndex = dataSql.indexOf("@r_");
        int orderEndIndex = dataSql.indexOf("_r@");
        if (orderStartIndex > -1 && orderEndIndex > -1) {
            String orderColums = dataSql.substring(orderStartIndex, orderEndIndex + 3);
            dataSql = dataSql.replace(orderColums, "");
        }
        return dataSql;
    }

    public static String[] removeAndSetOrderColumns(String dataSql) {
        String[] resultArr = new String[2];
        int orderStartIndex = dataSql.indexOf("@r_");
        int orderEndIndex = dataSql.indexOf("_r@");
        if (orderStartIndex > -1 && orderEndIndex > -1) {
            resultArr[0] = dataSql.substring(orderStartIndex + 3, orderEndIndex);
            String removeOrderColums = dataSql.substring(orderStartIndex, orderEndIndex + 3);
            resultArr[1] = dataSql.replace(removeOrderColums, "");
            return resultArr;
        }
        resultArr[0] = "";
        resultArr[1] = dataSql;
        return resultArr;
    }

    public static String replaceDataFlag(Context ctx, String dataSql, String orgId, boolean isJump) throws BOSException {
        dataSql = HRManagerUtil.sqlReplaceHandler(ctx, orgId, dataSql);
        dataSql = HRManagerUtil.replaceStartEndFlag(dataSql);
        dataSql = HRManagerUtil.replaceFilterColumnFlag(dataSql, isJump);
        dataSql = HRManagerUtil.replaceOrderColumnFlag(dataSql);
        dataSql = HRManagerUtil.removeChangeCoulmnsFlag(dataSql);
        return dataSql;
    }

    public static String removeChangeCoulmnsFlag(String dataSql) {
        if (dataSql.indexOf("@p1_") > -1 && dataSql.indexOf("_p1@") > -1 && dataSql.indexOf("@m1_") > -1 && dataSql.indexOf("_m1@") > -1) {
            dataSql = HRManagerUtil.replacepmFlag(dataSql, "@p1_", "_p1@", "@m1_", "_m1@");
        }
        if (dataSql.indexOf("@p2_") > -1 && dataSql.indexOf("_p2@") > -1 && dataSql.indexOf("@m2_") > -1 && dataSql.indexOf("_m2@") > -1) {
            dataSql = HRManagerUtil.replacepmFlag(dataSql, "@p2_", "_p2@", "@m2_", "_m2@");
        }
        if (dataSql.indexOf("@p3_") > -1 && dataSql.indexOf("_p3@") > -1 && dataSql.indexOf("@m3_") > -1 && dataSql.indexOf("_m3@") > -1) {
            dataSql = HRManagerUtil.replacepmFlag(dataSql, "@p3_", "_p3@", "@m3_", "_m3@");
        }
        if (dataSql.indexOf("@p4_") > -1 && dataSql.indexOf("_p4@") > -1 && dataSql.indexOf("@m4_") > -1 && dataSql.indexOf("_m4@") > -1) {
            dataSql = HRManagerUtil.replacepmFlag(dataSql, "@p4_", "_p4@", "@m4_", "_m4@");
        }
        if (dataSql.indexOf("@p5_") > -1 && dataSql.indexOf("_p5@") > -1 && dataSql.indexOf("@m5_") > -1 && dataSql.indexOf("_m5@") > -1) {
            dataSql = HRManagerUtil.replacepmFlag(dataSql, "@p5_", "_p5@", "@m5_", "_m5@");
        }
        return dataSql;
    }

    private static String replacepmFlag(String dataSql, String name1, String name2, String name3, String name4) {
        dataSql = dataSql.replace(name1, "");
        dataSql = dataSql.replace(name2, "");
        dataSql = dataSql.replace(name3, "");
        dataSql = dataSql.replace(name4, "");
        return dataSql;
    }

    public static String[] removeFlagAndGetChangeCloumns(String dataSql, String name) {
        String[] resultArr = new String[2];
        if (dataSql.indexOf("@p1_") > -1 && dataSql.indexOf("_p1@") > -1 && dataSql.indexOf("@m1_") > -1 && dataSql.indexOf("_m1@") > -1) {
            String mx_ = "@m1_";
            String _mx = "_m1@";
            String px_ = "@p1_";
            String _px = "_p1@";
            dataSql = HRManagerUtil.removeFlagAndRealCloumns(dataSql, name, resultArr, mx_, _mx, px_, _px);
            return resultArr;
        }
        if (dataSql.indexOf("@p2_") > -1 && dataSql.indexOf("_p2@") > -1 && dataSql.indexOf("@m2_") > -1 && dataSql.indexOf("_m2@") > -1) {
            String mx_ = "@m2_";
            String _mx = "_m2@";
            String px_ = "@p2_";
            String _px = "_p2@";
            dataSql = HRManagerUtil.removeFlagAndRealCloumns(dataSql, name, resultArr, mx_, _mx, px_, _px);
            return resultArr;
        }
        if (dataSql.indexOf("@p3_") > -1 && dataSql.indexOf("_p3@") > -1 && dataSql.indexOf("@m3_") > -1 && dataSql.indexOf("_m3@") > -1) {
            String mx_ = "@m3_";
            String _mx = "_m3@";
            String px_ = "@p3_";
            String _px = "_p3@";
            dataSql = HRManagerUtil.removeFlagAndRealCloumns(dataSql, name, resultArr, mx_, _mx, px_, _px);
            return resultArr;
        }
        if (dataSql.indexOf("@p4_") > -1 && dataSql.indexOf("_p4@") > -1 && dataSql.indexOf("@m4_") > -1 && dataSql.indexOf("_m4@") > -1) {
            String mx_ = "@m4_";
            String _mx = "_m4@";
            String px_ = "@p4_";
            String _px = "_p4@";
            dataSql = HRManagerUtil.removeFlagAndRealCloumns(dataSql, name, resultArr, mx_, _mx, px_, _px);
            return resultArr;
        }
        if (dataSql.indexOf("@p5_") > -1 && dataSql.indexOf("_p5@") > -1 && dataSql.indexOf("@m5_") > -1 && dataSql.indexOf("_m5@") > -1) {
            String mx_ = "@m5_";
            String _mx = "_m5@";
            String px_ = "@p5_";
            String _px = "_p5@";
            resultArr[1] = dataSql = HRManagerUtil.removeFlagAndRealCloumns(dataSql, name, resultArr, mx_, _mx, px_, _px);
            return resultArr;
        }
        resultArr[0] = name;
        resultArr[1] = dataSql;
        return resultArr;
    }

    private static String removeFlagAndRealCloumns(String dataSql, String name, String[] resultArr, String mx_, String _mx, String px_, String _px) {
        int m2Index;
        int m1Index = dataSql.indexOf(mx_);
        String aliasName = dataSql.substring(m1Index + 4, m2Index = dataSql.indexOf(_mx)).replace("'", "");
        if (name.equals(aliasName)) {
            int p1Index = dataSql.indexOf(px_);
            int p2Index = dataSql.indexOf(_px);
            resultArr[0] = dataSql.substring(p1Index + 4, p2Index).replace("'", "");
        } else {
            resultArr[0] = name;
        }
        resultArr[1] = dataSql = HRManagerUtil.replacepmFlag(dataSql, px_, _px, mx_, _mx);
        return dataSql;
    }

    public static String getBeginDateStr(int year, int month) {
        String beginDateStr = "";
        if (month == 1) {
            beginDateStr = "{ts'" + (year - 1) + "-12-31'}";
        } else {
            int day = HRManagerUtil.getDay(year, month - 1);
            beginDateStr = "{ts'" + year + "-" + (month - 1) + "-" + day + "'}";
        }
        return beginDateStr;
    }

    public static void setManagerPartCache(Context ctx, String splitFlag, String dataSql, Map param) {
        HttpSession session = (HttpSession)param.get("_session_");
        if (session == null) {
            return;
        }
        Object value = session.getAttribute("productionMode");
        if (value == null) {
            value = session.getServletContext().getAttribute("productionMode");
        }
        if ("production".equals(value)) {
            return;
        }
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        if (userInfo != null && !StringUtils.isEmpty((String)userInfo.getNumber())) {
            String key = userInfo.getNumber() + "_manager001";
            String querySql = (String)CacheService.getInstance().get(shrSelfCacheKey, key);
            if (!StringUtils.isEmpty((String)querySql)) {
                if (querySql.indexOf(splitFlag) == -1) {
                    CacheService.getInstance().put(shrSelfCacheKey, key, (Object)(querySql + "    *****" + splitFlag + ":  " + dataSql));
                }
            } else {
                CacheService.getInstance().put(shrSelfCacheKey, key, (Object)(splitFlag + ":  " + dataSql));
            }
        }
    }

    public static int getYearConditionNumber(String dataConfigsql) {
        if (dataConfigsql.indexOf("@YEAR_CONDITION_1") > -1 && dataConfigsql.indexOf("@YEAR_CONDITION_10") == -1) {
            return 1;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_2") > -1) {
            return 2;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_3") > -1) {
            return 3;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_4") > -1) {
            return 4;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_5") > -1) {
            return 5;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_6") > -1) {
            return 6;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_7") > -1) {
            return 7;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_8") > -1) {
            return 8;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_9") > -1) {
            return 9;
        }
        if (dataConfigsql.indexOf("@YEAR_CONDITION_10") > -1) {
            return 10;
        }
        return 3;
    }

    public static IRowSet getDataConfigInfoById(Context ctx, String fid) throws BOSException {
        String loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        StringBuffer bfSql = new StringBuffer();
        bfSql.append("select ").append(" t.FDataConfigsql_").append(loc).append(" as dataConfigsql,").append(" ext.FDataExtConfigsql_").append(loc).append(" as dataExtConfigsql").append(" FROM").append(" T_MGR_ManagerDataConfig t").append(" inner join T_MGR_ManagerEchartConfig ttt on t.FManagerEchartID=ttt.fid").append(" left join T_MGR_ManagerDataConfigExt ext on t.fid = ext.fparentId").append(" where t.FOpenStatus=1 ").append(" and t.fid='").append(fid).append("'");
        IRowSet rowSet = null;
        try {
            rowSet = DbUtil.executeQuery((Context)ctx, (String)bfSql.toString());
        }
        catch (BOSException e) {
            e.printStackTrace();
            throw new BOSException(e.getMessage(), (Throwable)e);
        }
        return rowSet;
    }

    public static String getUserAdminOrgRangeSQL(Context ctx, String userId, String permItemId, Integer isStartShr, Integer isSealUp) {
        if (SHRPermissionSQL.hasHRUserAdminOrgRange((Context)ctx, (String)userId, (String)permItemId)) {
            return SHRPermissionSQL.getHRUserAdminOrgRangeSql((String)userId, (String)permItemId, (Integer)isStartShr, (Integer)isSealUp);
        }
        return SHRPermissionSQL.getEASUserAdminOrgRangeSql((String)userId);
    }

    public static String getPersonPositionResponseAdminSqlNew(Context ctx, String userId, String permItemId) {
        String sql = SHRUserOrgPermissionApi.getUserHeadOfDepartmentAdminRangeSQL((Context)ctx, (String)userId, (String)permItemId);
        return sql;
    }
}

