/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.svg;

import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.batik.bridge.BridgeContext;
import org.apache.batik.bridge.UnitProcessor;
import org.apache.batik.ext.awt.RenderingHintsKeyExt;
import org.apache.batik.parser.UnitProcessor;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.image.ImageTranscoder;
import org.apache.fop.Version;
import org.apache.fop.configuration.Configuration;
import org.apache.fop.configuration.DefaultConfiguration;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.AbstractFOPTranscoder;
import org.apache.fop.svg.CustomerPDFDocumentGraphics2DConfigurator;
import org.apache.fop.svg.PDFBridgeContext;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.fop.svg.font.FOPFontFamilyResolver;
import org.apache.fop.svg.font.FOPFontFamilyResolverImpl;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomerPDFTranscoder
extends AbstractFOPTranscoder {
    protected PDFDocumentGraphics2D graphics;

    public CustomerPDFTranscoder() {
        this.handler = new AbstractFOPTranscoder.FOPErrorHandler((AbstractFOPTranscoder)this);
    }

    protected AbstractFOPTranscoder.FOPTranscoderUserAgent createUserAgent() {
        return new AbstractFOPTranscoder.FOPTranscoderUserAgent((AbstractFOPTranscoder)this);
    }

    protected Configuration getEffectiveConfiguration() {
        DefaultConfiguration config = new DefaultConfiguration("cfg");
        DefaultConfiguration fonts = new DefaultConfiguration("fonts");
        DefaultConfiguration autodetect = new DefaultConfiguration("auto-detect");
        fonts.addChild(autodetect);
        config.addChild(fonts);
        return config;
    }

    protected void transcode(Document document, String uri, TranscoderOutput output) throws TranscoderException {
        this.graphics = new PDFDocumentGraphics2D(this.isTextStroked());
        this.graphics.getPDFDocument().getInfo().setProducer("Apache FOP Version " + Version.getVersion() + ": PDF Transcoder for Batik");
        if (this.hints.containsKey((Object)KEY_DEVICE_RESOLUTION)) {
            this.graphics.setDeviceDPI(this.getDeviceResolution());
        }
        this.setupImageInfrastructure(uri);
        try {
            Configuration effCfg = this.getEffectiveConfiguration();
            if (effCfg != null) {
                CustomerPDFDocumentGraphics2DConfigurator configurator = new CustomerPDFDocumentGraphics2DConfigurator();
                boolean useComplexScriptFeatures = false;
                configurator.configure(this.graphics, effCfg, useComplexScriptFeatures);
            } else {
                this.graphics.setupDefaultFontInfo();
            }
            ((AbstractFOPTranscoder.FOPTranscoderUserAgent)this.userAgent).setFontFamilyResolver((FOPFontFamilyResolver)new FOPFontFamilyResolverImpl(this.graphics.getFontInfo()));
        }
        catch (Exception e) {
            throw new TranscoderException("Error while setting up PDFDocumentGraphics2D", e);
        }
        super.transcode(document, uri, output);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("document size: " + this.width + " x " + this.height));
        }
        UnitProcessor.Context uctx = UnitProcessor.createContext((BridgeContext)this.ctx, (Element)document.getDocumentElement());
        float widthInPt = UnitProcessor.userSpaceToSVG((float)this.width, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int w = (int)((double)widthInPt + 0.5);
        float heightInPt = UnitProcessor.userSpaceToSVG((float)this.height, (short)9, (short)2, (UnitProcessor.Context)uctx);
        int h = (int)((double)heightInPt + 0.5);
        if (this.getLogger().isTraceEnabled()) {
            this.getLogger().trace((Object)("document size: " + w + "pt x " + h + "pt"));
        }
        try {
            OutputStream out = output.getOutputStream();
            if (!(out instanceof BufferedOutputStream)) {
                out = new BufferedOutputStream(out);
            }
            this.graphics.setupDocument(out, w, h);
            this.graphics.setSVGDimension(this.width, this.height);
            if (this.hints.containsKey((Object)ImageTranscoder.KEY_BACKGROUND_COLOR)) {
                // empty if block
            }
            this.graphics.setGraphicContext(new GraphicContext());
            this.graphics.preparePainting();
            this.graphics.transform(this.curTxf);
            this.graphics.setRenderingHint(RenderingHintsKeyExt.KEY_TRANSCODING, (Object)"Vector");
            this.root.paint((Graphics2D)this.graphics);
            this.graphics.finish();
        }
        catch (IOException ex) {
            throw new TranscoderException((Exception)ex);
        }
    }

    protected BridgeContext createBridgeContext() {
        return this.createBridgeContext("1.x");
    }

    public BridgeContext createBridgeContext(String version) {
        FontInfo fontInfo = this.graphics.getFontInfo();
        if (this.isTextStroked()) {
            fontInfo = null;
        }
        PDFBridgeContext ctx = new PDFBridgeContext(this.userAgent, fontInfo, this.getImageManager(), this.getImageSessionContext());
        return ctx;
    }
}

