/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.shr.smsplatform.service;

import com.alibaba.fastjson.JSON;
import com.google.gson.Gson;
import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.shr.ml.util.SHRServerResource;
import com.kingdee.shr.preentry.PreEntryCollection;
import com.kingdee.shr.preentry.PreEntryFactory;
import com.kingdee.shr.smsplatform.IMessageApplyOper;
import com.kingdee.shr.smsplatform.MessageApplyOperCollection;
import com.kingdee.shr.smsplatform.MessageApplyOperFactory;
import com.kingdee.shr.smsplatform.MessageApplyOperInfo;
import com.kingdee.shr.smsplatform.SmsTemplateCollection;
import com.kingdee.shr.smsplatform.SmsTemplateFactory;
import com.kingdee.shr.smsplatform.SmsTemplateRelHRCollection;
import com.kingdee.shr.smsplatform.SmsTemplateRelHRFactory;
import com.kingdee.shr.smsplatform.SmsplatformFacadeFactory;
import com.kingdee.shr.smsplatform.app.sourceTypeEnum;
import com.kingdee.shr.smsplatform.enums.SMSSourceTypeEnum;
import com.kingdee.shr.smsplatform.service.ISMSSourceTypeStrategy;
import com.kingdee.shr.smsplatform.service.ISMSStrategy;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PresetSMSStrategy
implements ISMSStrategy {
    private static final Logger log = LoggerFactory.getLogger(PresetSMSStrategy.class);
    protected Map<String, String> presetParamsValue = new HashMap<String, String>();
    protected Map<String, String> queryParamsCondition = new HashMap<String, String>();
    protected Map<String, String> cloudParams = new HashMap<String, String>();
    protected Map<String, String> customParams = new HashMap<String, String>();
    private MessageApplyOperInfo messageApplyOperInfo;
    private String sourceConfig;
    private String messageApplyOperInfoId;
    private sourceTypeEnum type;
    private ISMSSourceTypeStrategy sourceTypeStrategy;
    private List<String> placeholders2Var;
    private boolean ifPresetSMSTemp;
    protected String operTypeNum;
    protected String phone;
    protected String hrOrgUseId;
    private static final Gson gs = new Gson();
    private static final String logPrefix = "PresetSMSStrategy.analyContent,";
    private static final String logPrefix_VALID = "PresetSMSStrategy.valid,";
    private static final String logPrefix_AnalyTempNumber = "PresetSMSStrategy.analyTempNumber,";

    public PresetSMSStrategy(String operTypeNum, String phone, String hrOrgUseId, Object ... presetParamsValueMaps) {
        this.operTypeNum = operTypeNum;
        this.phone = phone;
        this.hrOrgUseId = hrOrgUseId;
        this.presetParamsValue = null != presetParamsValueMaps && 1 <= presetParamsValueMaps.length ? (Map)presetParamsValueMaps[0] : null;
        this.queryParamsCondition = null != presetParamsValueMaps && 2 <= presetParamsValueMaps.length ? (Map)presetParamsValueMaps[1] : null;
        this.cloudParams = null != presetParamsValueMaps && 3 <= presetParamsValueMaps.length ? (Map)presetParamsValueMaps[2] : null;
        this.customParams = null != presetParamsValueMaps && 4 <= presetParamsValueMaps.length ? (Map)presetParamsValueMaps[3] : null;
    }

    @Override
    public final String analyTempNumber(Context ctx) throws BOSException {
        String returnTempNumber;
        SmsTemplateCollection smsTemplateCol = SmsTemplateFactory.getLocalInstance(ctx).getSmsTemplateCollection("where applyOper = '" + this.messageApplyOperInfoId + "' and state = 1 and auditState = 1 ");
        String smsTemplateId = null;
        String tempNumber = null;
        String presetTempNumber = null;
        int notSysPresetCount = 0;
        for (int i = 0; i < smsTemplateCol.size(); ++i) {
            if (null != smsTemplateCol.get(i) && !smsTemplateCol.get(i).isIsSysPreset()) {
                if (null == smsTemplateCol.get(i) || StringUtils.isBlank((CharSequence)smsTemplateCol.get(i).getClouduuid())) {
                    String label3 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label3", (Context)ctx);
                    throw new BOSException(label3);
                }
                smsTemplateId = smsTemplateCol.get(i).getId().toString();
                if (StringUtils.isBlank((CharSequence)smsTemplateId)) {
                    String label2 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label2", (Context)ctx);
                    throw new BOSException(label2);
                }
                if (StringUtils.isBlank((CharSequence)this.hrOrgUseId)) continue;
                SmsTemplateRelHRCollection smsTempCol = SmsTemplateRelHRFactory.getLocalInstance(ctx).getSmsTemplateRelHRCollection("select hrOrgUse  where baseInfoId = '" + smsTemplateId + "' and state=100 and hrOrgUse = '" + this.hrOrgUseId + "'");
                if (null == smsTempCol || 1 != smsTempCol.size()) {
                    String label4 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label4", (Context)ctx);
                    log.error(String.format(label4, logPrefix_AnalyTempNumber, this.hrOrgUseId));
                    continue;
                }
                tempNumber = smsTemplateCol.get(i).getClouduuid();
                ++notSysPresetCount;
                continue;
            }
            if (null == smsTemplateCol.get(i) || !smsTemplateCol.get(i).isIsSysPreset()) continue;
            if (StringUtils.isBlank((CharSequence)smsTemplateCol.get(i).getClouduuid())) {
                String label1 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label1", (Context)ctx);
                throw new BOSException(label1);
            }
            presetTempNumber = smsTemplateCol.get(i).getClouduuid();
        }
        if (1 < notSysPresetCount) {
            log.error(String.format("%snotSysPresetCount:[%s]!", logPrefix_AnalyTempNumber, notSysPresetCount));
            String label7 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label7", (Context)ctx);
            throw new BOSException(label7);
        }
        String string = returnTempNumber = StringUtils.isBlank(tempNumber) ? presetTempNumber : tempNumber;
        if (StringUtils.isBlank(returnTempNumber)) {
            String label6 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label6", (Context)ctx);
            throw new BOSException(label6);
        }
        this.ifPresetSMSTemp = StringUtils.isBlank(tempNumber);
        return returnTempNumber;
    }

    @Override
    public final String analyContent(String content, Context ctx) throws BOSException {
        log.error(String.format("%scontent:[%s],presetParamValues:[%s],customParams:[%s]", logPrefix, gs.toJson((Object)content), this.presetParamsValue, this.customParams));
        String regex = "\\{\\{[\\w]+[.]?[\\w]+:\\d\\}\\}";
        if (this.ifPresetSMSTemp) {
            regex = "\\{\\{[\\w]+[.]?[\\w]+\\}\\}";
        }
        String conWithoutPH = "";
        try {
            conWithoutPH = content.replaceAll(regex, "");
            if (conWithoutPH.contains("{{") || conWithoutPH.contains("}}")) {
                String label8 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label8", (Context)ctx);
                throw new BOSException(label8);
            }
        }
        catch (BOSException e) {
            log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
            regex = "\\{\\{[\\w]+[.]?[\\w]+\\}\\}";
            conWithoutPH = content.replaceAll(regex, "");
            if (conWithoutPH.contains("{{") || conWithoutPH.contains("}}")) {
                throw e;
            }
            this.ifPresetSMSTemp = true;
            log.error("PresetSMSStrategy.analyContent,\u517c\u5bb9\u5904\u7406\u975e\u9884\u7f6e\u6a21\u677f...");
        }
        catch (Exception e) {
            log.error(logPrefix + e.getLocalizedMessage(), (Throwable)e);
            String label5 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label5", (Context)ctx);
            throw new BOSException(label5);
        }
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(content);
        ArrayList<String> placeholders = new ArrayList<String>();
        while (matcher.find()) {
            placeholders.add(matcher.group());
        }
        if (0 == placeholders.size()) {
            String label11 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label11", (Context)ctx);
            log.error(String.format(label11, logPrefix));
            return "true";
        }
        this.placeholders2Var = JSON.parseArray((String)JSON.toJSONString(placeholders), String.class);
        ArrayList<String> queryParams = new ArrayList<String>();
        ArrayList<String> presetParams = new ArrayList<String>();
        for (int i = 0; i < placeholders.size(); ++i) {
            placeholders.set(i, ((String)placeholders.get(i)).replace("{{", ""));
            placeholders.set(i, ((String)placeholders.get(i)).replace("}}", ""));
            if (this.ifPresetSMSTemp) {
                this.sourceTypeStrategy.setQueryVal(false);
                this.sourceTypeStrategy.setPresetVal(sourceTypeEnum.CUSTOM_CONFIG != this.type && sourceTypeEnum.CLOUD_CONFIG != this.type && sourceTypeEnum.QCLO_CONFIG != this.type);
                presetParams.add((String)placeholders.get(i));
                continue;
            }
            if (StringUtils.isBlank((CharSequence)((CharSequence)placeholders.get(i))) || !((String)placeholders.get(i)).contains(":") || 2 != ((String)placeholders.get(i)).split(":").length || 1 != ((String)placeholders.get(i)).split(":")[1].length()) {
                String label10 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label10", (Context)ctx);
                throw new BOSException(label10);
            }
            int sourceType = 0;
            try {
                sourceType = Integer.parseInt(((String)placeholders.get(i)).split(":")[1]);
            }
            catch (Exception e) {
                String label12 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label12", (Context)ctx);
                throw new BOSException(label12);
            }
            switch (sourceType) {
                case 0: {
                    queryParams.add(((String)placeholders.get(i)).split(":")[0]);
                    break;
                }
                case 2: {
                    presetParams.add(((String)placeholders.get(i)).split(":")[0]);
                    break;
                }
            }
            if (0 < queryParams.size()) {
                this.sourceTypeStrategy.setQueryVal(true);
            }
            if (0 < presetParams.size()) {
                this.sourceTypeStrategy.setPresetVal(true);
            }
            placeholders.set(i, ((String)placeholders.get(i)).split(":")[0]);
        }
        Map<String, String> preSetValues = null;
        Map<String, String> queryValues = null;
        queryValues = this.sourceTypeStrategy.analyContent(this.sourceConfig, logPrefix, ctx, this.queryParamsCondition, queryParams);
        preSetValues = this.sourceTypeStrategy.analyContent2Preset(this.presetParamsValue, presetParams);
        this.sourceTypeStrategy.match(preSetValues, queryValues, placeholders, this.cloudParams, this.customParams, ctx);
        if (this.placeholders2Var.size() != placeholders.size()) {
            String label9 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label9", (Context)ctx);
            throw new BOSException(label9);
        }
        return StringUtils.join(placeholders, (String)"|");
    }

    @Override
    public String getPhone() {
        return this.phone;
    }

    @Override
    public boolean valid(Context ctx) throws BOSException {
        try {
            SmsplatformFacadeFactory.getLocalInstance(ctx).loadHistoryData();
            log.error("history template/sign data  handle finished!");
        }
        catch (Exception e) {
            String errMsg = "history template/sign data not handle finish!";
            log.error(errMsg, (Throwable)e);
            throw new BOSException(errMsg);
        }
        if (!(this instanceof PresetSMSStrategy)) {
            String label15 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label15", (Context)ctx);
            throw new BOSException(label15);
        }
        if (StringUtils.isBlank((CharSequence)this.phone)) {
            String label14 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label14", (Context)ctx);
            throw new BOSException(label14);
        }
        IMessageApplyOper messageApplyOper = MessageApplyOperFactory.getLocalInstance(ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("operTypeNum", (Object)this.operTypeNum));
        view.setFilter(filter);
        MessageApplyOperCollection messageApplyOperCol = messageApplyOper.getMessageApplyOperCollection(view);
        if (null == messageApplyOperCol || 1 != messageApplyOperCol.size()) {
            String label16 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label16", (Context)ctx);
            throw new BOSException(label16);
        }
        if (null == messageApplyOperCol.get(0) || null == messageApplyOperCol.get(0).getSourceTypeEnum()) {
            String label13 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label13", (Context)ctx);
            throw new BOSException(label13);
        }
        this.messageApplyOperInfo = messageApplyOperCol.get(0);
        this.sourceConfig = messageApplyOperCol.get(0).getSourceConfig();
        this.messageApplyOperInfoId = messageApplyOperCol.get(0).getId().toString();
        this.type = messageApplyOperCol.get(0).getSourceTypeEnum();
        this.sourceTypeStrategy = this.getSourceTypeStrategyInstance(SMSSourceTypeEnum.getPlatformEnum(this.type.getValue()).packagePath(), ctx);
        this.hrOrgUseId = this.initHrOrgUseId(ctx);
        this.queryParamsCondition = this.initQueryParamsCondition();
        Object[] objs = new Object[]{this.queryParamsCondition, this.cloudParams, this.customParams, this.presetParamsValue};
        this.sourceTypeStrategy.validBlankAndHrOrg(this.hrOrgUseId, logPrefix_VALID, ctx, objs);
        return true;
    }

    @Override
    public String initHrOrgUseId(Context ctx) throws BOSException {
        return this.hrOrgUseId;
    }

    @Override
    public Map<String, String> initQueryParamsCondition() {
        return this.queryParamsCondition;
    }

    private ISMSSourceTypeStrategy getSourceTypeStrategyInstance(String packagePath, Context ctx) throws BOSException {
        try {
            Class<?> c = Class.forName(packagePath);
            Constructor<?> con = c.getConstructor(new Class[0]);
            ISMSSourceTypeStrategy smsIsmsSourceTypeStrategy = (ISMSSourceTypeStrategy)con.newInstance(new Object[0]);
            return smsIsmsSourceTypeStrategy;
        }
        catch (Exception e) {
            log.error(logPrefix_VALID, (Throwable)e);
            String label19 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label19", (Context)ctx);
            throw new BOSException(label19);
        }
    }

    @Override
    public final List<String> getPlaceholders2Var() {
        return this.placeholders2Var;
    }

    protected String getHrOrgUseIdByPhone(Context ctx) throws BOSException {
        PreEntryCollection coll = PreEntryFactory.getLocalInstance((Context)ctx).getPreEntryCollection("select hrOrgUnit where checkInState = 4 and nCell = '" + this.phone + "'");
        if (null == coll || 1 != coll.size()) {
            String label18 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label18", (Context)ctx);
            log.error(String.format(label18, this.phone));
            return null;
        }
        if (null == coll.get(0) || null == coll.get(0).getHrOrgUnit() || null == coll.get(0).getHrOrgUnit().getId() || StringUtils.isBlank((CharSequence)coll.get(0).getHrOrgUnit().getId().toString())) {
            String label20 = SHRServerResource.getString((String)"com.kingdee.shr.smsplatform.ShrSmsplatformResource", (String)"label20", (Context)ctx);
            log.error(label20);
            return null;
        }
        return coll.get(0).getHrOrgUnit().getId().toString();
    }

    @Override
    public void afterSendSMSHandle(String content, String smsId, Context ctx) {
    }
}

